/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.visitors;

import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.util.Translate;
import org.htmlparser.visitors.NodeVisitor;

public class TextExtractingVisitor
extends NodeVisitor {
    private StringBuffer textAccumulator = new StringBuffer();
    private boolean preTagBeingProcessed = false;

    public String getExtractedText() {
        return this.textAccumulator.toString();
    }

    public void visitStringNode(Text stringNode) {
        String text = stringNode.getText();
        if (!this.preTagBeingProcessed) {
            text = Translate.decode(text);
            text = this.replaceNonBreakingSpaceWithOrdinarySpace(text);
        }
        this.textAccumulator.append(text);
    }

    private String replaceNonBreakingSpaceWithOrdinarySpace(String text) {
        return text.replace('\u00a0', ' ');
    }

    public void visitTag(Tag tag) {
        if (this.isPreTag(tag)) {
            this.preTagBeingProcessed = true;
        }
    }

    public void visitEndTag(Tag tag) {
        if (this.isPreTag(tag)) {
            this.preTagBeingProcessed = false;
        }
    }

    private boolean isPreTag(Tag tag) {
        return tag.getTagName().equals("PRE");
    }
}

