/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource.cachesync;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.cachesync.RequestValuesStrategy;
import com.isomorphic.log.Logger;
import java.util.List;
import java.util.Map;

public class RESTRequestValuesPlusKeysStrategy
extends RequestValuesStrategy {
    private static Logger log = new Logger(RESTRequestValuesPlusKeysStrategy.class);

    @Override
    public List getCacheSyncData(DSRequest request, DSResponse response) throws Exception {
        request.setAttribute("_calledFromGetKeys", true);
        List responseData = super.getCacheSyncData(request, response);
        request.removeAttribute("_calledFromGetKeys");
        if (!this.isCacheSyncFetchAllowed(request, response)) {
            return responseData;
        }
        DataSource ds = request.getDataSource();
        List<String> keys = ds.getPrimaryKeys();
        List dsRespData = (List)response.getParameter("_responseValues");
        if (dsRespData == null) {
            log.warn("There was no response data returned from the REST service for DataSource '" + ds.getName() + "', operationBinding '" + request.getOperationId() + "'. Cache sync data will be partial");
        } else if (responseData.size() != dsRespData.size()) {
            log.warn("Number of request value records and response value records differs.  Not able to map response value keys, cache sync data will be partial");
        } else {
            for (int i = 0; i < responseData.size(); ++i) {
                Map baseRecord = (Map)responseData.get(i);
                Map respRecord = (Map)dsRespData.get(i);
                for (int j = 0; j < keys.size(); ++j) {
                    if (respRecord.containsKey(keys.get(j))) {
                        baseRecord.put(keys.get(j), respRecord.get(keys.get(j)));
                        continue;
                    }
                    log.warn("Response record " + i + " is missing a value for key field '" + keys.get(j) + "'.  Cache sync data will be partial");
                }
            }
        }
        return responseData;
    }
}

