/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSFieldFormula;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.Relation;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.MysqlDriver;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ISCSystem;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OracleDriver
extends SQLDriver {
    private static Logger log = new Logger(OracleDriver.class.getName());
    public static final int UNIQUE_CONSTRAINT_VIOLATED = 1;
    static Map newEscapeSyntax = new HashMap();
    private static boolean CRASH_ON_FAILED_SNAPSHOT = Config.getGlobal().getBoolean((Object)"sql.Oracle.crash.on.failed.snapshot", true);
    protected boolean _supportsSQLLimit = false;
    private static boolean aliasWarningLogged = false;

    private static boolean useNewEscapeSyntax(String dbName) {
        if (!newEscapeSyntax.containsKey(dbName)) {
            if (config.get((Object)"sql.oracle.encloseEscapeClauseInBraces") != null) {
                newEscapeSyntax.put(dbName, !config.getBoolean((Object)"sql.oracle.encloseEscapeClauseInBraces", false));
            } else {
                newEscapeSyntax.put(dbName, Boolean.TRUE);
            }
        }
        return (Boolean)newEscapeSyntax.get(dbName);
    }

    public OracleDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
        boolean dbLevelSupportsSQLLimit = this._sqlConfig.getBoolean((Object)"supportsSQLLimit", false);
        this._supportsSQLLimit = this.driverConfig.getBoolean((Object)"supportsSQLLimit", dbLevelSupportsSQLLimit);
    }

    @Override
    public boolean supportsRegexp() throws Exception {
        return this.getDatabaseMajorVersion() >= 10;
    }

    @Override
    public String getExpressionForRegexp(String escapedColumnOrExpression, String operator, String regexp) throws Exception {
        return "REGEXP_LIKE(" + escapedColumnOrExpression + ", " + this.escapeRegexp(regexp) + ("iregexp".equals(operator) ? ", 'i' " : "") + ")";
    }

    @Override
    public boolean supportsNativeReplace() {
        return false;
    }

    @Override
    public boolean supportsSQLLimit() {
        return this._supportsSQLLimit;
    }

    @Override
    public String limitQuery(String query, long startRow, long batchSize, List outputColumns, String baseOrderClause, String computedOrderClause, DSRequest req, List dataSources, Map context) {
        String q = query;
        if (computedOrderClause != null && computedOrderClause.trim().length() > 0) {
            q = baseOrderClause == null || baseOrderClause.trim().length() == 0 || "$defaultOrderClause".equals(baseOrderClause) && (context.get("defaultOrderClause") == null || ((String)context.get("defaultOrderClause")).trim().length() == 0) ? q + " ORDER BY " : q + ", ";
            q = q + computedOrderClause;
        }
        DataSource ds = null;
        try {
            ds = req.getDataSource();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean useHint = true;
        if (ds != null) {
            useHint = DataTools.getBoolean((Map)ds.getConfig(), (Object)"sqlUsePagingHint", (boolean)true);
            DataTypeMap opConfig = ds.getOperationBinding(req);
            if (opConfig != null && opConfig.containsKey("sqlUsePagingHint")) {
                useHint = DataTools.getBoolean((Map)opConfig, (Object)"sqlUsePagingHint", (boolean)true);
            }
        }
        query = "SELECT * FROM (SELECT " + (useHint ? "/*+ FIRST_ROWS(" + batchSize + ") */ " : "") + "a.*, rownum myrownum FROM (" + q + ") a where rownum <=" + (startRow + batchSize) + ") WHERE myrownum >= " + (startRow + 1L);
        return query;
    }

    @Override
    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        if (this.dbConnection == null && req == null) {
            throw new Exception("no existing db connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        for (String sequenceName : sequencesNotPresent) {
            String sequence = this.getCurrentSequenceValue((String)ds.getCorrectDs2NativeFieldMap().get(sequenceName), ds);
            if (sequence == null) continue;
            Object obj = OracleDriver.getScalarResult("SELECT " + sequence + " FROM DUAL", this.dbConnection, this.dbName, this, req);
            Object transformed = this.getTransformedSequenceValue(obj, sequenceName, ds, req);
            if (transformed != null) {
                primaryKeys.put(sequenceName, transformed);
                continue;
            }
            Long sequenceValue = Long.valueOf(obj.toString());
            primaryKeys.put(sequenceName, sequenceValue);
        }
        return primaryKeys;
    }

    @Override
    public String formatValue(Object value) {
        return value.toString();
    }

    @Override
    public String sqlInTransform(Object value, DSField field, String overrideFieldType, SQLDataSource ds, boolean addLiteralPrefix, boolean noEscape) throws Exception {
        long start = System.currentTimeMillis();
        boolean isText = false;
        if (field != null) {
            try {
                isText = ds.simpleTypeInheritsFrom(field.getType(), "text");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value instanceof java.util.Date && (field == null || field.get((Object)"sqlStorageStrategy") == null)) {
            long timeStamp = ((java.util.Date)value).getTime();
            boolean isDateTime = false;
            boolean isTime = false;
            try {
                isDateTime = ds.simpleTypeInheritsFrom(field.getType(), "datetime");
                isTime = ds.simpleTypeInheritsFrom(field.getType(), "time");
            }
            catch (Exception ignored) {
                isDateTime = true;
            }
            if (isDateTime) {
                String dateTime = this.formatTimestamp(timeStamp, isDateTime, ds, field);
                if (field != null && field.shouldStoreMilliseconds()) {
                    String format = config.getString((Object)"sql.defaultDateTimeFormatWithMilliseconds");
                    return "TO_TIMESTAMP(" + this.escapeValue(dateTime) + ",'" + format + "')";
                }
                String format = config.getString((Object)"sql.defaultDateTimeFormat");
                return "TO_DATE(" + this.escapeValue(dateTime) + ",'" + format + "')";
            }
            if (isTime) {
                String time = this.formatTime(timeStamp);
                String format = config.getString((Object)"sql.defaultTimeFormat");
                return "TO_DATE(" + this.escapeValue(time) + ",'" + format + "')";
            }
            String date = this.formatDate(timeStamp);
            String format = config.getString((Object)"sql.defaultDateFormat");
            return "TO_DATE(" + this.escapeValue(date) + ",'" + format + "')";
        }
        if (isText) {
            if (this.supportsLongVarchar() || !this.fieldAssignableInline(field)) {
                return noEscape ? value.toString() : this.escapeValue(value);
            }
            String strValue = value.toString();
            if (strValue.length() <= 1000) {
                return noEscape ? strValue : this.escapeValue(strValue);
            }
            List chunks = DataTools.splitByLength((String)strValue, (int)1000);
            StringBuffer buffer = new StringBuffer();
            boolean first = true;
            for (String chunk : chunks) {
                if (first) {
                    first = false;
                    buffer.append("TO_CLOB(");
                    buffer.append(this.escapeValue(chunk));
                    buffer.append(")");
                    continue;
                }
                buffer.append(" || ");
                buffer.append(this.escapeValue(chunk));
            }
            String rtnVal = buffer.toString();
            long elapsed = System.currentTimeMillis() - start;
            log.debug((Object)("sqlInTransform took " + elapsed + "ms"));
            return rtnVal;
        }
        return super.sqlInTransform(value, field, overrideFieldType, ds, addLiteralPrefix, noEscape);
    }

    @Override
    public String sqlStringComparisonRValue(String fieldName, String value, String operator, DSRequest req) {
        if (this.supportsLongVarchar() || value.length() <= 998) {
            return super.sqlStringComparisonRValue(fieldName, value, operator, req);
        }
        StringBuffer sql = new StringBuffer();
        List chunks = DataTools.splitByLength((String)value, (int)998);
        int l = chunks.size();
        for (int i = 0; i < l; ++i) {
            String chunk = (String)chunks.get(i);
            if (i == 0) {
                sql.append("TO_CLOB(");
                if ((operator.contains("ndsWith") || operator.contains("tains")) && !value.startsWith("%")) {
                    chunk = "%" + chunk;
                }
                sql.append(req == null ? this.escapeValue(chunk) : req.prepareSQLParam(fieldName, this.escapeValue(chunk)));
                sql.append(")");
                continue;
            }
            if (i == l - 1 && (operator.contains("rtsWith") || operator.contains("tains")) && !value.endsWith("%")) {
                chunk = chunk + "%";
            }
            sql.append(" || ");
            sql.append(req == null ? this.escapeValue(chunk) : req.prepareSQLParam(fieldName, this.escapeValue(chunk)));
        }
        return sql.toString();
    }

    @Override
    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        boolean forceRemap = false;
        String output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + output;
        }
        return output;
    }

    @Override
    public String sqlOutTransformFunction(String expression, String functionName, Map functionParams) {
        if ("CONCAT".equals(functionName.toUpperCase())) {
            String prefix = "";
            String suffix = "";
            String delimiter = ", ";
            if (functionParams != null) {
                prefix = functionParams.get("joinPrefix") == null ? prefix : (String)functionParams.get("joinPrefix");
                suffix = functionParams.get("joinSuffix") == null ? suffix : (String)functionParams.get("joinSuffix");
                delimiter = functionParams.get("joinString") == null ? delimiter : (String)functionParams.get("joinString");
            }
            return "LISTAGG ('" + prefix + "' || " + expression + " || '" + suffix + "', '" + delimiter + "') WITHIN GROUP (ORDER BY " + expression + ")";
        }
        return super.sqlOutTransformFunction(expression, functionName, functionParams);
    }

    @Override
    public String transformFormula(String formula) {
        if (formula != null) {
            formula = DSFieldFormula.replace((String)formula, (String)"ceil", (String)"ceiling");
            formula = DSFieldFormula.replace((String)formula, (String)"max", (String)"greatest");
            formula = DSFieldFormula.replace((String)formula, (String)"min", (String)"least");
            formula = DSFieldFormula.replace((String)formula, (String)"pow", (String)"power");
            formula = DSFieldFormula.replace((String)formula, (String)"ln", (String)"log");
            formula = DSFieldFormula.replace((String)formula, (String)"random", (String)"rand");
            formula = DSFieldFormula.replace((String)formula, (String)"substr", (String)"substring");
            formula = DSFieldFormula.replace((String)formula, (String)"length", (String)"len");
            formula = DSFieldFormula.replace((String)formula, (String)"day", (String)"dayofmonth");
        }
        return formula;
    }

    @Override
    public int getMaximumSetSize() {
        return 1000;
    }

    @Override
    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    @Override
    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = this.matcher.reset(value.toString()).usePattern(SINGLE_QUOTE_PATTERN).replaceAll(SINGLE_QUOTE_ESCAPE);
        if (escapeForFilter) {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(PERCENT_PATTERN).replaceAll(PERCENT_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(UNDERSCORE_PATTERN).replaceAll(UNDERSCORE_ESCAPE);
        }
        return escaped;
    }

    @Override
    public String escapeClause(Object value) {
        if (OracleDriver.useNewEscapeSyntax(this.dbName)) {
            return " ESCAPE'\\' ";
        }
        return " {ESCAPE '\\'}";
    }

    @Override
    public boolean useActualSequenceObjects(SQLDataSource ds) {
        return true;
    }

    @Override
    public String getNextSequenceValue(String columnName, SQLDataSource dataSource) throws Exception {
        String sequenceName = this.getSequenceName(columnName, dataSource);
        if (sequenceName == null) {
            return null;
        }
        String schema = "";
        if (dataSource != null) {
            schema = dataSource.getSchemaName();
            schema = schema == null ? "" : schema + ".";
        }
        return schema + sequenceName + ".NextVal";
    }

    public String getCurrentSequenceValue(String columnName, SQLDataSource dataSource) throws Exception {
        String sequenceName = this.getSequenceName(columnName);
        if (sequenceName == null) {
            return null;
        }
        String schema = "";
        if (dataSource != null) {
            schema = dataSource.getSchemaName();
            schema = schema == null ? "" : schema + ".";
        }
        return schema + sequenceName + ".CurrVal";
    }

    @Override
    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        String expr = "DECODE(" + column;
        for (String rawValue : valueMap.keySet()) {
            String actualValue = this.transformActualValueForSort(rawValue, column, request);
            String displayValue = this.getLocalizedDisplayValue(valueMap.get(rawValue), request);
            displayValue = this.escapeValue(displayValue);
            expr = expr + ", " + actualValue + ", " + displayValue;
        }
        expr = expr + ", " + column + ")";
        return expr;
    }

    @Override
    public String sqlCast(String result, DSField field) {
        String type = field.getType();
        if (type != null && (DataSource.simpleTypeInheritsFromBuiltInType((String)type, (String)"datetime") || DataSource.simpleTypeInheritsFromBuiltInType((String)type, (String)"time"))) {
            return "CAST(" + result + " AS TIMESTAMP)";
        }
        return super.sqlCast(result, field);
    }

    public boolean supportsLongVarchar() {
        return false;
    }

    @Override
    public boolean fieldAssignableInline(DSField field) {
        String fieldType = field.getType();
        Long fieldLength = field.getLength();
        return super.fieldAssignableInline(field) && (fieldLength == null || fieldLength <= 1000L);
    }

    @Override
    public boolean shouldSetFetchSizeForStreaming() {
        return false;
    }

    @Override
    public Object modifyTemporalObject(Object obj, ResultSet rs, int ii) throws SQLException {
        Timestamp work = rs.getTimestamp(ii);
        if (work == null) {
            return obj;
        }
        return new Date(work.getTime());
    }

    @Override
    public String blankComparison(String fieldName, String operator) {
        if (fieldName == null) {
            return null;
        }
        if ("isBlank".equals(operator)) {
            return "(" + fieldName + " IS NULL OR LENGTH(" + fieldName + ")=0)";
        }
        return "(" + fieldName + " IS NOT NULL AND LENGTH(" + fieldName + ")>0)";
    }

    @Override
    public String generateJoinClause(String escapedTo, String escapedFrom, Relation relation) {
        return escapedFrom + " = " + escapedTo + (relation.getJoinType() == 1 ? "(+)" : "");
    }

    @Override
    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName == null ? null : objectName.toUpperCase();
    }

    @Override
    public String getDummyQuery() {
        return "SELECT 1 FROM dual";
    }

    @Override
    protected int defaultAliasLengthLimit() {
        block3: {
            try {
                if (this.getDatabaseMajorVersion() > 12 || this.getDatabaseMajorVersion() == 12 && this.getDatabaseMinorVersion() >= 2) {
                    return 128;
                }
            }
            catch (Exception ignored) {
                if (aliasWarningLogged) break block3;
                log.warn((Object)"Failed to detect Oracle DB version when trying to set default table alias length limit, which depends on DB version. Assuming an older version and setting alias length limit to 30. Search for 'aliasLengthLimit' in SQL setting overview in Smartclient reference for more details.");
                aliasWarningLogged = true;
            }
        }
        return 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSnapshot(File snapshotFile) throws Exception {
        snapshotFile.deleteOnExit();
        String snapshotFileName = snapshotFile.getCanonicalPath();
        String cmd = "db --name=" + this.dbName + " snapshot " + this.defaultSchemaName + " " + snapshotFileName;
        Class<MysqlDriver> clazz = MysqlDriver.class;
        synchronized (MysqlDriver.class) {
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                if (CRASH_ON_FAILED_SNAPSHOT) {
                    throw new Exception(iscSystem.getFormattedErrorString());
                }
                log.warn((Object)"Failed to snapshot database, but continuing anyway because 'sql.Oracle.crash.on.failed.snapshot' is set to false");
                log.warn((Object)("Snapshot failure output: " + iscSystem.getFormattedErrorString()));
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreFromSnapshot(File snapshotFile) throws Exception {
        String snapshotFileName = snapshotFile.getCanonicalPath();
        String cmd = "db --name=" + this.dbName + " restore " + this.defaultSchemaName + " " + snapshotFileName;
        Class<MysqlDriver> clazz = MysqlDriver.class;
        synchronized (MysqlDriver.class) {
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSandbox(String sandboxName) throws Exception {
        String sandboxMechanism = this._sqlConfig.getString((Object)"sandbox.mechanism", "schema");
        if (!"workspace".equals(sandboxMechanism)) {
            throw new Exception("Oracle driver currently supports sandboxing only via workspaces. You must set sql." + this.dbName + ".sandbox.mechanism: sandbox in server.properties");
        }
        Connection conn = this.getOrCreateConnection();
        try (CallableStatement cs = conn.prepareCall("CALL DBMS_WM.CreateWorkspace('" + sandboxName + "')");){
            cs.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSandbox(String sandboxName) throws Exception {
        String sandboxMechanism = this._sqlConfig.getString((Object)"sandbox.mechanism", "schema");
        if (!"workspace".equals(sandboxMechanism)) {
            throw new Exception("Oracle driver currently supports sandboxing only via workspaces. You must set sql." + this.dbName + ".sandbox.mechanism: sandbox in server.properties");
        }
        Connection conn = this.getOrCreateConnection();
        try (CallableStatement cs = conn.prepareCall("CALL DBMS_WM.RemoveWorkspace('" + sandboxName + "')");){
            cs.execute();
        }
    }

    @Override
    public boolean supportsMultipleValuesClauses(SQLDataSource ds) {
        Map sequences = ds.getSequences();
        return true;
    }

    @Override
    public String getMultiInsertPrelude(String multiInsertSelectList) {
        return "SELECT " + multiInsertSelectList + " FROM (";
    }

    @Override
    public String getMultiInsertValueSetPrelude() {
        return "SELECT ";
    }

    @Override
    public String getMultiInsertValueSetCoda(boolean isLastValueSet) {
        return " FROM dual " + (isLastValueSet ? "" : "UNION ALL ");
    }

    @Override
    public String getMultiInsertCoda() {
        return ")";
    }

    @Override
    public boolean multiInsertRequiresAdditionalSelect() {
        return true;
    }

    @Override
    public boolean shouldParameterizeNullValues(boolean isMultiInserting) {
        return !isMultiInserting;
    }

    @Override
    public String getClobColumnDefinition() {
        return "clob";
    }

    @Override
    public String getLargeIntegerSQLType() {
        return "integer";
    }

    @Override
    public String getTextColumnDefinitionForLength(long length) throws Exception {
        if (length <= 4000L) {
            return "varchar(" + length + ")";
        }
        return "clob";
    }

    @Override
    public String getFloatType() {
        return "float";
    }
}

