/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.GetConsoleOutputRequest;
import com.amazonaws.services.ec2.model.GetConsoleOutputResult;
import com.amazonaws.services.ec2.model.Instance;
import com.isomorphic.autotest.BatchRunDao;
import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.TestRunnerConfiguration;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class AwsInstancesDao {
    public static final int NUMBER_OF_VPN_KEYS = 15;
    private static Logger log = new Logger(AwsInstancesDao.class.getName());
    private static String tmpDir = System.getenv("TMP_DIR") != null ? System.getenv("TMP_DIR") : "/tmp";

    public static void registerKeyOrdinalWithInstance(int keyOrdinal, String instanceId, Date batchStartTime) {
        String logMessage = "instance " + instanceId + " with VPN key ordinal " + keyOrdinal;
        try {
            DSRequest dsReq = new DSRequest("awsInstances", "add");
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("vpnKeyOrdinal", keyOrdinal);
            dataMap.put("instanceId", instanceId);
            dataMap.put("batchStartTime", batchStartTime);
            dsReq.setValues(dataMap);
            dsReq.execute();
            log.info((Object)("registered " + logMessage));
        }
        catch (Exception e) {
            log.info((Object)("failed to register " + logMessage), (Throwable)e);
        }
    }

    public static int getKeyOrdinal(AmazonEC2 ec2, List<Instance> liveInstances) {
        try {
            DSRequest dsReq = new DSRequest("awsInstances", "fetch");
            List data = dsReq.execute().getDataList();
            HashSet<Integer> results = new HashSet<Integer>();
            ArrayList<Date> deletedRows = new ArrayList<Date>();
            for (Object e : data) {
                Map row = (Map)e;
                int vpnKeyOrdinal = DataTools.getInt((Map)row, (Object)"vpnKeyOrdinal");
                Date batchStartTime = (Date)row.get("batchStartTime");
                String instanceId = (String)row.get("instanceId");
                boolean isJenkins = vpnKeyOrdinal < 0;
                boolean isTerminated = false;
                if (isJenkins) {
                    dsReq = new DSRequest("sourceCommit", "fetch");
                    dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
                    Map sourceCommit = dsReq.execute().getDataMap();
                    if (sourceCommit == null) {
                        log.error((Object)("Invalid state: sourceCommit record missing for awsInstances record:" + DataTools.prettyPrint((Object)data)));
                        isTerminated = true;
                    } else {
                        String completionStatus = (String)sourceCommit.get("completionStatus");
                        if (completionStatus != null) {
                            log.info((Object)("jenkins instanceId: " + instanceId + " has completionStatus: " + (String)completionStatus + ", marking as terminated"));
                            BatchRunDao.setBatchEndTime(batchStartTime);
                            isTerminated = true;
                        } else {
                            TestRunnerConfiguration config = TestRunner.getConfiguration();
                            long lifespan = new Date().getTime() - batchStartTime.getTime();
                            int gracePeriod = 300000;
                            if (lifespan > (long)(config.getJenkinsMaximumLifespan() + gracePeriod)) {
                                log.info((Object)("jenkins instanceId: " + instanceId + " has exceeded maxLifespan: " + config.getJenkinsMaximumLifespan() + " and will be flaged as crashed (status: awsCrash)"));
                                isTerminated = true;
                            }
                        }
                    }
                } else {
                    boolean isKeyUsed = false;
                    for (Instance liveInstance : liveInstances) {
                        String liveInstanceId = liveInstance.getInstanceId();
                        if (!liveInstanceId.equals(instanceId)) continue;
                        results.add(vpnKeyOrdinal);
                        isKeyUsed = true;
                    }
                    boolean bl = isTerminated = !isKeyUsed;
                }
                if (!isTerminated) continue;
                deletedRows.add(batchStartTime);
                log.info((Object)("removing AWS/Jenkins instances entry for batch " + batchStartTime + ", instance " + instanceId + " with VPN key ordinal " + vpnKeyOrdinal));
                dsReq = new DSRequest("awsInstances", "remove");
                dsReq.setCriteria("vpnKeyOrdinal", (Object)vpnKeyOrdinal);
                dsReq.execute();
                if (isJenkins) continue;
                try {
                    GetConsoleOutputRequest request = new GetConsoleOutputRequest(instanceId);
                    GetConsoleOutputResult result = ec2.getConsoleOutput(request);
                    String output = new String(Base64.decodeBase64((String)result.getOutput()));
                    PrintWriter writer = new PrintWriter("/shared/autotest/awslogs/console-" + instanceId + ".log");
                    writer.println(output);
                    writer.close();
                }
                catch (Exception e2) {
                    log.error((Object)("unable to capture the console log for AWS ID " + instanceId), (Throwable)e2);
                }
            }
            log.info((Object)("beginning failsafe check of " + deletedRows.size() + " deleted instance rows"));
            Collections.sort(deletedRows);
            for (Object e : deletedRows) {
                Date batchStartTime = (Date)e;
                String branch = BatchRunDao.getBranch(batchStartTime);
                log.info((Object)("checking whether to validate batch " + batchStartTime));
                if (AwsInstancesDao.areAnyOlderBatchesAliveForBranch(batchStartTime, branch)) continue;
                log.info((Object)("there are no batches older than " + batchStartTime + " so calling validate"));
                TestRunner.validateCommitRecord(batchStartTime, branch);
                Date successorBatchTime = BatchRunDao.getSuccessorBatchStartTime(batchStartTime, branch);
                while (successorBatchTime != null && AwsInstancesDao.getAwsInstanceId(successorBatchTime) == null && BatchRunDao.getAwsInstanceId(successorBatchTime) != null) {
                    log.info((Object)("calling forward validate for batch " + successorBatchTime));
                    TestRunner.validateCommitRecord(successorBatchTime, branch);
                    successorBatchTime = BatchRunDao.getSuccessorBatchStartTime(successorBatchTime, branch);
                }
            }
            log.info((Object)"completed failsafe check of deleted instance rows");
            for (int i = 1; i <= 15; ++i) {
                if (results.contains(i)) continue;
                return i;
            }
        }
        catch (Exception e) {
            log.error((Object)"exception thrown while searching for a valid VPN key ordinal", (Throwable)e);
        }
        return 0;
    }

    public static String getAwsInstanceId(Date batchStartTime) {
        try {
            DSRequest dsReq = new DSRequest("awsInstances", "fetch");
            dsReq.setCriteria("batchStartTime", (Object)batchStartTime);
            DSResponse dsResp = dsReq.execute();
            List data = dsResp.getDataList();
            if (data.size() != 1) {
                return null;
            }
            Map row = (Map)data.get(0);
            return (String)row.get("instanceId");
        }
        catch (Exception e) {
            log.error((Object)("encountered exception finding AWS instance for batch " + batchStartTime + ":"), (Throwable)e);
            return null;
        }
    }

    public static boolean areAnyOlderBatchesAliveForBranch(Date batchStartTime, String branch) {
        try {
            DSRequest dsReq = new DSRequest("awsInstances", "fetch");
            List data = dsReq.execute().getDataList();
            for (Object object : data) {
                Map row = (Map)object;
                Date rowBatchTime = (Date)row.get("batchStartTime");
                if (!branch.equals(BatchRunDao.getBranch(rowBatchTime)) || rowBatchTime.getTime() >= batchStartTime.getTime()) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)("encounered exception finding AWS instance for batch " + batchStartTime + ":"), (Throwable)e);
        }
        return false;
    }
}

