/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.UnionDataSource;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTransformException;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import com.isomorphic.util.ISCDate;
import com.isomorphic.util.ISCTime;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.ArrayUtils;

public class SQLTransform {
    private static Logger log = new Logger(SQLTransform.class.getName());
    private static Config config = Config.getGlobal();
    public static final int ALL_ROWS = -1;

    public static Map toAttributeMap(ResultSet rs, ResultSetMetaData rsmd, boolean useColumnLabel) throws Exception {
        return SQLTransform.toAttributeMap(rs, null, rsmd, useColumnLabel, null, null, null);
    }

    public static Map toAttributeMap(ResultSet rs, List dataSources, ResultSetMetaData rsmd, boolean useColumnLabel, Map caseInsensitiveMap, List outputs, DSRequest req) throws Exception {
        int columns = rsmd.getColumnCount();
        HashMap<String, Object> result = new HashMap<String, Object>(columns + 1);
        boolean retainNullValues = req == null ? false : Boolean.TRUE.equals(req.getAttribute("retainNullValues"));
        boolean warnAboutOracleTimestampConversion = false;
        JSTranslater jsTrans = null;
        for (int ii = 1; ii <= columns; ++ii) {
            String columnName = useColumnLabel ? rsmd.getColumnLabel(ii) : rsmd.getColumnName(ii);
            if (caseInsensitiveMap != null && caseInsensitiveMap.get(columnName) != null) {
                columnName = (String)caseInsensitiveMap.get(columnName);
            }
            Object obj = null;
            try {
                obj = rs.getObject(ii);
                if (obj instanceof UUID && SQLDriver.forceUUIDToString()) {
                    obj = obj.toString();
                }
            }
            catch (Exception e) {
                log.warn((Object)("Crashed trying to getObject for column " + columnName));
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                log.warn((Object)"Stacktrace", (Throwable)e);
            }
            if (outputs != null && !outputs.contains(columnName)) continue;
            boolean skipObject = false;
            if (dataSources != null) {
                for (DataSource ds : dataSources) {
                    DSField field;
                    block87: {
                        String sqlType;
                        field = ds.getField(columnName);
                        if (field == null) continue;
                        boolean useUTCDateTimes = true;
                        SQLDriver driver = null;
                        if (ds instanceof SQLDataSource) {
                            useUTCDateTimes = ((SQLDataSource)ds).shouldUseUTCDateTimes();
                            driver = ((SQLDataSource)ds).getDriver();
                        }
                        String baseType = field.getType();
                        try {
                            baseType = ((BasicDataSource)ds).getSimpleBaseType(baseType);
                        }
                        catch (Exception e) {
                            log.warn((Object)("Exception trying to derive base type for field " + field.getName()));
                        }
                        if ("boolean".equals(baseType)) {
                            sqlType = (String)field.get((Object)"sqlStorageStrategy");
                            if ("number".equals(sqlType) || "integer".equals(sqlType)) {
                                if (obj == null) {
                                    skipObject = true;
                                    break;
                                }
                                String value = obj.toString();
                                obj = "1".equals(value) || "true".equals(value.toLowerCase()) ? Boolean.TRUE : Boolean.FALSE;
                            } else if (sqlType != null && sqlType.indexOf("singleChar") == 0) {
                                if (!"singleChar".equals(sqlType) && obj == null) {
                                    skipObject = true;
                                    break;
                                }
                                obj = SQLTransform.convertSingleCharValue(sqlType, obj, field);
                            } else if (sqlType != null && sqlType.equals("string")) {
                                String trueValue = (String)field.get((Object)"sqlTrueValue");
                                String falseValue = (String)field.get((Object)"sqlFalseValue");
                                if (trueValue == null && falseValue == null) {
                                    log.warn((Object)("Could not establish a storage strategy for boolean 'true' and 'false' for field " + field.getName() + " - returning 'false'"));
                                    obj = Boolean.FALSE;
                                } else {
                                    obj = trueValue != null ? Boolean.valueOf(trueValue.equals(obj)) : Boolean.valueOf(Boolean.valueOf(falseValue.equals(obj)) == false);
                                }
                            } else {
                                if (obj == null) {
                                    if (retainNullValues) break;
                                    skipObject = true;
                                    break;
                                }
                                obj = Boolean.valueOf(obj.toString());
                            }
                        } else if ("integer".equals(baseType)) {
                            if (field.getProperty("javaClass") != null) {
                                Class klass = Reflection.classForName((String)field.getString((Object)"javaClass"));
                                try {
                                    obj = driver.adaptGeneratedValue(obj, klass);
                                }
                                catch (Exception e) {
                                    log.warn((Object)("Caught exception processing explicit javaClass '" + field.getString((Object)"javaClass") + "' when adapting fetched value for field '" + field.getName() + "' of DataSource '" + ds.getName()), (Throwable)e);
                                }
                            }
                            if (obj == null) {
                                if (retainNullValues) break;
                                skipObject = true;
                                break;
                            }
                        } else {
                            if (obj == null) {
                                if (retainNullValues) break;
                                skipObject = true;
                                break;
                            }
                            if (field.isBinary()) {
                                if (driver.supportsBinaryStreams()) {
                                    obj = rs.getBinaryStream(ii);
                                    try {
                                        obj = ((SQLDataSource)ds).getDriver().handleInputStream((InputStream)obj);
                                    }
                                    catch (Exception e) {
                                        log.warn((Object)"Error attempting to handle a binary InputStream", (Throwable)e);
                                        continue;
                                    }
                                    if (req == null) break;
                                    req.setFreeOnExecute(false);
                                    break;
                                }
                                obj = rs.getBytes(ii);
                                break;
                            }
                            if (obj instanceof UUID || "uuid".equals(field.getType())) {
                                obj = obj.toString();
                            } else if (obj instanceof Clob || "clob".equals(field.getType())) {
                                obj = rs.getCharacterStream(ii);
                                try {
                                    obj = ((SQLDataSource)ds).getDriver().handleCharacterStream((Reader)obj);
                                }
                                catch (Exception e) {
                                    log.warn((Object)"Error attempting to handle a character stream", (Throwable)e);
                                    continue;
                                }
                                if (req != null) {
                                    req.setFreeOnExecute(false);
                                }
                            } else if (("date".equals(baseType) || "time".equals(baseType) || "datetime".equals(baseType)) && !field.isMultiple()) {
                                sqlType = (String)field.get((Object)"sqlStorageStrategy");
                                if ("number".equals(sqlType) || "integer".equals(sqlType) || "text".equals(sqlType)) {
                                    String sqlFormat = (String)field.get((Object)"sqlDateFormat");
                                    if (sqlFormat == null) {
                                        sqlFormat = "yyyyMMdd";
                                    }
                                    SimpleDateFormat sdf = null;
                                    if ("number".equals(sqlType) && ("epoch".equalsIgnoreCase(sqlFormat) || "epochms".equalsIgnoreCase(sqlFormat))) {
                                        long e = obj instanceof Number ? ((Number)obj).longValue() : Long.parseLong(rs.getString(ii));
                                        int milliseconds = 1000;
                                        if ("epochms".equalsIgnoreCase(sqlFormat)) {
                                            milliseconds = 1;
                                        }
                                        obj = new Date(e * (long)milliseconds);
                                        continue;
                                    }
                                    sdf = new SimpleDateFormat(sqlFormat);
                                    if (("number".equals(sqlType) || "integer".equals(sqlType)) && Float.parseFloat(obj.toString()) == 0.0f) {
                                        obj = null;
                                        continue;
                                    }
                                    String str = obj.toString();
                                    if (obj.toString().length() < sqlFormat.length()) {
                                        for (int j = str.length(); j < sqlFormat.length(); ++j) {
                                            str = "0" + str;
                                        }
                                    } else if (obj.toString().length() > sqlFormat.length()) {
                                        log.warn((Object)("Unable to parse a valid date, time or datetime out of value " + obj + " using format string " + sqlFormat));
                                        obj = null;
                                        continue;
                                    }
                                    try {
                                        obj = sdf.parse(str);
                                    }
                                    catch (ParseException pe) {
                                        log.warn((Object)("Unable to parse a valid date, time or datetime out of value " + obj + " using format string " + sqlFormat));
                                    }
                                } else if (obj instanceof Timestamp && "datetime".equals(field.getType())) {
                                    if (useUTCDateTimes && driver != null) {
                                        obj = driver.getUTCTimestamp(rs, ii);
                                    }
                                } else if (driver != null) {
                                    obj = driver.modifyTemporalObject(obj, rs, ii);
                                }
                                if (!(obj instanceof Date)) {
                                    log.warn((Object)("received a non-java.util.Date class: " + obj.getClass().getName() + " for date field: " + field.getName()));
                                } else if ("date".equals(field.getType())) {
                                    obj = new ISCDate(((Date)obj).getTime());
                                } else if ("time".equals(field.getType())) {
                                    obj = new ISCTime(((Date)obj).getTime());
                                }
                            } else if (field.isMultiple() && field.getMultipleStorage() == null) {
                                if (obj instanceof String) {
                                    String string = (String)obj;
                                    obj = string.split(",");
                                }
                            } else {
                                obj = driver.transformFieldValue(field, obj);
                            }
                        }
                        if ("text".equals(baseType) && !field.typeIsDefaulted()) {
                            if (obj instanceof InputStream) {
                                try {
                                    obj = IOUtil.inputStreamToString((InputStream)((InputStream)obj));
                                    break block87;
                                }
                                catch (IOException e) {
                                    log.warn((Object)"Error attempting to handle a binary InputStream", (Throwable)e);
                                    continue;
                                }
                            }
                            if (obj instanceof Byte[] || obj instanceof byte[]) {
                                try {
                                    obj = new String(obj instanceof Byte[] ? ArrayUtils.toPrimitive((Byte[])((Byte[])obj)) : (byte[])obj);
                                    break block87;
                                }
                                catch (Exception e) {
                                    log.warn((Object)"Error attempting to handle an array of bytes", (Throwable)e);
                                    continue;
                                }
                            }
                            if (obj instanceof Reader) {
                                try {
                                    obj = IOUtil.readerToString((Reader)((Reader)obj));
                                    break block87;
                                }
                                catch (Exception e) {
                                    log.warn((Object)"Error attempting to handle a Reader", (Throwable)e);
                                    continue;
                                }
                            }
                            if (obj instanceof Collection) {
                                String[] collection = new ArrayList();
                                for (Object o : (Collection)obj) {
                                    collection.add(o == null ? null : o.toString());
                                }
                                obj = collection;
                            } else if (obj != null && obj.getClass().isArray()) {
                                Object[] array = DataTools.toObjectArray((Object)obj);
                                for (int k = 0; k < array.length; ++k) {
                                    array[k] = array[k] == null ? null : array[k].toString();
                                }
                                obj = array;
                            } else {
                                obj = obj.toString();
                            }
                        }
                    }
                    if (!field.isJSON() || obj == null) continue;
                    if (jsTrans == null) {
                        jsTrans = JSTranslater.strict();
                    }
                    if (obj instanceof String) {
                        obj = jsTrans.fromJS((String)obj);
                        continue;
                    }
                    if (obj instanceof Reader) {
                        obj = jsTrans.fromJS((Reader)obj);
                        continue;
                    }
                    if (!(obj instanceof InputStream)) continue;
                    obj = jsTrans.fromJS((InputStream)obj);
                }
            }
            if (skipObject) continue;
            result.put(columnName, obj);
        }
        return result;
    }

    protected static Boolean convertSingleCharValue(String sqlType, Object columnValue, DSField field) {
        String t = (String)field.get((Object)"sqlTrueValue");
        if (t != null) {
            t = t.substring(0, 1);
        }
        if ("singleChar10".equals(sqlType)) {
            t = "1";
        } else if ("singleCharYN".equals(sqlType)) {
            t = "Y";
        } else if ("singleCharTF".equals(sqlType)) {
            t = "T";
        }
        if (t == null) {
            log.warn((Object)("Could not establish a storage strategy for boolean 'true' for field " + field.getName() + " - returning 'false'"));
            return Boolean.FALSE;
        }
        return t.equals(columnValue);
    }

    public static boolean hasBrokenCursorAPIs(SQLDriver driver) {
        return driver.hasBrokenCursorAPIs();
    }

    public static boolean hasBrokenCursorAPIs(String dbName) throws Exception {
        return SQLTransform.hasBrokenCursorAPIs(SQLDriver.instance(dbName));
    }

    public static List toListOfMaps(ResultSet rs) throws Exception {
        return SQLTransform.toListOfMaps(rs, -1L, false);
    }

    public static List toListOfMaps(ResultSet rs, SQLDriver driver) throws Exception {
        return SQLTransform.toListOfMaps(rs, -1L, SQLTransform.hasBrokenCursorAPIs(driver));
    }

    public static List toListOfMaps(ResultSet rs, boolean brokenCursorAPIs) throws Exception {
        return SQLTransform.toListOfMaps(rs, -1L, brokenCursorAPIs);
    }

    public static List toListOfMaps(ResultSet rs, long numRows) throws Exception {
        return SQLTransform.toListOfMaps(rs, numRows, false);
    }

    public static List toListOfMaps(ResultSet rs, long numRows, SQLDriver driver) throws Exception {
        return SQLTransform.toListOfMaps(rs, numRows, SQLTransform.hasBrokenCursorAPIs(driver));
    }

    public static List toListOfMaps(ResultSet rs, long numRows, boolean brokenCursorAPIs) throws Exception {
        return SQLTransform.toListOfMapsOrBeans(rs, numRows, brokenCursorAPIs, null);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, SQLDriver driver, List dataSources) throws Exception {
        return SQLTransform.toListOfMapsOrBeans(rs, -1L, SQLTransform.hasBrokenCursorAPIs(driver), dataSources);
    }

    public static List toListOfMaps(ResultSet rs, long numRows, SQLDriver driver, List dataSources) throws Exception {
        return SQLTransform.toListOfMapsOrBeans(rs, numRows, SQLTransform.hasBrokenCursorAPIs(driver), dataSources);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, boolean brokenCursorAPIs, List dataSources) throws Exception {
        return SQLTransform.toListOfMapsOrBeans(rs, -1L, brokenCursorAPIs, dataSources);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, long numRows, boolean brokenCursorAPIs, List dataSources) throws Exception {
        return SQLTransform.toListOfMapsOrBeans(rs, numRows, brokenCursorAPIs, dataSources, null);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, SQLDriver driver, List dataSources, Map opConfig) throws Exception {
        return SQLTransform.toListOfMapsOrBeans(rs, -1L, SQLTransform.hasBrokenCursorAPIs(driver), dataSources, opConfig);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, SQLDriver driver, List dataSources, Map opConfig, DSRequest req) throws Exception {
        return SQLTransform.toListOfMapsOrBeans(rs, -1L, SQLTransform.hasBrokenCursorAPIs(driver), dataSources, opConfig, req);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, boolean brokenCursorAPIs, List dataSources, Map opConfig) throws Exception {
        return SQLTransform.toListOfMapsOrBeans(rs, -1L, brokenCursorAPIs, dataSources, opConfig);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, boolean brokenCursorAPIs, List dataSources, Map opConfig, DSRequest req) throws Exception {
        return SQLTransform.toListOfMapsOrBeans(rs, -1L, brokenCursorAPIs, dataSources, opConfig, req);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, long numRows, SQLDriver driver, List dataSources, Map opConfig) throws Exception {
        return SQLTransform.toListOfMapsOrBeans(rs, numRows, SQLTransform.hasBrokenCursorAPIs(driver), dataSources, opConfig);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, long numRows, SQLDriver driver, List dataSources, Map opConfig, DSRequest req) throws Exception {
        return SQLTransform.toListOfMapsOrBeans(rs, numRows, SQLTransform.hasBrokenCursorAPIs(driver), dataSources, opConfig, req);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, long numRows, boolean brokenCursorAPIs, List dataSources, Map opConfig) throws Exception {
        return SQLTransform.toListOfMapsOrBeans(rs, numRows, brokenCursorAPIs, dataSources, opConfig, null);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, long numRows, boolean brokenCursorAPIs, List dataSources, Map opConfig, DSRequest req) throws Exception {
        return SQLTransform.toListOfMapsOrBeans(rs, numRows, brokenCursorAPIs, dataSources, opConfig, req, true);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, long numRows, boolean brokenCursorAPIs, List dataSources, Map opConfig, DSRequest req, boolean convertToBeans) throws Exception {
        return SQLTransform.toListOfMapsOrBeans(rs, numRows, brokenCursorAPIs, dataSources, opConfig, req, convertToBeans, null);
    }

    public static List toListOfMapsOrBeans(ResultSet rs, long numRows, boolean brokenCursorAPIs, List dataSources, Map opConfig, DSRequest req, boolean convertToBeans, DSResponse dsResponse) throws Exception {
        DataSource ds;
        DataSource firstDS;
        String beanClassName = null;
        ArrayList<String> outputs = null;
        DataSource dataSource = firstDS = dataSources == null ? null : (DataSource)dataSources.get(0);
        if (opConfig != null) {
            beanClassName = (String)opConfig.get("beanClassName");
            String outputsString = (String)opConfig.get("outputs");
            if (outputsString != null) {
                outputs = new ArrayList<String>();
                String[] outputsArray = outputsString.split(",");
                for (int i = 0; i < outputsArray.length; ++i) {
                    outputs.add(outputsArray[i].trim());
                }
            }
        }
        if (beanClassName == null && dataSources != null) {
            beanClassName = (String)firstDS.getConfig().get((Object)"beanClassName");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Date start = new Date();
        if (req == null || !req.shouldStreamResults()) {
            if (brokenCursorAPIs) {
                if (numRows != -1L) {
                    throw new SQLTransformException("Partial processing of ResultSets is not supported for this database");
                }
                if (!rs.next()) {
                    return result;
                }
            } else {
                boolean isBeforeFirst = false;
                boolean isAfterLast = false;
                try {
                    isBeforeFirst = rs.isBeforeFirst();
                    isAfterLast = rs.isAfterLast();
                }
                catch (Exception ignored) {
                    log.debug((Object)"isBeforeFirst()/isAfterLast() throwing exceptions - attempting workaround");
                }
                if ((isBeforeFirst || isAfterLast || rs.getRow() == 0) && !rs.next()) {
                    return result;
                }
            }
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        HashMap<String, String> caseInsensitiveMap = null;
        boolean useColumnLabel = false;
        if (dataSources != null && (ds = (DataSource)dataSources.get(0)) instanceof SQLDataSource) {
            SQLDriver driver = ((SQLDataSource)ds).getDriver();
            useColumnLabel = driver.useColumnLabelInMetadata();
        }
        if (dataSources != null) {
            caseInsensitiveMap = new HashMap<String, String>();
            int columns = rsmd.getColumnCount();
            for (int i = 1; i <= columns; ++i) {
                List names;
                String fieldName = null;
                String columnName = useColumnLabel ? rsmd.getColumnLabel(i) : rsmd.getColumnName(i);
                for (Object ds2 : dataSources) {
                    names = ds2._getFieldNames();
                    if (!names.contains(columnName)) continue;
                    fieldName = columnName;
                    break;
                }
                if (fieldName == null) {
                    for (Object ds2 : dataSources) {
                        names = ds2._getFieldNames();
                        for (String name : names) {
                            if (!name.equalsIgnoreCase(columnName)) continue;
                            fieldName = name;
                            break;
                        }
                        if (fieldName == null) continue;
                        break;
                    }
                }
                if (fieldName == null && req != null) {
                    List includeFrom = req.getIncludeFrom();
                    if (includeFrom != null && includeFrom.size() > 0) {
                        IncludeFromDefinition incFrom;
                        Object incFromObject;
                        Object ds2;
                        ds2 = includeFrom.iterator();
                        while (ds2.hasNext()) {
                            incFromObject = ds2.next();
                            incFrom = (IncludeFromDefinition)incFromObject;
                            if (!incFrom.getThisFieldName().equals(columnName)) continue;
                            fieldName = columnName;
                            break;
                        }
                        if (fieldName == null) {
                            ds2 = includeFrom.iterator();
                            while (ds2.hasNext()) {
                                incFromObject = ds2.next();
                                incFrom = (IncludeFromDefinition)incFromObject;
                                if (!incFrom.getThisFieldName().equalsIgnoreCase(columnName)) continue;
                                fieldName = incFrom.getThisFieldName();
                                break;
                            }
                        }
                    }
                    if (Boolean.TRUE.equals(req.getAttribute("unionMode"))) {
                        UnionDataSource uds = (UnionDataSource)req.getAttribute("unionDataSource");
                        names = uds.getUnionFieldNames(req);
                        if (names.contains(columnName)) {
                            fieldName = columnName;
                        } else {
                            for (String name : names) {
                                if (!name.equalsIgnoreCase(columnName)) continue;
                                fieldName = name;
                                break;
                            }
                        }
                    }
                }
                if (fieldName != null) {
                    caseInsensitiveMap.put(columnName, fieldName);
                    continue;
                }
                caseInsensitiveMap.put(columnName, columnName);
            }
        }
        Map maxRowsInfo = req == null ? null : req.getMaxRowsToFetch();
        int maxRows = maxRowsInfo == null ? -1 : (Integer)maxRowsInfo.get("maxRows");
        String maxRowsReason = maxRowsInfo == null ? "" : (String)maxRowsInfo.get("reason");
        int i = 0;
        while ((long)i < numRows || numRows == -1L) {
            if (i >= maxRows && maxRows != -1 && numRows == -1L) {
                String msg = "Response data was truncated for fetch on DataSource '" + (firstDS == null ? "NULL" : firstDS.getID()) + "', operation '" + req.getOperationId() + "' because there were more rows in the resultset than the safety limit configured by the " + maxRowsReason + " property, which is set to " + maxRows + ".  Scan the client-side documentation for '" + (maxRowsReason.contains("client") ? "clientRequest" : "request") + "MaxRows' for more details";
                throw new Exception(msg);
            }
            Map map = SQLTransform.toAttributeMap(rs, dataSources, rsmd, useColumnLabel, caseInsensitiveMap, outputs, req);
            if (!convertToBeans || beanClassName == null || beanClassName.equals("")) {
                result.add(map);
            } else {
                try {
                    Object bean = DataTools.setProperties((Map)map, Reflection.classForName((String)beanClassName).newInstance());
                    result.add(bean);
                }
                catch (Exception e) {
                    log.warn((Object)("Couldn't create bean of class '" + beanClassName + "':" + e.getMessage()));
                    throw new SQLException(e.getMessage());
                }
            }
            if (!rs.next()) {
                if (dsResponse == null) break;
                dsResponse._setHasNextRecord(false);
                break;
            }
            ++i;
        }
        Date end = new Date();
        Logger.timing.debug((Object)("SQLTransform (" + result.size() + " rows): " + (end.getTime() - start.getTime()) + "ms"));
        return result;
    }

    public static Map toMapOfLists(ResultSet rs) throws SQLException {
        int ii;
        HashMap result = new HashMap();
        ResultSetMetaData header = rs.getMetaData();
        for (ii = 1; ii <= header.getColumnCount(); ++ii) {
            result.put(header.getColumnName(ii), new ArrayList());
        }
        while (rs.next()) {
            for (ii = 1; ii < header.getColumnCount(); ++ii) {
                Object value = rs.getObject(ii);
                if (value instanceof UUID && SQLDriver.forceUUIDToString()) {
                    value = value.toString();
                }
                ((List)result.get(header.getColumnName(ii))).add(value);
            }
        }
        return result;
    }

    public static List toValuesList(ResultSet results, String column) throws SQLException {
        ArrayList<Object> valuesList = new ArrayList<Object>();
        while (results.next()) {
            Object value = results.getObject(column);
            if (value instanceof UUID && SQLDriver.forceUUIDToString()) {
                value = value.toString();
            }
            if (value == null) continue;
            valuesList.add(value);
        }
        return valuesList;
    }
}

