/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scripting.java;

import com.isomorphic.log.Logger;
import com.isomorphic.scripting.java.ISCJavaFileObject;
import com.isomorphic.scripting.java.ISCMemoryJavaFileManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class ISCJavaCompiler {
    private JavaCompiler tool;
    private StandardJavaFileManager stdManager;
    private ISCMemoryJavaFileManager customManager;
    private ClassLoader loader;
    private Logger log = new Logger(ISCJavaCompiler.class);
    private static final String CLASS_FILE_EXTENSION = ".class";

    public ISCJavaCompiler(ClassLoader loader) {
        this.tool = ToolProvider.getSystemJavaCompiler();
        if (this.tool == null) {
            throw new RuntimeException("Unable to obtain an instance of the Java compiler.  If you wish to use the \"java\" language for scripting, you must ensure that the VM is using a JDK, not a JRE");
        }
        this.stdManager = this.tool.getStandardFileManager(null, null, null);
        this.customManager = new ISCMemoryJavaFileManager(this, this.stdManager, loader);
        this.loader = loader;
    }

    public Map<String, byte[]> compile(String source, String fileName) {
        PrintWriter err = new PrintWriter(System.err);
        return this.compile(source, fileName, err, null, null);
    }

    public Map<String, byte[]> compile(String fileName, String source, Writer err) {
        return this.compile(fileName, source, err, null, null);
    }

    public Map<String, byte[]> compile(String fileName, String source, Writer err, String sourcePath) {
        return this.compile(fileName, source, err, sourcePath, null);
    }

    public Map<String, byte[]> compile(String fileName, String source, Writer err, String sourcePath, String classPath) {
        JavaCompiler.CompilationTask task;
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ArrayList<JavaFileObject> compUnits = new ArrayList<JavaFileObject>(1);
        compUnits.add(ISCMemoryJavaFileManager.makeStringSource(fileName, source));
        ArrayList<String> options = new ArrayList<String>();
        options.add("-Xlint:all");
        options.add("-g:none");
        options.add("-deprecation");
        if (sourcePath != null) {
            options.add("-sourcepath");
            options.add(sourcePath);
        }
        if (classPath != null) {
            options.add("-classpath");
            options.add(classPath);
        }
        if (!(task = this.tool.getTask(err, this.customManager, diagnostics, options, null, compUnits)).call().booleanValue()) {
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                try {
                    if (err == null) continue;
                    err.write(diagnostic.toString() + "\n");
                }
                catch (Exception exception) {}
            }
            return null;
        }
        Map<String, byte[]> classBytes = this.customManager.getClassBytes();
        try {
            this.customManager.close();
        }
        catch (IOException exp) {
            this.log.warn(exp);
        }
        return classBytes;
    }

    public List<JavaFileObject> find(String packageName) throws IOException {
        String javaPackageName = packageName.replaceAll("\\.", "/");
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        if (result.size() == 0) {
            Enumeration<URL> urlEnumeration = this.loader.getResources(javaPackageName);
            while (urlEnumeration.hasMoreElements()) {
                URL packageFolderURL = urlEnumeration.nextElement();
                result.addAll(this.listUnder(packageName, packageFolderURL));
            }
        }
        return result;
    }

    private Collection<JavaFileObject> listUnder(String packageName, URL packageFolderURL) {
        File directory;
        try {
            directory = new File(URLDecoder.decode(packageFolderURL.getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("UnsupportedEncodingException when trying to decode URL " + packageFolderURL.getFile() + " during classloading for Java-language script compilation.  Trying the URL without decoding");
            directory = new File(packageFolderURL.getFile());
        }
        if (directory.isDirectory()) {
            return this.processDir(packageName, directory);
        }
        return this.processJar(packageFolderURL);
    }

    private List<JavaFileObject> processJar(URL packageFolderURL) {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        try {
            String jarUri = packageFolderURL.toExternalForm().split("!")[0];
            if (packageFolderURL.toExternalForm().split("!").length == 1) {
                return result;
            }
            JarURLConnection jarConn = (JarURLConnection)packageFolderURL.openConnection();
            String rootEntryName = jarConn.getEntryName();
            int rootEnd = rootEntryName.length() + 1;
            Enumeration<JarEntry> entryEnum = jarConn.getJarFile().entries();
            while (entryEnum.hasMoreElements()) {
                JarEntry jarEntry = entryEnum.nextElement();
                String name = jarEntry.getName();
                if (!name.startsWith(rootEntryName) || name.indexOf(47, rootEnd) != -1 || !name.endsWith(CLASS_FILE_EXTENSION)) continue;
                URI uri = URI.create(jarUri + "!/" + name);
                String binaryName = name.replaceAll("/", ".");
                binaryName = binaryName.replaceAll(".class$", "");
                result.add(new ISCJavaFileObject(binaryName, uri));
            }
        }
        catch (Exception e) {
            new Logger().error((Object)("Wasn't able to open " + packageFolderURL + " as a jar file"), e);
            throw new RuntimeException("Wasn't able to open " + packageFolderURL + " as a jar file", e);
        }
        return result;
    }

    private List<JavaFileObject> processDir(String packageName, File directory) {
        File[] childFiles;
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        for (File childFile : childFiles = directory.listFiles()) {
            if (!childFile.isFile() || !childFile.getName().endsWith(CLASS_FILE_EXTENSION)) continue;
            String binaryName = packageName + "." + childFile.getName();
            binaryName = binaryName.replaceAll(".class$", "");
            result.add(new ISCJavaFileObject(binaryName, childFile.toURI()));
        }
        return result;
    }
}

