/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scripting;

import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.scripting.AbstractScript;
import com.isomorphic.scripting.ScriptExceptionItem;
import com.isomorphic.util.DataTools;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.codec.digest.DigestUtils;

public class ScriptXBase
extends AbstractScript {
    private static Logger log = new Logger(ScriptXBase.class.getName());
    static Map<Class, ScriptEngine> reusableEngines = new HashMap<Class, ScriptEngine>();
    static Map<String, Boolean> engineNamesLogged = new HashMap<String, Boolean>();
    private static boolean cacheCompilableScripts = Config.getGlobal().getBoolean((Object)"scripting.cache.compilable.scripts", true);
    protected boolean cacheThisScript = true;
    protected ScriptEngine engine;
    protected StringWriter stdout;
    protected StringWriter stderr;
    protected ScriptContext scriptContext;
    protected static final ThreadLocal<List> scriptEvalStackContainer = new ThreadLocal();
    static List<String> jsEngineNames = new ArrayList<String>(){
        {
            this.add("javascript");
            this.add("Javascript");
            this.add("JavaScript");
            this.add("ecmascript");
            this.add("graal.js");
        }
    };
    static Map<String, CompiledScript> compiledScripts = new HashMap<String, CompiledScript>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map eval(DataTypeMap data) throws Exception {
        long str = System.nanoTime();
        this.configure(data);
        long configTime = System.nanoTime() - str;
        str = System.nanoTime();
        this.init();
        long initTime = System.nanoTime() - str;
        this.prepareContext();
        str = System.nanoTime();
        long prepTime = System.nanoTime() - str;
        ArrayList<Integer> scriptEvalStack = scriptEvalStackContainer.get();
        if (scriptEvalStack == null) {
            scriptEvalStack = new ArrayList<Integer>();
            scriptEvalStackContainer.set(scriptEvalStack);
        }
        scriptEvalStack.add(0);
        try {
            Map map = this.evalScript();
            return map;
        }
        finally {
            scriptEvalStack.remove(scriptEvalStack.size() - 1);
        }
    }

    protected void resetEngine() throws Exception {
        reusableEngines.remove(this.getClass());
        this.init();
    }

    protected void init() throws Exception {
        int index;
        DSRequest req = (DSRequest)this.bindings.get("dsRequest");
        DataSource ds = (DataSource)this.bindings.get("ds");
        if (ds == null) {
            ds = (DataSource)this.bindings.get("dataSource");
        }
        DataTypeMap opBinding = ds != null ? ds.getOperationBinding(req) : null;
        boolean bl = this.cacheThisScript = opBinding != null ? opBinding.getBoolean((Object)"useScriptCaching", cacheCompilableScripts) : cacheCompilableScripts;
        if (this.cacheThisScript) {
            if (reusableEngines.containsKey(this.getClass())) {
                this.engine = reusableEngines.get(this.getClass());
                log.debug("Found reusable Engine for scripting environment " + this.getClass().getSimpleName());
                return;
            }
            log.debug("In init(), and there's no reusableEngine");
        }
        ScriptEngineManager factory = null;
        try {
            factory = new ScriptEngineManager();
        }
        catch (Throwable e) {
            log.error((Object)"Unable to init scripting - make sure you are running JDK 1.6+?", e);
            throw new Exception("Unable to init scripting.  Make sure you're running JDK 1.6+");
        }
        String localEngineName = this.engineName;
        log.info("Initializing scripting engine: " + localEngineName);
        try {
            this.engine = factory.getEngineByName(localEngineName);
        }
        catch (Exception e) {
            log.error((Object)("Unable to load engine: " + localEngineName), e);
            throw new Exception("Unable to load engine by name: " + localEngineName + ".  Please make sure you have the required JARs for this engine in WEB-INF/lib");
        }
        if (this.engine == null) {
            try {
                this.engine = factory.getEngineByExtension(localEngineName);
            }
            catch (Error e) {
                log.error((Object)("Unable to load engine: " + localEngineName), e);
                throw new Exception("Unable to load engine by extension: " + localEngineName + ".  Please make sure you have the required JARs for this engine in WEB-INF/lib");
            }
        }
        if (this.engine == null && (index = jsEngineNames.indexOf(localEngineName)) != -1) {
            for (int i = 0; i < jsEngineNames.size(); ++i) {
                if (i == index) continue;
                localEngineName = jsEngineNames.get(i);
                try {
                    this.engine = factory.getEngineByName(localEngineName);
                }
                catch (Error e) {
                    log.error((Object)("Unable to load engine: " + localEngineName), e);
                    throw new Exception("Unable to load engine by name: " + localEngineName + " when looking for alternative Javascript engines");
                }
                if (this.engine == null) continue;
                log.warn("We could not find a ScriptEngine registered with name '" + this.engineName + "', using the engine registered with name '" + localEngineName + "' instead.");
            }
        }
        if (this.engine == null) {
            throw new Exception("Unable to load engine by name or extension: " + this.engineName + ".  Please make sure you have the required JARs for this engine in WEB-INF/lib");
        }
        if (!Boolean.TRUE.equals(engineNamesLogged.get(localEngineName))) {
            log.info("Using ScriptEngine '" + this.engine.getFactory().getEngineName() + "' for registered short name '" + localEngineName + "'");
            log.debug("Further information:");
            log.debug("Local Name: " + localEngineName);
            log.debug("Engine Name: " + this.engine.getFactory().getEngineName());
            log.debug("Engine Version: " + this.engine.getFactory().getEngineVersion());
            log.debug("Language Name: " + this.engine.getFactory().getLanguageName());
            log.debug("Language Version: " + this.engine.getFactory().getLanguageVersion());
            log.debug("Implementing class: " + this.engine.getClass().getCanonicalName());
        }
        if (this.cacheThisScript && this.engine instanceof Compilable) {
            log.info("Engine '" + this.engineName + "' (" + this.engine.getFactory().getEngineName() + ") is Compilable, so we can pre-compile scripts and avoid the overhead of recompilation every time a script is eval'd.  However, this requires that the ScriptEngine be the same object from one call to the next, so caching this instance on the class as 'reusableEngine'");
            reusableEngines.put(this.getClass(), this.engine);
        }
    }

    protected void prepareContext() throws Exception {
        if (this.cacheThisScript) {
            this.scriptContext = new SimpleScriptContext();
            this.scriptContext.setBindings(this.engine.createBindings(), 100);
        } else {
            this.scriptContext = this.engine.getContext();
        }
        if (this.bindings != null) {
            for (String key : this.bindings.keySet()) {
                Object value = this.bindings.get(key);
                this.scriptContext.setAttribute(key, value, 100);
            }
        }
        if (this.captureOutput) {
            this.stdout = new StringWriter();
            this.stderr = new StringWriter();
            this.scriptContext.setWriter(this.stdout);
            this.scriptContext.setErrorWriter(this.stderr);
        }
        this.engine.setContext(this.scriptContext);
    }

    protected ScriptExceptionItem getScriptExceptionItem(ScriptExceptionItem.Type type, int line, String message, int column) {
        int footerLines;
        int importDirectivesLines = (this.importDirectives == null ? 0 : DataTools.countCompleteLines(this.importDirectives)) + 1;
        int headerLines = (this.header == null ? 0 : DataTools.countCompleteLines(this.header)) + 1;
        int scriptLines = (this.script == null ? 0 : DataTools.countCompleteLines(this.script)) + 1;
        int n = footerLines = this.footer == null ? 0 : DataTools.countCompleteLines(this.footer);
        if (line < 0) {
            return new ScriptExceptionItem(type, "Unknown Source", line, column, message);
        }
        if (line <= importDirectivesLines) {
            return new ScriptExceptionItem(type, "importDirectives", line, column, message);
        }
        if (line <= importDirectivesLines + headerLines) {
            return new ScriptExceptionItem(type, this.headerFilename, line - importDirectivesLines, column, message);
        }
        if (line <= importDirectivesLines + headerLines + scriptLines) {
            int scriptOffset = -1;
            int scriptLine = line - importDirectivesLines - headerLines;
            int sourceLine = -1;
            if (this.scriptSource != null) {
                try {
                    scriptOffset = this.scriptSource.getScriptSourceOffset(this.scriptSourceContext);
                    if (scriptOffset > 0) {
                        sourceLine = scriptLine + scriptOffset;
                    }
                }
                catch (Exception soe) {
                    log.warn((Object)"Error obtaining script offset: ", soe);
                }
            }
            return new ScriptExceptionItem(type, this.scriptSourceFilename == null ? "script" : this.scriptSourceFilename, scriptLine, sourceLine, column, message);
        }
        return new ScriptExceptionItem(type, this.footerFilename, line - importDirectivesLines - headerLines - scriptLines, column, message);
    }

    protected Exception fillInStackTrace(Exception e) {
        StackTraceElement element;
        int i;
        ScriptExceptionItem sei = null;
        StackTraceElement previousElement = null;
        ArrayList<StackTraceElement> filledStackTrace = new ArrayList<StackTraceElement>();
        boolean alreadyFilledStack = false;
        List scriptEvalStack = scriptEvalStackContainer.get();
        Integer scriptEvalStackIndex = (Integer)scriptEvalStack.get(0);
        StackTraceElement[] stackTraceArray = e.getStackTrace();
        if (scriptEvalStackIndex > 0) {
            for (i = 0; i < scriptEvalStackIndex; ++i) {
                element = stackTraceArray[i];
                filledStackTrace.add(element);
                previousElement = element;
            }
        }
        for (i = scriptEvalStackIndex.intValue(); i < stackTraceArray.length; ++i) {
            element = stackTraceArray[i];
            if (("com.isomorphic.scripting.ScriptXBase".equals(element.getClassName()) || this.getClass().getName().equals(element.getClassName())) && "evalScript".equals(element.getMethodName()) && !alreadyFilledStack) {
                if (e instanceof ScriptException) {
                    ScriptException se = (ScriptException)e;
                    sei = this.getScriptExceptionItem(ScriptExceptionItem.Type.RUNTIME, se.getLineNumber(), se.getMessage(), se.getColumnNumber());
                } else {
                    sei = this.getScriptExceptionItem(ScriptExceptionItem.Type.RUNTIME, previousElement != null ? previousElement.getLineNumber() : -1, "", -1);
                }
                int sourceLineNumber = sei.getScriptSourceLineNumber();
                if (sourceLineNumber < 0) {
                    filledStackTrace.add(new StackTraceElement(this.scriptSourceName, "", sei.getSource(), sei.getLineNumber()));
                } else {
                    filledStackTrace.add(new StackTraceElement(this.scriptSourceName, "scriptLine:" + sei.getLineNumber(), sei.getSource(), sourceLineNumber));
                }
                alreadyFilledStack = true;
                scriptEvalStackIndex = i + 2;
                scriptEvalStack.set(0, scriptEvalStackIndex);
            }
            filledStackTrace.add(element);
            previousElement = element;
        }
        StackTraceElement[] filledStackTraceArray = new StackTraceElement[filledStackTrace.size()];
        for (int j = 0; j < filledStackTrace.size(); ++j) {
            filledStackTraceArray[j] = (StackTraceElement)filledStackTrace.get(j);
        }
        e.setStackTrace(filledStackTraceArray);
        return e;
    }

    @Override
    protected Map evalScript() throws Exception {
        String evalScript = null;
        Object evalResult = null;
        DataSource ds = (DataSource)this.bindings.get("ds");
        if (ds == null) {
            ds = (DataSource)this.bindings.get("dataSource");
        }
        try {
            evalScript = (this.importDirectives == null ? "" : this.importDirectives) + "\n" + (this.header == null ? "" : this.header) + "\n" + (this.script == null ? "" : this.script) + "\n" + (this.footer == null ? "" : this.footer);
            if (log.isDebugEnabled()) {
                log.debug("Evaluating assembled script:\n" + evalScript);
            } else {
                log.info("Evaluating script:\n" + this.script);
            }
            if (this.cacheThisScript && ds != null) {
                String cacheKey = DigestUtils.md5Hex((String)evalScript);
                CompiledScript compiledScript = ds.getCompiledScript(cacheKey);
                if (compiledScript != null) {
                    Map javaValues = (Map)this.bindings.get("values");
                    long start = System.currentTimeMillis();
                    log.debug("Found compiledScript, invoking it");
                    evalResult = compiledScript.eval(this.scriptContext);
                    log.debug("Script execution elapsed time: " + (System.currentTimeMillis() - start) + "ms");
                } else if (this.engine instanceof Compilable) {
                    Compilable compilableEngine = (Compilable)((Object)this.engine);
                    log.debug("Did not find compiledScript, but '" + this.engineName + "' (" + this.engine.getFactory().getEngineName() + ", Java classname " + this.engine.getClass().getCanonicalName() + ") is Compilable - compiling and caching script");
                    long tc0 = System.nanoTime();
                    compiledScript = compilableEngine.compile(evalScript);
                    long tc2 = System.nanoTime();
                    log.debug("Elapsed time for compile: " + ((tc2 /= 1000L) - (tc0 /= 1000L)) + "us");
                    ds.cacheCompiledScript(cacheKey, compiledScript);
                    long t0 = System.nanoTime();
                    evalResult = compiledScript.eval(this.scriptContext);
                    long l = System.nanoTime();
                } else {
                    log.debug("'" + this.engine.getClass().getSimpleName() + "' is not Compilable, evaluating the script text intepretively");
                    evalResult = this.engine.eval(evalScript);
                }
            } else {
                if (cacheCompilableScripts) {
                    log.info("Caching switched off for this particular script - evaluating it using its own dedicated ScriptEngine instance");
                }
                evalResult = this.engine.eval(evalScript);
            }
        }
        catch (Exception e) {
            Exception processed = this.processException(e);
            if (processed != null) {
                throw processed;
            }
            throw this.fillInStackTrace(e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("evalResult", evalResult);
        if (this.captureOutput) {
            result.put("stdout", this.stdout.toString());
            result.put("stderr", this.stderr.toString());
        }
        return result;
    }

    protected Exception processException(Exception e) {
        return null;
    }
}

