/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLExpression;
import com.isomorphic.sql.SQLExpressions;
import java.util.Iterator;
import java.util.List;

public class SQLOrderClause
extends Base {
    private static Logger log = new Logger(SQLOrderClause.class.getName());
    private SQLExpressions sqlExpressions;
    private DSRequest request;
    private List<String> sortBy;
    private boolean isSqlLimit = false;

    public SQLOrderClause(DSRequest request) throws Exception {
        this.request = request;
        this.sqlExpressions = SQLExpressions.get(request);
    }

    public boolean isEmpty() {
        List<String> sortBy = this.sortBy != null ? this.sortBy : this.sqlExpressions.getSortFieldsWithDirection();
        return sortBy == null || sortBy.isEmpty();
    }

    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        return 1;
    }

    public String getSQLString() throws Exception {
        if (this.isEmpty()) {
            log.debug((Object)"no data; returning empty string");
            return "";
        }
        StringBuffer result = new StringBuffer();
        boolean sqlLimitMode = this.sortBy != null;
        Iterator<String> i = sqlLimitMode ? this.sortBy.iterator() : this.sqlExpressions.getSortFieldsWithDirection().iterator();
        while (i.hasNext()) {
            SQLExpression expression;
            String fieldName = i.next();
            boolean descending = false;
            if (fieldName.startsWith("-")) {
                fieldName = fieldName.substring(1);
                descending = true;
            }
            if ((expression = SQLExpressions.getExpression(this.request, fieldName, true)) == null || expression.isExcluded()) continue;
            String text = null;
            if (sqlLimitMode && this.isSqlLimit) {
                String column = expression.getColumn();
                SQLDriver driver = expression.getDriver();
                if (fieldName.equals(column)) {
                    if (driver.quoteColumnNames) {
                        column = driver.escapeColumnName(column);
                    }
                } else {
                    column = fieldName;
                }
                text = expression.getDriver().getExpressionForSortBy(column, this.sqlExpressions.getValueMap(fieldName), null, this.request);
            } else {
                if (expression.isAggregation()) {
                    text = expression.getRequest().getGroupBy() != null && expression.getRequest().getGroupBy().contains(fieldName) ? expression.getExprForSortBy() : expression.getAlias();
                }
                if (text == null) {
                    text = expression.getExprForSortBy();
                }
                if (text == null || "".equals(text.trim())) {
                    text = expression.getExpr();
                }
            }
            if (descending) {
                text = text + " DESC";
            }
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(text);
        }
        return result.toString();
    }

    public List<String> getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(List<String> sortBy) {
        this.sortBy = sortBy;
    }

    public boolean isSqlLimit() {
        return this.isSqlLimit;
    }

    public void setSqlLimit(boolean sqlLimit) {
        this.isSqlLimit = sqlLimit;
    }
}

