/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSFieldFormula;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLMetaData;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.util.ISCSystem;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class MysqlDriver
extends SQLDriver {
    private static Logger log = new Logger(MysqlDriver.class.getName());
    private static boolean optimizeCaseSensitiveCriteria = config.getBoolean((Object)"sql.mysql.optimizeCaseSensitiveCriteria", false);

    public MysqlDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
    }

    @Override
    public boolean supportsRegexp() throws Exception {
        return true;
    }

    @Override
    public String getExpressionForRegexp(String escapedColumnOrExpression, String operator, String regexp) throws Exception {
        regexp = this.matcher.reset(regexp).usePattern(REGEXP_SPECIAL_PATTERN).replaceAll(REGEXP_SPECIAL_ESCAPE);
        return ("regexp".equals(operator) ? "BINARY " : "") + escapedColumnOrExpression + " REGEXP " + this.escapeRegexp(regexp);
    }

    @Override
    public String openQuote() {
        return "`";
    }

    @Override
    public String closeQuote() {
        return "`";
    }

    public boolean isMariaDB() throws Exception {
        return this.getDatabaseProductVersion().indexOf("MariaDB") != -1;
    }

    @Override
    public boolean supportsMilliseconds() throws Exception {
        Boolean supportsMilliseconds = this._sqlConfig.getBoolean((Object)"_supportsMilliseconds");
        if (supportsMilliseconds == null) {
            supportsMilliseconds = Boolean.FALSE;
            if (this.isMariaDB()) {
                String version = this.getDatabaseProductVersion();
                String[] _version = version.split("\\.");
                version = version.substring(version.indexOf("-") + 1);
                int major = Integer.parseInt(_version[0]);
                int minor = Integer.parseInt(_version[1]);
                supportsMilliseconds = major >= 6 || major == 5 && minor >= 3;
            } else {
                supportsMilliseconds = this.getDatabaseMajorVersion() >= 6 || this.getDatabaseMajorVersion() == 5 && this.getDatabaseMinorVersion() >= 6;
            }
            this._sqlConfig.put((Object)"_supportsMilliseconds", (Object)supportsMilliseconds);
        }
        return supportsMilliseconds;
    }

    @Override
    public boolean supportsFieldComparison(String columnType, String otherColumnType) {
        if (columnType != null && otherColumnType != null) {
            if (columnType.equals(otherColumnType)) {
                return true;
            }
            boolean isText = DataSource.simpleTypeInheritsFromBuiltInType((String)columnType, (String)"text");
            boolean isInteger = DataSource.simpleTypeInheritsFromBuiltInType((String)columnType, (String)"integer");
            boolean isFloat = DataSource.simpleTypeInheritsFromBuiltInType((String)columnType, (String)"float");
            boolean isTextOther = DataSource.simpleTypeInheritsFromBuiltInType((String)otherColumnType, (String)"text");
            boolean isIntegerOther = DataSource.simpleTypeInheritsFromBuiltInType((String)otherColumnType, (String)"integer");
            boolean isFloatOther = DataSource.simpleTypeInheritsFromBuiltInType((String)otherColumnType, (String)"float");
            if ((isText || isInteger || isFloat) && (isTextOther || isIntegerOther || isFloatOther)) {
                return true;
            }
        }
        return super.supportsFieldComparison(columnType, otherColumnType);
    }

    @Override
    public boolean supportsSQLLimit() {
        return true;
    }

    @Override
    public String limitQuery(String query, long startRow, long batchSize, List outputColumns, String baseOrderClause, String computedOrderClause, DSRequest req, List dataSources, Map context) {
        String q = query;
        if (computedOrderClause != null && computedOrderClause.trim().length() > 0) {
            q = baseOrderClause == null || baseOrderClause.trim().length() == 0 || "$defaultOrderClause".equals(baseOrderClause) && (context.get("defaultOrderClause") == null || ((String)context.get("defaultOrderClause")).trim().length() == 0) ? q + " ORDER BY " : q + ", ";
            q = q + computedOrderClause;
        }
        return q + " LIMIT " + startRow + ", " + batchSize;
    }

    @Override
    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        log.debug((Object)("fetchLastRow data - primaryKeysPresent: " + primaryKeysPresent.toString() + "sequencesNotPresent: " + sequencesNotPresent.toString()));
        if (sequencesNotPresent.size() > 1) {
            throw new Exception("mysql can't handle more than one auto_increment primary_key");
        }
        if (this.dbConnection == null && req == null) {
            throw new Exception("no connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        if (!sequencesNotPresent.isEmpty()) {
            String sequenceName = (String)sequencesNotPresent.get(0);
            Object obj = MysqlDriver.getScalarResult("SELECT LAST_INSERT_ID()", this.dbConnection, this.dbName, this, req);
            Object transformed = this.getTransformedSequenceValue(obj, sequenceName, ds, req);
            if (transformed != null) {
                primaryKeys.put(sequenceName, transformed);
            } else {
                Long sequenceValue = Long.valueOf(obj.toString());
                primaryKeys.put(sequenceName, sequenceValue);
            }
        }
        return primaryKeys;
    }

    @Override
    public boolean supportsNativeReplace() {
        return true;
    }

    @Override
    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (tableName != null) {
            output = tableName + "." + output;
        }
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + remapName;
        }
        return output;
    }

    @Override
    public String transformFormula(String formula) {
        if (formula != null) {
            formula = DSFieldFormula.replace((String)formula, (String)"ceiling", (String)"ceil");
            formula = DSFieldFormula.replace((String)formula, (String)"max", (String)"greatest");
            formula = DSFieldFormula.replace((String)formula, (String)"min", (String)"least");
            formula = DSFieldFormula.replace((String)formula, (String)"random", (String)"rand");
            formula = DSFieldFormula.replace((String)formula, (String)"len", (String)"length");
        }
        return formula;
    }

    @Override
    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value, false) + "'";
    }

    public String escapeValueForFilter(Object value) {
        return this.escapeValueForFilter(value, null);
    }

    @Override
    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = this.matcher.reset(value.toString()).usePattern(SINGLE_QUOTE_PATTERN).replaceAll(SINGLE_QUOTE_ESCAPE);
        if (!escapeForFilter) {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE);
        } else {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE_DOUBLE);
            escaped = this.matcher.reset(escaped).usePattern(PERCENT_PATTERN).replaceAll(PERCENT_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(UNDERSCORE_PATTERN).replaceAll(UNDERSCORE_ESCAPE);
        }
        return escaped;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return this.utcDateTimeFormatter.format((Date)value);
        }
        return value.toString();
    }

    @Override
    public String getNextSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        return "null";
    }

    @Override
    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        String expr = "CASE " + column;
        for (String rawValue : valueMap.keySet()) {
            String actualValue = this.transformActualValueForSort(rawValue, column, request);
            String displayValue = this.getLocalizedDisplayValue(valueMap.get(rawValue), request);
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN " + actualValue + " THEN " + displayValue;
        }
        expr = expr + " ELSE " + column + " END";
        return expr;
    }

    @Override
    public Timestamp getUTCTimestamp(ResultSet rs, int index) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(index);
        long millis = timestamp.getTime();
        TimeZone tz = TimeZone.getDefault();
        int offset = tz.getOffset(millis);
        return new Timestamp(millis + (long)offset);
    }

    @Override
    public String caseSensitiveEqualsPredicate() {
        return " LIKE BINARY ";
    }

    @Override
    public String caseInsensitiveEqualsPredicate() {
        return "=";
    }

    @Override
    public int caseInsensitiveStrategyForRelativeComparisons() {
        return 0;
    }

    @Override
    public String caseSensitiveNotEqualPredicate() {
        return " NOT LIKE BINARY ";
    }

    @Override
    public String caseSensitiveLikePredicate() {
        return "LIKE BINARY";
    }

    @Override
    public String caseSensitiveFieldPrefixForRelativeComparisons() {
        return "CAST(";
    }

    @Override
    public String caseSensitiveFieldSuffixForRelativeComparisons() {
        return " AS BINARY)";
    }

    @Override
    protected boolean defaultLikeIsCaseSensitive() {
        return false;
    }

    @Override
    protected int defaultAliasLengthLimit() {
        return 256;
    }

    @Override
    public boolean optimizeCaseSensitiveCriteria() {
        return optimizeCaseSensitiveCriteria;
    }

    @Override
    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName;
    }

    @Override
    public String sqlConcat(String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuffer sql = new StringBuffer("CONCAT(");
        for (String s : strings) {
            if (sql.length() > "CONCAT(".length()) {
                sql.append(", ");
            }
            sql.append(s);
        }
        sql.append(")");
        return sql.toString();
    }

    @Override
    public String sqlCast(String result, DSField field) {
        String type = field.getType();
        if (type != null && DataSource.simpleTypeInheritsFromBuiltInType((String)type, (String)"integer")) {
            return "CAST(" + result + " AS SIGNED)";
        }
        return super.sqlCast(result, field);
    }

    @Override
    public boolean aliasRequiredForSubselect() {
        return true;
    }

    @Override
    public boolean tableExists(String tableName, String schema) throws Exception {
        return new SQLMetaData(this.dbConnection).tableExists(tableName, null, schema);
    }

    @Override
    public String getDummyQuery() {
        return "SELECT 1 FROM dual";
    }

    public int maxAllowedSequenceColumns() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSnapshot(File snapshotFile) throws Exception {
        snapshotFile.deleteOnExit();
        String snapshotFileName = snapshotFile.getCanonicalPath();
        String cmd = "db --name=" + this.dbName + " snapshot " + this.defaultSchemaName + " " + snapshotFileName;
        Class<MysqlDriver> clazz = MysqlDriver.class;
        synchronized (MysqlDriver.class) {
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreFromSnapshot(File snapshotFile) throws Exception {
        String snapshotFileName = snapshotFile.getCanonicalPath();
        String cmd = "db --name=" + this.dbName + " restore " + this.defaultSchemaName + " " + snapshotFileName;
        Class<MysqlDriver> clazz = MysqlDriver.class;
        synchronized (MysqlDriver.class) {
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    protected String getCredentialsCLI() {
        String user = this.sandboxConfig.getString((Object)"user", this.driverConfig.getString((Object)"user", "root"));
        String password = this.sandboxConfig.getString((Object)"password", this.driverConfig.getString((Object)"password", null));
        String serverName = this.driverConfig.getString((Object)"serverName", null);
        String portNumber = this.driverConfig.getString((Object)"portNumber", null);
        if ("localhost".equals(serverName)) {
            serverName = "127.0.0.1";
        }
        return "-u" + user + (password == null ? "" : " -p'" + password + "'") + (portNumber == null ? "" : " -P'" + portNumber + "'") + (serverName == null ? "" : " -h'" + serverName + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSandbox(String sandboxName) throws Exception {
        String credentialsCLI = this.getCredentialsCLI();
        String string = sandboxName.intern();
        synchronized (string) {
            if (this.exists(sandboxName)) {
                log.debug((Object)("Sandboxed db " + sandboxName + " already exists, not rebuilding"));
                return;
            }
            String cmd = "echo 'drop database if exists " + sandboxName + "' | mysql " + credentialsCLI + " && echo 'create database " + sandboxName + "' | mysql " + credentialsCLI + " && mysqldump " + credentialsCLI + " " + this.defaultSchemaName + " --no-create-db --skip-add-locks --skip-add-drop-table |mysql " + credentialsCLI + " " + sandboxName;
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSandbox(String sandboxName) throws Exception {
        String credentialsCLI = this.getCredentialsCLI();
        String cmd = "echo 'drop database if exists " + sandboxName + "' | mysql " + credentialsCLI;
        Class<MysqlDriver> clazz = MysqlDriver.class;
        synchronized (MysqlDriver.class) {
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean exists(String schemaName) throws Exception {
        return this.lastModified(schemaName) != -1L;
    }

    @Override
    public long lastModified(String schemaName) throws Exception {
        String credentialsCLI = this.getCredentialsCLI();
        String cmd = "echo 'select UNIX_TIMESTAMP(max(create_time)) from information_schema.tables where table_schema=\"" + schemaName + "\"' | mysql -N " + credentialsCLI;
        ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
        int exitValue = iscSystem.exitValue();
        if (exitValue != 0) {
            throw new Exception(iscSystem.getFormattedErrorString());
        }
        String lastModifiedString = iscSystem.getStdout().trim();
        if (lastModifiedString.equals("NULL")) {
            return -1L;
        }
        return Long.valueOf(lastModifiedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listAvailableDatabases(String pattern) throws Exception {
        if (!pattern.matches("[A-Za-z0-9_$*?]+")) {
            throw new Exception("Globbing pattern is limited to alphanumerics, '*', and '?'");
        }
        pattern = pattern.replaceAll("\\*", "%").replaceAll("_", "\\_").replaceAll("\\?", "_");
        String cmd = "echo \"show databases like '" + pattern + "'\" | mysql -Ns " + this.getCredentialsCLI();
        Class<MysqlDriver> clazz = MysqlDriver.class;
        synchronized (MysqlDriver.class) {
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
            String out = iscSystem.getStdout();
            // ** MonitorExit[var4_3] (shouldn't be in output)
            ArrayList<String> matches = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(out);
            while (tokenizer.hasMoreTokens()) {
                matches.add((String)tokenizer.nextElement());
            }
            return matches;
        }
    }

    @Override
    public String getTextColumnDefinitionForLength(long length) throws Exception {
        if (length <= 255L) {
            return "varchar(" + length + ")";
        }
        if (length <= 65535L) {
            return "text";
        }
        if (length <= 0xFFFFFFL) {
            return "mediumtext";
        }
        return "longtext";
    }

    @Override
    public String getFloatType() {
        return "double";
    }
}

