/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCRequest;
import com.isomorphic.servlet.RequestContext;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class SeleneseRPC {
    private static Logger log = new Logger(SeleneseRPC.class.getName());

    private static int copyStreams(InputStream inputStream, OutputStream outputStream) throws Exception {
        int bytesRead;
        byte[] buffer = new byte[8192];
        int totalBytes = 0;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
            totalBytes += bytesRead;
        }
        return totalBytes;
    }

    public static void downloadScreenshot(String serverFilePath, String downloadFilename, boolean saveScreenshot, HttpServletResponse response, RPCManager rpc, RPCRequest request) throws Exception {
        rpc.doCustomResponse();
        RequestContext.setNoCacheHeaders((HttpServletResponse)response);
        response.setContentType("image/png");
        String disposition = saveScreenshot ? "attachment; " : "inline; ";
        String filenameEncoding = rpc.encodeParameter("filename", downloadFilename);
        response.addHeader("content-disposition", disposition + filenameEncoding);
        FileInputStream inputStream = new FileInputStream(serverFilePath);
        ServletOutputStream outputStream = response.getOutputStream();
        int length = SeleneseRPC.copyStreams(inputStream, (OutputStream)outputStream);
        response.setContentLength(length);
        outputStream.flush();
        outputStream.close();
    }
}

