/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Base;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.SimpleHttpResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class HttpUtil
extends Base {
    private static Logger log = new Logger(HttpUtil.class.getName());

    public static void main(String[] args) throws Exception {
        String url = args[0];
        SimpleHttpResponse httpResponse = HttpUtil.httpGet(url, (Map)((Object)DataTools.buildMap("numRetriesFileNotFound", 12)));
        if (httpResponse.isSuccess()) {
            System.out.println("SUCCESS:" + httpResponse.getBodyAsString());
        } else {
            System.out.println("FAIL: " + httpResponse.getBodyAsString());
        }
    }

    public static HttpClient getHttpClient() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        return HttpUtil.getHttpClient(null);
    }

    public static HttpClient getHttpClient(Map optsIn) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        Integer timeout;
        DataTypeMap opts = optsIn == null ? new DataTypeMap() : new DataTypeMap(optsIn);
        HttpClient httpClient = (HttpClient)opts.get("httpClient");
        if (httpClient != null) {
            return httpClient;
        }
        String redirectStrategy = opts.getString("redirectStrategy", null);
        boolean disableRedirectHandling = opts.getBoolean((Object)"disableRedirectHandling", false);
        String sslTrustStrategy = opts.getString("sslTrustStrategy", null);
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (redirectStrategy != null && !"default".equals(redirectStrategy) && !disableRedirectHandling) {
            if ("lax".equals(redirectStrategy)) {
                httpClientBuilder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
            } else {
                log.warn("Ignoring invalid redirectStrategy: " + redirectStrategy);
            }
        }
        if (disableRedirectHandling) {
            httpClientBuilder.disableRedirectHandling();
        }
        if (sslTrustStrategy != null && !"default".equals(sslTrustStrategy)) {
            SSLContextBuilder sslContextBuilder = SSLContextBuilder.create();
            SSLConnectionSocketFactory sslsf = null;
            if ("trustSelfSigned".equals(sslTrustStrategy)) {
                sslContextBuilder.loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
                sslsf = new SSLConnectionSocketFactory(sslContextBuilder.build());
            } else if ("trustAll".equals(sslTrustStrategy)) {
                sslContextBuilder.loadTrustMaterial((TrustStrategy)new TrustAllStrategy());
                sslsf = new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            } else {
                log.warn("Ignoring invalid sslTrustStrategy: " + sslTrustStrategy);
            }
            if (sslsf != null) {
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
                Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
                BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
                httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
            }
        }
        if ((timeout = opts.getInteger((Object)"timeout", null)) != null) {
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout.intValue()).setConnectionRequestTimeout(timeout.intValue()).setSocketTimeout(timeout.intValue()).build();
            httpClientBuilder.setDefaultRequestConfig(config);
            log.info("Set timeout to " + timeout + "ms");
        } else {
            log.info("No timeout specified");
        }
        return httpClientBuilder.build();
    }

    public static SimpleHttpResponse httpRequest(String method, String url, Map optsIn) throws IOException, InterruptedException {
        int numRetriesFileNotFound;
        int numRetriesServerDown;
        DataTypeMap<String, Object> opts = optsIn == null ? new DataTypeMap<String, Object>() : new DataTypeMap(optsIn);
        int initialNumRetriesServerDown = numRetriesServerDown = opts.getInteger((Object)"numRetriesServerDown", 10);
        int retryDelayServerDown = opts.getInteger((Object)"retryDelayServerDown", 60);
        int initialNumRetriesFileNotFound = numRetriesFileNotFound = opts.getInteger((Object)"numRetriesFileNotFound", 0);
        int retryDelayFileNotFound = opts.getInteger((Object)"retryDelayFileNotFound", 5);
        boolean wantedRetriesForFileNotFound = numRetriesFileNotFound != 0;
        while (true) {
            SimpleHttpResponse simpleHttpResponse = null;
            try {
                RequestBuilder requestBuilder = RequestBuilder.create((String)method).setUri(url);
                HttpUtil.addParams(requestBuilder, (Map)((Object)opts.getMap("params")));
                HttpUtil.addHeaders(requestBuilder, (Map)((Object)opts.getMap("headers")));
                Object bodyObj = opts.get("body");
                if (bodyObj != null) {
                    if (bodyObj instanceof HttpEntity) {
                        requestBuilder.setEntity((HttpEntity)bodyObj);
                    } else {
                        String implicitRequestCharset = opts.getString("implicitRequestCharset");
                        requestBuilder.setEntity((HttpEntity)new StringEntity(bodyObj.toString(), implicitRequestCharset));
                    }
                }
                HttpUriRequest httpRequest = requestBuilder.build();
                HttpClient httpClient = HttpUtil.getHttpClient(opts);
                HttpClientContext clientContext = HttpUtil.getClientContext(url, opts);
                log.debug("Ready to send httpRequest to " + httpRequest.getURI());
                log.debug("httpRequest including URL params: " + httpRequest.getRequestLine());
                Header[] hdrs = httpRequest.getAllHeaders();
                log.debug("httpRequest headers: ");
                HashMap<String, String> simpleHeaders = new HashMap<String, String>();
                for (int i = 0; i < hdrs.length; ++i) {
                    log.debug(hdrs[i].getName() + "=" + hdrs[i].getValue());
                    simpleHeaders.put(hdrs[i].getName(), hdrs[i].getValue());
                }
                if (bodyObj == null) {
                    log.debug("httpRequest body: NULL");
                } else {
                    log.debug("httpRequest body: " + bodyObj.toString());
                }
                boolean disableRedirectHandling = opts.getBoolean((Object)"disableRedirectHandling", false);
                if (opts.getBoolean((Object)"skipExecution", false)) {
                    opts.put("_url", httpRequest.getURI().toString());
                    opts.put("_method", method);
                    if (bodyObj != null && bodyObj instanceof HttpEntity) {
                        bodyObj = EntityUtils.toString((HttpEntity)((HttpEntity)bodyObj));
                    }
                    opts.put("_body", bodyObj == null ? null : bodyObj.toString());
                    opts.put("_headers", simpleHeaders);
                    return null;
                }
                simpleHttpResponse = new SimpleHttpResponse(httpClient, httpClient.execute(httpRequest, (HttpContext)clientContext));
                if (simpleHttpResponse.isSuccess() || simpleHttpResponse.isRedirect() && disableRedirectHandling) {
                    return simpleHttpResponse;
                }
            }
            catch (Exception e) {
                if (numRetriesServerDown == 0) {
                    log.error((Object)("Failed to load " + url + " - all " + initialNumRetriesServerDown + " retries exhausted and server still not available"), e);
                    return simpleHttpResponse;
                }
                log.warn("Exception thrown while loading " + url + ": " + e.getMessage());
                log.info("Assuming server down, will retry " + numRetriesServerDown + " more times on a " + retryDelayServerDown + "s delay");
                --numRetriesServerDown;
                Thread.sleep(retryDelayServerDown * 1000);
                continue;
            }
            if (simpleHttpResponse.getStatusCode() != 404) {
                String bodyString = simpleHttpResponse.getBodyAsString();
                String message = "Server request did not fail, but the server returned an error response (" + simpleHttpResponse.getStatusCode() + ") other than 404.  Response body: " + bodyString;
                log.error(message);
                throw new IOException(message);
            }
            if (numRetriesFileNotFound == 0) {
                if (wantedRetriesForFileNotFound) {
                    log.error("File not found at " + url + " and all " + initialNumRetriesFileNotFound + " retries exhausted");
                    return simpleHttpResponse;
                }
                log.info("File not found at " + url + " no retries specified, so not considered an error");
                return simpleHttpResponse;
            }
            log.warn("File not found at " + url + " will retry " + numRetriesFileNotFound + " more times on a " + retryDelayFileNotFound + "s delay");
            --numRetriesFileNotFound;
            Thread.sleep(retryDelayFileNotFound * 1000);
        }
    }

    public static SimpleHttpResponse httpGet(String url) throws Exception {
        return HttpUtil.httpGet(url, null);
    }

    public static SimpleHttpResponse httpGet(String url, Map opts) throws Exception {
        return HttpUtil.httpRequest("GET", url, opts);
    }

    public static SimpleHttpResponse httpHead(String url) throws Exception {
        return HttpUtil.httpHead(url, null);
    }

    public static SimpleHttpResponse httpHead(String url, Map opts) throws Exception {
        return HttpUtil.httpRequest("HEAD", url, opts);
    }

    public static SimpleHttpResponse httpPut(String url) throws Exception {
        return HttpUtil.httpPut(url, null);
    }

    public static SimpleHttpResponse httpPut(String url, Map opts) throws Exception {
        return HttpUtil.httpRequest("PUT", url, opts);
    }

    public static SimpleHttpResponse httpPost(String url) throws Exception {
        return HttpUtil.httpPost(url, null);
    }

    public static SimpleHttpResponse httpPost(String url, Map opts) throws Exception {
        return HttpUtil.httpRequest("POST", url, opts);
    }

    public static SimpleHttpResponse httpDelete(String url) throws Exception {
        return HttpUtil.httpDelete(url, null);
    }

    public static SimpleHttpResponse httpDelete(String url, Map opts) throws Exception {
        return HttpUtil.httpRequest("DELETE", url, opts);
    }

    public static HttpClientContext getClientContext(String url, DataTypeMap opts) throws MalformedURLException {
        String username = opts.getString("username");
        if (username == null) {
            return HttpClientContext.create();
        }
        String password = opts.getString("password");
        URL urlObj = new URL(url);
        String host = urlObj.getHost();
        String protocol = urlObj.getProtocol();
        int port = urlObj.getPort();
        if (port == -1) {
            port = urlObj.getDefaultPort();
        }
        HttpHost targetHost = new HttpHost(host, port, protocol);
        AuthScope authScope = new AuthScope(targetHost, "realm", "basic");
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(username, password));
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credsProvider);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicAuth);
        context.setAuthCache((AuthCache)authCache);
        return context;
    }

    protected static void addParams(RequestBuilder builder, Map params) {
        if (params != null) {
            for (String key : params.keySet()) {
                Object value = params.get(key);
                if (value == null) continue;
                builder.addParameter(key, value.toString());
            }
        }
    }

    protected static void addHeaders(RequestBuilder builder, Map params) {
        if (params != null) {
            for (String key : params.keySet()) {
                Object value = params.get(key);
                if (value == null) continue;
                builder.addHeader(key, value.toString());
            }
        }
    }
}

