/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.constraints.impl;

import java.util.ArrayList;

public class LuhnValidator {
    private final int multiplicator;

    public LuhnValidator(int multiplicator) {
        this.multiplicator = multiplicator;
    }

    public boolean passesLuhnTest(String value) {
        char[] chars = value.toCharArray();
        ArrayList<Integer> digits = new ArrayList<Integer>();
        for (char c : chars) {
            if (!Character.isDigit(c)) continue;
            digits.add(c - 48);
        }
        int length = digits.size();
        int sum = 0;
        boolean even = false;
        for (int index = length - 1; index >= 0; --index) {
            int digit = (Integer)digits.get(index);
            if (even) {
                digit *= this.multiplicator;
            }
            if (digit > 9) {
                digit = digit / 10 + digit % 10;
            }
            sum += digit;
            even = !even;
        }
        return sum % 10 == 0;
    }
}

