/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.sql.SQLDriver;

public enum DBType {
    Oracle("oracle"),
    CloudSQL("cloudsql"),
    MySQL("mysql"),
    MariaDB("mariadb"),
    PostgreSQL("postgresql"),
    SQLServer("sqlserver"),
    DB2("db2"),
    DB2iSeries("db2iSeries"),
    HSQLDB("hsqldb"),
    Generic("generic"),
    Cache("cache"),
    Firebird("firebirdsql"),
    Informix("informix"),
    IRIS("iris"),
    Hibernate("hibernate");

    protected static Config config;
    public String dbTypeString;
    public String implementer;
    protected static DataTypeMap<String, DBType> enumForType;
    protected static DataTypeMap<DBType, String> iscImplementerForType;

    private DBType(String dbTypeString) {
        this.dbTypeString = dbTypeString;
    }

    public String toString() {
        return this.dbTypeString;
    }

    public String getImplementer() {
        return (String)iscImplementerForType.get((Object)this);
    }

    public static DBType forDb(String dbName) throws Exception {
        String dbTypeString;
        String string = dbTypeString = "::hibernate::".equals(dbName) ? "hibernate" : config.getString((Object)("sql." + dbName + ".database.type"), null);
        if (dbTypeString != null) {
            return DBType.fromString(dbTypeString);
        }
        return SQLDriver.instance(dbName).getDBType();
    }

    public static DBType fromString(String dbTypeString) throws Exception {
        DBType dbType = (DBType)((Object)enumForType.get((Object)dbTypeString));
        if (dbType == null) {
            throw new Exception("Invalid database type: " + dbTypeString);
        }
        dbType.dbTypeString = dbTypeString;
        return dbType;
    }

    static {
        config = Config.getGlobal();
        enumForType = new DataTypeMap();
        iscImplementerForType = new DataTypeMap();
        for (DBType enumValue : DBType.values()) {
            enumForType.put((Object)enumValue.dbTypeString, (Object)enumValue);
        }
        enumForType.put((Object)"firebird", (Object)Firebird);
        iscImplementerForType.put((Object)Oracle, (Object)"com.isomorphic.sql.OracleDriver");
        iscImplementerForType.put((Object)CloudSQL, (Object)"com.isomorphic.sql.MysqlDriver");
        iscImplementerForType.put((Object)MySQL, (Object)"com.isomorphic.sql.MysqlDriver");
        iscImplementerForType.put((Object)MariaDB, (Object)"com.isomorphic.sql.MysqlDriver");
        iscImplementerForType.put((Object)PostgreSQL, (Object)"com.isomorphic.sql.PostgresDriver");
        iscImplementerForType.put((Object)SQLServer, (Object)"com.isomorphic.sql.SQLServerDriver");
        iscImplementerForType.put((Object)DB2, (Object)"com.isomorphic.sql.DB2Driver");
        iscImplementerForType.put((Object)DB2iSeries, (Object)"com.isomorphic.sql.DB2iSeriesDriver");
        iscImplementerForType.put((Object)HSQLDB, (Object)"com.isomorphic.sql.HSQLDBDriver");
        iscImplementerForType.put((Object)Generic, (Object)"com.isomorphic.sql.GenericSQLDriver");
        iscImplementerForType.put((Object)Cache, (Object)"com.isomorphic.sql.CacheDriver");
        iscImplementerForType.put((Object)Firebird, (Object)"com.isomorphic.sql.FirebirdDriver");
        iscImplementerForType.put((Object)Informix, (Object)"com.isomorphic.sql.InformixDriver");
        iscImplementerForType.put((Object)IRIS, (Object)"com.isomorphic.sql.IRISDriver");
    }
}

