/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.Operation;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SeleneseWebDriverProperties
extends Properties {
    private static final String LEGACY_MODE = "legacyMode";
    private static final String[] WEBDRIVER_ENVIRONMENT_VARS = new String[]{"webdriver.gecko.driver", "webdriver.chrome.driver", "webdriver.ie.driver"};
    private DesiredCapabilities explicitCapabilities;

    public SeleneseWebDriverProperties(DesiredCapabilities capabilities) {
        if (capabilities == null) {
            capabilities = new DesiredCapabilities();
        }
        this.explicitCapabilities = capabilities;
    }

    public SeleneseWebDriverProperties(String fileName) throws IOException {
        FileInputStream inStream = new FileInputStream(fileName);
        this.load(inStream);
        inStream.close();
        this.canonicalize();
        this.applyEnvVars();
    }

    private void applyEnvVars() {
        for (String key : WEBDRIVER_ENVIRONMENT_VARS) {
            if (!this.containsKey(key)) continue;
            System.setProperty(key, (String)this.get(key));
            this.remove(key);
        }
    }

    private void canonicalize() {
        for (Object key : this.keySet()) {
            String stringVal = (String)this.get((String)key);
            if ("true".equalsIgnoreCase(stringVal)) {
                this.put(key, Boolean.TRUE);
                continue;
            }
            if ("false".equalsIgnoreCase(stringVal)) {
                this.put(key, Boolean.FALSE);
                continue;
            }
            if (Operation.isInteger(stringVal)) {
                this.put(key, (Object)Integer.parseInt(stringVal));
                continue;
            }
            if (!Operation.isLong(stringVal)) continue;
            this.put(key, (Object)Long.parseLong(stringVal));
        }
    }

    public DesiredCapabilities getConfiguredCapabilities() {
        return this.explicitCapabilities != null ? this.explicitCapabilities : new DesiredCapabilities((Map)this);
    }

    public FirefoxOptions addToOptions(FirefoxOptions options) {
        if (this.containsKey(LEGACY_MODE)) {
            options.setLegacy(((Boolean)this.get(LEGACY_MODE)).booleanValue());
            this.remove(LEGACY_MODE);
        }
        return options.merge((Capabilities)this.getConfiguredCapabilities());
    }
}

