/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLMetaData;
import com.isomorphic.sql.SQLServerDriver;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLDSGenerator
extends Base {
    private Logger log = new Logger(SQLDSGenerator.class.getName());
    public static final String DEFAULT_TIMESTAMP_TYPE = "datetime";
    private static Map<Integer, String> jdbcTypes = new HashMap<Integer, String>();
    private String tableName;
    private String schema;
    private String dbName;
    private Map autoDeriveSchemaOperation = null;
    private String serverType;
    private String timestampType;
    private boolean returnSQLType;
    private boolean autoDeriveFKs = true;
    private Connection conn;
    private String ID;
    private Map overriddenFields;
    private String discoveredSchema;
    protected static final Pattern JS_IDENTIFIER_START_PATTERN;
    protected static final Pattern JS_IDENTIFIER_VALID_PATTERN;
    protected Matcher matcher = JS_IDENTIFIER_START_PATTERN.matcher("");

    public static List getFieldsFromTable(Connection conn, String tableName, String schema) throws Exception {
        SQLDSGenerator instance = new SQLDSGenerator(tableName, schema);
        instance.setConn(conn);
        return instance.getFieldsFromTable();
    }

    public SQLDSGenerator(String tableName, String schema) {
        this(tableName, schema, null, "sql", DEFAULT_TIMESTAMP_TYPE, false);
    }

    public SQLDSGenerator(String tableName, String schema, String dbName) {
        this(tableName, schema, dbName, "sql", DEFAULT_TIMESTAMP_TYPE, false);
    }

    public SQLDSGenerator(String tableName, String schema, String dbName, String serverType) {
        this(tableName, schema, dbName, serverType, DEFAULT_TIMESTAMP_TYPE, false);
    }

    public SQLDSGenerator(String tableName, String schema, String dbName, String serverType, String timestampType, boolean returnSQLType) {
        this.tableName = tableName;
        this.schema = schema;
        this.dbName = dbName;
        this.serverType = serverType;
        this.timestampType = timestampType;
        this.returnSQLType = returnSQLType;
        this.autoDeriveFKs = !Boolean.FALSE.equals(config.getBoolean((Object)"datasource.autoLinkFKs"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map generate() throws Exception {
        Config iscConfig;
        if (this.serverType == null) {
            this.serverType = "sql";
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (this.ID == null) {
            this.ID = this.tableName;
        }
        config.put("ID", this.ID);
        config.put("dataSourceVersion", String.valueOf(1));
        if (this.tableName != null) {
            config.put("tableName", this.tableName);
        }
        if (this.schema != null) {
            config.put("schema", this.schema);
        }
        config.put("serverType", this.serverType);
        if ("hibernate".equals(this.serverType)) {
            config.put("xmlFromConfig", "true");
        }
        if ((iscConfig = Config.getGlobal()) != null) {
            String version = iscConfig.getString((Object)"iscVersion") + " " + iscConfig.getString((Object)"iscPackageDate");
            config.put("generatedBy", version);
        }
        List fields = null;
        boolean freeConnection = false;
        if (this.conn == null) {
            freeConnection = true;
            this.conn = SQLConnectionManager.getConnection(this.dbName);
        }
        boolean impSeq = false;
        try {
            this.discoveredSchema = null;
            List list = fields = this.autoDeriveSchemaOperation == null ? this.getFieldsFromTable() : this.getFieldsFromOperation(this.autoDeriveSchemaOperation);
            if (this.discoveredSchema != null) {
                config.put("schema", this.discoveredSchema);
            }
            if (this.overriddenFields != null) {
                Iterator<Object> i = this.overriddenFields.keySet().iterator();
                while (i.hasNext()) {
                    Map fieldDef;
                    boolean ignore;
                    Object fieldDefObj = this.overriddenFields.get(i.next());
                    if (!(fieldDefObj instanceof Map) || !(ignore = DataTools.getBoolean((Map)(fieldDef = (Map)fieldDefObj), (Object)"ignore"))) continue;
                    String fieldName = (String)fieldDef.get("name");
                    for (int j = 0; j < fields.size(); ++j) {
                        String name;
                        if (!(fields.get(j) instanceof Map) || (name = (String)((Map)fields.get(j)).get("name")) == null || !name.equals(fieldName)) continue;
                        fields.remove(j);
                    }
                }
            }
            for (Map fieldDef : fields) {
                if (impSeq || !DataTools.getBoolean((Map)fieldDef, (Object)"implicitSequence", (boolean)false)) continue;
                impSeq = true;
                break;
            }
        }
        finally {
            if (freeConnection) {
                SQLConnectionManager.free(this.conn);
            }
        }
        config.put("fields", fields);
        if (this.autoDeriveSchemaOperation != null) {
            ArrayList<Map> operationBindings = new ArrayList<Map>();
            operationBindings.add(this.autoDeriveSchemaOperation);
            config.put("operationBindings", operationBindings);
        }
        if (impSeq && config.get("sequenceMode") == null) {
            config.put("sequenceMode", "jdbcDriver");
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFieldsFromOperation(Map operation) throws Exception {
        boolean freeConnection = false;
        if (this.conn == null) {
            freeConnection = true;
            this.conn = SQLConnectionManager.getConnection();
        }
        SQLDriver driver = SQLDriver.instance(this.dbName != null ? this.dbName : config.getString((Object)"sql.defaultDatabase"));
        Statement s = null;
        ResultSet rs = null;
        try {
            ArrayList fields = new ArrayList();
            String query = (String)operation.get("command");
            if (query == null) {
                query = (String)operation.get("customSQL");
            }
            if (query == null) {
                String tableClause;
                String selectClause = (String)operation.get("selectClause");
                if (selectClause == null) {
                    selectClause = "$defaultSelectClause";
                }
                if ((tableClause = (String)operation.get("tableClause")) == null) {
                    throw new Exception("command, customSQL or tableClause is required for auto-deriving schema from an operationBinding");
                }
                String whereClause = (String)operation.get("whereClause");
                if (whereClause == null) {
                    whereClause = "$defaultWhereClause";
                }
                query = "SELECT " + selectClause + " FROM " + tableClause + " WHERE " + whereClause;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("defaultWhereClause", "1=0");
            params.put("defaultSelectClause", "*");
            query = Velocity.evaluateAsString((String)query, params);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"Auto-deriving datasource using query: ", (Object)SQLDriver.formatSQL(query));
            }
            s = this.conn.createStatement();
            rs = s.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            try {
                s.close();
            }
            catch (Exception whereClause) {
                // empty catch block
            }
            int numCols = rsmd.getColumnCount();
            if (numCols == 0) {
                throw new Exception("autoDeriveSchema query produced zero columns: " + query);
            }
            for (int i = 1; i <= numCols; ++i) {
                String columnLabel;
                String dsType;
                String fieldName = rsmd.getColumnName(i);
                this.log.warn((Object)("processing field: " + fieldName));
                Integer type = rsmd.getColumnType(i);
                String typeName = rsmd.getColumnTypeName(i);
                if (type == 1111 && ("FLOAT".equals(typeName) || "DOUBLE".equals(typeName))) {
                    type = 6;
                }
                if ((dsType = this.overrideTypeConversion((int)type, fieldName, rsmd)) == null) {
                    dsType = this.dsTypeForDBType(type, null, null);
                }
                HashMap<String, Object> dsField = new HashMap<String, Object>();
                dsField.put("name", fieldName);
                dsField.put("type", dsType);
                if (this.returnSQLType) {
                    dsField.put("sqlType", driver.getDriverSpecificSQLType(jdbcTypes.get(type), typeName));
                }
                if (dsType.equals("text")) {
                    Integer length = rsmd.getColumnDisplaySize(i);
                    dsField.put("length", length);
                }
                if ((columnLabel = rsmd.getColumnLabel(i)) != null && !columnLabel.equals("")) {
                    dsField.put("title", columnLabel);
                }
                fields.add(dsField);
            }
            ArrayList arrayList = fields;
            return arrayList;
        }
        finally {
            try {
                s.close();
            }
            catch (Exception exception) {}
            try {
                rs.close();
            }
            catch (Exception exception) {}
            if (freeConnection) {
                SQLConnectionManager.free(this.conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFieldsFromTable() throws Exception {
        boolean freeConnection = false;
        if (this.conn == null) {
            freeConnection = true;
            this.conn = SQLConnectionManager.getConnection();
        }
        SQLDriver driver = SQLDriver.instance(this.dbName != null ? this.dbName : config.getString((Object)"sql.defaultDatabase"));
        try {
            ArrayList fields = new ArrayList();
            SQLMetaData md = new SQLMetaData(this.conn);
            ResultSetMetaData rsmd = null;
            String catalog = this.conn.getCatalog();
            this.log.info((Object)("Fetching column metadata for table: " + this.tableName));
            this.log.info((Object)("=============Using catalog: " + catalog));
            List columns = md.getColumnMetaData(catalog, this.schema, driver.getNaturalDatabaseObjectName(this.tableName));
            this.log.info((Object)("Fetching column metadata for " + this.tableName + " complete"));
            if (columns.size() == 0 && (columns = md.getColumnMetaData(catalog, this.schema, this.tableName)).size() == 0) {
                this.log.info((Object)("table " + this.tableName + " does not exist or contains no columns,  aborting and throwing Exception"));
                throw new Exception("table " + this.tableName + " does not exist or contains no columns.");
            }
            HashMap<String, String> foreignKeysAssociations = new HashMap<String, String>();
            if (this.autoDeriveFKs) {
                try {
                    List foreignKeys = md.getForeignKeys(catalog, this.schema, driver.getNaturalDatabaseObjectName(this.tableName));
                    for (Map data : foreignKeys) {
                        Map overriddenField;
                        String tableField = driver.getNaturalDatabaseObjectName("PKTABLE_NAME");
                        String columnField = driver.getNaturalDatabaseObjectName("PKCOLUMN_NAME");
                        String tableName = (String)data.get(tableField);
                        String fieldName = (String)data.get(columnField);
                        if (fieldName == null) {
                            tableName = (String)data.get(tableField.toUpperCase());
                            fieldName = (String)data.get(columnField.toUpperCase());
                        }
                        if (fieldName == null) {
                            tableName = (String)data.get(tableField.toLowerCase());
                            fieldName = (String)data.get(columnField.toLowerCase());
                        }
                        if (this.overriddenFields != null && (overriddenField = (Map)this.overriddenFields.get(fieldName)) != null && Boolean.FALSE.equals(overriddenField.get("autoDeriveFKs"))) continue;
                        String fkColumnField = driver.getNaturalDatabaseObjectName("FKCOLUMN_NAME");
                        String fkColumn = (String)data.get(fkColumnField);
                        if (fkColumn == null) {
                            fkColumn = (String)data.get(fkColumnField.toUpperCase());
                        }
                        if (fkColumn == null) {
                            fkColumn = (String)data.get(fkColumnField.toLowerCase());
                        }
                        foreignKeysAssociations.put(fkColumn, tableName + "." + fieldName);
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)"Unable to load foreign key information for autoDeriveFK logic.", (Throwable)e);
                }
            }
            List pks = md.getPrimaryKeys(catalog, this.schema, driver.getNaturalDatabaseObjectName(this.tableName));
            Iterator i = columns.iterator();
            int columnNum = 0;
            while (i.hasNext()) {
                Object commentsObj;
                String dsType;
                ++columnNum;
                Map metaData = (Map)i.next();
                String columnName = (String)metaData.get("COLUMN_NAME");
                if (columnName == null) {
                    columnName = (String)metaData.get("column_name");
                }
                if (columnName == null) {
                    columnName = (String)metaData.get("NAME");
                }
                if (columnName == null) {
                    this.log.warn((Object)("Found no COLUMN_NAME element in field metadata entry: " + metaData));
                    continue;
                }
                String fieldName = this.makeValidJSIdentifier(columnName);
                Object typeObj = metaData.get("DATA_TYPE");
                if (typeObj == null) {
                    typeObj = metaData.get("data_type");
                }
                if (typeObj == null) continue;
                Integer type = Integer.valueOf(typeObj.toString());
                String typeName = (String)metaData.get("TYPE_NAME");
                if (type == 1111) {
                    if (typeName == null) {
                        typeName = (String)metaData.get("type_name");
                    }
                    if ("FLOAT".equals(typeName) || "DOUBLE".equals(typeName)) {
                        type = 6;
                    }
                    if (typeName != null && typeName.toLowerCase().startsWith("timestamp")) {
                        type = 93;
                    }
                }
                if (this.isBinary(type)) {
                    String[] suffix = new String[]{"filename", "filesize", "date_created"};
                    boolean ok0 = false;
                    boolean ok1 = false;
                    boolean ok2 = false;
                    for (int j = 0; j < columns.size(); ++j) {
                        String otherField = (String)((Map)columns.get(j)).get("COLUMN_NAME");
                        if (otherField == null) {
                            otherField = (String)((Map)columns.get(j)).get("column_name");
                        }
                        if (otherField == null) {
                            otherField = (String)((Map)columns.get(j)).get("NAME");
                        }
                        if (otherField == null) {
                            this.log.warn((Object)("Looking for '_filename' fields, found no COLUMN_NAME element in field metadata entry: " + columns.get(j)));
                            continue;
                        }
                        if (!ok0 && otherField.equalsIgnoreCase(fieldName + "_" + suffix[0])) {
                            ok0 = true;
                        }
                        if (!ok1 && otherField.equalsIgnoreCase(fieldName + "_" + suffix[1])) {
                            ok1 = true;
                        }
                        if (!ok2 && otherField.equalsIgnoreCase(fieldName + "_" + suffix[2])) {
                            ok2 = true;
                        }
                        if (ok0 && ok1 && ok2) break;
                    }
                    if (!ok0 || !ok1 || !ok2) continue;
                }
                if ((dsType = this.overrideTypeConversion((int)type, fieldName, md)) == null) {
                    dsType = this.dsTypeForDBType(type, null, metaData, driver);
                }
                HashMap<String, Object> dsField = new HashMap<String, Object>();
                dsField.put("name", fieldName);
                if (!fieldName.equals(columnName)) {
                    dsField.put("nativeName", columnName);
                    dsField.put("title", DataTools.deriveTitleFromName((String)columnName));
                }
                if (foreignKeysAssociations.containsKey(columnName)) {
                    String nativeFK = (String)foreignKeysAssociations.get(columnName);
                    String[] parts = nativeFK.split("\\.");
                    try {
                        String tableCode = DataTools.hashValue((String)parts[0].toLowerCase());
                        String columnCode = DataTools.hashValue((String)parts[1].toLowerCase());
                        dsField.put("fkTableCode", tableCode);
                        dsField.put("fkColumnCode", columnCode);
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Can't hash foreign key", (Throwable)e);
                    }
                }
                dsField.put("type", dsType);
                if (this.returnSQLType) {
                    dsField.put("sqlType", driver.getDriverSpecificSQLType(jdbcTypes.get(type), typeName));
                    Object size = metaData.get("COLUMN_SIZE");
                    if (size == null) {
                        metaData.get("column_size");
                    }
                    dsField.put("sqlLength", size);
                }
                if (dsType.equals("text")) {
                    Object lengthObj = metaData.get("COLUMN_SIZE");
                    if (lengthObj == null) {
                        lengthObj = metaData.get("column_size");
                    }
                    if (lengthObj != null) {
                        Integer length = Integer.valueOf(lengthObj.toString());
                        dsField.put("length", length);
                    }
                }
                if ((commentsObj = metaData.get("REMARKS")) == null) {
                    commentsObj = metaData.get("remarks");
                }
                if (commentsObj != null && !commentsObj.equals("")) {
                    dsField.put("title", commentsObj.toString());
                }
                if (pks.contains(fieldName)) {
                    dsField.put("primaryKey", Boolean.TRUE);
                    String columnDef = (String)metaData.get("COLUMN_DEF");
                    String string = columnDef = columnDef == null ? null : columnDef.toUpperCase();
                    if ("YES".equals(metaData.get("IS_AUTOINCREMENT")) || "serial".equals(metaData.get("TYPE_NAME")) || columnDef != null && columnDef.contains("ISEQ$$") && columnDef.endsWith(".NEXTVAL")) {
                        dsField.put("type", "sequence");
                        dsField.put("implicitSequence", true);
                    } else {
                        if (rsmd == null) {
                            Statement stmt = this.conn.createStatement();
                            String qry = "SELECT * FROM " + (this.schema != null && !this.schema.trim().isEmpty() ? driver.getNaturalDatabaseObjectName(this.schema) + "." : "") + driver.getNaturalDatabaseObjectName(this.tableName) + " WHERE '0'='1'";
                            ResultSet rs = stmt.executeQuery(qry);
                            rsmd = rs.getMetaData();
                        }
                        if (rsmd.isAutoIncrement(columnNum)) {
                            dsField.put("type", "sequence");
                            dsField.put("implicitSequence", true);
                        } else if (dsType.equals("integer") && config.getBoolean((Object)"auto.derive.integer.pk.always.sequence", false)) {
                            dsField.put("type", "sequence");
                        }
                    }
                }
                fields.add(dsField);
                String discoveredSchema = (String)metaData.get("TABLE_SCHEM");
                if (discoveredSchema == null) {
                    discoveredSchema = (String)metaData.get("table_schem");
                }
                if (discoveredSchema == null) continue;
                this.discoveredSchema = discoveredSchema;
            }
            ArrayList arrayList = fields;
            return arrayList;
        }
        finally {
            if (freeConnection) {
                SQLConnectionManager.free(this.conn);
            }
        }
    }

    private boolean isBinary(int i) {
        return i == -2 || i == -3 || i == -4 || i == 2004;
    }

    public String dsTypeForDBType(Number dbType, String dbName, SQLDriver driver) throws Exception {
        return this.dsTypeForDBType(dbType, dbName, null, driver);
    }

    public String dsTypeForDBType(Number dbType, String dbName, Map metadata, SQLDriver driver) throws Exception {
        switch (dbType.intValue()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return "text";
            }
            case -16: 
            case -15: 
            case -9: 
            case 2011: {
                return driver instanceof SQLServerDriver ? "ntext" : "text";
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "integer";
            }
            case 2: 
            case 3: {
                if (metadata != null) {
                    Integer iDecimalDigits;
                    Object oDecimalDigits = metadata.get("DECIMAL_DIGITS");
                    if (oDecimalDigits == null) {
                        oDecimalDigits = metadata.get("decimal_digits");
                    }
                    if (oDecimalDigits != null && (iDecimalDigits = Integer.valueOf(oDecimalDigits.toString())) == 0) {
                        return "integer";
                    }
                }
                return "float";
            }
            case 6: 
            case 7: 
            case 8: {
                return "float";
            }
            case 91: {
                return "date";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return this.timestampType;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return "binary";
            }
        }
        return "text";
    }

    public String getTimestampType() {
        return this.timestampType;
    }

    public void setTimestampType(String timestampType) {
        this.timestampType = timestampType;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String id) {
        this.ID = id;
    }

    public Map getOverriddenFields() {
        return this.overriddenFields;
    }

    public void setOverriddenFields(Map overriddenFields) {
        this.overriddenFields = overriddenFields;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setAutoDeriveSchemaOperation(Map autoDeriveSchemaOperation) {
        this.autoDeriveSchemaOperation = autoDeriveSchemaOperation;
    }

    public Map getAutoDeriveSchemaOperation() {
        return this.autoDeriveSchemaOperation;
    }

    public String overrideTypeConversion(int javaSQLType, String columnName, SQLMetaData metadata) {
        return null;
    }

    public String overrideTypeConversion(int javaSQLType, String columnName, ResultSetMetaData metadata) {
        return null;
    }

    public String makeValidJSIdentifier(String in) {
        in = this.matcher.reset(in).usePattern(JS_IDENTIFIER_START_PATTERN).replaceAll("_");
        in = this.matcher.reset(in).usePattern(JS_IDENTIFIER_VALID_PATTERN).replaceAll("_");
        return in;
    }

    public void setAutoDeriveFKs(Boolean autoDeriveFKs) {
        this.autoDeriveFKs = !Boolean.FALSE.equals(autoDeriveFKs) && !Boolean.FALSE.equals(config.getBoolean((Object)"datasource.autoLinkFKs"));
    }

    static {
        jdbcTypes.put(-7, "bit");
        jdbcTypes.put(-6, "tinyint");
        jdbcTypes.put(5, "smallint");
        jdbcTypes.put(4, "integer");
        jdbcTypes.put(-5, "bigint");
        jdbcTypes.put(6, "float");
        jdbcTypes.put(7, "real");
        jdbcTypes.put(8, "double");
        jdbcTypes.put(2, "numeric");
        jdbcTypes.put(3, "decimal");
        jdbcTypes.put(1, "char");
        jdbcTypes.put(12, "varchar");
        jdbcTypes.put(-1, "longvarchar");
        jdbcTypes.put(91, "date");
        jdbcTypes.put(92, "time");
        jdbcTypes.put(93, "timestamp");
        jdbcTypes.put(-2, "binary");
        jdbcTypes.put(-3, "varbinary");
        jdbcTypes.put(-4, "longvarbinary");
        jdbcTypes.put(0, "null");
        jdbcTypes.put(1111, "other");
        jdbcTypes.put(2000, "java_object");
        jdbcTypes.put(2001, "distinct");
        jdbcTypes.put(2002, "struct");
        jdbcTypes.put(2003, "array");
        jdbcTypes.put(2004, "blob");
        jdbcTypes.put(2005, "clob");
        jdbcTypes.put(2006, "ref");
        jdbcTypes.put(70, "datalink");
        jdbcTypes.put(16, "boolean");
        JS_IDENTIFIER_START_PATTERN = Pattern.compile("^[^\\$_A-Za-z]");
        JS_IDENTIFIER_VALID_PATTERN = Pattern.compile("[^\\$_A-Za-z0-9]");
    }
}

