/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.datasource.ValueMap;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.xml.XML;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class IsomorphicXML
extends BasicDataSource {
    private static Logger log = new Logger(ValueMap.class.getName());

    @Override
    public Object toRecord(Object data, ValidationContext context) throws Exception {
        if (!(data instanceof Element)) {
            log.warning("Unexpected type passed to IsomorphicXML: " + data.getClass().getName());
            return data;
        }
        Node bundleChild = null;
        String oldBundleName = context.getBundleName();
        String oldBundleEncoding = context.getBundleEncoding();
        NodeList dataChildren = ((Element)data).getChildNodes();
        for (int i = 0; i < dataChildren.getLength(); ++i) {
            Node child = dataChildren.item(i);
            String name = child.getNodeName();
            if (!name.equals("fmt:bundle") || !(child instanceof Element)) continue;
            Map childAttrs = XML.attributesToMap((Element)child);
            String basename = (String)childAttrs.get("basename");
            String encoding = (String)childAttrs.get("encoding");
            context.setBundleName(basename);
            context.setBundleEncoding(encoding);
            bundleChild = child;
            break;
        }
        List children = XML.getChildren((Element)data);
        final ArrayList<Object> results = new ArrayList<Object>();
        for (Node child : children) {
            if (child == bundleChild) continue;
            if (child instanceof Text) {
                results.add(child);
                continue;
            }
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            Object result = DataSource.recordsFromXML(child, context);
            results.add(result);
        }
        final boolean useMockMode = context != null && context.useMockMode();
        IToJSON rtnVal = new IToJSON(){

            @Override
            public void toJSON(Writer out, JSTranslater jsTrans) throws UnconvertableException, IOException {
                for (Object result : results) {
                    if (result instanceof Text) {
                        out.write(((Text)result).getData());
                        continue;
                    }
                    if (result instanceof Map && "DataSource".equals(((Map)result).get("__autoConstruct"))) {
                        try {
                            DataSource ds;
                            if (useMockMode) {
                                ((Map)result).put("mockMode", true);
                            }
                            if ((ds = DataSource.fromConfig((Map)result, null)) != null) {
                                result = ds;
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)"Exception trying to instantiate DataSource", e);
                        }
                    }
                    jsTrans.toJS(result, out);
                }
            }
        };
        if (bundleChild != null) {
            context.setBundleName(oldBundleName);
            context.setBundleEncoding(oldBundleEncoding);
        }
        return rtnVal;
    }
}

