/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.pool;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.PoolableDataSourceFactory;
import com.isomorphic.log.Logger;
import com.isomorphic.pool.IPoolableObjectFactory;
import com.isomorphic.pool.ISCKeyedObjectPool;
import com.isomorphic.pool.ISCKeyedPoolableObjectFactory;
import com.isomorphic.pool.ISCObjectPool;
import com.isomorphic.pool.ISCPoolableObjectFactory;
import com.isomorphic.util.DataTools;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PoolManager
extends Base {
    private Logger log = new Logger(PoolManager.class.getName());
    protected String name;
    protected String symbolicName;
    protected IPoolableObjectFactory factory;
    protected Object source;
    protected Map<String, Object> sources = new ConcurrentHashMap<String, Object>();
    protected boolean _isClosed = false;

    public IPoolableObjectFactory getFactory() {
        return this.factory;
    }

    public PoolManager(String name, IPoolableObjectFactory factory) {
        this.name = name;
        this.factory = factory;
        this.symbolicName = this.getClass().getName();
    }

    public Object borrowObject(String key) throws Exception {
        return this.borrowObject(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object borrowObject(String key, DSRequest dsRequest) throws Exception {
        Object objectSource = this.getObjectSource(key);
        if (objectSource instanceof ISCKeyedObjectPool) {
            ISCKeyedPoolableObjectFactory factory = ((ISCKeyedObjectPool)((Object)objectSource)).getObjectFactory();
            if (factory instanceof PoolableDataSourceFactory) {
                ((PoolableDataSourceFactory)factory).setDSRequest(dsRequest);
            }
            Object object = null;
            try {
                object = ((ISCKeyedObjectPool)((Object)objectSource)).borrowObject(key);
            }
            finally {
                if (factory instanceof PoolableDataSourceFactory) {
                    ((PoolableDataSourceFactory)factory).removeDSRequest();
                }
            }
            if (object == null) {
                this.log.debug("Invalidating null object for key '" + key);
                ((ISCKeyedObjectPool)((Object)objectSource)).invalidateObject(key, object);
            }
            return object;
        }
        if (objectSource instanceof ISCObjectPool) {
            return ((ISCObjectPool)((Object)objectSource)).borrowObject();
        }
        if (objectSource instanceof ISCPoolableObjectFactory) {
            return ((ISCPoolableObjectFactory)objectSource).makeObject();
        }
        if (objectSource instanceof ISCKeyedPoolableObjectFactory) {
            ISCKeyedPoolableObjectFactory source = (ISCKeyedPoolableObjectFactory)objectSource;
            if (source instanceof PoolableDataSourceFactory) {
                ((PoolableDataSourceFactory)source).setDSRequest(dsRequest);
            }
            try {
                Object object = source.makeObject(key);
                return object;
            }
            finally {
                if (this.factory instanceof PoolableDataSourceFactory) {
                    ((PoolableDataSourceFactory)this.factory).removeDSRequest();
                }
            }
        }
        throw new Exception("Invalid objectSource type: " + objectSource.getClass().getName());
    }

    public Object borrowUnpooledObject(String key) throws Exception {
        return this.borrowUnpooledObject(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object borrowUnpooledObject(String key, DSRequest dsRequest) throws Exception {
        Object objectSource = this.getObjectSource(key);
        if (objectSource instanceof ISCKeyedObjectPool) {
            ISCKeyedPoolableObjectFactory factory = ((ISCKeyedObjectPool)((Object)objectSource)).getObjectFactory();
            if (factory instanceof PoolableDataSourceFactory) {
                ((PoolableDataSourceFactory)factory).setDSRequest(dsRequest);
            }
            Object object = null;
            try {
                object = ((ISCKeyedObjectPool)((Object)objectSource)).getObjectFactory().makeUnpooledObject(key);
            }
            finally {
                if (factory instanceof PoolableDataSourceFactory) {
                    ((PoolableDataSourceFactory)factory).removeDSRequest();
                }
            }
            return object;
        }
        if (objectSource instanceof ISCObjectPool) {
            return ((ISCObjectPool)((Object)objectSource)).getObjectFactory().makeUnpooledObject();
        }
        if (objectSource instanceof ISCPoolableObjectFactory) {
            return ((ISCPoolableObjectFactory)objectSource).makeUnpooledObject();
        }
        if (objectSource instanceof ISCKeyedPoolableObjectFactory) {
            ISCKeyedPoolableObjectFactory source = (ISCKeyedPoolableObjectFactory)objectSource;
            if (source instanceof PoolableDataSourceFactory) {
                ((PoolableDataSourceFactory)source).setDSRequest(dsRequest);
            }
            try {
                Object object = ((ISCKeyedPoolableObjectFactory)objectSource).makeUnpooledObject(key);
                return object;
            }
            finally {
                if (this.factory instanceof PoolableDataSourceFactory) {
                    ((PoolableDataSourceFactory)this.factory).removeDSRequest();
                }
            }
        }
        throw new Exception("Invalid objectSource type: " + objectSource.getClass().getName());
    }

    public Object borrowNewObject(String key) throws Exception {
        Object objectSource = this.getObjectSource(key);
        if (objectSource instanceof ISCKeyedObjectPool) {
            return ((ISCKeyedObjectPool)((Object)objectSource)).getObjectFactory().makeObject(key);
        }
        if (objectSource instanceof ISCObjectPool) {
            return ((ISCObjectPool)((Object)objectSource)).getObjectFactory().makeObject();
        }
        if (objectSource instanceof ISCPoolableObjectFactory) {
            return ((ISCPoolableObjectFactory)objectSource).makeObject();
        }
        if (objectSource instanceof ISCKeyedPoolableObjectFactory) {
            return ((ISCKeyedPoolableObjectFactory)objectSource).makeObject(key);
        }
        throw new Exception("Invalid objectSource type: " + objectSource.getClass().getName());
    }

    public void returnObject(String key, Object obj) {
        try {
            Object objectSource = this.getObjectSource(key);
            if (objectSource instanceof ISCObjectPool) {
                ((ISCObjectPool)((Object)objectSource)).returnObject(obj);
            } else if (objectSource instanceof ISCKeyedObjectPool) {
                ((ISCKeyedObjectPool)((Object)objectSource)).returnObject(key, obj);
            } else if (objectSource instanceof ISCPoolableObjectFactory) {
                ((ISCPoolableObjectFactory)objectSource).destroyObject(obj);
            } else if (objectSource instanceof ISCKeyedPoolableObjectFactory) {
                ((ISCKeyedPoolableObjectFactory)objectSource).destroyObject(key, obj);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error while freeing object - ignored.", e);
        }
    }

    public void invalidateObject(String key, Object obj) {
        try {
            Object objectSource = this.getObjectSource(key);
            if (objectSource instanceof ISCObjectPool) {
                ((ISCObjectPool)((Object)objectSource)).invalidateObject(obj);
            } else if (objectSource instanceof ISCKeyedObjectPool) {
                ((ISCKeyedObjectPool)((Object)objectSource)).invalidateObject(key, obj);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error while invalidating object - ignored.", e);
        }
    }

    public void clearPool(String key) throws Exception {
        Object objectSource = this.getObjectSource(key);
        if (objectSource instanceof ISCObjectPool) {
            ((ISCObjectPool)((Object)objectSource)).clear();
        } else if (objectSource instanceof ISCKeyedObjectPool) {
            ((ISCKeyedObjectPool)((Object)objectSource)).clear(key);
        }
    }

    public void close() throws Exception {
        this._isClosed = true;
        for (String key : this.sources.keySet()) {
            this.closePool(key);
        }
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void closePool(String key) throws Exception {
        Object objectSource = this.getObjectSource(key);
        if (objectSource instanceof ISCObjectPool) {
            ((ISCObjectPool)((Object)objectSource)).close();
        } else if (objectSource instanceof ISCKeyedObjectPool) {
            ((ISCKeyedObjectPool)((Object)objectSource)).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectSource(String key) throws Exception {
        if (this.factory instanceof ISCKeyedPoolableObjectFactory) {
            if (this.source == null) {
                String string = ("PoolManager_keyed_factory" + key).intern();
                synchronized (string) {
                    if (this.source == null) {
                        this.source = this.makeSource(key);
                    }
                }
            }
            return this.source;
        }
        Object source = this.sources.get(key);
        if (source == null) {
            String string = ("PoolManager_factory" + key).intern();
            synchronized (string) {
                if (source == null) {
                    source = this.makeSource(key);
                    this.sources.put(key, source);
                }
            }
        }
        return source;
    }

    public Object makeSource(String key) throws Exception {
        IPoolableObjectFactory factory;
        Config globalPoolConfig = config.getSubtree("pooling.default");
        Config objectConfig = config.getSubtree(this.name + ".pool");
        Config thisPoolConfig = config.getSubtree(this.name + "." + key + ".pool");
        Config mergedConfig = new Config();
        DataTools.mapMerge((Map)((Object)globalPoolConfig), (Map)((Object)mergedConfig));
        DataTools.mapMerge((Map)((Object)objectConfig), (Map)((Object)mergedConfig));
        DataTools.mapMerge((Map)((Object)thisPoolConfig), (Map)((Object)mergedConfig));
        Object source = factory = this.factory.newInstance(key);
        ISCPoolableObjectFactory iscFactory = null;
        if (factory instanceof ISCPoolableObjectFactory) {
            iscFactory = (ISCPoolableObjectFactory)factory;
        }
        if (iscFactory != null && Boolean.FALSE.equals(iscFactory.poolDisabled) || mergedConfig.getBoolean((Object)"enabled", false) && (iscFactory == null || !Boolean.TRUE.equals(iscFactory.poolDisabled))) {
            mergedConfig.remove("enabled");
            Object pool = factory instanceof ISCKeyedPoolableObjectFactory ? new ISCKeyedObjectPool((ISCKeyedPoolableObjectFactory)factory, (Map)((Object)mergedConfig)) : new ISCObjectPool((ISCPoolableObjectFactory)factory, (Map)((Object)mergedConfig));
            factory.setPool(pool);
            source = pool;
            this.log.info("SmartClient pooling started for '" + key + "' objects");
        } else {
            this.log.info("SmartClient pooling disabled for '" + key + "' objects");
        }
        if (source == null) {
            throw new Exception("Unable to bind objectSource for key: " + key);
        }
        return source;
    }
}

