/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource.cachesync;

import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.cachesync.CacheSyncStrategy;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestValuesStrategy
extends CacheSyncStrategy {
    private static Logger log = new Logger(RequestValuesStrategy.class);

    @Override
    public boolean worksForBatchAdd(DSRequest request) {
        return true;
    }

    @Override
    public List getCacheSyncData(DSRequest request, DSResponse response) throws Exception {
        boolean calledFromGetKeys;
        ArrayList responseData;
        block19: {
            DataSource ds;
            block20: {
                block18: {
                    responseData = new ArrayList();
                    ds = request.getDataSource();
                    calledFromGetKeys = Boolean.TRUE.equals(request.getAttribute("_calledFromGetKeys"));
                    if (!DataSource.isAdd(request.getOperationType())) break block18;
                    if (!calledFromGetKeys) {
                        List<String> keys = ds.getPrimaryKeys();
                        for (int i = 0; i < keys.size(); ++i) {
                            if (!"sequence".equals(ds.getField(keys.get(i)).getType())) continue;
                            log.warn("DataSource '" + ds.getName() + "', field '" + keys.get(i) + "' is of type 'sequence'.  The RequestValues cache sync strategy cannot provide missing sequence values, so the returned cache sync data will be missing key values");
                            break;
                        }
                    }
                    responseData.addAll(request.getValueSets());
                    break block19;
                }
                if (DataSource.isUpdate(request.getOperationType())) break block20;
                if (!DataSource.isRemove(request.getOperationType())) break block19;
            }
            boolean useOldValues = true;
            if (DataSource.isRemove(request.getOperationType())) {
                useOldValues = false;
            } else if (request.getOldValueSets().size() == 0) {
                if (DataTools.getBoolean(ds.getConfig(), "sparseUpdates", false)) {
                    log.warn("No 'oldValues' provided, and the dataSource is configured for sparseUpdates.  Cache sync data will be incomplete");
                }
                useOldValues = false;
            } else if (request.getValueSets().size() > 1 && request.getValueSets().size() != request.getOldValueSets().size()) {
                String msg = "A different number of request 'values' and 'oldValues' was provided, so we cannot reliably make use of the oldValues.";
                if (DataTools.getBoolean(ds.getConfig(), "sparseUpdates", false)) {
                    msg = msg + "Since the dataSource is configured for sparseUpdates, cache sync data will be incomplete";
                }
                log.warn(msg);
                useOldValues = false;
            }
            for (int i = 0; i < request.getValueSets().size(); ++i) {
                HashMap<String, Object> rec = new HashMap<String, Object>();
                if (useOldValues) {
                    rec.putAll((Map)request.getOldValueSets().get(i));
                }
                if (!DataSource.isRemove(request.getOperationType())) {
                    rec.putAll((Map)request.getValueSets().get(i));
                } else {
                    Map<String, Object> criteria = (Map<String, Object>)request.getValueSets().get(i);
                    if (AdvancedCriteria.isAdvancedCriteria(criteria)) {
                        criteria = AdvancedCriteria.getFlattenedFieldValueMap(criteria);
                    }
                    rec.putAll(criteria);
                }
                responseData.add(rec);
            }
        }
        if (!calledFromGetKeys) {
            this.convertToBeansIfRequired(request, response, responseData);
        }
        return responseData;
    }
}

