/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DSFileSpec {
    private static Logger log = new Logger(DSFileSpec.class.getName());
    protected String dsName;
    protected String dsFileName;
    protected String dsFileType;
    protected String dsFileFormat;
    protected String dsOwnerId;
    protected DSRequest requestContext;
    protected String textMatchStyle;
    private DataSource ds;
    private boolean existsShouldFetchContents = false;
    private Reader contentsFromLastExistsCall;
    public String prevailingSandbox;

    private DataSource getDataSource() throws Exception {
        if (this.ds == null) {
            DataStructCache.disableDsPaths();
            try {
                if (this.requestContext == null) {
                    this.ds = DataSourceManager.getDataSource(this.dsName);
                } else {
                    this.ds = this.requestContext.getCachedDataSourceInstance(this.dsName);
                    if (this.ds == null) {
                        this.ds = DataSourceManager.getDataSource(this.dsName, this.requestContext);
                        this.requestContext.cacheDataSourceInstance(this.dsName, this.ds);
                    }
                }
            }
            finally {
                DataStructCache.enableDsPaths();
                if (this.ds != null) {
                    this.prevailingSandbox = this.ds.getPrevailingSandboxOrDbName();
                }
            }
        }
        return this.ds;
    }

    private void freeDataSource() {
        if (this.requestContext == null) {
            DataSourceManager.freeDataSource(this.ds);
            this.ds = null;
        }
    }

    public DSFileSpec(String dsName, String dsFileName) {
        this.dsName = dsName;
        this.dsFileName = dsFileName;
    }

    public DSFileSpec(String dsName, String dsFileName, String dsFileType) {
        this(dsName, dsFileName);
        this.dsFileType = dsFileType;
    }

    public DSFileSpec(String dsName, String dsFileName, String dsFileType, String dsFileFormat) {
        this(dsName, dsFileName, dsFileType);
        this.dsFileFormat = dsFileFormat;
    }

    public DSFileSpec(String dsName, String dsFileName, String dsFileType, String dsFileFormat, DSRequest request) {
        this(dsName, dsFileName, dsFileType, dsFileFormat);
        this.requestContext = request;
    }

    public DSFileSpec(Map record) {
        this.dsFileName = (String)record.get("fileName");
        this.dsFileType = (String)record.get("fileType");
        this.dsFileFormat = (String)record.get("fileFormat");
    }

    public DSFileSpec(String dsName, Map record) {
        this(record);
        this.dsName = dsName;
    }

    public DSFileSpec(String dsName, Map record, DSRequest request) {
        this(record);
        this.dsName = dsName;
        this.requestContext = request;
    }

    public DSFileSpec(String url) {
        this(url, (DSRequest)null);
    }

    public DSFileSpec(String url, DSRequest request) {
        String fullPath;
        String remainder;
        this.requestContext = request;
        if (url.startsWith("ds://")) {
            remainder = StringUtils.removeStart((String)url, (String)"ds://");
            this.dsName = StringUtils.substringBefore((String)remainder, (String)"/");
            fullPath = StringUtils.substringAfter((String)remainder, (String)"/");
        } else if (url.startsWith("ds:/")) {
            remainder = StringUtils.removeStart((String)url, (String)"ds:/");
            this.dsName = StringUtils.substringBefore((String)remainder, (String)"/");
            fullPath = StringUtils.substringAfter((String)remainder, (String)"/");
        } else {
            fullPath = url;
        }
        Map<String, Object> parsed = ISCFile.parseFileExtensions(fullPath);
        this.dsFileName = (String)parsed.get("fileName");
        this.dsFileType = (String)parsed.get("fileType");
        this.dsFileFormat = (String)parsed.get("fileFormat");
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public void setDataSourceName(String name) {
        this.dsName = name;
    }

    public DSRequest getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(DSRequest context) {
        this.requestContext = context;
    }

    public String getFileName() {
        return this.dsFileName;
    }

    public void setFileName(String name) {
        this.dsFileName = name;
    }

    public String getFileType() {
        return this.dsFileType;
    }

    public void setFileType(String type) {
        this.dsFileType = type;
    }

    public String getFileFormat() {
        return this.dsFileFormat;
    }

    public void setFileFormat(String format) {
        this.dsFileFormat = format;
    }

    public String getOwnerId() {
        return this.dsOwnerId;
    }

    public void setOwnerId(String ownerId) {
        this.dsOwnerId = ownerId;
    }

    public void setTextMatchStyle(String textMatchStyle) {
        this.textMatchStyle = textMatchStyle;
    }

    public String getTextMatchStyle() {
        return this.textMatchStyle;
    }

    public boolean remove() {
        try {
            List<Map<String, Object>> results = this.getDataSource().removeFile(this);
            boolean bl = results != null && results.size() > 0;
            return bl;
        }
        catch (Exception ex) {
            log.warn(ex.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            this.freeDataSource();
        }
    }

    public boolean exists() {
        try {
            boolean exists;
            if (this.existsShouldFetchContents) {
                this.contentsFromLastExistsCall = this.getDataSource().getFile(this);
                boolean bl = this.contentsFromLastExistsCall != null;
                return bl;
            }
            boolean bl = exists = this.getDataSource().hasFile(this);
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.freeDataSource();
        }
    }

    public Reader getReader() {
        try {
            if (this.contentsFromLastExistsCall != null) {
                Reader reader = this.contentsFromLastExistsCall;
                return reader;
            }
            Reader reader = this.getDataSource().getFile(this);
            return reader;
        }
        catch (Exception ex) {
            log.warn(ex.toString());
            Reader reader = null;
            return reader;
        }
        finally {
            this.contentsFromLastExistsCall = null;
            this.freeDataSource();
        }
    }

    public InputStream getInputStream() {
        try {
            if (this.contentsFromLastExistsCall != null) {
                String contents = IOUtil.readerToString(this.contentsFromLastExistsCall);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(contents.getBytes(Charset.forName("UTF-8")));
                return byteArrayInputStream;
            }
            InputStream contents = this.getDataSource().getFileAsInputStream(this);
            return contents;
        }
        catch (Exception ex) {
            log.warn(ex.toString());
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            this.contentsFromLastExistsCall = null;
            this.freeDataSource();
        }
    }

    public Writer getWriter() {
        return new DSFileSpecWriter();
    }

    public OutputStream getOutputStream() {
        return new DSFileSpecOutputStream();
    }

    public void saveFile(Object contents) throws Exception {
        try {
            this.getDataSource().saveFile(this, contents);
        }
        finally {
            this.freeDataSource();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        try {
            long l = this.getDataSource().getFileSize(this);
            return l;
        }
        catch (Exception ex) {
            log.warn(ex.toString());
            long l = -1L;
            return l;
        }
        finally {
            this.freeDataSource();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified() {
        try {
            long l = this.getDataSource().getFileLastModified(this);
            return l;
        }
        catch (Exception ex) {
            log.warn(ex.toString());
            long l = 0L;
            return l;
        }
        finally {
            this.freeDataSource();
        }
    }

    public boolean setLastModified(long time) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameTo(DSFileSpec destination) {
        try {
            this.getDataSource().renameFile(this, destination);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            log.warn(ex.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            this.freeDataSource();
        }
    }

    public Map<String, Object> readAttributes() throws Exception {
        try {
            List<Map<String, Object>> list = this.getDataSource().listFiles(this.getPrimaryKeys(), this.requestContext);
            if (list.size() == 0) {
                Map<String, Object> map = null;
                return map;
            }
            if (list.size() > 1) {
                log.warn("readAttributes found multiple files, returning first");
            }
            Map<String, Object> map = list.get(0);
            return map;
        }
        finally {
            this.freeDataSource();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> findChildAttributes(Object criteria, DSRequest request) throws Exception {
        if (request == null) {
            request = this.requestContext;
        }
        try {
            List<Map<String, Object>> results;
            List<Map<String, Object>> list = results = this.getDataSource().listFiles(criteria, request);
            return list;
        }
        finally {
            this.freeDataSource();
        }
    }

    public List<DSFileSpec> findChildren(Object criteria, DSRequest request) throws Exception {
        if (request == null) {
            request = this.requestContext;
        }
        List<Map<String, Object>> attributes = this.findChildAttributes(criteria, request);
        ArrayList<DSFileSpec> results = new ArrayList<DSFileSpec>(attributes.size());
        for (Map map : attributes) {
            results.add(new DSFileSpec(this.dsName, map, request));
        }
        return results;
    }

    public DSFileSpec getChild(Map<String, Object> primaryKeys, DSRequest request) {
        return new DSFileSpec(this.dsName, primaryKeys, request);
    }

    public Map<String, Object> getPrimaryKeys() {
        HashMap<String, Object> primaryKeys = new HashMap<String, Object>();
        String fileName = this.getFileName();
        String fileType = this.getFileType();
        String fileFormat = this.getFileFormat();
        String ownerId = this.getOwnerId();
        if (fileName != null) {
            primaryKeys.put("fileName", fileName);
        }
        if (fileType != null) {
            primaryKeys.put("fileType", fileType);
        }
        if (fileFormat != null) {
            primaryKeys.put("fileFormat", fileFormat);
        }
        if (ownerId != null) {
            primaryKeys.put("ownerId", ownerId);
        }
        return primaryKeys;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.dsName != null) {
            sb.append("ds://");
            sb.append(this.dsName);
        }
        if (this.dsFileName != null) {
            sb.append('/');
            sb.append(this.dsFileName);
            if (this.dsFileType != null) {
                sb.append('.');
                sb.append(this.dsFileType);
            }
            if (this.dsFileFormat != null) {
                sb.append('.');
                sb.append(this.dsFileFormat);
            }
        }
        return sb.toString();
    }

    public void setExistsShouldFetchContents(boolean newValue) {
        this.existsShouldFetchContents = newValue;
    }

    public boolean existsShouldFetchContents() {
        return this.existsShouldFetchContents;
    }

    protected class DSFileSpecOutputStream
    extends ByteArrayOutputStream {
        private boolean flushed = false;

        protected DSFileSpecOutputStream() {
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.flushed = true;
            try {
                DSFileSpec.this.saveFile(this.toByteArray());
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.flushed) {
                this.flush();
            }
            super.close();
        }
    }

    protected class DSFileSpecWriter
    extends StringWriter {
        private boolean flushed = false;

        protected DSFileSpecWriter() {
        }

        @Override
        public void flush() {
            super.flush();
            this.flushed = true;
            try {
                DSFileSpec.this.saveFile(this.toString());
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.flushed) {
                this.flush();
            }
            super.close();
        }
    }
}

