/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DSTransaction;
import com.isomorphic.datasource.Relation;
import com.isomorphic.datasource.StreamingResponseIterator;
import com.isomorphic.interfaces.ISpringBeanFactory;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.naming.JNDI;
import com.isomorphic.sql.DBType;
import com.isomorphic.sql.SQLClauseType;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLLogger;
import com.isomorphic.sql.SQLMetaData;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.sql.SQLTransform;
import com.isomorphic.sql.SQLWhereClause;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import com.isomorphic.util.LocaleMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.sql.DataSource;

public abstract class SQLDriver
extends Base {
    private static Logger log = new Logger(SQLDriver.class.getName());
    private static Logger logSqlError = new Logger("com.isomorphic.SQL_ERROR");
    protected static Config config = Config.getGlobal();
    protected String dbName = null;
    protected DBType dbType = null;
    protected DataTypeMap metaData = null;
    protected String defaultSchemaName = null;
    protected SQLTable table = null;
    protected JSTranslater jsTrans;
    public Connection dbConnection = null;
    private static Boolean forceUUIDToString = null;
    protected static ConcurrentHashMap<String, Config> globalSqlConfig = new ConcurrentHashMap();
    protected Config _sqlConfig = null;
    protected Config driverConfig = null;
    protected Config sandboxConfig = null;
    protected Config databaseConfig = null;
    protected boolean quoteColumnNames;
    protected boolean useColumnLabelInMetadata;
    protected boolean useUTCDateTimes;
    public static final String TRANSFORM_GENERATED_KEYS = "sql.transformGeneratedKeys";
    public static final String TRANSFORM_GENERATED_KEYS_TO_FETCH_TYPE = "sql.transformGeneratedKeysToFetchType";
    public static final String DO_NOT_TRANSFORM_FLOATS = "sql.doNotTransformFloats";
    protected static final Pattern SINGLE_QUOTE_PATTERN = Pattern.compile(Pattern.quote("'"));
    protected static final String SINGLE_QUOTE_ESCAPE = Matcher.quoteReplacement("''");
    protected static final Pattern DOUBLE_QUOTE_PATTERN = Pattern.compile(Pattern.quote("\""));
    protected static final String DOUBLE_QUOTE_ESCAPE = Matcher.quoteReplacement("\"\"");
    protected static final Pattern PERCENT_PATTERN = Pattern.compile(Pattern.quote("%"));
    protected static final String PERCENT_ESCAPE = Matcher.quoteReplacement("\\%");
    protected static final Pattern UNDERSCORE_PATTERN = Pattern.compile(Pattern.quote("_"));
    protected static final String UNDERSCORE_ESCAPE = Matcher.quoteReplacement("\\_");
    protected static final Pattern BACKSLASH_PATTERN = Pattern.compile(Pattern.quote("\\"));
    protected static final String BACKSLASH_ESCAPE = Matcher.quoteReplacement("\\\\");
    protected static final String BACKSLASH_ESCAPE_DOUBLE = Matcher.quoteReplacement("\\\\\\\\");
    protected static final Pattern REGEXP_SPECIAL_PATTERN = Pattern.compile("\\\\(?=(\\\\)?)([-\\].$*+?()\\[{}|\\\\^])");
    protected static final String REGEXP_SPECIAL_ESCAPE = BACKSLASH_ESCAPE + "$1$2";
    protected Matcher matcher = SINGLE_QUOTE_PATTERN.matcher("");
    protected static final String[] LIKE_VALUE_CHARS_TO_ESCAPE = new String[]{"%", "_"};
    protected static Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    protected SQLDataSource.SequenceMode lastSequenceMode;
    public static final int NO_CONVERSION = 0;
    public static final int TO_LOWERCASE = 1;
    public static final int TO_UPPERCASE = 2;
    private static final Map EMPTY_REMAP = new HashMap();
    private static final String TIMING_LOG_UNPAGED_FETCH = "Unpaged fetch";
    private static final String TIMING_LOG_GET_CONNECTION = "get connection";
    private static final String TIMING_LOG_QUERY = "query";
    private static final String TIMING_LOG_SQLTRANSFORM = "SQLTransform";
    protected SimpleDateFormat logicalDateFormatter;
    protected SimpleDateFormat logicalTimeFormatter;
    protected SimpleDateFormat utcDateTimeFormatter;
    protected SimpleDateFormat localDateTimeFormatter;
    protected SimpleDateFormat utcDateTimeMsFormatter;
    protected SimpleDateFormat localDateTimeMsFormatter;
    private static boolean compactFormattingSQL = config.getBoolean((Object)"sql.log.compactFormatting", false);
    private static boolean canFormatSQL = config.getBoolean((Object)"sql.log.formatQueries", false);
    private static int maxLogLength = config.getInt((Object)"sql.log.maxLength", -1);
    protected boolean useDistinctForGroupBy = true;
    protected Map jdbcPKs = new HashMap();
    private Boolean useHavingClause = null;
    private static Boolean _supportsGetGeneratedKeys = null;
    private boolean forceInsensitive;
    private Boolean likeIsCaseSensitive;
    public static final int DEFAULT_ALIAS_LENGTH_LIMIT = 128;
    private int aliasLengthLimit;
    private static String snapshotFileNamePrefix = IOUtil.threadSafeTmpFileName((String)"/tmp/db_snapshot_sql");

    public static boolean forceUUIDToString() {
        if (forceUUIDToString == null) {
            forceUUIDToString = config.getBoolean((Object)"sql.forceUUIDToString", false);
        }
        return forceUUIDToString;
    }

    public SQLDataSource.SequenceMode getLastSequenceMode() {
        return this.lastSequenceMode;
    }

    public void setLastSequenceMode(SQLDataSource.SequenceMode sequenceMode) {
        this.lastSequenceMode = sequenceMode;
    }

    protected void initDateFormatters() throws Exception {
        String dateTimeFormat = this._sqlConfig.getString((Object)"defaultDateTimeFormat", "yyyy-MM-dd HH:mm:ss");
        String dateTimeMsFormat = this._sqlConfig.getString((Object)"defaultDateTimeFormatWithMilliseconds", "yyyy-MM-dd HH:mm:ss.SSS");
        String dateFormat = this._sqlConfig.getString((Object)"defaultDateFormat", "yyyy-MM-dd");
        String timeFormat = this._sqlConfig.getString((Object)"defaultTimeFormat", dateTimeFormat);
        this.utcDateTimeFormatter = new SimpleDateFormat(dateTimeFormat);
        this.utcDateTimeFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.localDateTimeFormatter = new SimpleDateFormat(dateTimeFormat);
        this.utcDateTimeMsFormatter = new SimpleDateFormat(dateTimeMsFormat);
        this.utcDateTimeMsFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.localDateTimeMsFormatter = new SimpleDateFormat(dateTimeMsFormat);
        this.logicalDateFormatter = new SimpleDateFormat(dateFormat);
        this.logicalTimeFormatter = new SimpleDateFormat(timeFormat);
    }

    protected SimpleDateFormat getLocalDateTimeFormatter() {
        return this.localDateTimeFormatter;
    }

    protected SimpleDateFormat getUTCDateTimeFormatter() {
        return this.utcDateTimeFormatter;
    }

    protected SimpleDateFormat getLocalDateTimeMsFormatter() {
        return this.localDateTimeMsFormatter;
    }

    protected SimpleDateFormat getUTCDateTimeMsFormatter() {
        return this.utcDateTimeMsFormatter;
    }

    protected SimpleDateFormat getLogicalDateFormatter() {
        return this.logicalDateFormatter;
    }

    protected SimpleDateFormat getLogicalTimeFormatter() {
        return this.logicalTimeFormatter;
    }

    public String openQuote() {
        return "\"";
    }

    public String closeQuote() {
        return "\"";
    }

    public String getQualifiedSchemaSeparator() {
        return ".";
    }

    public String sequencePrefix() {
        return config.getString((Object)("sql." + config.getString((Object)("sql." + this.dbName + ".database.type")) + ".sequence.name.prefix"), "");
    }

    public String sequenceSuffix() {
        return config.getString((Object)("sql." + config.getString((Object)("sql." + this.dbName + ".database.type")) + ".sequence.name.suffix"), "");
    }

    public int maxSequenceNameLength() {
        return config.getInt((Object)("sql." + config.getString((Object)("sql." + this.dbName + ".database.type")) + ".sequence.name.maxLength"), -1);
    }

    public static SQLDriver instance() throws Exception {
        return SQLDriver.instance(config.getString((Object)"sql.defaultDatabase"));
    }

    public static SQLDriver instance(String dbName) throws Exception {
        return SQLDriver.instance(dbName, null);
    }

    public static SQLDriver instance(String dbName, SQLTable table) throws Exception {
        DBType dbType = (DBType)((Object)SQLDriver.getInternalSqlConfig(dbName).get((Object)"_dbType"));
        Class[] argTypes = new Class[]{String.class, SQLTable.class};
        Object[] argValues = new Object[]{dbName, table};
        return (SQLDriver)((Object)Reflection.instantiateClass((String)dbType.getImplementer(), (Class[])argTypes, (Object[])argValues));
    }

    public SQLDriver(String dbName, SQLTable table) throws Exception {
        this.dbName = dbName;
        this.table = table;
        this._sqlConfig = SQLDriver.getInternalSqlConfig(dbName);
        this.dbType = (DBType)((Object)this._sqlConfig.get((Object)"_dbType"));
        this.metaData = this._sqlConfig.getMap((Object)"_metaData");
        this.driverConfig = this._sqlConfig.getSubtree("driver");
        this.sandboxConfig = this._sqlConfig.getSubtree("sandbox");
        this.databaseConfig = this._sqlConfig.getSubtree("database");
        this.defaultSchemaName = this.driverConfig.getString((Object)"databaseName", dbName);
        this.quoteColumnNames = this._sqlConfig.getBoolean((Object)"quoteColumnNames", false);
        this.useColumnLabelInMetadata = this._sqlConfig.getBoolean((Object)"useColumnLabelInMetadata", false);
        this.useUTCDateTimes = this._sqlConfig.getBoolean((Object)"useUTCDateTimes", false);
        this.forceInsensitive = this._sqlConfig.getBoolean((Object)"forceInsensitive", config.getBoolean((Object)"sql.forceInsensitive", this.defaultForceInsensitive()));
        this.likeIsCaseSensitive = this._sqlConfig.getBoolean((Object)"likeIsCaseSensitive", config.getBoolean((Object)"sql.likeIsCaseSensitive", null));
        this.aliasLengthLimit = this._sqlConfig.getInteger((Object)"aliasLengthLimit", config.getInteger((Object)"sql.aliasLengthLimit", this.defaultAliasLengthLimit()));
        this.initDateFormatters();
        this.jsTrans = JSTranslater.strict();
    }

    public SQLDriver setSchemaName(String schemaName) {
        if (schemaName != null) {
            this.defaultSchemaName = schemaName;
        }
        return this;
    }

    public static void purgeSqlConfig(String dbName) {
        globalSqlConfig.remove(dbName);
    }

    public static void purgeSqlConfig() {
        globalSqlConfig.clear();
    }

    public static boolean isConfigured(String dbName) {
        return globalSqlConfig.containsKey(dbName);
    }

    public static void configure(String dbName, Config namedSqlConfig) throws Exception {
        Config _sqlConfig = SQLDriver.initSqlConfig(dbName, namedSqlConfig);
        globalSqlConfig.put(dbName, _sqlConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Config getInternalSqlConfig(String dbName) throws Exception {
        if (!SQLDriver.isConfigured(dbName)) {
            String string = ("SQLDriver_" + dbName).intern();
            synchronized (string) {
                if (!SQLDriver.isConfigured(dbName)) {
                    SQLDriver.configure(dbName, config.getSubtree("sql." + dbName));
                }
            }
        }
        return globalSqlConfig.get(dbName);
    }

    public static Config getSqlConfig(String dbName) throws Exception {
        return SQLDriver.safeSqlConfig(SQLDriver.getInternalSqlConfig(dbName));
    }

    public Config getSqlConfig() {
        return SQLDriver.safeSqlConfig(this._sqlConfig);
    }

    protected static Config safeSqlConfig(Config _sqlConfig) {
        Config sqlConfig = new Config(new HashMap(_sqlConfig));
        Iterator i = sqlConfig.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith("_")) continue;
            i.remove();
        }
        return sqlConfig;
    }

    public static Config initSqlConfig(String dbName) throws Exception {
        return SQLDriver.initSqlConfig(dbName, config.getSubtree("sql." + dbName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Config initSqlConfig(String dbName, Config namedSqlConfig) throws Exception {
        Connection conn;
        Config _sqlConfig;
        String dbTypeString;
        block86: {
            if (namedSqlConfig == null) {
                namedSqlConfig = new Config();
            }
            dbTypeString = namedSqlConfig.getString((Object)"database.type");
            _sqlConfig = (Config)DataTools.cascadeMaps((Map[])new Map[]{config.getSubtree("sql.default"), dbTypeString == null ? null : config.getSubtree("sql." + dbTypeString), namedSqlConfig, new Config()});
            String interfaceType = (_sqlConfig = SQLDriver.safeSqlConfig(_sqlConfig)).getString((Object)"interface.type");
            if (interfaceType == null) {
                if (_sqlConfig.getString((Object)"driver.driverName") != null) {
                    interfaceType = "driverManager";
                } else if (_sqlConfig.getString((Object)"driver") != null) {
                    interfaceType = "datasource";
                } else {
                    interfaceType = "jndi";
                    log.info((Object)("No explicit configuration for db: " + dbName + " in server.properties - will look for a Connection object at " + dbName + " or java:comp/env/" + dbName + "."));
                    _sqlConfig.put((Object)"driver.name", (Object)dbName);
                }
                log.debug((Object)(dbName + ": Auto-derived interface.type: " + interfaceType));
            }
            interfaceType = interfaceType.toLowerCase();
            _sqlConfig.put((Object)"interface.type", (Object)interfaceType);
            Config driverConfig = _sqlConfig.getSubtree("driver");
            conn = null;
            DataSource ds = null;
            String jdbcURL = null;
            Boolean credentialsInURL = null;
            if ("datasource".equals(interfaceType)) {
                String dsImplementer = _sqlConfig.getString((Object)"driver");
                if (dsImplementer == null) {
                    throw new Exception(dbName + ": Missing driver name for interface.type: datasource - unable to proceed");
                }
                log.debug((Object)(dbName + ": Initializing SQL config using interface.type: datasource with driver: " + dsImplementer));
                ds = (DataSource)Reflection.newInstance((String)dsImplementer, (Object[])new Object[0]);
                try {
                    DataTools.setProperties((Map)driverConfig, (Object)ds);
                }
                catch (Exception e) {
                    log.warn((Object)(dbName + ": Exception trying to set connection properties"), (Throwable)e);
                }
                if (ds == null) {
                    throw new Exception(dbName + ": Unable to instantiate JDBC DataSource for using specified driver: " + dsImplementer);
                }
                _sqlConfig.put((Object)"_ds", (Object)ds);
                try {
                    conn = ds.getConnection();
                }
                catch (SQLException se) {
                    log.warn((Object)(dbName + ": Unable to obtain initial connection: " + se.getMessage()));
                }
            } else if ("drivermanager".equals(interfaceType)) {
                jdbcURL = driverConfig.getString((Object)"url");
                Boolean credentialsSetting = _sqlConfig.getBoolean((Object)"interface.credentialsInURL");
                credentialsInURL = credentialsSetting == null || credentialsSetting != false;
                if (jdbcURL == null || jdbcURL.length() == 0) {
                    String driverName = driverConfig.getString((Object)"driverName", dbTypeString);
                    if (driverName == null) {
                        throw new Exception(dbName + ": Unable to determine driverName");
                    }
                    jdbcURL = "jdbc:" + driverName + "://" + driverConfig.getString((Object)"serverName") + ":" + driverConfig.get((Object)"portNumber") + "/" + driverConfig.getString((Object)"databaseName", dbName) + (credentialsInURL != false ? "?user=" + driverConfig.get((Object)"user") + "&password=" + driverConfig.get((Object)"password") : "");
                    String urlParams = driverConfig.getString((Object)"urlParams");
                    if (urlParams != null && !"".equals(urlParams)) {
                        jdbcURL = jdbcURL + (jdbcURL.contains("&") ? "&" : "?");
                        jdbcURL = jdbcURL + urlParams;
                    }
                }
                Class driver = null;
                String dmImplementer = _sqlConfig.getString((Object)"driver");
                if (dmImplementer != null) {
                    log.debug((Object)(dbName + ": Initializing SQL config using interface.type: driverManager with driver: " + dmImplementer));
                    driver = Reflection.classForName((String)dmImplementer);
                    if (driver != null) {
                        log.debug((Object)(dmImplementer + " lookup successful"));
                    } else {
                        throw new Exception(dbName + ": Unable to instantiate JDBC Driver for database " + dbName + " using specified driver: " + dmImplementer);
                    }
                }
                if (ISCFile.isUnresolvedContainer((String)jdbcURL)) {
                    jdbcURL = ISCFile.replaceUnresolvedContainer((String)jdbcURL) + "; shutdown=true";
                }
                _sqlConfig.put((Object)"_jdbcURL", (Object)jdbcURL);
                _sqlConfig.put((Object)"_credentialsInURL", (Object)credentialsInURL);
                log.debug((Object)(dbName + ": Fetching connection via jdbc url " + jdbcURL));
                try {
                    if (!credentialsInURL.booleanValue()) {
                        log.debug((Object)(dbName + ": Passing credentials getConnection separately from JDBC URL"));
                        conn = DriverManager.getConnection(jdbcURL, driverConfig.getString((Object)"user"), driverConfig.getString((Object)"password"));
                        break block86;
                    }
                    log.debug((Object)(dbName + ": Passing JDBC URL only to getConnection"));
                    conn = DriverManager.getConnection(jdbcURL);
                }
                catch (SQLException se) {
                    if (dmImplementer == null) {
                        String defaultDmImplementer = _sqlConfig.getString((Object)"defaultDriver");
                        if (defaultDmImplementer == null) {
                            log.warn((Object)(dbName + ": Unable to obtain initial connection (driver not explicitly specified and no default available): " + se.getMessage()));
                            break block86;
                        }
                        log.warn((Object)(dbName + ": Unable to obtain initial connection (driver not explicitly specified - backing off to defaultDriver: " + defaultDmImplementer + "): " + se.getMessage()));
                        driver = Reflection.classForName((String)defaultDmImplementer);
                        if (driver == null) {
                            throw new Exception(dbName + ": Unable to instantiate JDBC Driver for database " + dbName + " using defaultDriver: " + defaultDmImplementer);
                        }
                        log.debug((Object)(defaultDmImplementer + " lookup successful"));
                        try {
                            if (!credentialsInURL.booleanValue()) {
                                log.debug((Object)(dbName + ": Passing credentials getConnection separately from JDBC URL"));
                                conn = DriverManager.getConnection(jdbcURL, driverConfig.getString((Object)"user"), driverConfig.getString((Object)"password"));
                                break block86;
                            }
                            log.debug((Object)(dbName + ": Passing JDBC URL only to getConnection"));
                            conn = DriverManager.getConnection(jdbcURL);
                        }
                        catch (SQLException se2) {
                            log.warn((Object)(dbName + ": Unable to obtain initial connection (driver not explicitly specified - and backoff off to defaultDriver: " + defaultDmImplementer + " failed): " + se2.getMessage()));
                        }
                        break block86;
                    }
                    log.warn((Object)(dbName + ": Unable to obtain initial connection (using explicitly set driver: " + dmImplementer + "): " + se.getMessage()));
                }
            } else if ("jndi".equals(interfaceType)) {
                String jndiName = null;
                if (ds == null) {
                    String ctxName = driverConfig.getString((Object)"context", "");
                    log.debug((Object)(dbName + ": Initializing SQL config via JNDI"));
                    Context dbContext = JNDI.bindConfiguredContext((String)ctxName);
                    jndiName = driverConfig.getString((Object)"name");
                    if (jndiName == null) {
                        throw new Exception(dbName + ": Encountered null JNDI name when trying to connect a JNDI DataSource.");
                    }
                    try {
                        ds = (DataSource)dbContext.lookup(jndiName);
                    }
                    catch (NameNotFoundException se) {
                        // empty catch block
                    }
                    if (ds == null) {
                        dbContext = JNDI.bindConfiguredContext((String)"_container_");
                        if (dbContext != null) {
                            ds = (DataSource)dbContext.lookup(jndiName);
                        } else {
                            log.warn((Object)(dbName + ": Unable to obtain initialContext via new InitialContext() - this shouldn't happen and indicates a low level error with instantiating a Context.INITIAL_CONTEXT_FACTORY - please check for overrides of this on the command line or other bootstrap logic"));
                        }
                    }
                }
                if (ds == null) {
                    throw new Exception(dbName + ": JNDI lookup for " + jndiName + " failed.");
                }
                try {
                    conn = ds.getConnection();
                }
                catch (SQLException se) {
                    log.warn((Object)(dbName + ": Unable to obtain initial connection: " + se.getMessage()));
                }
                _sqlConfig.put((Object)"_ds", (Object)ds);
                _sqlConfig.put((Object)"driver.serverName", (Object)"[Auto-configured JNDI resource]");
                _sqlConfig.put((Object)"driver.autoConfigured", (Object)Boolean.TRUE);
            } else if ("spring".equals(interfaceType)) {
                String beanName = _sqlConfig.getString((Object)"spring.dataSourceBean");
                if (beanName == null) {
                    throw new Exception(dbName + ": Missing spring.dataSourceBean for interface.type: spring - unable to proceed");
                }
                log.debug((Object)(dbName + ": Initializing SQL config via Spring bean: " + beanName));
                ISpringBeanFactory beanFactory = (ISpringBeanFactory)InterfaceProvider.load((String)"ISpringBeanFactory");
                Object bean = beanFactory.getBean(null, beanName);
                try {
                    conn = (Connection)Reflection.invokeMethod((Object)bean, (String)"getConnection");
                }
                catch (SQLException se) {
                    log.warn((Object)(dbName + ": Unable to obtain initial connection: " + se.getMessage()));
                }
                _sqlConfig.put((Object)"_ds", bean);
            } else {
                throw new Exception(dbName + ": Unsupported interface.type: " + interfaceType + " - check your config.");
            }
        }
        if (conn == null) {
            throw new SQLException("Failed to acquire connection for " + dbName + " (null connection returned");
        }
        DBType dbType = dbTypeString == null ? null : DBType.fromString(dbTypeString);
        DataTypeMap metaData = new DataTypeMap();
        try {
            DatabaseMetaData md = conn.getMetaData();
            metaData.put((Object)"databaseMajorVersion", (Object)md.getDatabaseMajorVersion());
            metaData.put((Object)"databaseMinorVersion", (Object)md.getDatabaseMinorVersion());
            metaData.put((Object)"databaseProductName", (Object)md.getDatabaseProductName());
            metaData.put((Object)"databaseProductVersion", (Object)md.getDatabaseProductVersion());
            metaData.put((Object)"databaseProductString", (Object)(md.getDatabaseProductName() + " " + md.getDatabaseProductVersion()));
            metaData.put((Object)"driverMajorVersion", (Object)md.getDriverMajorVersion());
            metaData.put((Object)"driverMinorVersion", (Object)md.getDriverMinorVersion());
            metaData.put((Object)"driverName", (Object)md.getDriverName());
            metaData.put((Object)"driverVersion", (Object)md.getDriverVersion());
            metaData.put((Object)"JDBCMajorVersion", (Object)md.getJDBCMajorVersion());
            metaData.put((Object)"JDBCMinorVersion", (Object)md.getJDBCMinorVersion());
            log.debug((Object)(dbName + ": Database metadata: " + DataTools.prettyPrint((Object)metaData)));
            if (dbType == null) {
                String productName = md.getDatabaseProductName();
                String productVersion = md.getDatabaseProductVersion();
                String driverName = md.getDriverName();
                String driverVersion = md.getDriverVersion();
                dbType = DBType.Generic;
                String lcProductName = productName.toLowerCase();
                if (lcProductName.contains("sql server")) {
                    dbType = DBType.SQLServer;
                } else if (lcProductName.contains("oracle")) {
                    dbType = DBType.Oracle;
                } else if (lcProductName.contains("mysql")) {
                    dbType = DBType.MySQL;
                } else if (lcProductName.contains("mariadb")) {
                    dbType = DBType.MariaDB;
                } else if (lcProductName.contains("postgresql")) {
                    dbType = DBType.PostgreSQL;
                } else if (lcProductName.contains("db2")) {
                    dbType = DBType.DB2;
                } else if (lcProductName.contains("hsqldb")) {
                    dbType = DBType.HSQLDB;
                } else if (lcProductName.contains("cache")) {
                    dbType = DBType.Cache;
                } else if (lcProductName.contains("informix")) {
                    dbType = DBType.Informix;
                } else if (lcProductName.contains("firebird")) {
                    dbType = DBType.Firebird;
                } else if (lcProductName.contains("iris")) {
                    dbType = DBType.IRIS;
                } else {
                    throw new Exception("Unable to derive dbType from string: " + productName);
                }
                log.info((Object)(dbName + ": Derived DB type is: " + (Object)((Object)dbType)));
                _sqlConfig.put((Object)"database.type", (Object)dbType.toString());
            }
            if (dbType == DBType.PostgreSQL) {
                try {
                    metaData.put((Object)"standard_conforming_strings", SQLDriver.readSingleValue(conn, "show standard_conforming_strings;", "standard_conforming_strings"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            _sqlConfig.put((Object)"_metaData", (Object)metaData);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        if (dbType == null) {
            throw new Exception(dbName + ": database.type not explicitly specified and initial connection not available (see reason above)");
        }
        _sqlConfig.put((Object)"_dbType", (Object)dbType);
        if (dbTypeString == null) {
            dbTypeString = dbType.toString();
            _sqlConfig = (Config)DataTools.cascadeMaps((Map[])new Map[]{config.getSubtree("sql.default"), config.getSubtree("sql." + dbTypeString), _sqlConfig, new Config()});
        }
        return _sqlConfig;
    }

    public static Object readSingleValue(Connection conn, String query, String columnName) throws Exception {
        Statement s = null;
        ResultSet rs = null;
        try {
            s = conn.createStatement();
            rs = s.executeQuery(query);
            rs.next();
            Object result = rs.getObject(columnName);
            if (result instanceof UUID && SQLDriver.forceUUIDToString()) {
                result = result.toString();
            }
            Object object = result;
            return object;
        }
        catch (SQLException se) {
            logSqlError.debug((Object)("Failed to execute query: " + query + ", SQL error: " + se.getMessage()));
            throw se;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                s.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection rawConnection() throws Exception {
        DataSource ds = (DataSource)this._sqlConfig.get((Object)"_ds");
        String jdbcURL = this._sqlConfig.getString((Object)"_jdbcURL");
        Boolean credentialsInURL = this._sqlConfig.getBoolean((Object)"_credentialsInURL");
        if (credentialsInURL == null) {
            credentialsInURL = Boolean.FALSE;
        }
        if (!this._sqlConfig.getBoolean((Object)"_oneTimeConnectionInitComplete", false)) {
            Config config = this._sqlConfig;
            synchronized (config) {
                if (!this._sqlConfig.getBoolean((Object)"_oneTimeConnectionInitComplete", false)) {
                    if (ds != null) {
                        Map driverProperties;
                        if (this._sqlConfig.getBoolean((Object)"log.enabled", false)) {
                            ds.setLogWriter(new PrintWriter(System.out));
                        }
                        if ((driverProperties = this.getDriverProperties()) != null && driverProperties.size() > 0) {
                            DataTools.setProperties((Map)driverProperties, (Object)ds);
                        }
                    } else {
                        Map driverProperties = this.getDriverProperties();
                        if (driverProperties != null && driverProperties.size() > 0) {
                            jdbcURL = jdbcURL + (jdbcURL.contains("&") ? "&" : "?");
                            Iterator i = driverProperties.keySet().iterator();
                            while (i.hasNext()) {
                                String propName = (String)i.next();
                                Object propValue = driverProperties.get(propName);
                                jdbcURL = jdbcURL + (propName + "=" + propValue == null ? "" : propValue.toString());
                                if (!i.hasNext()) continue;
                                jdbcURL = jdbcURL + "&";
                            }
                        }
                    }
                    this._sqlConfig.put((Object)"_oneTimeConnectionInitComplete", (Object)Boolean.TRUE);
                }
            }
        }
        Connection conn = null;
        conn = ds != null ? ds.getConnection() : (credentialsInURL == false ? DriverManager.getConnection(jdbcURL, this.driverConfig.getString((Object)"user"), this.driverConfig.getString((Object)"password")) : DriverManager.getConnection(jdbcURL));
        return conn;
    }

    protected Map getDriverProperties() {
        HashMap<String, String> driverProperties = new HashMap<String, String>();
        if ((this.dbType == DBType.Informix || this.dbType == DBType.MySQL || this.dbType == DBType.MariaDB) && this.useUTCDateTimes) {
            driverProperties.put("serverTimezone", "UTC");
        }
        return driverProperties;
    }

    public void freeConnection() {
        try {
            if (this.dbConnection != null && !this.dbConnection.isClosed()) {
                log.debug((Object)("Freeing SQLDriver dbConnection " + this.dbConnection.hashCode() + " for SQLDriver instance " + ((Object)((Object)this)).hashCode()));
                SQLConnectionManager.free(this.dbConnection);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception freeing the SQLDriver dbConnection", (Throwable)e);
        }
        finally {
            this.dbConnection = null;
        }
    }

    public void finalize() throws Throwable {
        this.freeConnection();
    }

    public Connection getConnection() {
        return this.dbConnection;
    }

    public Connection getOrCreateConnection() throws SQLException {
        if (this.dbConnection == null) {
            this.dbConnection = SQLConnectionManager.getConnection(this.dbName);
        }
        return this.dbConnection;
    }

    public String getDBName() {
        return this.dbName;
    }

    public DBType getDBType() {
        return this.dbType;
    }

    public boolean useColumnLabelInMetadata() {
        return this.useColumnLabelInMetadata;
    }

    public SQLTable getTable() {
        return this.table;
    }

    public static List getTransformedResults(String query, DSRequest req) throws Exception {
        return SQLDriver.getTransformedResults(query, null, req);
    }

    public static List getTransformedResults(String query, String dbName, DSRequest req) throws Exception {
        return SQLDriver.getTransformedResults(query, null, dbName, null, req);
    }

    protected static List getTransformedResults(String query, Connection conn, String dbName, SQLDriver driver, DSRequest req) throws Exception {
        return SQLDriver.getTransformedResults(query, conn, dbName, driver, null, req, null);
    }

    protected static List getTransformedResults(String query, Connection conn, String dbName, SQLDriver driver, List dataSources, DSRequest req, DSResponse resp) throws Exception {
        return SQLDriver.getTransformedResults(query, conn, dbName, driver, dataSources, null, req, resp);
    }

    protected static List getTransformedResults(String query, Connection conn, String dbName, SQLDriver driver, List dataSources, Map opConfig, DSRequest req, DSResponse result) throws Exception {
        Connection workingConn;
        boolean closeConnection = false;
        boolean userOrAutoTransaction = true;
        Connection userOrAutoConn = null;
        if (req != null) {
            req.recordTimingData(TIMING_LOG_UNPAGED_FETCH, DSRequest.TimingLogType.START);
            req.recordTimingData(TIMING_LOG_GET_CONNECTION, DSRequest.TimingLogType.START);
            if (req.getDsTransaction() != null) {
                SQLDataSource ds = (SQLDataSource)req.getDataSource();
                userOrAutoConn = ds.getTransactionalConnection(req);
            }
        }
        if (userOrAutoConn == null) {
            if (dbName == null) {
                dbName = config.getString((Object)"sql.defaultDatabase");
            }
            if (conn == null) {
                if (driver != null && driver.dbConnection != null) {
                    conn = driver.dbConnection;
                    closeConnection = false;
                }
                if (conn == null) {
                    conn = SQLConnectionManager.getConnection(dbName);
                    closeConnection = true;
                }
                if (driver != null && driver.dbConnection == null) {
                    driver.dbConnection = conn;
                    closeConnection = false;
                }
            } else if (driver != null) {
                if (driver.dbConnection != null && driver.dbConnection != conn) {
                    SQLConnectionManager.free(driver.dbConnection);
                }
                driver.dbConnection = conn;
            }
            userOrAutoTransaction = false;
            workingConn = conn;
        } else {
            workingConn = userOrAutoConn;
        }
        if (req != null) {
            req.recordTimingData(TIMING_LOG_GET_CONNECTION, DSRequest.TimingLogType.END);
        }
        Statement s = null;
        ResultSet rs = null;
        boolean streaming = req != null && req.shouldStreamResults();
        int batchSize = req == null ? 0 : (int)req.getBatchSize();
        boolean mdcKeyAdded = false;
        try {
            query = SQLDataSource.addMDCKey(query);
            mdcKeyAdded = true;
            if (SQLLogger.isInfoEnabled() && (req == null || !"fileSourceDataSources".equals(req.getDataSourceName()) || config.getBoolean((Object)"sql.log.fileSourceDataSources.queries", true))) {
                SQLLogger.info((Object)("Executing SQL query on '" + dbName + "'" + (log.isDebugEnabled() ? " using connection '" + workingConn.hashCode() + "'" : "")), SQLDriver.formatSQL(query));
            }
            s = driver == null ? workingConn.createStatement() : driver.createFetchStatement(workingConn, streaming, batchSize, req);
            long start = System.currentTimeMillis();
            if (req != null) {
                req.recordTimingData(TIMING_LOG_QUERY, DSRequest.TimingLogType.START);
            }
            rs = s.executeQuery(query);
            if (req != null) {
                req.recordTimingData(TIMING_LOG_QUERY, DSRequest.TimingLogType.END);
            }
            SQLDataSource.logSlowQuery(query, start, -1L, req);
            if (streaming) {
                log.debug((Object)"Streaming the response");
                result.setData((Object)new StreamingResponseIterator(result));
                HashMap<String, Object> sContext = new HashMap<String, Object>();
                sContext.put("resultSet", rs);
                sContext.put("brokenCursorAPIs", SQLTransform.hasBrokenCursorAPIs(driver));
                sContext.put("dataSources", dataSources);
                sContext.put("opConfig", opConfig);
                sContext.put("dsRequest", req);
                result.setStreamingContext(sContext);
                result.setStartRow(req.getStartRow());
                result.setEndRow(req.getStartRow());
                result._setHasNextRecord(rs.next());
                List list = null;
                return list;
            }
            start = System.currentTimeMillis();
            if (req != null) {
                req.recordTimingData(TIMING_LOG_SQLTRANSFORM, DSRequest.TimingLogType.START);
            }
            List data = SQLTransform.toListOfMapsOrBeans(rs, SQLTransform.hasBrokenCursorAPIs(dbName), dataSources, opConfig, req);
            if (req != null) {
                req.recordTimingData(TIMING_LOG_SQLTRANSFORM, DSRequest.TimingLogType.END);
            }
            List list = data;
            return list;
        }
        catch (SQLException se) {
            if (!userOrAutoTransaction) {
                if (config.getBoolean((Object)"sql.log.fileSourceDataSources.queries", true)) {
                    log.info((Object)("Execute of select: " + query + " on db: " + dbName + " threw exception: " + se.toString() + " - assuming stale connection and retrying query."));
                }
                SQLConnectionManager.free(conn, true);
                conn = SQLConnectionManager.getNewConnection(dbName);
                if (driver != null) {
                    driver.dbConnection = conn;
                }
                Statement statement = s = driver == null ? conn.createStatement() : driver.createFetchStatement(conn, streaming, batchSize, req);
                if (!mdcKeyAdded) {
                    query = SQLDataSource.addMDCKey(query);
                }
                long start = System.currentTimeMillis();
                try {
                    rs = s.executeQuery(query);
                }
                catch (SQLException se2) {
                    logSqlError.debug((Object)("Failed to execute query: " + query + ", SQL error: " + se2.getMessage()));
                    throw se2;
                }
                SQLDataSource.logSlowQuery(query, start, -1L, req);
                List list = SQLTransform.toListOfMapsOrBeans(rs, SQLTransform.hasBrokenCursorAPIs(dbName), dataSources, opConfig);
                return list;
            }
            logSqlError.debug((Object)("Failed to execute query: " + query + ", SQL error: " + se.getMessage()));
            throw se;
        }
        finally {
            if (!streaming) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
                try {
                    s.close();
                }
                catch (Exception exception) {}
                if (req != null) {
                    req.recordTimingData(TIMING_LOG_UNPAGED_FETCH, DSRequest.TimingLogType.END);
                }
            }
        }
    }

    public static String formatSQL(String sql) {
        return SQLDriver.formatSQL(sql, false);
    }

    public static String formatSQL(String sql, boolean slowSQL) {
        if (!canFormatSQL) {
            return sql;
        }
        boolean maxLengthExceeded = false;
        if (!slowSQL && maxLogLength > 0 && sql.length() > maxLogLength) {
            sql = sql.substring(0, maxLogLength);
            maxLengthExceeded = true;
        }
        try {
            sql = (String)Reflection.invokeStaticMethod((String)"com.isomorphic.hibernate.HB", (String)"formatSQL", (Object[])new Object[]{sql});
            if (compactFormattingSQL) {
                sql = sql.replaceAll(",[\\t\\n\\r ]+", ", ");
                sql = sql.replaceAll("(\\S)( |\\t)+", "$1 ");
            }
            if (slowSQL) {
                sql = sql.replaceAll("[\\n\\r]+", "\n\r    ");
            }
        }
        catch (Throwable e) {
            canFormatSQL = false;
        }
        if (maxLengthExceeded) {
            sql = sql + "\n...truncated (sql.log.maxLength: " + maxLogLength + ") exceeded.";
        }
        return sql;
    }

    public static Object getScalarResult(String query, DSRequest req) throws Exception {
        return SQLDriver.getScalarResult(query, null, req);
    }

    public static Object getScalarResult(String query, String dbName, DSRequest req) throws Exception {
        return SQLDriver.getScalarResult(query, null, dbName, null, req);
    }

    public static Object getScalarResult(String query, Connection conn, String dbName, SQLDriver driver, DSRequest req) throws Exception {
        List list = SQLDriver.getTransformedResults(query, conn, dbName, driver, req);
        if (list == null || list.size() == 0) {
            return null;
        }
        Map map = (Map)list.get(0);
        return map.get(DataTools.getSingle((Object)map));
    }

    public static int update(String update, DSRequest req) throws Exception {
        return SQLDriver.update(update, null, req);
    }

    public static int update(String update, String dbName, DSRequest req) throws Exception {
        return SQLDriver.update(update, null, dbName, req);
    }

    public static int update(String update, List data, String dbName, DSRequest req) throws Exception {
        return SQLDriver.update(update, data, SQLConnectionManager.getConnection(dbName), dbName, null, req);
    }

    protected static int update(String update, List data, Connection conn, String dbName, SQLDriver driver, DSRequest req) throws Exception {
        Connection workingConn;
        if (dbName == null) {
            dbName = config.getString((Object)"sql.defaultDatabase");
        }
        boolean userOrAutoTransaction = true;
        Connection userOrAutoConn = null;
        if (req != null && req.getDsTransaction() != null) {
            SQLDataSource ds = (SQLDataSource)req.getDataSource();
            userOrAutoConn = ds.getTransactionalConnection(req);
        } else {
            log.info((Object)"DSRequest has no DSTransaction set, when testing if we should join a transaction - transaction will not be joined");
        }
        if (userOrAutoConn == null) {
            if (conn == null) {
                if (driver != null && driver.dbConnection != null) {
                    conn = driver.dbConnection;
                }
                if (conn == null) {
                    conn = SQLConnectionManager.getConnection(dbName);
                }
                if (driver != null) {
                    driver.dbConnection = conn;
                }
            } else if (driver != null) {
                if (driver.dbConnection != null && driver.dbConnection != conn) {
                    SQLConnectionManager.free(driver.dbConnection);
                }
                driver.dbConnection = conn;
            }
            userOrAutoTransaction = false;
            workingConn = conn;
        } else {
            workingConn = userOrAutoConn;
        }
        if (SQLLogger.isInfoEnabled() && (req == null || !"fileSourceDataSources".equals(req.getDataSourceName()) || config.getBoolean((Object)"sql.log.fileSourceDataSources.queries", true))) {
            SQLLogger.info((Object)("Executing SQL query on '" + dbName + "'" + (log.isDebugEnabled() ? " using connection '" + workingConn.hashCode() + "'" : "")), SQLDriver.formatSQL(update));
        }
        try {
            int ds = SQLDriver.doUpdate(update, data, workingConn, req, driver);
            return ds;
        }
        catch (SQLException se) {
            if (!userOrAutoTransaction) {
                if (config.getBoolean((Object)"sql.log.fileSourceDataSources.queries", true)) {
                    log.info((Object)("Execute of update: " + update + " on db: " + dbName + " threw exception: " + se.toString() + " - assuming stale connection and retrying update."));
                }
                SQLConnectionManager.free(conn, true);
                conn = SQLConnectionManager.getNewConnection(dbName);
                if (driver != null) {
                    driver.dbConnection = conn;
                }
                int n = SQLDriver.doUpdate(update, data, conn, req, driver);
                return n;
            }
            log.debug((Object)("FAILED to execute SQL update in '" + dbName + "' using connection'" + workingConn.hashCode() + "'"));
            throw se;
        }
        finally {
            if (!userOrAutoTransaction && driver == null) {
                SQLConnectionManager.free(conn);
            }
        }
    }

    public static int doUpdate(String update, List data, Connection conn, DSRequest req) throws SQLException {
        return SQLDriver.doUpdate(update, data, conn, req, null);
    }

    public static int doUpdate(String update, List data, Connection conn, DSRequest req, SQLDriver driver) throws SQLException {
        try {
            if (req != null) {
                DataTypeMap opBinding;
                DataTypeMap dataTypeMap = opBinding = req.getDataSource() == null ? null : req.getDataSource().getOperationBinding(req);
                if (opBinding != null && DataTools.getBoolean((Map)opBinding, (Object)"isDDL", (boolean)false)) {
                    driver.setLastSequenceMode(SQLDataSource.SequenceMode.NONE);
                } else {
                    driver.setLastSequenceMode(((SQLDataSource)req.getDataSource()).getSequenceMode());
                }
            } else {
                driver.setLastSequenceMode(SQLDataSource.SequenceMode.NONE);
            }
        }
        catch (Exception e) {
            throw new SQLException("Exception getting sequenceMode: " + e.getMessage());
        }
        PreparedStatement s = driver.getPreparedStatement(conn, update, driver.getLastSequenceMode(), req);
        try {
            if (data != null && !com.isomorphic.datasource.DataSource.isRemove((String)req.getOperationType())) {
                int pos = 1;
                for (Object o : data) {
                    if (o instanceof InputStream) {
                        s.setBinaryStream(pos, (InputStream)o);
                    } else if (o instanceof Reader) {
                        s.setCharacterStream(pos, (Reader)o);
                    } else if (o instanceof StringBuffer) {
                        StringBuffer sb = (StringBuffer)o;
                        s.setCharacterStream(pos, (Reader)new StringReader(sb.toString()), sb.length());
                    } else if (o == null) {
                        boolean isMultiInserting;
                        boolean bl = isMultiInserting = req != null && "add".equals(req.getOperationType()) && req.getValueSets().size() > 1;
                        if (driver.shouldParameterizeNullValues(isMultiInserting)) {
                            s.setString(pos, null);
                        }
                    }
                    ++pos;
                }
            }
            long start = System.currentTimeMillis();
            int res = s.executeUpdate();
            SQLDataSource.logSlowQuery(update, start, -1L, req);
            int n = res;
            return n;
        }
        catch (SQLException se) {
            logSqlError.debug((Object)("Failed to execute update: " + update + ", SQL error: " + se.getMessage()));
            throw se;
        }
        finally {
            try {
                if (driver != null && req != null && com.isomorphic.datasource.DataSource.isAdd((String)req.getOperationType())) {
                    driver.saveGeneratedKeys(s, req);
                }
            }
            catch (Exception e) {
                log.warn((Object)"Exception thrown during saveGeneratedKeys()", (Throwable)e);
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected PreparedStatement getPreparedStatement(Connection conn, String update, SQLDataSource.SequenceMode sequenceMode, DSRequest req) throws SQLException {
        try {
            if (sequenceMode == SQLDataSource.SequenceMode.JDBC_DRIVER) {
                if (this.supportsGetGeneratedKeys(conn, req.getDataSource())) {
                    return conn.prepareStatement(update, 1);
                }
                return conn.prepareStatement(update);
            }
            return conn.prepareStatement(update);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public static boolean execute(String sql, Connection conn, String dbName, SQLDriver driver) throws Exception {
        if (dbName == null) {
            dbName = config.getString((Object)"sql.defaultDatabase");
        }
        if (conn == null) {
            conn = SQLConnectionManager.getConnection(dbName);
            if (driver != null) {
                driver.dbConnection = conn;
            }
        }
        Statement s = null;
        try {
            if (SQLLogger.isInfoEnabled()) {
                SQLLogger.info((Object)("Executing SQL on '" + dbName + "'"), SQLDriver.formatSQL(sql));
            }
            s = conn.createStatement();
            boolean bl = s.execute(sql);
            return bl;
        }
        catch (SQLException se) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Execute of sql: " + SQLDriver.formatSQL(sql) + " on db: " + dbName + " threw exception: " + se.toString() + " - assuming stale connection and retrying update."));
            }
            SQLConnectionManager.free(conn, true);
            conn = SQLConnectionManager.getNewConnection(dbName);
            if (driver != null) {
                driver.dbConnection = conn;
            }
            s = conn.createStatement();
            try {
                boolean bl = s.execute(sql);
                return bl;
            }
            catch (SQLException se2) {
                logSqlError.debug((Object)("Failed to execute update: " + sql + ", SQL error: " + se2.getMessage()));
                throw se2;
            }
        }
        finally {
            try {
                s.close();
            }
            catch (Exception exception) {}
            if (driver == null) {
                SQLConnectionManager.free(conn);
            }
        }
    }

    public boolean execute(String sql) throws Exception {
        return SQLDriver.execute(sql, this.dbConnection, this.dbName, this);
    }

    public int executeUpdate(String update, DSRequest req) throws Exception {
        return SQLDriver.update(update, null, this.dbConnection, this.dbName, this, req);
    }

    public int executeUpdate(String update, List data, DSRequest req) throws Exception {
        return SQLDriver.update(update, data, this.dbConnection, this.dbName, this, req);
    }

    public List executeQuery(String query, DSRequest req) throws Exception {
        return this.executeQuery(query, null, req, null);
    }

    public List executeQuery(String query, List dataSources, DSRequest req) throws Exception {
        return this.executeQuery(query, dataSources, null, req, null);
    }

    public List executeQuery(String query, List dataSources, DSRequest req, DSResponse resp) throws Exception {
        return this.executeQuery(query, dataSources, null, req, resp);
    }

    public List executeQuery(String query, List dataSources, Map opConfig, DSRequest req, DSResponse resp) throws Exception {
        return SQLDriver.getTransformedResults(query, this.dbConnection, this.dbName, this, dataSources, opConfig, req, resp);
    }

    public Object executeScalar(String query, DSRequest req) throws Exception {
        return SQLDriver.getScalarResult(query, this.dbConnection, this.dbName, this, req);
    }

    public boolean supportsSQLLimit() {
        return false;
    }

    public boolean limitRequiresSQLOrderClause() {
        Boolean dbNameLevel = config.getBoolean((Object)("sql." + this.dbName + ".forceSort"));
        if (dbNameLevel != null) {
            return dbNameLevel;
        }
        return config.getBoolean((Object)("sql." + (Object)((Object)this.dbType) + ".forceSort"), false);
    }

    public boolean supportsOffsetFetch() {
        return true;
    }

    public String limitQuery(String query, long startRow, long totalRows, List outputColumns, DSRequest req) throws Exception {
        return this.limitQuery(query, startRow, totalRows, outputColumns);
    }

    public String limitQuery(String query, long startRow, long totalRows, List outputColumns, DSRequest req, Map context) throws Exception {
        return this.limitQuery(query, startRow, totalRows, outputColumns, null, null, null, context);
    }

    public String limitQuery(String query, long startRow, long totalRows, List outputColumns) throws Exception {
        return this.limitQuery(query, startRow, totalRows, outputColumns, null, null, null);
    }

    public String limitQuery(String query, long startRow, long totalRows, List outputColumns, String orderClause, DSRequest req, List dataSources) throws Exception {
        return this.limitQuery(query, startRow, totalRows, outputColumns, orderClause, req, dataSources, null);
    }

    public String limitQuery(String query, long startRow, long totalRows, List outputColumns, String orderClause, DSRequest req, List dataSources, Map context) throws Exception {
        return this.limitQuery(query, startRow, totalRows, outputColumns, orderClause, null, req, dataSources, context);
    }

    public String limitQuery(String query, long startRow, long totalRows, List outputColumns, String orderClause, String computedOrderClause, DSRequest req, List dataSources, Map context) throws Exception {
        throw new Exception("limitQuery not supported by '" + (Object)((Object)this.getDBType()) + "'.  Implementation: " + ((Object)((Object)this)).getClass().getCanonicalName());
    }

    public String getRowCountQueryString(String select, String tables, String ansiJoin, String where, String joinWhere, String group, String groupWithAlias, String groupWhere, Map context, Boolean useHavingClause) {
        boolean hasGroupWhere;
        boolean hasGroup;
        boolean _useDistinctForGroupBy = this.useDistinctForGroupBy;
        boolean hasCustomGroup = hasGroup = !group.equals("$defaultGroupClause");
        if (!hasGroup && context != null && context.containsKey("dsRequest")) {
            DSRequest req = (DSRequest)context.get("dsRequest");
            hasGroup = req.isSummary();
        }
        boolean bl = hasGroupWhere = !groupWhere.equals("$defaultGroupWhereClause");
        if (hasGroupWhere) {
            _useDistinctForGroupBy = false;
        }
        String qry = "SELECT COUNT(*) FROM ";
        if (hasGroup) {
            qry = !hasCustomGroup && _useDistinctForGroupBy ? qry + "(SELECT distinct " + groupWithAlias + " FROM " : qry + "(SELECT " + select + " FROM ";
        }
        qry = qry + tables;
        boolean tableClauseIncludesAnsiJoins = DataTools.getBoolean((Map)context, (Object)"tableClauseIncludesAnsiJoins", (boolean)false);
        boolean emittedJoinClause = false;
        if (!(tableClauseIncludesAnsiJoins || "$defaultAnsiJoinClause".equals(ansiJoin) && context.get("defaultAnsiJoinClause") == null)) {
            qry = qry + ansiJoin;
            emittedJoinClause = true;
        }
        boolean emittedWhere = false;
        if (!where.equals("$defaultWhereClause") || context.get("defaultWhereClause") != null && !SQLWhereClause.isDefaultPositiveClause(context.get("defaultWhereClause"))) {
            qry = qry + " WHERE " + where;
            emittedWhere = true;
        }
        if (!(emittedJoinClause || "$defaultJoinWhereClause".equals(joinWhere) && (context.get("defaultJoinWhereClause") == null || "".equals(context.get("defaultJoinWhereClause"))))) {
            qry = !emittedWhere ? qry + " WHERE " + joinWhere : qry + " AND " + joinWhere;
        }
        if (hasGroup) {
            if (!hasCustomGroup && _useDistinctForGroupBy) {
                qry = qry + " ) work";
            } else if (Boolean.TRUE.equals(useHavingClause) || this.useHavingClause()) {
                qry = qry + " GROUP BY " + group;
                if (hasGroupWhere) {
                    qry = qry + " HAVING " + groupWhere;
                }
                qry = qry + ") work";
            } else {
                qry = qry + " GROUP BY " + group + ") work";
                if (hasGroupWhere) {
                    qry = qry + " WHERE " + groupWhere;
                }
            }
        }
        return qry;
    }

    public abstract boolean supportsNativeReplace();

    public String sortBy(Object order, Map remapTable, Map valueMaps) {
        if (order == null) {
            return "";
        }
        List orderList = order instanceof String ? DataTools.makeList((Object)order) : (List)order;
        if (orderList.size() == 0) {
            return "";
        }
        if (remapTable == null) {
            remapTable = EMPTY_REMAP;
        }
        String clause = " ORDER BY ";
        Iterator e = orderList.iterator();
        while (e.hasNext()) {
            String orderColumn = (String)e.next();
            boolean descending = false;
            if (orderColumn.startsWith("-")) {
                orderColumn = orderColumn.substring(1);
                descending = true;
            }
            Map valueMap = (Map)valueMaps.get(orderColumn);
            String remappedName = (String)remapTable.get(orderColumn);
            if (remappedName != null) {
                orderColumn = remappedName;
            }
            orderColumn = this.escapeColumnName(orderColumn);
            clause = clause + this.getExpressionForSortBy(orderColumn, valueMap, null) + (descending ? " DESC" : "");
            if (!e.hasNext()) continue;
            clause = clause + ", ";
        }
        return clause;
    }

    protected abstract String getExpressionForSortBy(String var1, Map var2, DSRequest var3);

    protected String getExpressionForSortBy(String column, Map valueMap, String functionName, DSRequest request) {
        String expr = this.getExpressionForSortBy(column, valueMap, request);
        if (functionName != null && !"".equals(functionName.trim())) {
            expr = functionName + "(" + expr + ")";
        }
        return expr;
    }

    protected String getLocalizedDisplayValue(Object displayValue, DSRequest request) {
        if (displayValue instanceof LocaleMessage) {
            if (request != null && request.context == null) {
                log.warn((Object)"Passed a DSRequest with no context, so we cannot discover the client locale.  Using the server default locale");
            }
            Locale locale = request != null && request.context != null ? request.context.getLocale() : Locale.getDefault();
            return ((LocaleMessage)displayValue).getMessage(locale);
        }
        return displayValue == null ? null : displayValue.toString();
    }

    protected String transformActualValueForSort(String value, String column, DSRequest req) {
        String fieldName;
        DSField field;
        String quotedValue = "'" + value + "'";
        com.isomorphic.datasource.DataSource ds = null;
        try {
            ds = req.getDataSource();
        }
        catch (Exception e) {
            log.warn((Object)("Caught Exception while trying to derive DSField for column " + column + ". Continuing without checking for the special combination of a boolean field with a declared sqlStorageStrategy and a valueMap"), (Throwable)e);
            return quotedValue;
        }
        if (ds == null) {
            return quotedValue;
        }
        if (column.indexOf(46) != -1) {
            String[] elements = column.split("\\.");
            column = elements[elements.length - 1];
        }
        if ((field = ds.getField(fieldName = ds.native2DSFieldMap() == null ? column : (String)ds.native2DSFieldMap().get(column))) == null) {
            return quotedValue;
        }
        if (!"boolean".equals(ds.getSimpleBaseType(field.getType()))) {
            return quotedValue;
        }
        if (field.get((Object)"sqlStorageStrategy") == null) {
            return quotedValue;
        }
        String sqlStorageStrategy = (String)field.get((Object)"sqlStorageStrategy");
        String t = "'true'";
        String f = "'false'";
        switch (sqlStorageStrategy) {
            case "integer": 
            case "number": {
                t = "1";
                f = "0";
                break;
            }
            case "singleChar10": {
                t = "'1'";
                f = "'0'";
                break;
            }
            case "singleCharTF": {
                t = "'T'";
                f = "'F'";
                break;
            }
            case "singleCharYN": {
                t = "'Y'";
                f = "'N'";
                break;
            }
            case "singleChar": {
                t = (String)field.get((Object)"sqlTrueValue");
                if (t != null) {
                    t = t.substring(0, 1);
                    t = "'" + t + "'";
                }
                if ((f = (String)field.get((Object)"sqlFalseValue")) == null) break;
                f = f.substring(0, 1);
                f = "'" + f + "'";
                break;
            }
            case "string": {
                t = (String)field.get((Object)"sqlTrueValue");
                if (t != null) {
                    t = "'" + t + "'";
                }
                if ((f = (String)field.get((Object)"sqlFalseValue")) == null) break;
                f = "'" + f + "'";
            }
        }
        return Boolean.FALSE.equals(value) || "false".equals(value) ? f : t;
    }

    public abstract Map fetchLastPrimaryKeys(Map var1, List var2, SQLDataSource var3, DSRequest var4) throws Exception;

    public Map getJdbcPKs() {
        return this.jdbcPKs;
    }

    public void saveGeneratedKeys(Statement s, DSRequest req) throws Exception {
        this.jdbcPKs.clear();
        if (this.getLastSequenceMode() != SQLDataSource.SequenceMode.JDBC_DRIVER) {
            log.debug((Object)"SequenceMode is not JDBC_DRIVER, skipping search for generated values");
            return;
        }
        if (!this.supportsGetGeneratedKeys(s.getConnection(), req.getDataSource())) {
            this.logGeneratedKeysWarning(req.getDataSource());
            return;
        }
        if (req.getDataSource() instanceof SQLDataSource) {
            SQLDataSource ds = (SQLDataSource)req.getDataSource();
            List pkNames = ds.getPrimaryKeys();
            List fieldNames = ds._getFieldNames();
            boolean proceed = false;
            for (String fieldName : fieldNames) {
                DSField field = ds.getField(fieldName);
                if (field == null || !"sequence".equals(field.getType()) && (!pkNames.contains(fieldName) || !field.getBoolean("autoGenerated", false))) continue;
                proceed = true;
                break;
            }
            if (!proceed) {
                log.debug((Object)("DataSource " + ds.getName() + " has no sequence fields and no primaryKeys where 'autoGenerated' is true.  Skipping search for generated values"));
                return;
            }
            LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
            ArrayList<String> sequenceList = new ArrayList<String>();
            ArrayList<String> sequenceFieldList = new ArrayList<String>();
            ArrayList<String> seqOrGenFieldList = new ArrayList<String>();
            int count = 0;
            int seqCount = 0;
            Iterator i = pkNames.iterator();
            while (i.hasNext()) {
                DSField pk = ds.getField((String)i.next());
                if (!"sequence".equals(pk.getType()) && !pk.getBoolean("autoGenerated", false)) continue;
                sequences.put(ds.getColumnName(pk.getName()).toLowerCase(), ds.getColumnName(pk.getName()));
                sequenceList.add(ds.getColumnName(pk.getName()));
                seqOrGenFieldList.add(pk.getName());
                ++count;
                if (!"sequence".equals(pk.getType())) continue;
                ++seqCount;
                sequenceFieldList.add(pk.getName());
            }
            if (seqCount > this.maxAllowedSequenceColumns()) {
                log.warn((Object)("DataSource " + ds.getName() + " can have a maximum of " + this.maxAllowedSequenceColumns() + " sequence fields, but it actually has " + seqCount + ": " + sequenceFieldList + ". Cannot continue."));
                return;
            }
            log.debug((Object)("Found " + count + " sequence(s)/autoGenerated PK field(s): " + seqOrGenFieldList));
            ResultSet rs = s.getGeneratedKeys();
            if (rs == null) {
                return;
            }
            Map<String, Class> returnTypes = null;
            if (config.getBoolean((Object)TRANSFORM_GENERATED_KEYS_TO_FETCH_TYPE, false)) {
                returnTypes = ds.getGeneratedKeyTypes(seqOrGenFieldList, req);
            }
            if (count == 1) {
                if (rs.next()) {
                    DSField field = ds.getField((String)seqOrGenFieldList.get(0));
                    String columnName = ds.getColumnName(field.getName());
                    Object generated = rs.getObject(1);
                    if (generated != null) {
                        if (generated instanceof RowId || "oracle.sql.ROWID".equals(generated.getClass().getName())) {
                            this.jdbcPKs = this.fetchSequenceValues(seqOrGenFieldList, req, rs.getString(1));
                            this.jdbcPKs = this.mapColumnsToFields(this.jdbcPKs, ds);
                            log.debug((Object)("Discovered zero or one generated key via JDBC: " + this.jdbcPKs));
                            req.setAttribute("_jdbcGeneratedKeys", (Object)true);
                        } else {
                            String baseType = ds.getSimpleBaseType(field.getType());
                            if ("integer".equals(baseType)) {
                                Class klass = this.getTransformClassForSequence(baseType, field, returnTypes);
                                if (klass != null) {
                                    Object transformed = null;
                                    try {
                                        transformed = this.adaptGeneratedValue(generated, klass);
                                    }
                                    catch (Exception e) {
                                        log.warn((Object)("Caught exception when adapting a generated sequence value for field '" + field.getName() + "' of DataSource '" + ds.getName() + "' to type " + klass), (Throwable)e);
                                    }
                                    if (transformed != null) {
                                        this.jdbcPKs.put(columnName, transformed);
                                    } else {
                                        this.jdbcPKs.put(columnName, generated);
                                    }
                                } else {
                                    log.warn((Object)"server.properties flag 'sql.transformGeneratedKeys' is false, not transforming sequence value");
                                    this.jdbcPKs.put(columnName, generated);
                                }
                            } else if ("date".equals(baseType) || "datetime".equals(baseType)) {
                                Date pkValue = generated instanceof Date ? (Date)generated : rs.getDate(1);
                                this.jdbcPKs.put(columnName, pkValue);
                            } else if ("boolean".equals(baseType)) {
                                boolean pkValue = generated instanceof Boolean ? ((Boolean)generated).booleanValue() : rs.getBoolean(1);
                                this.jdbcPKs.put(columnName, pkValue);
                            } else {
                                this.jdbcPKs.put(columnName, generated.toString());
                            }
                            this.jdbcPKs = this.mapColumnsToFields(this.jdbcPKs, ds);
                            log.debug((Object)("Discovered zero or one generated key via JDBC: " + this.jdbcPKs));
                            req.setAttribute("_jdbcGeneratedKeys", (Object)true);
                        }
                        req.setAttribute("_jdbcGeneratedKeys", (Object)true);
                    } else {
                        log.warn((Object)("getGeneratedKeys: there was a row in the metadata resultset, but it contained a null value for the generated key field '" + field.getName() + "'"));
                        if (log.isInfoEnabled() && seqOrGenFieldList.contains(field.getName()) && !sequenceFieldList.contains(field.getName())) {
                            log.info((Object)("(This is because field " + field.getName() + " is a generated value, not a sequence; see the client-side documentation for the DataSourceField 'autoGenerated' property"));
                        }
                    }
                } else {
                    log.debug((Object)"No rows in metadata resultset - driver thinks there were no generated values!");
                }
            } else if (rs.next()) {
                ResultSetMetaData rsmd = rs.getMetaData();
                for (int i2 = 0; i2 < rsmd.getColumnCount(); ++i2) {
                    Object generated = rs.getObject(i2 + 1);
                    if (generated == null) continue;
                    if (generated instanceof RowId || "oracle.sql.ROWID".equals(generated.getClass().getName())) {
                        this.jdbcPKs = this.fetchSequenceValues(seqOrGenFieldList, req, rs.getString(i2 + 1));
                        break;
                    }
                    String colName = rsmd.getColumnName(i2 + 1).toLowerCase();
                    if (colName == null || !sequences.containsKey(colName)) continue;
                    this.jdbcPKs.put(ds.getFieldNameFromColumnName((String)sequences.get(colName)), generated);
                }
                this.jdbcPKs = this.mapColumnsToFields(this.jdbcPKs, ds);
                log.debug((Object)("Discovered zero or more generated key(s) via JDBC: " + this.jdbcPKs));
                if (this.jdbcPKs.keySet().size() < seqOrGenFieldList.size()) {
                    log.warn((Object)"getGeneratedKeys: there was a row in the metadata resultset, but it contained fewer keys than we need");
                    if (log.isInfoEnabled() && seqOrGenFieldList.size() > sequenceFieldList.size()) {
                        log.info((Object)("(This is probably because your dataSource specifies autoGenerated primaryKey fields " + (sequenceFieldList.size() == 0 ? "instead of" : "as well as") + " sequence fields; see the client-side documentation for the DataSourceField 'autoGenerated' property"));
                    }
                }
                req.setAttribute("_jdbcGeneratedKeys", (Object)true);
            } else {
                log.debug((Object)"No rows in metadata resultset - driver thinks there were no generated values!");
            }
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected Class getTransformClassForSequence(String baseType, DSField field, Map<String, Class> returnTypes) throws Exception {
        Class<?> klass = null;
        if (field.getString((Object)"javaClass") != null) {
            log.debug((Object)("Transforming sequence value to declared javaClass " + field.getString((Object)"javaClass")));
            klass = Class.forName(field.getString((Object)"javaClass"));
        } else if (returnTypes != null) {
            log.debug((Object)("Transforming sequence value to discovered 'fetch type' " + returnTypes.get(field.getName())));
            klass = returnTypes.get(field.getName());
        } else if (config.getBoolean((Object)TRANSFORM_GENERATED_KEYS, true)) {
            Object sqlType = null;
            String javaClass = null;
            String sequenceSize = config.getString((Object)("sql." + this.dbName + ".defaultKeySize"));
            if (sequenceSize != null) {
                log.debug((Object)("Sequence size '" + sequenceSize + "' derived at dbName level for dbName '" + this.dbName + "'"));
            } else {
                sequenceSize = config.getString((Object)("sql." + (Object)((Object)this.dbType) + ".defaultKeySize"));
                if (sequenceSize != null) {
                    log.debug((Object)("Sequence size '" + sequenceSize + "' derived at dbType level for dbType '" + (Object)((Object)this.dbType) + "'"));
                }
            }
            if (sequenceSize == null) {
                sequenceSize = "large";
                log.warn((Object)("Sequence size 'large' was used because no settings were found at dbName or dbType level (dbName is '" + this.dbName + "', dbType is '" + (Object)((Object)this.dbType) + "')"));
            }
            sequenceSize = sequenceSize.toUpperCase().substring(0, 1) + sequenceSize.substring(1);
            javaClass = config.getString((Object)("sql." + this.dbName + ".javaTypeFor" + sequenceSize + "Key"));
            if (javaClass == null) {
                javaClass = config.getString((Object)("sql." + (Object)((Object)this.dbType) + ".javaTypeFor" + sequenceSize + "Key"));
            }
            if (javaClass == null) {
                log.warn((Object)("Transfoming sequence value to java.lang.Long because no settings were found at dbName or dbType level (dbName is '" + this.dbName + "', dbType is '" + (Object)((Object)this.dbType) + "')"));
                javaClass = "java.lang.Long";
            }
            log.debug((Object)("Transforming sequence value to default '" + sequenceSize + "' type " + javaClass));
            klass = Class.forName(javaClass);
        }
        if (klass == null) {
            log.warn((Object)"server.properties flag 'sql.transformGeneratedKeys' is false, not transforming sequence value");
        }
        return klass;
    }

    protected Object adaptGeneratedValue(Object generated, Class targetClass) throws Exception {
        if (generated == null) {
            return null;
        }
        if (targetClass.isAssignableFrom(generated.getClass())) {
            return generated;
        }
        if (Number.class.isAssignableFrom(targetClass)) {
            Constructor<?>[] ctors = targetClass.getDeclaredConstructors();
            for (int i = 0; i < ctors.length; ++i) {
                Class<?>[] types;
                if (ctors[i].getParameterCount() != 1 || !String.class.isAssignableFrom((types = ctors[i].getParameterTypes())[0])) continue;
                String generatedAsString = generated.toString();
                Object pkValue = ctors[i].newInstance(generatedAsString);
                return pkValue;
            }
        } else {
            throw new Exception("Class '" + targetClass + "' is not a subclass of Number when adapting a generated sequence value");
        }
        return null;
    }

    protected Object getTransformedSequenceValue(Object obj, String sequenceName, SQLDataSource ds, DSRequest req) throws Exception {
        Class klass;
        DSField field = ds.getField(sequenceName);
        String baseType = ds.getSimpleBaseType(field.getType());
        Map<String, Class> returnTypes = null;
        if (config.getBoolean((Object)TRANSFORM_GENERATED_KEYS_TO_FETCH_TYPE, false)) {
            returnTypes = ds.getGeneratedKeyTypes(sequenceName, req);
        }
        if ((klass = this.getTransformClassForSequence(baseType, field, returnTypes)) != null) {
            return this.adaptGeneratedValue(obj, klass);
        }
        return null;
    }

    protected void logGeneratedKeysWarning(com.isomorphic.datasource.DataSource ds) {
        log.warn((Object)(ds.getName() + ": SequenceMode is JDBC_DRIVER but the driver is not GENERATED_KEYS capable"));
    }

    private Map mapColumnsToFields(Map in, SQLDataSource ds) {
        LinkedHashMap out = new LinkedHashMap();
        for (String columnName : in.keySet()) {
            out.put(ds.native2DSFieldMap().get(columnName), in.get(columnName));
        }
        return out;
    }

    private int maxAllowedSequenceColumns() {
        return Integer.MAX_VALUE;
    }

    /*
     * Loose catch block
     */
    private Map fetchSequenceValues(List sequences, DSRequest req, String rowId) throws Exception {
        LinkedHashMap linkedHashMap;
        String sql;
        boolean free;
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block36: {
            List data;
            LinkedHashMap values;
            block34: {
                LinkedHashMap linkedHashMap2;
                block35: {
                    DSTransaction dsTransaction;
                    DSRequest work = new DSRequest(req.getDataSourceName(), "fetch", req.getRPCManager());
                    work.inheritClientContext(req);
                    work.setOutputs(sequences);
                    Iterator i = req.getAttributeNames();
                    while (i.hasNext()) {
                        String key = (String)i.next();
                        work.setAttribute(key, req.getAttribute(key));
                    }
                    work.setPrimaryDSRequest(req);
                    req.addSubRequest(work);
                    values = new LinkedHashMap();
                    conn = null;
                    stmt = null;
                    rs = null;
                    free = false;
                    sql = null;
                    sql = SQLDataSource.getSQLClause(SQLClauseType.All, work);
                    int index = sql.indexOf("WHERE ('1'='1')");
                    if (index != -1) {
                        sql = sql.substring(0, index) + "WHERE ROWID = '" + rowId + "'";
                    }
                    if ((dsTransaction = req.getDsTransaction()) != null) {
                        conn = (Connection)dsTransaction.getAttribute(req.getDataSource().getTransactionObjectKey(true));
                    }
                    if (conn == null) {
                        conn = ((SQLDataSource)req.getDataSource()).getConnection();
                        free = true;
                    }
                    stmt = conn.createStatement();
                    if (SQLLogger.isDebugEnabled()) {
                        SQLLogger.debug("Executing ROWID query: " + SQLDriver.formatSQL(sql));
                    }
                    rs = stmt.executeQuery(sql);
                    data = SQLTransform.toListOfMaps(rs);
                    log.debug((Object)("ROWID query returned " + data.size() + " rows"));
                    if (data.size() == 1) break block34;
                    log.warn((Object)"ROWID query should return a single row, abandoning");
                    linkedHashMap2 = values;
                    if (rs == null) break block35;
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (free && conn != null) {
                    SQLConnectionManager.free(conn);
                }
                return linkedHashMap2;
            }
            Map record = (Map)data.get(0);
            if (record != null) {
                for (int i = 0; i < sequences.size(); ++i) {
                    String key = (String)sequences.get(i);
                    Object value = record.get(key);
                    if (value == null) {
                        value = record.get(key.toUpperCase());
                    }
                    if (value == null) {
                        value = record.get(key.toLowerCase());
                    }
                    if (value != null) {
                        log.debug((Object)("Setting sequence value for field " + key + " to " + value));
                        values.put(key, value);
                        continue;
                    }
                    log.debug((Object)("No value for sequence field " + key + " found in record: " + record));
                }
            }
            linkedHashMap = values;
            if (rs == null) break block36;
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (free && conn != null) {
            SQLConnectionManager.free(conn);
        }
        return linkedHashMap;
        catch (SQLException se) {
            try {
                logSqlError.debug((Object)("Failed to execute query: " + sql + ", SQL error: " + se.getMessage()));
                throw se;
            }
            catch (Throwable throwable) {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (free && conn != null) {
                    SQLConnectionManager.free(conn);
                }
                throw throwable;
            }
        }
    }

    public void clearState() {
        this.freeConnection();
        this.lastSequenceMode = null;
    }

    public String escapeColumnName(Object columnName) {
        return this.escapeColumnName(columnName, false);
    }

    public String escapeColumnName(Object columnName, boolean forceQuoteColumnName) {
        if (columnName == null) {
            return null;
        }
        if (forceQuoteColumnName || this.quoteColumnNames || this.table != null && this.table.isQuoteColumnNames()) {
            return this.openQuote() + this.matcher.reset(columnName.toString()).usePattern(DOUBLE_QUOTE_PATTERN).replaceAll(DOUBLE_QUOTE_ESCAPE) + this.closeQuote();
        }
        return columnName.toString();
    }

    public abstract String escapeValue(Object var1);

    public abstract String escapeValueForFilter(Object var1, String var2);

    public abstract String formatValue(Object var1);

    public String escapeClause(Object value) {
        return "";
    }

    public abstract String escapeValueUnquoted(Object var1, boolean var2);

    public boolean shouldEscapeLikeValue(String value) {
        if (value != null) {
            for (String c : LIKE_VALUE_CHARS_TO_ESCAPE) {
                if (!value.contains(c)) continue;
                return true;
            }
        }
        return false;
    }

    public String sqlInTransform(Object value, DSField field, SQLDataSource ds) throws Exception {
        return this.sqlInTransform(value, field, ds, true);
    }

    public String sqlInTransform(Object value, DSField field, SQLDataSource ds, boolean addLiteralPrefix) throws Exception {
        return this.sqlInTransform(value, field, ds, addLiteralPrefix, false);
    }

    public String sqlInTransform(Object value, DSField field, SQLDataSource ds, boolean addLiteralPrefix, boolean noEscape) throws Exception {
        boolean isFloat = false;
        boolean isInteger = false;
        boolean isSequence = false;
        boolean isBoolean = false;
        boolean isTime = false;
        boolean isDate = false;
        boolean isDateTime = false;
        if (field != null) {
            try {
                isFloat = ds.simpleTypeInheritsFrom(field.getType(), "float");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isInteger = ds.simpleTypeInheritsFrom(field.getType(), "integer");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isSequence = ds.simpleTypeInheritsFrom(field.getType(), "sequence");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isBoolean = ds.simpleTypeInheritsFrom(field.getType(), "boolean");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isTime = ds.simpleTypeInheritsFrom(field.getType(), "time");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isDate = ds.simpleTypeInheritsFrom(field.getType(), "date");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                isDateTime = ds.simpleTypeInheritsFrom(field.getType(), "datetime");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (field != null && field.isJSON()) {
            value = this.jsTrans.toJS(value);
        } else {
            String sqlType;
            if (value instanceof GregorianCalendar) {
                value = ((GregorianCalendar)value).getTime();
            }
            if (value instanceof Date) {
                if (field != null) {
                    sqlType = (String)field.get((Object)"sqlStorageStrategy");
                    if ("number".equals(sqlType) || "integer".equals(sqlType) || "text".equals(sqlType)) {
                        String sqlFormat = (String)field.get((Object)"sqlDateFormat");
                        if (sqlFormat == null) {
                            sqlFormat = "yyyyMMdd";
                        }
                        if ("epoch".equalsIgnoreCase(sqlFormat)) {
                            return Long.toString(((Date)value).getTime() / 1000L);
                        }
                        if ("epochms".equalsIgnoreCase(sqlFormat)) {
                            return Long.toString(((Date)value).getTime());
                        }
                        SimpleDateFormat sdf = new SimpleDateFormat(sqlFormat);
                        String formatted = sdf.format(value);
                        return this.escapeValue(formatted);
                    }
                    if (isDateTime) {
                        long timeStamp = ((Date)value).getTime();
                        return this.escapeValue(this.formatTimestamp(timeStamp, true, ds, field));
                    }
                    if (isTime) {
                        return this.escapeValue(this.formatTime(((Date)value).getTime()));
                    }
                    if (isDate) {
                        return this.escapeValue(this.formatDate(((Date)value).getTime()));
                    }
                }
                long timeStamp = ((Date)value).getTime();
                return this.escapeValue(this.formatTimestamp(timeStamp, true, ds, field));
            }
            if (isBoolean) {
                sqlType = (String)field.get((Object)"sqlStorageStrategy");
                if ("number".equals(sqlType) || "integer".equals(sqlType)) {
                    return value.equals(Boolean.TRUE) ? "1" : "0";
                }
                if (sqlType != null && sqlType.indexOf("singleChar") == 0) {
                    String val = this.convertSingleCharValue(sqlType, value, field);
                    if (val != null) {
                        return val;
                    }
                } else if (sqlType != null && sqlType.equals("string")) {
                    String t = (String)field.get((Object)"sqlTrueValue");
                    String f = (String)field.get((Object)"sqlFalseValue");
                    value = value.equals(Boolean.TRUE) ? t : f;
                }
            } else if (isFloat || isInteger || isSequence) {
                if (value instanceof Number) {
                    return value.toString();
                }
                try {
                    if (isFloat) {
                        return new Double(value.toString()).toString();
                    }
                    if (isInteger) {
                        return Long.valueOf(value.toString()).toString();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return noEscape ? value.toString() : this.escapeValue(value);
    }

    public String sqlStringComparisonRValue(String value, String operator) {
        StringBuffer sql = new StringBuffer();
        sql.append("'");
        if (operator.contains("ndsWith") || operator.contains("tains")) {
            sql.append("%");
        }
        if (operator.equals("containsPattern")) {
            if (value.startsWith("%")) {
                value = value.substring(1);
            }
            if (value.endsWith("%")) {
                value = value.substring(0, value.length() - 1);
            }
        }
        sql.append(value);
        if (operator.contains("rtsWith") || operator.contains("tains")) {
            sql.append("%");
        }
        sql.append("'");
        return sql.toString();
    }

    public String sqlFilterTransform(Object value, DSField field, SQLDataSource ds, String filterStyle) {
        String compare = value.toString();
        if (this.caseInsensitiveStrategy() == 1 || this.caseInsensitiveStrategy() == 1) {
            compare = compare.toLowerCase();
        } else if (this.caseInsensitiveStrategy() == 2) {
            compare = compare.toUpperCase();
        }
        return this.escapeValueForFilter(compare, filterStyle);
    }

    protected String formatTimestamp(long millis, boolean convertToUTC, SQLDataSource ds, DSField field) throws Exception {
        if (convertToUTC && (ds == null || ds.shouldUseUTCDateTimes())) {
            if (field != null && field.shouldStoreMilliseconds() && this.supportsMilliseconds()) {
                return this.getUTCDateTimeMsFormatter().format(new Timestamp(millis));
            }
            return this.getUTCDateTimeFormatter().format(new Timestamp(millis));
        }
        if (field != null && field.shouldStoreMilliseconds() && this.supportsMilliseconds()) {
            return this.getLocalDateTimeMsFormatter().format(new Timestamp(millis));
        }
        return this.getLocalDateTimeFormatter().format(new Timestamp(millis));
    }

    protected String formatDate(long millis) {
        return this.getLogicalDateFormatter().format(new Timestamp(millis));
    }

    protected String formatTime(long millis) {
        return this.getLogicalTimeFormatter().format(new Timestamp(millis));
    }

    protected String convertSingleCharValue(String sqlType, Object columnValue, DSField field) {
        return this.convertSingleCharValue(sqlType, columnValue, field, true);
    }

    protected String convertSingleCharValue(String sqlType, Object columnValue, DSField field, boolean quote) {
        String t = (String)field.get((Object)"sqlTrueValue");
        String f = (String)field.get((Object)"sqlFalseValue");
        if (t != null) {
            t = t.substring(0, 1);
        }
        if (f != null) {
            f = f.substring(0, 1);
        }
        if ("singleChar10".equals(sqlType)) {
            t = "1";
            f = "0";
        } else if ("singleCharYN".equals(sqlType)) {
            t = "Y";
            f = "N";
        } else if ("singleCharTF".equals(sqlType)) {
            t = "T";
            f = "F";
        }
        if (t != null || f != null) {
            return Boolean.TRUE.equals(DataTools.asBoolean((Object)columnValue)) ? (t == null ? "null" : "'" + t + "'") : (f == null ? "null" : "'" + f + "'");
        }
        return null;
    }

    public abstract String sqlOutTransform(String var1, String var2, String var3) throws Exception;

    public String sqlOutTransform(String columnName, String remapName) throws Exception {
        return this.sqlOutTransform(columnName, remapName, null);
    }

    public String sqlOutTransform(String columnName) throws Exception {
        return this.sqlOutTransform(columnName, null, null);
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName, String functionName) throws Exception {
        return this.sqlOutTransform(columnName, remapName, tableName, functionName, null);
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName, String functionName, Map functionParams) throws Exception {
        return this.sqlOutTransform(columnName, remapName, tableName, functionName, functionParams, null);
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName, String functionName, Map functionParams, String unionDSFType) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (tableName != null) {
            output = tableName + "." + output;
        }
        if (functionName != null && !"".equals(functionName)) {
            output = this.sqlOutTransformFunction(output, functionName, functionParams);
            if (remapName != null) {
                output = output + " AS " + this.escapeColumnName(remapName);
            }
        } else if (remapName != null && !remapName.equals(columnName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        return output;
    }

    public String sqlOutTransformFunction(String expression, String functionName, Map functionParams) {
        return functionName + "(" + expression + ")";
    }

    public boolean useHavingClause() {
        if (this.useHavingClause == null) {
            this.useHavingClause = DataTools.asBoolean((Object)Config.getProperty((String)("sql." + this.dbName + ".useHavingClause")), (boolean)true);
        }
        return this.useHavingClause;
    }

    public boolean referAggregatedFieldByAlias() {
        return false;
    }

    public int getMaximumSetSize() {
        return 0;
    }

    public abstract String getNextSequenceValue(String var1, SQLDataSource var2) throws Exception;

    public Map forceSingleRow(List rows) throws Exception {
        if (rows == null) {
            throw new Exception("forceSingleRow() got null value");
        }
        if (rows.size() == 0 || rows.size() > 1) {
            throw new Exception("forceSingleRow() got " + rows.size() + " results");
        }
        return (Map)rows.get(0);
    }

    public boolean hasBrokenCursorAPIs() {
        return this.databaseConfig.getBoolean((Object)"brokenCursorAPIs", false);
    }

    public static String getSequenceName(String columnName, Map sequences, String tableName, SQLDriver sqlDriver) throws Exception {
        if (columnName == null || sequences == null || tableName == null) {
            return null;
        }
        String sequenceName = (String)sequences.get(columnName);
        if (sequenceName == null) {
            return null;
        }
        if (sequenceName.equals("__default")) {
            sequenceName = tableName + "_" + columnName;
            int fixedLength = columnName.length() + 1;
            if (sqlDriver != null) {
                String pref = sqlDriver.sequencePrefix();
                String suff = sqlDriver.sequenceSuffix();
                sequenceName = pref + sequenceName + suff;
                fixedLength += pref.length() + suff.length();
                int sequenceLength = sequenceName.length();
                int maxLength = sqlDriver.maxSequenceNameLength();
                if (maxLength >= 0 && sequenceLength > maxLength) {
                    if (fixedLength > maxLength) {
                        throw new Exception("can't create a unique sequence name for column name: '" + columnName + "' - unable to continue");
                    }
                    String truncatedTableName = tableName.substring(0, maxLength - fixedLength);
                    sequenceName = pref + truncatedTableName + "_" + columnName + suff;
                }
            }
        }
        return sequenceName;
    }

    protected String getSequenceName(String columnName) throws Exception {
        return SQLDriver.getSequenceName(columnName, this.table.getSequences(), this.table.getName(), this);
    }

    protected String getSequenceName(String columnName, SQLDataSource dataSource) throws Exception {
        return SQLDriver.getSequenceName(columnName, dataSource.getSequences(), this.table.getName(), this);
    }

    public boolean fieldIsSearchable(DSField field) {
        String fieldType = field.getType();
        return !field.isBinary() && !"blob".equals(fieldType) && !"clob".equals(fieldType);
    }

    public boolean fieldAssignableInline(DSField field) {
        String fieldType = field.getType();
        return !field.isBinary() && !"blob".equals(fieldType) && !"clob".equals(fieldType) && field.getBoolean("sqlValueAssignableInline", true);
    }

    public Statement createFetchStatement(Connection conn, boolean streaming, long batchSize, DSRequest req) throws SQLException {
        try {
            Statement stmt;
            if (streaming) {
                stmt = conn.createStatement(1003, 1007);
                if (this.canSetFetchSize() && this.shouldSetFetchSizeForStreaming()) {
                    int fetchSize = config.getInt((Object)("sql." + config.getString((Object)("sql." + this.dbName + ".database.type")) + ".streaming.fetchSize"), 1);
                    stmt.setFetchSize(fetchSize);
                    if (config.getBoolean((Object)"devenv", false)) {
                        req.setAttribute("_jdbcFetchSize", (Object)fetchSize);
                    }
                }
            } else {
                stmt = conn.createStatement();
                if (this.canSetFetchSize() && this.shouldSetFetchSize(req, batchSize)) {
                    stmt.setFetchSize((int)batchSize);
                    if (config.getBoolean((Object)"devenv", false)) {
                        req.setAttribute("_jdbcFetchSize", (Object)batchSize);
                    }
                }
            }
            return stmt;
        }
        catch (SQLException e) {
            if (streaming) {
                log.warn((Object)"Unable to create statement with flags: ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY.  Backing off to createStatement().");
                return conn.createStatement();
            }
            throw e;
        }
    }

    public boolean shouldSetFetchSize(DSRequest req, long batchSize) {
        boolean avoid = config.getBoolean((Object)("sql." + (Object)((Object)this.dbType) + ".avoid.batchSize.with.limit.queries"), false);
        if (req != null) {
            return (!avoid || req._isExplicitBatchSize() || req.shouldStreamResults()) && batchSize > 0L;
        }
        return !avoid && batchSize > 0L;
    }

    public Statement createScrollableFetchStatement(Connection conn, long batchSize, DSRequest req) throws SQLException {
        try {
            Statement stmt = conn.createStatement(1004, 1007);
            if (this.canSetFetchSize() && this.shouldSetFetchSize(req, batchSize)) {
                stmt.setFetchSize((int)batchSize);
            }
            return stmt;
        }
        catch (SQLException e) {
            log.warn((Object)"Unable to create statement with flags: ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_READ_ONLY.  Backing off to createStatement()");
            return conn.createStatement();
        }
    }

    public boolean shouldSetFetchSizeForStreaming() {
        return true;
    }

    public boolean canSetFetchSize() {
        return true;
    }

    public Object transformFieldValue(DSField field, Object obj) {
        return obj;
    }

    public boolean shouldUseSQLDateType(DSField field) {
        String sqlType = null;
        if (field != null) {
            sqlType = field.getProperty("sqlStorageStrategy");
        }
        if (field == null || sqlType == null) {
            String defaultDateType = this._sqlConfig.getString((Object)"defaultDateType");
            if (defaultDateType != null) {
                return defaultDateType.trim().toLowerCase().equals("date");
            }
        } else {
            return sqlType.equals("nativeDate");
        }
        return false;
    }

    protected boolean supportsGetGeneratedKeys(Connection conn, com.isomorphic.datasource.DataSource ds) throws SQLException {
        if (_supportsGetGeneratedKeys == null) {
            try {
                _supportsGetGeneratedKeys = conn.getMetaData().supportsGetGeneratedKeys();
            }
            catch (AbstractMethodError ame) {
                _supportsGetGeneratedKeys = false;
            }
        }
        return _supportsGetGeneratedKeys;
    }

    public InputStream handleInputStream(InputStream stream) throws Exception {
        if (config.getBoolean((Object)("sql." + (Object)((Object)this.getDBType()) + ".readBinaryDataImmediately"), false)) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            IOUtil.copyStreams((InputStream)stream, (OutputStream)os);
            return new ByteArrayInputStream(os.toByteArray());
        }
        return stream;
    }

    public Reader handleCharacterStream(Reader reader) throws Exception {
        if (config.getBoolean((Object)("sql." + (Object)((Object)this.getDBType()) + ".readBinaryDataImmediately"), false)) {
            return new StringReader(IOUtil.readerToString((Reader)reader));
        }
        return reader;
    }

    public void setConnectionProperties(Connection conn) {
    }

    public Timestamp getUTCTimestamp(ResultSet rs, int index) throws SQLException {
        return rs.getTimestamp(index, calendar);
    }

    public String getLiteralPrefix(DSField field, BasicDataSource ds) {
        return "";
    }

    public Object modifyTemporalObject(Object obj, ResultSet rs, int ii) throws SQLException {
        return obj;
    }

    public int caseInsensitiveStrategy() {
        return 1;
    }

    public int caseInsensitiveStrategyForRelativeComparisons() {
        return 1;
    }

    public String caseSensitiveEqualsPredicate() {
        return "=";
    }

    public String caseInsensitiveEqualsPredicate() {
        return "=";
    }

    public String caseSensitiveNotEqualPredicate() {
        return "<>";
    }

    public String caseInsensitiveLikePredicate() {
        return "LIKE";
    }

    public String caseSensitiveLikePredicate() {
        return "LIKE";
    }

    protected boolean defaultForceInsensitive() {
        return true;
    }

    public boolean forceInsensitive() {
        return this.forceInsensitive;
    }

    public Boolean likeIsCaseSensitive() {
        return this.likeIsCaseSensitive;
    }

    protected int defaultAliasLengthLimit() {
        return 128;
    }

    public int aliasLengthLimit() {
        return this.aliasLengthLimit;
    }

    public boolean optimizeCaseSensitiveCriteria() {
        return false;
    }

    public String caseSensitiveFieldPrefix() {
        return "";
    }

    public String caseSensitiveFieldSuffix() {
        return "";
    }

    public String caseSensitiveFieldPrefixForRelativeComparisons() {
        return this.caseSensitiveFieldPrefix();
    }

    public String caseSensitiveFieldSuffixForRelativeComparisons() {
        return this.caseSensitiveFieldSuffix();
    }

    public String blankComparison(String fieldName, String operator) {
        if (fieldName == null) {
            return null;
        }
        if ("isBlank".equals(operator)) {
            return "(" + fieldName + " IS NULL OR " + fieldName + "='')";
        }
        return "(" + fieldName + " IS NOT NULL AND " + fieldName + "<>'')";
    }

    public String generateJoinClause(String escapedTo, String escapedFrom, Relation relation) throws Exception {
        if (relation.getJoinType() == 1) {
            log.warn((Object)("The relation between " + relation.getFromDataSource().getID() + " and " + relation.getToDataSource().getID() + " is defined as an outer join, but outer joins are not yet supported on this database product (" + (Object)((Object)this.getDBType()) + ")  Falling back to a regular inner join."));
        }
        return escapedFrom + " = " + escapedTo;
    }

    public boolean castNumbersBeforeLikeCompare() {
        return false;
    }

    public abstract String getNaturalDatabaseObjectName(String var1);

    public String sqlConcat(String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuffer sql = new StringBuffer();
        for (String s : strings) {
            if (sql.length() > 0) {
                sql.append(" || ");
            }
            sql.append(s);
        }
        return sql.toString();
    }

    public boolean aliasRequiredForSubselect() {
        return false;
    }

    public boolean aliasForbiddenForSubselect() {
        return false;
    }

    public boolean shouldParameterizeNullValues(boolean isMultiInserting) {
        return true;
    }

    public boolean supportsMilliseconds() throws Exception {
        return true;
    }

    public boolean toleratesExplicitSequenceValues() throws Exception {
        return true;
    }

    public boolean supportsRegexp() throws Exception {
        return false;
    }

    public String getExpressionForRegexp(String escapedColumnOrExpression, String operator, String regexp) throws Exception {
        throw new Exception(operator + " is not supported by " + this.getDatabaseProductString());
    }

    public String escapeRegexp(String value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeRegexpUnquoted(value) + "'";
    }

    public String escapeRegexpUnquoted(String value) {
        if (value == null) {
            return null;
        }
        return this.matcher.reset(value).usePattern(SINGLE_QUOTE_PATTERN).replaceAll(SINGLE_QUOTE_ESCAPE);
    }

    public boolean supportsFieldComparison(String columnType, String otherColumnType) {
        return columnType != null && columnType.equals(otherColumnType);
    }

    public boolean tableExists(String tableName) throws Exception {
        return this.tableExists(tableName, null);
    }

    public boolean tableExists(String tableName, String schema) throws Exception {
        return new SQLMetaData(this.getOrCreateConnection()).tableExists(this.getNaturalDatabaseObjectName(tableName), this.getNaturalDatabaseObjectName(schema));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String deriveDefaultSchema(String schema) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            if (schema == null) {
                String sql = this.getDummyQuery();
                stmt = this.getOrCreateConnection().createStatement();
                rs = stmt.executeQuery(sql);
                ResultSetMetaData rsmd = rs.getMetaData();
                schema = rsmd.getSchemaName(1);
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        return schema;
    }

    public abstract String getDummyQuery();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canQueryTable(String tableName, String schemaName) throws Exception {
        String sql = "SELECT * FROM ";
        if (schemaName != null && !schemaName.equals("")) {
            sql = sql + schemaName + this.getQualifiedSchemaSeparator();
        }
        sql = sql + tableName + " WHERE '0'='1'";
        Connection conn = this.getOrCreateConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        log.debug((Object)("Checking for table existence with query: " + sql));
        try {
            rs = stmt.executeQuery(sql);
        }
        catch (Exception e) {
            log.debug((Object)("Test query failed, assuming table does not exist.  Error was: " + e.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        log.debug((Object)"Test query succeeded");
        return true;
    }

    public List<String> listAvailableDatabases() throws Exception {
        return this.listAvailableDatabases("*");
    }

    public List<String> listAvailableDatabases(String pattern) throws Exception {
        throw new Exception("not currently supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public static List<String> listConfiguredDatabases() {
        ArrayList<String> dbNames = new ArrayList<String>();
        Config dbConfig = config.getSubtree("sql");
        for (String key : dbConfig.keySet()) {
            String dbName;
            int index = key.indexOf(".database.type");
            if (index == -1 || dbNames.contains(dbName = key.substring(0, index))) continue;
            dbNames.add(dbName);
        }
        return dbNames;
    }

    public static String getSnapshotFileName(String dbName, String schemaName) throws Exception {
        return snapshotFileNamePrefix + "." + dbName + "." + schemaName;
    }

    public static String createSnapshot(String dbName) throws Exception {
        String defaultSchemaName = config.getString((Object)("sql." + dbName + ".driver.databaseName"), dbName);
        String snapshotFileName = SQLDriver.getSnapshotFileName(dbName, defaultSchemaName);
        SQLDriver.createSnapshot(dbName, snapshotFileName);
        return snapshotFileName;
    }

    public static void createSnapshot(String dbName, String snapshotFileName) throws Exception {
        File snapshotFile = new File(snapshotFileName);
        SQLDriver.instance(dbName).createSnapshot(new File(snapshotFileName));
    }

    public void createSnapshot(File snapshotFile) throws Exception {
        if (!config.getBoolean((Object)"sql.snapshot.warnAndIgnoreIfUnsupported", false)) {
            throw new Exception("not currently supported by " + ((Object)((Object)this)).getClass().getName());
        }
        log.warn((Object)("create snapshot: no-op for " + ((Object)((Object)this)).getClass().getName() + " due to sql.snapshot.warnAndIgnoreIfUnsupported: true"));
    }

    public static void restoreFromSnapshot(String dbName) throws Exception {
        String defaultSchemaName = config.getString((Object)("sql." + dbName + ".driver.databaseName"), dbName);
        String snapshotFileName = SQLDriver.getSnapshotFileName(dbName, defaultSchemaName);
        SQLDriver.restoreFromSnapshot(dbName, snapshotFileName);
    }

    public static void restoreFromSnapshot(String dbName, String snapshotFileName) throws Exception {
        SQLDriver.instance(dbName).restoreFromSnapshot(new File(snapshotFileName));
    }

    public void restoreFromSnapshot(File snapshotFile) throws Exception {
        if (!config.getBoolean((Object)"sql.snapshot.warnAndIgnoreIfUnsupported", false)) {
            throw new Exception("not currently supported by " + ((Object)((Object)this)).getClass().getName());
        }
        log.warn((Object)("restore from snapshot: no-op for " + ((Object)((Object)this)).getClass().getName() + " due to sql.snapshot.warnAndIgnoreIfUnsupported: true"));
    }

    public static void createSandbox(String dbName, String schemaName, String sandboxName) throws Exception {
        long start = new Date().getTime();
        SQLDriver.instance(dbName).setSchemaName(schemaName).createSandbox(sandboxName);
        long end = new Date().getTime();
        log.debug((Object)("Created sandbox for: " + dbName + " in: " + (end - start) + "ms"));
    }

    public static void createSandbox(String dbName, String sandboxName) throws Exception {
        SQLDriver.createSandbox(dbName, null, sandboxName);
    }

    public void createSandbox(String sandboxName) throws Exception {
        throw new Exception("not currently supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public static void removeSandbox(String dbName, String sandboxName) throws Exception {
        SQLDriver.instance(dbName).removeSandbox(sandboxName);
    }

    public void removeSandbox(String sandboxName) throws Exception {
        throw new Exception("not currently supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public static boolean exists(String dbName, String schemaName) throws Exception {
        return SQLDriver.lastModified(dbName, schemaName) != -1L;
    }

    public static long lastModified(String dbName, String schemaName) throws Exception {
        return SQLDriver.instance(dbName).lastModified(schemaName);
    }

    public boolean exists(String schemaName) throws Exception {
        throw new Exception("not currently supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public long lastModified(String schemaName) throws Exception {
        throw new Exception("not currently supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public int getDatabaseMajorVersion() throws Exception {
        return this.metaData.getInt((Object)"databaseMajorVersion", -1);
    }

    public int getDatabaseMinorVersion() throws Exception {
        return this.metaData.getInt((Object)"databaseMinorVersion", -1);
    }

    public String getDatabaseProductName() throws Exception {
        return this.metaData.getString((Object)"databaseProductName");
    }

    public String getDatabaseProductVersion() throws Exception {
        return this.metaData.getString((Object)"databaseProductVersion");
    }

    public String getDatabaseProductString() throws Exception {
        return this.metaData.getString((Object)"databaseProductString");
    }

    public int getDriverMajorVersion() throws Exception {
        return this.metaData.getInt((Object)"driverMajorVersion", -1);
    }

    public int getDriverMinorVersion() throws Exception {
        return this.metaData.getInt((Object)"driverMinorVersion", -1);
    }

    public String getDriverName() throws Exception {
        return this.metaData.getString((Object)"driverName");
    }

    public String getDriverVersion() throws Exception {
        return this.metaData.getString((Object)"driverVersion");
    }

    public int getJDBCMajorVersion() throws Exception {
        return this.metaData.getInt((Object)"JDBCMajorVersion", -1);
    }

    public int getJDBCMinorVersion() throws Exception {
        return this.metaData.getInt((Object)"JDBCMinorVersion", -1);
    }

    public boolean supportsMultipleValuesClauses(SQLDataSource ds) {
        return true;
    }

    public String getMultiInsertPrelude(String multiInsertSelectList) {
        return "VALUES";
    }

    public String getMultiInsertValueSetPrelude() {
        return "(";
    }

    public String getMultiInsertValueSetCoda(boolean isLastValueSet) {
        return ")" + (isLastValueSet ? "" : ", ");
    }

    public String getMultiInsertCoda() {
        return "";
    }

    public boolean multiInsertRequiresAdditionalSelect() {
        return false;
    }

    public String getDriverSpecificSQLType(String jdbcTypeName, String rsmdTypeName) {
        return jdbcTypeName;
    }
}

