/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.awt;

import com.sun.applet2.Applet2Context;
import com.sun.applet2.Applet2Host;
import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.AppletInitEvent;
import com.sun.applet2.preloader.event.DownloadEvent;
import com.sun.applet2.preloader.event.ErrorEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.perf.DeployPerfUtil;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.impl.awt.AWTGrayBoxPainter;
import com.sun.deploy.uitoolkit.impl.awt.ui.DownloadWindow;
import com.sun.deploy.util.URLUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import sun.plugin.JavaRunTime;
import sun.plugin2.applet2.Plugin2Host;
import sun.plugin2.main.client.DisconnectedExecutionContext;
import sun.plugin2.util.ColorUtil;

public class AWTDefaultPreloader
extends Preloader {
    private Preloader webstartDP = null;
    private Container parentContainer = null;
    private AWTGrayBoxPainter grayBoxPainter;
    private GrayBoxListener grayBoxListener;
    private final GrayBoxPainterStarter grayBoxPainterStarter;
    private boolean gotError = false;
    private boolean hadSwitched = false;
    private boolean offerReload = false;
    private Color bgColor = Color.white;
    private Color fgColor = Color.black;

    public AWTDefaultPreloader(Applet2Context applet2Context, Container container) {
        super(applet2Context);
        this.parentContainer = container;
        if (this.isDownloadDialogMode()) {
            this.webstartDP = new DownloadWindow();
            this.grayBoxPainterStarter = null;
        } else {
            this.grayBoxPainterStarter = new GrayBoxPainterStarter();
            this.grayBoxPainterStarter.start();
            this.webstartDP = null;
        }
    }

    private boolean isDownloadDialogMode() {
        Plugin2Host plugin2Host;
        Applet2Host applet2Host = this.ctx.getHost();
        return applet2Host instanceof Plugin2Host && (plugin2Host = (Plugin2Host)applet2Host).getAppletExecutionContext() instanceof DisconnectedExecutionContext;
    }

    private synchronized void markGotError() {
        this.gotError = true;
    }

    private synchronized boolean hasErrorOccurred() {
        return this.gotError;
    }

    private synchronized void resetErrorStatus() {
        this.gotError = false;
    }

    public Object getOwner() {
        this.grayBoxPainterStarter.waitTillDone();
        return this.parentContainer;
    }

    public boolean handleEvent(PreloaderEvent preloaderEvent) throws CancelException {
        if (this.grayBoxPainterStarter != null) {
            return this.browserHandleEvent(preloaderEvent);
        }
        return this.webstartHandleEvent(preloaderEvent);
    }

    private boolean webstartHandleEvent(PreloaderEvent preloaderEvent) throws CancelException {
        AppletInitEvent appletInitEvent;
        int n;
        if (preloaderEvent.getType() == 5 && ((n = (appletInitEvent = (AppletInitEvent)preloaderEvent).getSubtype()) == 3 || n == 4 || n == 2)) {
            this.ctx.getHost().showApplet();
        }
        return this.webstartDP.handleEvent(preloaderEvent);
    }

    private boolean browserHandleEvent(PreloaderEvent preloaderEvent) throws CancelException {
        this.grayBoxPainterStarter.waitTillDone();
        if (this.hasErrorOccurred()) {
            if (preloaderEvent.getType() == 1) {
                this.resetErrorStatus();
            }
            return true;
        }
        switch (preloaderEvent.getType()) {
            case 3: {
                DownloadEvent downloadEvent = (DownloadEvent)preloaderEvent;
                if (this.grayBoxPainter != null) {
                    this.grayBoxPainter.setProgress(downloadEvent.getOverallPercentage());
                }
                return true;
            }
            case 6: {
                this.markGotError();
                if (this.grayBoxPainter != null) {
                    this.grayBoxPainter.finishPainting();
                }
                ErrorEvent errorEvent = (ErrorEvent)preloaderEvent;
                Throwable throwable = errorEvent.getException();
                boolean bl = true;
                if (throwable != null && throwable instanceof JARSigningException) {
                    bl = false;
                }
                String string = throwable != null ? throwable.getMessage() : null;
                this.ctx.getHost().showError(string, throwable, bl);
                return true;
            }
            case 7: {
                this.offerReload = true;
                return true;
            }
            case 5: {
                AppletInitEvent appletInitEvent = (AppletInitEvent)preloaderEvent;
                if (!this.hadSwitched && (appletInitEvent.getSubtype() == 3 || appletInitEvent.getSubtype() == 4) || appletInitEvent.getSubtype() == 6) {
                    this.shutdownGrayBoxPainter();
                    this.ctx.getHost().showApplet();
                    this.hadSwitched = true;
                }
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    void handleReloadApplet() {
        this.ctx.getHost().reloadAppletPage();
    }

    public Color getBGColor() {
        this.grayBoxPainterStarter.waitTillDone();
        return this.bgColor;
    }

    public Color getFGColor() {
        this.grayBoxPainterStarter.waitTillDone();
        return this.fgColor;
    }

    public void shutdownGrayBoxPainter() {
        if (this.grayBoxPainterStarter.isAlive()) {
            this.grayBoxPainterStarter.interrupt();
        }
        if (this.grayBoxPainter != null) {
            this.grayBoxPainter.finishPainting();
            this.grayBoxPainter = null;
        }
        if (this.grayBoxListener != null) {
            if (this.parentContainer != null) {
                this.parentContainer.removeMouseListener(this.grayBoxListener);
            }
            this.grayBoxListener = null;
        }
    }

    private void setupColorAndText(String string) {
        ColorUtil.ColorRGB colorRGB = null;
        String string2 = this.ctx.getParameter("boxbgcolor");
        if (string2 != null && (colorRGB = ColorUtil.createColorRGB("boxbgcolor", string2)) != null) {
            this.bgColor = new Color(colorRGB.rgb);
        }
        this.grayBoxPainter.setBoxBGColor(this.bgColor);
        String string3 = this.ctx.getParameter("boxfgcolor");
        if (string3 != null && (colorRGB = ColorUtil.createColorRGB("boxfgcolor", string3)) != null) {
            this.fgColor = new Color(colorRGB.rgb);
        }
        this.grayBoxPainter.setBoxFGColor(this.fgColor);
        if (this.parentContainer != null) {
            this.parentContainer.setBackground(this.grayBoxPainter.getBoxBGColor());
            this.parentContainer.setForeground(this.grayBoxPainter.getBoxFGColor());
        }
        if (string != null) {
            this.grayBoxPainter.setWaitingMessage(string);
        } else {
            this.grayBoxPainter.setWaitingMessage(this.getWaitingMessage());
        }
    }

    public void doPaint(Graphics graphics) {
        this.grayBoxPainterStarter.waitTillDone();
        if (this.grayBoxPainter != null) {
            this.grayBoxPainter.paintGrayBox(graphics);
        }
    }

    protected static String getMessage(String string) {
        return ResourceManager.getMessage((String)string);
    }

    protected String getWaitingMessage() {
        if (this.hasErrorOccurred()) {
            return AWTDefaultPreloader.getMessage("failed");
        }
        MessageFormat messageFormat = new MessageFormat(AWTDefaultPreloader.getMessage("loading"));
        return messageFormat.format(new Object[]{this.getHandledType()});
    }

    protected String getHandledType() {
        return AWTDefaultPreloader.getMessage("java_applet");
    }

    private class GrayBoxListener
    implements MouseListener,
    ActionListener {
        private PopupMenu popup;
        private MenuItem open_console;
        private MenuItem about_java;
        private String msg = null;
        private Container parent;

        GrayBoxListener(Container container, String string) {
            this.msg = string;
            this.parent = container;
        }

        private PopupMenu getPopupMenu() {
            if (this.popup == null) {
                Font font = this.parent.getFont();
                Font font2 = font.deriveFont(11.0f);
                this.popup = new PopupMenu();
                this.open_console = new MenuItem(ResourceManager.getMessage((String)"dialogfactory.menu.open_console"));
                this.open_console.setFont(font2);
                this.about_java = new MenuItem(ResourceManager.getMessage((String)"dialogfactory.menu.about_java"));
                this.about_java.setFont(font2);
                this.open_console.addActionListener(this);
                this.about_java.addActionListener(this);
                this.popup.add(this.open_console);
                this.popup.add("-");
                this.popup.add(this.about_java);
                this.parent.add(this.popup);
            }
            return this.popup;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Trace.msgPrintln((String)(this.msg != null ? this.msg : AWTDefaultPreloader.this.getWaitingMessage()), null, (TraceLevel)TraceLevel.BASIC);
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && AWTDefaultPreloader.this.hasErrorOccurred()) {
                this.getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && AWTDefaultPreloader.this.hasErrorOccurred()) {
                this.getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.open_console) {
                JavaRunTime.showJavaConsole(true);
            } else if (actionEvent.getSource() == this.about_java) {
                ToolkitStore.getUI().showAboutJavaDialog();
            }
        }
    }

    private class GrayBoxPainterStarter
    extends Thread {
        private int state = 0;

        public GrayBoxPainterStarter() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitTillDone() {
            GrayBoxPainterStarter grayBoxPainterStarter = this;
            synchronized (grayBoxPainterStarter) {
                while (this.state == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            GrayBoxPainterStarter grayBoxPainterStarter;
            boolean bl = false;
            try {
                long l = DeployPerfUtil.put((long)0L, (String)"Plugin2Manager.setupGrayBoxPainter() - BEGIN");
                Trace.println((String)("GrayBox: parent = " + AWTDefaultPreloader.this.parentContainer), (TraceLevel)TraceLevel.PRELOADER);
                if (AWTDefaultPreloader.this.parentContainer != null) {
                    Object object;
                    AWTDefaultPreloader.this.grayBoxPainter = new AWTGrayBoxPainter(AWTDefaultPreloader.this.parentContainer, AWTDefaultPreloader.this.ctx.getHost());
                    String string = AWTDefaultPreloader.this.ctx.getParameter("image");
                    if (string != null) {
                        try {
                            object = AWTDefaultPreloader.this.ctx.getCodeBase();
                            URL uRL = new URL((URL)object, string);
                            if (!URLUtil.checkTargetURL((URL)object, (URL)uRL)) {
                                throw new SecurityException("Permission denied: " + uRL);
                            }
                            boolean bl2 = Boolean.valueOf(AWTDefaultPreloader.this.ctx.getParameter("centerimage"));
                            AWTDefaultPreloader.this.grayBoxPainter.setBoxBorder(AWTDefaultPreloader.this.ctx.getParameter("boxborder"));
                            AWTDefaultPreloader.this.grayBoxPainter.setCustomImageURL(uRL, bl2);
                        }
                        catch (MalformedURLException malformedURLException) {
                            malformedURLException.printStackTrace();
                        }
                    }
                    object = AWTDefaultPreloader.this.ctx.getParameter("boxmessage");
                    AWTDefaultPreloader.this.setupColorAndText((String)object);
                    AWTDefaultPreloader.this.grayBoxPainter.beginPainting(Thread.currentThread().getThreadGroup());
                    AWTDefaultPreloader.this.grayBoxListener = new GrayBoxListener(AWTDefaultPreloader.this.parentContainer, (String)object);
                    AWTDefaultPreloader.this.parentContainer.addMouseListener(AWTDefaultPreloader.this.grayBoxListener);
                }
                DeployPerfUtil.put((long)l, (String)"Plugin2Manager.setupGrayBoxPainter() - END");
                bl = true;
                Object var9_8 = null;
                grayBoxPainterStarter = this;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                GrayBoxPainterStarter grayBoxPainterStarter2 = this;
                synchronized (grayBoxPainterStarter2) {
                    this.state = bl ? 1 : -1;
                    this.notifyAll();
                }
                throw throwable;
            }
            synchronized (grayBoxPainterStarter) {
                this.state = bl ? 1 : -1;
                this.notifyAll();
            }
        }
    }
}

