/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.IAuthenticator;
import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DataSourceAuthenticator;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthenticatedUser
extends DataTypeMap
implements Principal,
Serializable,
IToJSON {
    private static Logger log = new Logger(AuthenticatedUser.class.getName());
    private static final String userNameField = "isc_username";
    private static final String emailField = "isc_email";
    private static final String realUserNameField = "isc_real_username";
    private List<String> clientSafeFields;
    private List<String> roles = new ArrayList<String>();
    private String superuserRole;
    Config authLocalConfig;

    public AuthenticatedUser() {
    }

    public AuthenticatedUser(String username, IAuthenticator authenticator) {
        this(username, new HashMap(), authenticator);
    }

    public AuthenticatedUser(String username, Map userData, IAuthenticator authenticator) {
        super(userData);
        String configuredEmailField;
        Boolean lockReloginToCurrentUser;
        String loginPasswordFieldName;
        String loginUsernameFieldName;
        this.authLocalConfig = authenticator.getLocalConfig();
        if (authenticator == null) {
            this.clientSafeFields = new ArrayList<String>();
        } else {
            this.clientSafeFields = authenticator.getClientSafeFields();
            this.superuserRole = authenticator.getSuperUserRole();
            try {
                this.roles = authenticator.getUserRoles(userData);
            }
            catch (Exception e) {
                log.error((Object)"Failed to obtain user roles", e);
            }
        }
        if (!this.clientSafeFields.contains("roles")) {
            this.clientSafeFields.add("roles");
        }
        this.put(userNameField, username);
        if (!this.clientSafeFields.contains(userNameField)) {
            this.clientSafeFields.add(userNameField);
        }
        this.put(realUserNameField, username);
        if (!this.clientSafeFields.contains(realUserNameField)) {
            this.clientSafeFields.add(realUserNameField);
        }
        if ((loginUsernameFieldName = this.authLocalConfig.getString("usernameParameter")) != null) {
            this.put("loginUsernameFieldName", loginUsernameFieldName);
            this.clientSafeFields.add("loginUsernameFieldName");
        }
        if ((loginPasswordFieldName = this.authLocalConfig.getString("passwordParameter")) != null) {
            this.put("loginPasswordFieldName", loginPasswordFieldName);
            this.clientSafeFields.add("loginPasswordFieldName");
        }
        if ((lockReloginToCurrentUser = this.authLocalConfig.getBoolean("lockReloginToCurrentUser")) != null) {
            this.put("lockReloginToCurrentUser", lockReloginToCurrentUser);
            this.clientSafeFields.add("lockReloginToCurrentUser");
        }
        if ((configuredEmailField = this.authLocalConfig.getString("emailField")) != null) {
            this.put(emailField, userData.get(configuredEmailField));
            if (this.isSuper()) {
                this.clientSafeFields.add(configuredEmailField);
            }
        }
        if (this.isSuper() && authenticator instanceof DataSourceAuthenticator) {
            DataSourceAuthenticator dsAuthenticator = (DataSourceAuthenticator)authenticator;
            this.put("dataSource", dsAuthenticator.datasource);
            this.put("dataSourceUsernameField", dsAuthenticator.usernameField);
            this.clientSafeFields.add("dataSource");
            this.clientSafeFields.add("dataSourceUsernameField");
        }
    }

    public String getEmail() {
        return this.getString(emailField);
    }

    public String getUserName() {
        return this.getString(userNameField);
    }

    public String getRealUserName() {
        return this.getString(realUserNameField, this.getUserName());
    }

    public void setRealUserName(String realName) {
        this.put(realUserNameField, realName);
    }

    public boolean isMasquerading() {
        return this.getRealUserName() != null && !this.getUserName().equals(this.getRealUserName());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof AuthenticatedUser)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return this.getName().equals(((AuthenticatedUser)o).getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " (" + this.getName() + ")";
    }

    @Override
    public void toJSON(Writer out, JSTranslater jsTrans) throws UnconvertableException, IOException {
        jsTrans.toJS((Object)this.clientSafeMap(), out);
    }

    public DataTypeMap clientSafeMap() {
        HashMap clientSafeMap = new HashMap(this);
        DataTools.divideMap(clientSafeMap, this.clientSafeFields);
        return new DataTypeMap(clientSafeMap);
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public boolean inRole(String role) {
        if (role == null || "__ISC_NONE_ROLE__".equals(role)) {
            return false;
        }
        return this.getRoles().contains(role);
    }

    public boolean isSuper() {
        return this.isSuperUser();
    }

    public boolean isSuperUser() {
        return this.inRole(this.superuserRole);
    }

    public boolean canMasquerade() {
        return this.isSuper() || this.isMasquerading();
    }

    @Override
    public String getName() {
        return this.getUserName();
    }
}

