/*

  SmartClient Ajax RIA system
  Version v13.0p_2025-11-27/LGPL Development Only (2025-11-27)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/

if(window.isc&&window.isc.module_Core&&!window.isc.module_SkinUtil){isc.module_SkinUtil=1;isc._moduleStart=isc._SkinUtil_start=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc._moduleEnd&&(!isc.Log||(isc.Log&&isc.Log.logIsDebugEnabled('loadTime')))){isc._pTM={message:'SkinUtil load/parse time: '+(isc._moduleStart-isc._moduleEnd)+'ms',category:'loadTime'};if(isc.Log&&isc.Log.logDebug)isc.Log.logDebug(isc._pTM.message,'loadTime');else if(isc._preLog)isc._preLog[isc._preLog.length]=isc._pTM;else isc._preLog=[isc._pTM]}isc.definingFramework=true;isc.defineClass("SkinUtil");isc.A=isc.SkinUtil;isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.testPanes={};isc.A.colorArrays=["background","color","border","borderTop","borderLeft","borderBottom","borderRight"];isc.A.skinColorWindowDefaults={_constructor:"Window",autoDraw:false,autoCenter:true,overflow:"visible",canDragResize:true,title:"Palette Tools",colorEditorDefaults:{_constructor:"SkinPaletteTools"},bodyProperties:{overflow:"visible"},draw:function(){this.Super("draw",arguments);this.addAutoChild("colorEditor");this.body.addMember(this.colorEditor)}};isc.B.push(isc.A.toHexString=function isc_c_SkinUtil_toHexString(_1){var _2=new isc.tinycolor(_1);if(_2.isValid())return _2.toHexString();else return""},isc.A.getSkinColor=function isc_c_SkinUtil_getSkinColor(_1){return new isc.tinycolor(_1)},isc.A.createDataSources=function isc_c_SkinUtil_createDataSources(){var _1=isc.clone(isc.Canvas.$1937);var _2="";var _3=[];for(var i=0;i<_1.length;i++){var _5=_1[i];_5.backgroundCount=_5.background.length;_5.colorCount=_5.color.length;_5.borderCount=_5.border.length;_5.borderTopCount=_5.borderTop.length;_5.borderLeftCount=_5.borderLeft.length;_5.borderBottomCount=_5.borderBottom.length;_5.borderRightCount=_5.borderRight.length;var _6=isc.tinycolor(_5.original);isc.addProperties(_5,_6);_2+="\n"+_5.original+" background: "+_5.backgroundCount+", font-color: "+_5.colorCount+", border: "+_5.borderCount+", borderTop: "+_5.borderTopCount+", borderLeft: "+_5.borderLeftCount+", borderBottom: "+_5.borderBottomCount+", borderRight: "+_5.borderRightCount;var _7=0;var _8=isc.SkinUtil.colorArrays;for(var j=0;j<_8.length;j++){var _10=_5[_8[j]+"Count"];if(_10>_7){_7=_10;if(_8[j].contains("border")){_5.mostlyType="Borders"}else if(_8[j].contains("background")){_5.mostlyType="Backgrounds"}else{_5.mostlyType="Fonts"}}}
_3.add(_5)}
isc.DataSource.create({ID:"colorSearchDS",clientOnly:true,fields:[{name:"original",primaryKey:true},{name:"current"},{name:"isSkinCSS",type:"boolean"},{name:"background",multiple:true},{name:"color",multiple:true},{name:"border",multiple:true},{name:"borderTop",multiple:true},{name:"borderLeft",multiple:true},{name:"borderBottom",multiple:true},{name:"borderRight",multiple:true},{name:"backgroundCount",type:"integer"},{name:"colorCount",type:"integer"},{name:"borderCount",type:"integer"},{name:"borderTopCount",type:"integer"},{name:"borderLeftCount",type:"integer"},{name:"borderBottomCount",type:"integer"},{name:"borderRightCount",type:"integer"},{name:"mostlyType"},{name:"red",type:"integer"},{name:"green",type:"integer"},{name:"blue",type:"integer"},{name:"hue",type:"integer"},{name:"sat",type:"integer"},{name:"lightness",type:"integer"},{name:"lab",type:"number"}],cacheData:_3});isc.SkinUtil.colorSearchDS=isc.DS.get("colorSearchDS")},isc.A.showSkinPaletteTools=function isc_c_SkinUtil_showSkinPaletteTools(_1){if(_1||!isc.Canvas.$1937)isc.Canvas.getSkinColors();if(isc.SkinUtil.$1938==null){isc.SkinUtil.$1938=isc.Window.create(isc.SkinUtil.skinColorWindowDefaults)}
var _2=isc.SkinUtil.$1938;_2.setTitle("Palette Tools - "+isc.getCurrentSkinName());_2.show();return _2},isc.A.getClosestColors=function isc_c_SkinUtil_getClosestColors(_1,_2){var _3=isc.SkinUtil,_4=_3.colorSearchDS,_5=_4.cacheData,_6=[];if(!_2)_2=10;for(var i=0;i<_5.length;i++){var _8=_5[i].current;if(_1==_8)continue;var _9=_3.colorDistance(_1,_8);if(_9<=_2){_6.add(_5[i])}}
return _6},isc.A.colorDistance=function isc_c_SkinUtil_colorDistance(_1,_2){var _3=isc.tinycolor(_1);var _4=isc.tinycolor(_2);var _5=(_3.r+_4.r)/2;var r=_3.r-_4.r;var g=_3.g-_4.g;var b=_3.b-_4.b;return Math.sqrt((((512+_5)*r*r)>>8)+4*g*g+(((767-_5)*b*b)>>8))},isc.A.getContrastYIQ=function isc_c_SkinUtil_getContrastYIQ(_1){var r=parseInt(_1.substr(0,2),16);var g=parseInt(_1.substr(2,2),16);var b=parseInt(_1.substr(4,2),16);var _5=((r*299)+(g*587)+(b*114))/1000;return(_5>=128)?'black':'white'});isc.B._maxIndex=isc.C+7;isc.defineClass("SkinColorPalette","Canvas");isc.A=isc.SkinColorPalette.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.overflow="visible";isc.A.titleLabelDefaults={_constructor:"Canvas",autoDraw:true,autoSize:true,wrap:false,height:20,overflow:"visible"};isc.B.push(isc.A.initWidget=function isc_SkinColorPalette_initWidget(){this.Super("initWidget",arguments);this.addAutoChild("titleLabel");this.addChild(this.titleLabel);if(this.title)this.titleLabel.setContents(this.title);this.titleLabel.redraw();this.drawColors()},isc.A.selectColor=function isc_SkinColorPalette_selectColor(_1){var _2=null;if(this.selectedCanvas){this.selectedCanvas.setProperty("border","2px solid "+this.selectedCanvas.color)}
for(var i=0;i<this.children.length;i++){if(this.children[i].isColorCanvas&&this.children[i].color==_1){this.selectedCanvas=this.children[i];this.selectedCanvas.setProperty("border","2px solid white");break}}},isc.A.drawColors=function isc_SkinColorPalette_drawColors(_1){if(this.children){for(var i=this.children.length-1;i>0;i--){var _3=this.children[i];if(_3.isColorCanvas){this.removeChild(_3);_3.destroy();_3=null}}}
_1=_1||this.colors||isc.Canvas.$1937.findAll({isSkinCSS:true});_1.setSort([{property:"original",direction:"ascending"}]);var _4=this.titleLabel.getHeight();var _5=0,_6=0;var _7=0,_8=0;for(var i=0;i<_1.length;i++){if(_8==10){_8=0;_7++}
var _3=this.getColorCanvas(_1[i].original);this.addChild(_3)
_3.moveTo(_8*20,_4+(_7*20));_8++}},isc.A.getColorCanvas=function isc_SkinColorPalette_getColorCanvas(_1){return isc.Canvas.create({width:20,height:20,color:_1,isColorCanvas:true,autoDraw:false,border:"2px solid "+_1,backgroundColor:_1,prompt:_1})});isc.B._maxIndex=isc.C+4;isc.defineClass("ColorConverter","VLayout");isc.A=isc.ColorConverter.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.width=270;isc.A.height=180;isc.A.overflow="auto";isc.A.autoDraw=true;isc.A.formDefaults={_constructor:"DynamicForm",colWidths:[100,150],fields:[{name:"inputColor",width:"*",changed:function(_1,_2,_3){_1.creator.setColor(_3)}},{name:"changeTo",editorType:"ColorItem",title:"Change To",width:"*",changed:function(_1,_2,_3){_1.creator.changeColor(_1.getValue("Hex"),_3)}},{name:"Hex",editorType:"ColorItem",width:"*"},{name:"Name",width:"*"},{name:"Rgb",width:"*"},{name:"Hsl",width:"*"},{name:"Hwb",width:"*"},{name:"Cmyk",width:"*"}]};isc.B.push(isc.A.initWidget=function isc_ColorConverter_initWidget(){this.Super("initWidget",arguments);this.addAutoChild("form");this.addMember(this.form);if(this.color)this.setColor(this.color)},isc.A.setColor=function isc_ColorConverter_setColor(_1){this.inputColor=_1;this.color=isc.tinycolor(_1);this.updateForm()},isc.A.changeColor=function isc_ColorConverter_changeColor(_1,_2){var _3={};_3[_1]=_2;isc.Canvas.changeSkinColors(_3);this.creator.changeConfigColor(_1,_2)},isc.A.updateForm=function isc_ColorConverter_updateForm(){var c=this.color;if(c.valid){var _2=c.toHexString();var _3=isc.Canvas.$1937.find("original",_2);this.form.setValues({"inputColor":this.inputColor,"Hex":_2,"changeTo":_3?_3.current:_2,"Name":c.toName(),"Rgb":c.toRgbString(),"Hsl":c.toHslString(),"Hwb":c.toHwbString(),"Cmyk":c.toCmykString()})}else{this.form.setValues({"inputColor":this.inputColor})}});isc.B._maxIndex=isc.C+4;isc.defineClass("SkinPaletteTools","HLayout");isc.A=isc.SkinPaletteTools.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.membersMargin=5;isc.A.layoutMargin=5;isc.A.leftPaneDefaults={_constructor:"VLayout",membersMargin:5};isc.A.gridDefaults={_constructor:"ListGrid",height:400,headerHeight:56,dataSource:"colorSearchDS",autoFetchData:true,autoFitData:"horizontal",autoFitFieldWidths:true,autoFitWidthApproach:"both",getCellCSSText:function(_1,_2,_3){return"background-color: "+_1.original+";"},canHover:true,showHover:true,cellHoverHTML:function(_1,_2,_3,_4){if(_3>2)return _1[this.creator.colorArrays[_3-3]].join("\n");return _4},fields:[{name:"original",title:"Original",width:100},{name:"isSkinCSS",type:"boolean",title:"From Skin"},{name:"mostlyType",editorType:"SelectItem",valueMap:["","Backgrounds","Fonts","Borders"]},{name:"backgroundCount",title:"Background"},{name:"colorCount",title:"Text"},{name:"borderCount",title:"Border"},{name:"borderTopCount",title:"Top"},{name:"borderLeftCount",title:"Left"},{name:"borderBottomCount",title:"Bottom"},{name:"borderRightCount",title:"Right"},{name:"background",hidden:true},{name:"color",hidden:true},{name:"border",hidden:true},{name:"borderTop",hidden:true},{name:"borderLeft",hidden:true},{name:"borderBottom",hidden:true},{name:"borderRight",hidden:true},{name:"red",type:"integer",hidden:true},{name:"green",type:"integer",hidden:true},{name:"blue",type:"integer",hidden:true},{"name":"lab",hidden:true}],headerSpans:[{fields:["original","isSkinCSS","mostlyType","backgroundCount","colorCount"],title:"Color"},{fields:["borderCount","borderTopCount","borderLeftCount","borderBottomCount","borderRightCount"],title:"Borders"}],recordClick:function(_1,_2,_3,_4,_5,_6,_7){_1.creator.converter.setColor(_2.original)},showFilterEditor:true,canGroupby:true,canMultiGroup:true,allowFilterExpressions:true,dataArrived:function(){this.creator.rowCountLabel.setContents(this.data.getLength()+" filtered rows...")},initialCriteria:{_constructor:"AdvancedCriteria",operator:"and",criteria:[{fieldName:"isSkinCSS",operator:"equals",value:true}]},initialSort:[{property:"lab",direction:"ascending"}]};isc.A.buttonBarDefaults={_constructor:"HLayout",overflow:"visible",membersMargin:5,height:40};isc.A.loadConfigButtonDefaults={_constructor:"IButton",title:"Load Config",autoFit:true,click:function(){this.creator.loadConfig()}};isc.A.saveConfigButtonDefaults={_constructor:"IButton",title:"Save Config",autoFit:true,click:function(){this.creator.saveConfig()}};isc.A.allButtonDefaults={_constructor:"IButton",title:"All",autoFit:true,click:function(){this.creator.grid.setCriteria({})}};isc.A.only1RefButtonDefaults={_constructor:"IButton",title:"Only 1 ref",autoFit:true,click:function(){this.creator.grid.setCriteria(this.creator.getSearchCrit("lessThan",2))}};isc.A.lessThan5RefsButtonDefaults={_constructor:"IButton",title:"Less than 5 refs",autoFit:true,click:function(){this.creator.grid.setCriteria(this.creator.getSearchCrit("lessThan",5))}};isc.A.rowCountLabelDefaults={_constructor:"Label",autoFit:true,wrap:false,color:"white"};isc.A.rightPaneDefaults={_constructor:"VLayout",membersMargin:5,height:"100%"};isc.A.paletteDefaults={_constructor:"SkinColorPalette",title:"Palette Colors"};isc.A.closestPaletteDefaults={_constructor:"SkinColorPalette",title:"Closest Colors"};isc.A.converterDefaults={_constructor:"ColorConverter",setColor:function(_1){this.Super("setColor",arguments);this.creator.converterColorChanged(this.inputColor)}};isc.A.repo=null;isc.B.push(isc.A.initWidget=function isc_SkinPaletteTools_initWidget(){this.Super("initWidget",arguments);this.colorArrays=isc.SkinUtil.colorArrays;this.config={colors:[],fonts:[]};this.createDataSources();this.addAutoChild("leftPane");this.addMember(this.leftPane);this.addAutoChild("grid");this.leftPane.addMember(this.grid);this.addAutoChild("buttonBar");this.leftPane.addMember(this.buttonBar,0);this.addAutoChildren(["loadConfigButton","saveConfigButton","allButton","only1RefButton","lessThan5RefsButton","rowCountLabel"]);this.buttonBar.addMembers([this.loadConfigButton,this.saveConfigButton,this.allButton,this.only1RefButton,this.lessThan5RefsButton,this.rowCountLabel])
this.addAutoChild("rightPane")
this.addMember(this.rightPane);this.addAutoChild("converter");this.rightPane.addMember(this.converter);this.addAutoChild("palette",{title:"Palette Colors"});this.rightPane.addMember(this.palette);this.addAutoChild("closestPalette",{title:"Closest Colors",colors:[]});this.rightPane.addMember(this.closestPalette)},isc.A.converterColorChanged=function isc_SkinPaletteTools_converterColorChanged(_1){this.palette.selectColor(_1);this.closestPalette.drawColors(isc.SkinUtil.getClosestColors(_1,50))},isc.A.getSearchCrit=function isc_SkinPaletteTools_getSearchCrit(_1,_2){var _3={_constructor:"AdvancedCriteria",operator:"and",criteria:[]};for(var i=0;i<this.colorArrays.length;i++){_3.criteria.add({fieldName:this.colorArrays[i]+"Count",operator:_1,value:_2})}
return _3},isc.A.createDataSources=function isc_SkinPaletteTools_createDataSources(){isc.SkinUtil.createDataSources();this.colorSearchDS=isc.SkinUtil.colorSearchDS},isc.A.getRepo=function isc_SkinPaletteTools_getRepo(){if(!this.repo)this.repo=isc.ViewRepo.create();return this.repo},isc.A.loadConfig=function isc_SkinPaletteTools_loadConfig(_1,_2){var _3=_1;if(!_2&&this.configChanged){isc.ask("Config has been changed - proceed anyway (changes will be lost)?",function(_5){if(_5!=null&&_5==true){this.loadConfig(_3,true)}});return}
var _4=this;this.loadFile("/isomorphic/skins/$1939/tools/skinColors/skin.config",function(_5){_4.configLoaded(_5,_3)})},isc.A.configLoaded=function isc_SkinPaletteTools_configLoaded(_1,_2){this.config=isc.JSON.decode(_1);isc.logWarn(isc.echoFull(_1));var _3=this.config.colors.length,_4={};if(_3>0){for(var i=0;i<_3;i++){var _6=this.config.colors[i];_4[_6.original]=_6.current}
isc.Canvas.changeSkinColors(_4)}
if(_2)this.fireCallback(_2,"data",[_1])},isc.A.loadFile=function isc_SkinPaletteTools_loadFile(_1,_2){var _3=this.getRepo();var _4=_2;_3.loadObject({criteria:{path:_1}},function(_5,_6,_2){_4(_5)})},isc.A.saveFile=function isc_SkinPaletteTools_saveFile(_1,_2,_3){var _4=this.getRepo();var _5=_3;var _6=this;var _7=isc.DS.get("Filesystem");var _8={path:_2,name:_2,fileName:_2,contents:isc.JSON.encode(_1)};_7.updateData(_8,function(_9){_6.saveObjectReply(_9,_5,_8)})},isc.A.saveObjectReply=function isc_SkinPaletteTools_saveObjectReply(_1,_2,_3){this.configChanged=false;if(_2)this.fireCallback(_2,"success",[true])},isc.A.saveConfig=function isc_SkinPaletteTools_saveConfig(_1,_2){_1=_1||this.config
this.saveFile(_1,"/isomorphic/skins/$1939/tools/skinColors/skin.config",function(_3){isc.logWarn(_3)})},isc.A.changeConfigColor=function isc_SkinPaletteTools_changeConfigColor(_1,_2,_3){var _4=this.config.colors.find("original",_1);if(_4){_4.current=_2}else{if(!_3)_3={background:true,border:true,color:true}
_4={original:_1,current:_2,types:_3};this.config.colors.add(_4)}
this.configChanged=true});isc.B._maxIndex=isc.C+12;isc.showPaletteTools=isc.SkinUtil.showSkinPaletteTools;isc.defineClass("SkinMetadata","Class");isc.A=isc.SkinMetadata;isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.B.push(isc.A.initialize=function isc_c_SkinMetadata_initialize(_1){this.toolsDir=isc.Page.getToolsDir();this.skinToolsDir=this.toolsDir+"skinTools/";this.metadataPath=this.skinToolsDir+"data/";this.dsObserver=isc.Class.create({owner:this,variableMetadataChanged:function(){this.owner.$217l(true,"variable")},groupMetadataChanged:function(){this.owner.$217l(true,"group")}});this.groupMetadataDS=this.getNewGroupMetadataDS("groupMetadataDS");this.dsObserver.observe(this.groupMetadataDS,"dataChanged","observer.groupMetadataChanged(true);");this.variableMetadataDS=this.getNewVariableMetadataDS("variableMetadataDS");this.dsObserver.observe(this.variableMetadataDS,"dataChanged","observer.variableMetadataChanged(true);");var _2=this;this.groupMetadataDS.fetchData(null,function(){_2.groupMetadataDS.cacheData.map(function(_4){if(_4.iscClass!=null&&isc.Media.stockIcons){var _3=isc.Class.getClassIcon(_4.iscClass);if(_3){_4.icon=_3.src}}});_2.variableMetadataDS.fetchData(null,function(){if(isc.Media.stockIcons){_2.variableMetadataDS.cacheData.map(function(_4){if(_4.iscClass!=null){var _3=isc.Class.getClassIcon(_4.iscClass);if(_3){_4.icon=_3.src}}})}
_2.$210=true;if(_1)_1()})})},isc.A.$217l=function isc_c_SkinMetadata__notifyDirty(_1,_2){if(_2=="group")this.getGroupMetadataDS().$216i=_1;else if(_2=="variable")this.getGroupMetadataDS().$216i=_1;this.$216i=this.dataDirty();if(this.notifyDirty)this.notifyDirty(_1,_2)},isc.A.dataDirty=function isc_c_SkinMetadata_dataDirty(){return this.getGroupMetadataDS().$216i||this.getVariableMetadataDS().$216i},isc.A.getNewGroupMetadataDS=function isc_c_SkinMetadata_getNewGroupMetadataDS(_1){var _2=isc.DS.get("skinVariableGroups").getFields();var _3=[];for(var _4 in _2){var _5=_2[_4];var _6=isc.addProperties({},_5);delete _6.columnCode;delete _6.$61;delete _6.validators;delete _6.$62;var _7=_6.foreignKey;if(_7){_6.foreignKey=_7.replace("skinVariableGroups",_1)}
_3.add(_6)}
return isc.DataSource.create({ID:_1,fields:_3,clientOnly:true,dataURL:this.metadataPath+"groupMetadata.json"})},isc.A.getGroupMetadataDS=function isc_c_SkinMetadata_getGroupMetadataDS(){if(!this.$210){this.logWarn("Initializing metadata - call isc.SkinMetadata.initialize()");this.initialize()}
return this.groupMetadataDS},isc.A.saveGroupMetaData=function isc_c_SkinMetadata_saveGroupMetaData(_1,_2){_1=_1||this.getGroupMetadataDS();var _3=_1.cacheData;var _4=[];for(var i=0;i<_3.length;i++){var _6=isc.addProperties({},_3[i]);for(var _7 in _6){if(["isFolder","children"].contains(_7))delete _6[_7];if(_7.startsWith("_"))delete _6[_7];delete _6.icon}
_4.add(_6)}
_4.setSort([{property:"parentId",direction:"ascending"},{property:"index",direction:"ascending"}]);var _8=this;isc.DS.get("isc_userSkin").performCustomOperation("updateVariableGroupMetadata",{metadata:_4},function(_9){_8.logWarn("Output-Group metadata updated...");_8.$217l(false,"group");if(_2)_2(_9)},{useStrictJSON:true})},isc.A.getNewVariableMetadataDS=function isc_c_SkinMetadata_getNewVariableMetadataDS(_1,_2){var _3=isc.DS.get("skinVariables").getFields();var _4=[];for(var _5 in _3){var _6=_3[_5];var _7=isc.addProperties({},_6);delete _7.columnCode;delete _7.$61;delete _7.validators;delete _7.$62;var _8=_7.foreignKey;if(_8){_7.foreignKey=_8.replace("skinVariables",_1)}
_4.add(_7)}
if(_2){_4.add({name:"transformedValue"});_4.add({name:"transformResult"});_4.add({name:"metadataValue"});_4.add({name:"themeValue"});_4.add({name:"customValue"});_4.add({name:"savedValue"})}
var _9=isc.DataSource.create({ID:_1,fields:_4,clientOnly:true,dataURL:this.metadataPath+"variableMetadata.json"});return _9},isc.A.getVariableMetadataDS=function isc_c_SkinMetadata_getVariableMetadataDS(){if(!this.$210)this.initialize();return this.variableMetadataDS},isc.A.saveVariableMetadata=function isc_c_SkinMetadata_saveVariableMetadata(_1,_2){_1=_1||this.getVariableMetadataDS()
var _3=_1.cacheData;var _4=[];for(var i=0;i<_3.length;i++){var _6=isc.addProperties({},_3[i]);for(var _7 in _6){if(_7.startsWith("_"))delete _6[_7]}
delete _6.transform;delete _6.icon;delete _6.internal;_4.add(_6)}
_4.setSort([{property:"id",direction:"ascending"}]);var _8=this;isc.DS.get("isc_userSkin").performCustomOperation("updateVariableMetadata",{metadata:_4},function(_9){_8.logWarn("Variable metadata updated...");_8.$217l(false,"variable");if(_2)_2(_9)},{useStrictJSON:true})},isc.A.isColorTransform=function isc_c_SkinMetadata_isColorTransform(_1){return _1.search(/^(lighten|darken|brighten|dim|saturate|desaturate)/i)>=0},isc.A.regenSeriesDynamicBaseFile=function isc_c_SkinMetadata_regenSeriesDynamicBaseFile(_1,_2){_1=_1||"Flat";var _3=isc.SkinFunc;var _4=isc.SkinMetadata;var _5=this;isc.DS.get("skinSeries").fetchData({name:_1},function(_15,_16){var _6=isc.isAn.Array(_16)?_16[0]:_16;var _7=_6.baseCSS;var _8=_3.readSection("skin_base_styles",_7);var _9=_4.getVariableMetadataDS().cacheData;_9.setSort({property:"name",direction:"descending"});for(var i=0;i<_9.length;i++){var v=_9[i],_12=v.name;if(v.value.contains("linear")||_12.search(/(linear|transition|fadeIn|fadeOut|duration|fudgeFact)/i)>=0)
{continue}
var _13=new RegExp("(?:\\$)("+_12.substring(1)+")(\\W|$)","g");_8=_8.replace(_13,"var(--isc-$1)$2")}
var _14=_3.replaceSectionContent("skin_base_styles",_8,_7);isc.DS.get("skinSeries").updateData({name:_1,dynamicCSS:_14},function(_15,_16){isc.logWarn("Dynamic Base File _base"+_1+"$216u.scss regenerated...");if(_2)_2()})})},isc.A.parseSettings=function isc_c_SkinMetadata_parseSettings(_1,_2){var _3=[],_4=-1,_5,_6=-1,_7=0;var c=_1;var _9=c.indexOf("//* CSS *//");if(_9>0){c=c.substring(0,_9-1)}
c=c.replaceAll(" !default;",";");while(true){_4=c.indexOf("$",_6+1);if(_4==-1){break}
_5=c.indexOf(":",_4);_6=c.indexOf(";",_5+1)
var _10={name:c.substring(_4,_5),value:c.substring(_5+1,_6).trim(),index:_7++};_10[_2]=_10.value;_3.add(_10)}
return _3},isc.A.regenAllBaseSkinFiles=function isc_c_SkinMetadata_regenAllBaseSkinFiles(_1){var _2=this;_2.$224a=[];isc.DS.get("isc_baseSkin").fetchData({},function(_4,_5){for(var i=0;i<_5.length;i++){_2.$224a.add({name:_5[i].name,regen:1});isc.SkinMetadata.regenBaseSkinFiles(_5[i].name,_1)}})},isc.A.regenBaseSkinFiles=function isc_c_SkinMetadata_regenBaseSkinFiles(_1,_2){var _3=isc.SkinMetadata;var _4=isc.SkinFunc;var _5=_3.getNewVariableMetadataDS(null);var _6=this;_5.fetchData({},function(_13,_14){var _7=_5.cacheData;isc.DS.get("fileSystemSkin").fetchData({name:_1},function(_15,_14){if(isc.isAn.Array(_14))_14=_14[0];var _8=_14.skinSettings;var _9=_4.readSection("theme_variables",_8);var _10=_3.parseSettings(_9||"","value");_3.applyOverlaySettings(_5,_10);var _11=_4.getVariableScript(_7,{includeAll:true,returnDefaults:true},_3.getGroupMetadataDS().cacheData);_8=_4.replaceSectionContent("theme_variables",_11,_8);var _12="\n@function v($var) {@return var(--#{$var})}\n:root {";_12+=_3.generateThemeCssProperties(_11,_7);_12+=";\n}";isc.DS.get("fileSystemSkin").updateData({name:_1,skinSettings:_8,cssProperties:_12},function(){_6.$224a.find("name",_1).regen=0;isc.logWarn(_1+" updated - $194n"+_1+".scss and $217y.scss regenerated...");if(_6.$224a.getProperty("regen").sum()==0){if(_2)_2()}})})})},isc.A.applyOverlaySettings=function isc_c_SkinMetadata_applyOverlaySettings(_1,_2){var _3=_1.cacheData;for(var i=0;i<_3.length;i++){var _5=_3[i];var _6=_2.find("name",_5.name);if(_6!=null)_5.value=_6.value}},isc.A.generateThemeCssProperties=function isc_c_SkinMetadata_generateThemeCssProperties(_1,_2){var _3=_1.replaceAll(" !default;",";");var _4=_3.split("\n");var _5=[];var _6=[";",",",")"," ","+","-"];var _7=isc.SkinMetadata;for(var i=0;i<_4.length;i++){var _9=_4[i];if(!_9||_9=="")continue;if(_9.startsWith("//"))continue;var _10=_9.split(":");var _11=_10[0].substring(1);if(_10[1]==null)continue;var _12=_10[1].trim().replaceAll(";","");var d=_2.find("name","$"+_11);var _14=null;if(_12.contains("linear")||_11.search(/(linear|transition|fadeIn|fadeOut|duration|fudgeFact)/i)>=0){continue}
if(_12.startsWith("$")&&!_12.contains(" ")){_12="#{v(isc-"+_12.substring(1)+")}";_14="--isc-"+_11+": "+_12}else if(_12.contains("$")){if(_7.isColorTransform(_12)||_12.startsWith("adjust")){_14="--isc-"+_11+": #{$"+_11+"}"}else{for(var j=0;j<_2.length;j++){var _16=_12.indexOf(_2[j].name);if(_16>=0){_16+=_2[j].name.length;var _17=_12.substring(_16,_16+1);if(_16>=_12.length||_6.contains(_17)){_12=_12.replaceAll(_2[j].name,"#{v(isc-"+_2[j].name.substring(1)+")}");if(!_12.contains("$"))break}}}
_14="--isc-"+_11+": "+_12}}else{_14="--isc-"+_11+": #{$"+_11+"}"}
_5.add(_14)}
var _18=_5.join(";\n");return _18},isc.A.getClassIconValueMap=function isc_c_SkinMetadata_getClassIconValueMap(){if(!isc.Media||!isc.Media.stockIcons)return{};if(isc.SkinMetadata.$2188)return isc.SkinMetadata.$2188;var _1=isc.Media.getStockIcons("classIcons");var _2=_1.getProperty("name").getUniqueItems().sort();isc.SkinMetadata.$2188=_2;return isc.SkinMetadata.$2188},isc.A.getClassIconValueIcons=function isc_c_SkinMetadata_getClassIconValueIcons(){if(!isc.Media||!isc.Media.stockIcons)return{};if(isc.SkinMetadata.$2189)return isc.SkinMetadata.$2189;var _1=isc.Media.getStockIcons("classIcons");var _2=_1.getValueMap("name","src");isc.SkinMetadata.$2189=_2;return isc.SkinMetadata.$2189});isc.B._maxIndex=isc.C+18;if(!isc.SkinFunc)isc.defineClass("SkinFunc");isc.A=isc.SkinFunc;isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.metadataPath=isc.Page.getToolsDir()+"skinTools/data/";isc.A.repo=null;isc.A.seriesSassPath="/isomorphic/skins/$1939/FlatSeries/sass/";isc.A.skinsFolderPath="/isomorphic/skins/";isc.A.currentSeries=null;isc.A.transformTypes={"none":"None","lighten":"Lighten","darken":"Darken","saturate":"Saturate","desaturate":"Desaturate","custom":"Custom"};isc.B.push(isc.A.loadFile=function isc_c_SkinFunc_loadFile(_1,_2){if(!_1){isc.say("loadFile called with no file-path");return null}
var _3=_2;if(!isc.SkinFunc.repo){isc.SkinFunc.repo=isc.ViewRepo.create({dataSource:isc.DS.get("Filesystem")})}
isc.SkinFunc.repo.loadObject({criteria:{path:_1}},function(_4,_5,_2){_3(_4)});return},isc.A.saveFile=function isc_c_SkinFunc_saveFile(_1,_2,_3){if(!_2){isc.say("saveFile called with no file-path");return null}
var _4=_3;var _5=(isc.isA.String(_1)?_1:isc.JSON.encode(_1,{prettyPrint:false}));var _6=isc.DS.get("Filesystem");var _7={path:_2,name:_2,fileName:_2,contents:_5};_6.updateData(_7,function(_8){if(_4)_4(_7)})},isc.A.init=function isc_c_SkinFunc_init(){var _1=isc.SkinFunc;if(!_1.$210){_1.createDataSources();_1.$210=true}},isc.A.createDataSources=function isc_c_SkinFunc_createDataSources(){var _1=isc.SkinFunc;isc.RPCManager.startQueue();_1.groupMetadataDS=isc.DataSource.create({ID:"groupMetadataDS",inheritsFrom:"skinVariableGroups",clientOnly:true,dataURL:_1.metadataPath+"groupMetadata.json"}).fetchData();_1.skinVariableDS=isc.DataSource.create({ID:"variableMetadataDS",inheritsFrom:"skinVariables",clientOnly:true,dataURL:_1.metadataPath+"variableMetadata.json"}).fetchData();isc.RPCManager.sendQueue()},isc.A.getVariableGroupCache=function isc_c_SkinFunc_getVariableGroupCache(){return isc.SkinFunc.groupMetadataDS.cacheData},isc.A.getVariablesDS=function isc_c_SkinFunc_getVariablesDS(_1,_2){var _3=isc.DataSource.create({ID:_1,clientOnly:true,inheritsFrom:"skinVariables"});if(_2){_3.cacheData=_2}
return _3},isc.A.editVariableName=function isc_c_SkinFunc_editVariableName(_1,_2,_3){_2=_2||isc.SkinFunc.currentSeries;var _4=(isc.isAn.Object(_1)?_1.name:_1);if(_4.startsWith("$"))_4=_4.substring(1);isc.askForValue("Rename '"+_4+"' to:",function(_5){if(!_5){isc.say("No value entered");return}
_5=_5.trim();if(!_5.startsWith("$"))_5="$"+_5;isc.SkinFunc.changeVariableName(_2,_1,_5);if(_3)_3.invalidateCache()},{defaultValue:_4,width:400})},isc.A.changeVariableName=function isc_c_SkinFunc_changeVariableName(_1,_2,_3){_1.changeVariableName(_2,_3)},isc.A.getThemeOutputPath=function isc_c_SkinFunc_getThemeOutputPath(_1,_2){if(_2)return"/tools/skinTools/$1939/";return isc.SkinFunc.skinsFolderPath+_1+"/$1939/sass/"},isc.A.getOutputPath=function isc_c_SkinFunc_getOutputPath(_1){if(_1)return"/tools/skinTools/$1939/";return isc.SkinFunc.seriesSassPath},isc.A.loadSeries=function isc_c_SkinFunc_loadSeries(_1,_2,_3){var _4=isc.SkinSeries.create({ID:"series_"+_1,seriesName:_1,themeNames:_2,$76b:_3});_4.loadSeries(_1,_2)},isc.A.readSection=function isc_c_SkinFunc_readSection(_1,_2){if(!_2)return"";var _3="//>"+_1,_4=_2.indexOf(_3)+_3.length,_5=_2.indexOf("//<"+_1);return _2.substring(_4,_5)},isc.A.replaceSectionContent=function isc_c_SkinFunc_replaceSectionContent(_1,_2,_3){var _4="//>"+_1;var _5=_3.indexOf(_4);if(_5<0)return false;_5+=_4.length;var _6=_3.indexOf("//<"+_1);if(_6<0)return false;var _7=_3.substring(0,_5);_7+=_2;_7+="\n"+_3.substring(_6);return _7},isc.A.getSectionContent=function isc_c_SkinFunc_getSectionContent(_1,_2){_2=_2||"";var _3="//>"+_1+"\n"+_2.trim()+"\n//<"+_1+"\n";isc.logWarn("writing section "+_1+"\n\n"+_3);return _3},isc.A.remapOutputIndices=function isc_c_SkinFunc_remapOutputIndices(_1,_2){if(!_2){isc.logWarn("No variableDS provided to remapOutputIndices().")
return}
var _3=_1||isc.SkinFunc.getVariableGroupCache();var _4=[];for(var i=0;i<_3.length;i++){if(_3[i].parentId==null||_3[i].parentId=="none")_4.add(_3[i])}
_4.setSort([{property:"index",direction:"ascending"}]);_2.fetchData({},function(_11,_12){for(var i=0;i<_4.length;i++){var _6=_4[i];var _7=_3.findAll("parentId",_6.name)||[];_7.setSort([{property:"index",direction:"ascending"}]);if(_7.length>0){for(var j=0;j<_7.length;j++){var _9=_12.findAll({outputGroup:_7[j].name})||[];_9.setSort([{property:"outputIndex",direction:"ascending"}]);for(var i=0;i<_9.getLength();i++){var _10=_9.get(i);_10.outputIndex=i*10;_2.updateData(_10)}}}}})},isc.A.getOutputGroup=function isc_c_SkinFunc_getOutputGroup(_1,_2,_3){var _4={group:_1};_4.childGroups=_2.findAll("parentId",_1.name)||[];_4.childGroups.setSort([{property:"index",direction:"ascending"}]);_4.variables=_3.findAll({outputGroup:_1.name})||[];_4.variables.setSort([{property:"outputIndex",direction:"ascending"}]);return _4},isc.A.getGroupScript=function isc_c_SkinFunc_getGroupScript(_1,_2,_3,_4){var _5=this.getOutputGroup(_1,_2,_3),_6=_5.group,_7=_6.parentId==null||_6.parentId=="none",_8=[];if(_7){var _9="\n// ==== "+_6.title;if(_6.comment&&_6.comment!=""){var _10=_6.comment.split("\n");if(_10.length==1){_8.add(_9+" - "+_10[0])}else{_8.add(_9);for(var _11=0;_11<_10.length;_11++){_8.add("// "+_10[_11])}}}}else{if(_6.comment&&_6.comment!=""){var _10=_6.comment.split("\n");for(var _11=0;_11<_10.length;_11++){_8.add("// "+_10[_11])}}else if(_6.title&&_6.title!=""){_8.add("// "+_6.title)}}
if(_5.variables.length>0){for(var k=0;k<_5.variables.getLength();k++){var _13=_5.variables.get(k);var _14=null;if(_4.exportFieldName){if(_13[_4.exportFieldName])_14=_13[_4.exportFieldName]}
if(_14==null)_14=_13.value;_14=_14.replaceAll("!default").trim();if(_14.endsWith(";"))_14=_14.substring(0,_14.length-1).trim();var _15=_13.name+": "+_14;if(_4.returnDefaults)_15+=" !default";if(!_15.endsWith(";"))_15+=";";_8.add(_15)}}
if(_5.childGroups.length>0){for(var j=0;j<_5.childGroups.length;j++){_8.addList(this.getGroupScript(_5.childGroups[j],_2,_3,_4))}}
return _8},isc.A.getVariableScript=function isc_c_SkinFunc_getVariableScript(_1,_2,_3){_2=_2||{};var _4=(isc.isA.ResultSet(_1)?_1.allRows:_1),_5=_3||isc.SkinMetadata.getGroupMetadataDS().cacheData,_6=[],_7=[];_6.addList(_5.findAll("parentId",null));_6.addList(_5.findAll("parentId","none"))
_6.setSort([{property:"index",direction:"ascending"}]);for(var i=0;i<_6.length;i++){var _9=this.getGroupScript(_6[i],_5,_4,_2);_7.addList(_9)}
var _7=_7.join("\n");return _7},isc.A.transformColor=function isc_c_SkinFunc_transformColor(_1,_2,_3){_1=isc.tinycolor(_1);if(_2=="custom"){}else if(_2!="none"){if(_1[_2])_1[_2](_3)}
return _1.toHexString()},isc.A.updateVariableMetaData=function isc_c_SkinFunc_updateVariableMetaData(_1,_2){var _3=isc.DS.get("skinVariables"),_4=_1.variablesRS.allRows,_5=_1.baseFile.content;var _6=0,_7=0;_2=_2||{};if(_2.updateUsageAndExclude==null)_2.updateUsageAndExclude=false;if(_2.removeUsedBy==null)_2.removeUsedBy=true;for(var i=0;i<_4.length;i++){var _9=isc.addProperties({},_4[i]);if(_2.updateUsageAndExclude){var _10=_9.usedInSeriesFile,_11=_9.usedInThemeFile;if(_5.contains(_9.name+";")||_5.contains(_9.name+",")||_5.contains(_9.name+" ")||_5.contains(_9.name+")")){_9.usedInSeriesFile=true}else _9.usedInSeriesFile=false;var _12=false;for(var k=0;k<_1.themes.length;k++){var _14=_1.themes[k].themeVariableData;if(_14.contains(_9.name+";")||_14.contains(_9.name+",")||_14.contains(_9.name+" ")||_14.contains(_9.name+")")){_12=true;break}
var _15=_1.themes[k].customFileContent;if(_15.contains(_9.name+";")||_15.contains(_9.name+",")||_15.contains(_9.name+" ")||_15.contains(_9.name+")")){_12=true;break}}
_9.usedInThemeFile=_12;continue}
if(_2.removeUsedBy){delete _9.usedBy}
_3.updateData(_9)}},isc.A.exportToNewDSFormat=function isc_c_SkinFunc_exportToNewDSFormat(_1){var _2=_1.cacheData,_3=isc.DS.get("skinVariables"),_4=0;_2.setSort({property:"id",direction:"ascending"});for(var i=0;i<_2.length;i++){var _6=isc.addProperties({},_2[i]);if(_6.superKey==_6.derivesFrom)delete _6.superKey;delete _6.usedInThemeFile;delete _6.usedBy;_6.id=++_4;_3.addData(_6)}});isc.B._maxIndex=isc.C+21;isc.defineClass("SkinSeries");isc.A=isc.SkinSeries.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.seriesName="Flat";isc.A.seriesFilePath="$194g.scss";isc.A.baseFile=null;isc.A.dynamicFile=null;isc.A.generatorProps={};isc.B.push(isc.A.init=function isc_SkinSeries_init(){this.Super("init",arguments);if(this.seriesName)this.loadSeries(this.seriesName,this.themeNames,this.loadCallback)},isc.A.loadSeries=function isc_SkinSeries_loadSeries(_1,_2,_3){isc.logWarn("Loading '"+this.seriesName+"' Series...");if(_2&&!isc.isAn.Array(_2))_2=[_2];var _4=isc.SkinFunc,_5=_3,_6=this;isc.DS.get("skinSeries").fetchData({name:_1},function(_7,_8,_9){_6.record=_8[0];_6.parseSeriesFile(_6.record.baseCSS);if(_5)_5(_6)})},isc.A.parseSeriesFile=function isc_SkinSeries_parseSeriesFile(_1){this.baseFile={name:"_base"+this.seriesName+".scss",content:_1};this.baseFile.variablesScript=this.readSection("skin_default_variables");this.baseFile.headerDocScript=this.readSection("skin_header_doc");this.baseFile.stylesScript=this.readSection("skin_base_styles")},isc.A.writeSeriesBaseFile=function isc_SkinSeries_writeSeriesBaseFile(_1){this.$195j=_1;this.getVariableScript(_1,{target:this,methodName:"$195k"})},isc.A.getVariableScript=function isc_SkinSeries_getVariableScript(_1,_2){var _3=this;isc.DS.get("skinVariables").fetchData({},function(_5,_6){var _4=isc.SkinFunc.getVariableScript(_6,isc.addProperties({},_3.generatorProps,{returnDefaults:true}));_4=isc.SkinFunc.getSectionContent("skin_default_variables",_4);if(_2){this.fireCallback(_2,["variableScript"],[_4])}})},isc.A.loadThemes=function isc_SkinSeries_loadThemes(_1,_2){var _3=_2,_4=this;this.themes=[];this.$194k=isc.shallowClone(_1);isc.logWarn("Loading '"+this.seriesName+"' Themes...");for(var i=0;i<_1.length;i++){var _6=_1[i];var _7=isc.SkinTheme.create({ID:"theme_"+_6,series:_4,themeName:_6,themeLoaded:function(){_4.themeLoaded(this,_3)}});this.themes.add(_7);_7.loadTheme(_6)}},isc.A.themeLoaded=function isc_SkinSeries_themeLoaded(_1,_2){isc.logWarn("Theme '"+_1.themeName+"' loaded ("+this.seriesName+" series)");this.$194k.remove(_1.themeName);if(this.$194k.length==0){this.themesLoaded(_2)}},isc.A.themesLoaded=function isc_SkinSeries_themesLoaded(_1){isc.logWarn("All '"+this.seriesName+"' series Themes loaded ("+isc.echoFull(this.themes.getProperty("themeName"))+")");this.seriesLoaded(_1)},isc.A.seriesLoaded=function isc_SkinSeries_seriesLoaded(_1){isc.logWarn("'"+this.seriesName+"' series loaded...");if(this.$76b)this.$76b(this);if(_1)_1(this)},isc.A.replaceVariableNameInValue=function isc_SkinSeries_replaceVariableNameInValue(_1,_2,_3){var _4=""+_3;_4=_4.replaceAll(_1+";",_2+";");_4=_4.replaceAll(_1+",",_2+",");_4=_4.replaceAll(_1+" ",_2+" ");_4=_4.replaceAll(_1+")",_2+")");return _4},isc.A.renameVariables=function isc_SkinSeries_renameVariables(_1,_2){var _3=this.variablesRS.allRows,_4=[];if(!_1.startsWith("$"))_1="$"+_1;for(var i=0;i<_3.length;i++){var _6=isc.addProperties({},_3[i]);if(_6.name.startsWith(_1)){var _7=_6.name,_8=_6.name.replace(_1,_2);this.changeVariableName(_7,_8)}}},isc.A.changeVariableName=function isc_SkinSeries_changeVariableName(_1,_2){var _3=this.variablesRS.allRows,_4=[];for(var i=0;i<_3.length;i++){var _6={};var _7=_3[i];if(_7.name==_1)_6.name=_2;if(_7.derivesFrom==_1)_6.derivesFrom=_2;if(_7.value==_1)_6.value=_2;else if(_7.value&&_7.value.contains(_1)){_6.value=this.replaceVariableNameInValue(_1,_2,_7.value)}
if(_6.name||_6.derivesFrom||_6.value){_6.id=_7.id;_4.add(_6)}}
var _8=isc.DS.get("skinVariables");for(var i=0;i<_4.length;i++){_8.updateData(_4[i])}
this.baseFile.content=this.replaceVariableNameInValue(_1,_2,this.baseFile.content);for(var i=0;i<this.themes.length;i++){var _9=this.themes[i],_3=_9.variablesDS.cacheData;for(var j=0;j<_3.length;j++){var _7=_3[j];if(_7.name==_1)_7.name=_2;if(_7.derivesFrom==_1)_7.derivesFrom=_2;if(_7.value==_1)_7.value=_2;else if(_7.value&&_7.value.contains("$")){_7.value=this.replaceVariableNameInValue(_1,_2,_7.value)}}
_9.customFileContent=this.replaceVariableNameInValue(_1,_2,_9.customFileContent)}},isc.A.addSeriesVariable=function isc_SkinSeries_addSeriesVariable(_1){isc.DS.get("skinVariables").addData(_1)},isc.A.readSection=function isc_SkinSeries_readSection(_1,_2){_2=_2||this.baseFile.content;return isc.SkinFunc.readSection(_1,_2)},isc.A.writeAllMetadata=function isc_SkinSeries_writeAllMetadata(){this.writeMetadataFile();for(var i=0;i<this.themes.length;i++){this.themes[i].writeMetadataFile()}},isc.A.writeAllOther=function isc_SkinSeries_writeAllOther(){this.writeSeriesBaseFile();for(var i=0;i<this.themes.length;i++){this.themes[i].writeThemeFile()}});isc.B._maxIndex=isc.C+16;isc.defineClass("SkinFile");isc.A=isc.SkinFile.getPrototype();isc.A.name=null;isc.A.content="";isc.A.sections=[];isc.defineClass("SkinTheme");isc.A=isc.SkinTheme.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.themeName=null;isc.A.themeFileContent=null;isc.A.themeFontData=null;isc.A.themeVariableData=null;isc.A.customFileContent=null;isc.B.push(isc.A.init=function isc_SkinTheme_init(){this.Super("init",arguments)},isc.A.loadTheme=function isc_SkinTheme_loadTheme(_1,_2){var _3=isc.SkinFunc,_4=this,_5=_2;_4.themeName=_1;isc.DS.get("fileSystemSkin").fetchData({name:_1},function(_6,_7){_4.record=isc.isAn.Array(_7)?_7[0]:_7;_4.readThemeFileSections(_4.skinSettings);_4.parseThemeFile(_7);_4.customFileContent=_7.skinSettingsCustom;_4.themeLoaded(_5)})},isc.A.themeLoaded=function isc_SkinTheme_themeLoaded(_1){if(_1)_1()},isc.A.getSkinSettings=function isc_SkinTheme_getSkinSettings(){},isc.A.readSection=function isc_SkinTheme_readSection(_1,_2){_2=_2||this.themeFileContent;return isc.SkinFunc.readSection(_1,_2)},isc.A.readThemeFileSections=function isc_SkinTheme_readThemeFileSections(_1){this.themeFileContent=_1;this.themeHeaderContent=this.readSection("theme_header")
this.themeFontData=this.readSection("theme_fonts");this.themeVariableData=this.readSection("theme_variables")},isc.A.parseThemeFile=function isc_SkinTheme_parseThemeFile(_1){var _2=isc.SkinMetadata;var _3=_2.parseSettings(this.themeVariableData||"","value");var _4=_2.getVariableMetadataDS().cacheData,_5=[];for(var i=0;i<_4.length;i++){var _7=isc.addProperties({},_4[i]),_8=_3.find("name",_7.name);if(_8)_7.value=_8.value;_5.add(_7)}
this.variablesDS=isc.SkinFunc.getVariablesDS(this.themeName+"VariablesDS",_5);var _9=isc.ResultSet.create({dataSource:this.variablesDS,fetchMode:"local",allRows:this.variablesDS.cacheData});this.variablesRS=_9},isc.A.readMetadataFile=function isc_SkinTheme_readMetadataFile(_1){var _2=isc.SkinFunc,_3=this;var _4=_1||(_2.getOutputPath(true)+"_"+this.themeName+"$194p.js");_2.loadFile(_4,function(_5){_3.themeMetadata=_5;_3.variablesDS=isc.SkinFunc.getVariablesDS(this.themeName+"VariablesDS",_5.variables)})},isc.A.writeMetadataFile=function isc_SkinTheme_writeMetadataFile(_1){var _2=isc.SkinFunc,_3=this;var _4=_1||(_2.getOutputPath(true)+"_"+this.themeName+"$194p.js");this.variablesDS.fetchData(null,function(_6,_7){var _5={};_5.themeName=_3.themeName;_5.variables=_7;_2.saveFile(_5,_4)})},isc.A.writeThemeFile=function isc_SkinTheme_writeThemeFile(_1){var _2=isc.SkinFunc;var _3=_1;if(!_3){_3=_2.getThemeOutputPath(this.themeName)+"$194n"+this.themeName+".scss"}
var _4=_2.getSectionContent("theme_header",this.themeHeaderContent);_4+=_2.getSectionContent("theme_fonts",this.themeFontData)
var _5=this;this.variablesDS.fetchData(null,function(_7,_8){var _6=isc.SkinFunc.getVariableScript(_8,isc.addProperties({},_5.generatorProps,{returnDefaults:false}));_4+=_2.getSectionContent("theme_variables",_6);_2.saveFile(_4,_3)})});isc.B._maxIndex=isc.C+10;isc.defineClass("SkinToolStrip","ToolStrip");isc.A=isc.SkinToolStrip.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.width="100%";isc.A.groupMetadataDS=null;isc.A.variableMetadataDS=null;isc.A.showHelpButton=true;isc.A.helpButtonDefaults={_constructor:"ToolStripButton",iconOnly:true,icon:"[SKINIMG]actions/help.png",hoverAutoFitMaxWidth:400,prompt:"In the Output-Group tree, left-click nodes to see their variables in the grid, right-click nodes to see available options, or edit nodes directly to update group Title or index.<br><br>In the Variable Grid, left-click to manage records in the editor below, right-click to see available options, or edit rows directly.<br><br><b>NOTE:<b>  You must click the 'Save Metadata' button to commit your changes and regenerate the necessary files.",click:function(){isc.say(this.prompt,null,{autoSize:false,minWidth:800})}};isc.A.showSaveMetadataButton=true;isc.A.saveMetadataButtonDefaults={_constructor:"ToolStripButton",showIcon:false,title:"Save Metadata",disabled:true,hoverAutoFitMaxWidth:400,prompt:"Save the metadata and prepare for 'build skins'- does the following:<br><<br>- update the variableMetadata and groupMetadata .json files in skinTools/data<br>- copy $194g.scss to $224b.scss (used to gen per-skin skin_styles_editor.css, for the skinEditor)<br>- token-replace SASS vars (starting '$') with css properties (starting --isc)<br>- update the per-skin $194n{name}.scss and $217y.scss files with latest variables and output groups<br>",click:function(){this.creator.saveMetadata();this.creator.showSaveNotification("All Files")}};isc.A.showRegenDynamicBaseFileButton=false;isc.A.regenDynamicBaseFileButtonDefaults={_constructor:"ToolStripButton",showIcon:false,autoSize:true,autoFit:true,title:"Update Dynamic Base File",hoverAutoFitMaxWidth:400,prompt:"Regenerate _base{Series}$216u.scss, a copy of _base{Series}.scss, instrumented with runtime-mutable css custom properties, rather than SASS variables.  Used to generate skin_styles_editor.css, a secondary version of skin_styles.css, per skin, which the SkinEditor loads in order to provide live updates in the browser.",click:function(){isc.SkinMetadata.regenSeriesDynamicBaseFile("Flat");this.creator.showSaveNotification("Series File")}};isc.A.showRegenAllBaseSkinFilesButton=true;isc.A.regenAllBaseSkinFilesButtonDefaults={_constructor:"ToolStripButton",showIcon:false,autoSize:true,autoFit:true,title:"Prepare Skins",hoverAutoFitMaxWidth:400,prompt:"Regenerate the skin-files with latest changes and prepare the separate $224b.scss file used to produce a second .css file per skin (for the skinEditor)",click:function(){var _1=this;isc.SkinMetadata.regenSeriesDynamicBaseFile("Flat",function(){isc.SkinMetadata.regenAllBaseSkinFiles(function(){_1.creator.showSaveNotification("Skin Files")})})}};isc.B.push(isc.A.initWidget=function isc_SkinToolStrip_initWidget(){this.Super("initWidget",arguments);this.addAutoChild("helpButton");this.addAutoChild("saveMetadataButton");this.addAutoChild("regenDynamicBaseFileButton");this.addAutoChild("regenAllBaseSkinFilesButton");this.observe(this.groupMetadataDS,"dataChanged","observer.groupDataChanged()");this.observe(this.variableMetadataDS,"dataChanged","observer.variableDataChanged()")},isc.A.destroy=function isc_SkinToolStrip_destroy(){this.ignore(this.groupMetadataDS,"dataChanged");this.ignore(this.variableMetadataDS,"dataChanged")},isc.A.saveMetadata=function isc_SkinToolStrip_saveMetadata(){var _1=this;if(this.groupMetadataDirty){isc.SkinMetadata.saveGroupMetaData(this.groupMetadataDS,function(_2){_1.setMetadataDirty(false)})}
if(this.variableMetadataDirty){isc.SkinMetadata.saveVariableMetadata(this.variableMetadataDS,function(){_1.setMetadataDirty(false);_1.regenAllSkinFiles()})}},isc.A.showSaveNotification=function isc_SkinToolStrip_showSaveNotification(_1){isc.notify("Skins updated and prepared for 'build skins' - see developer console for details...",null,null,{position:"T",slideInOrigin:"T",autoFitWidth:true,autoFitMaxWidth:300})},isc.A.groupDataChanged=function isc_SkinToolStrip_groupDataChanged(){this.setMetadataDirty(true,"group")},isc.A.regenAllSkinFiles=function isc_SkinToolStrip_regenAllSkinFiles(){isc.SkinMetadata.regenSeriesDynamicBaseFile();isc.SkinMetadata.regenAllBaseSkinFiles()},isc.A.variableDataChanged=function isc_SkinToolStrip_variableDataChanged(){this.setMetadataDirty(true,"variable")},isc.A.setMetadataDirty=function isc_SkinToolStrip_setMetadataDirty(_1,_2){if(!_2){this.groupMetadataDirty=_1;this.variableMetadataDirty=_1}else if(_2=="group")this.groupMetadataDirty=_1;else if(_2=="variable")this.variableMetadataDirty=_1;if(this.saveMetadataButton)this.saveMetadataButton.setDisabled(!_1)});isc.B._maxIndex=isc.C+8;isc.defineClass("SkinVariablesGrid","ListGrid");isc.A=isc.SkinVariablesGrid.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A._constructor="ListGrid";isc.A.width="100%";isc.A.height="*";isc.A.showResizesBar=true;isc.A.autoFetchData=true;isc.A.dataFetchMode="local";isc.A.autoSaveEdits=true;isc.A.saveLocally=false;isc.A.canEdit=true;isc.A.canGroupBy=true;isc.A.canMultiGroup=true;isc.A.showFilterEditor=true;isc.A.allowFilterExpressions=true;isc.A.filterOnEnter=true;isc.A.showRowNumbers=true;isc.A.allowFilterExpressions=true;isc.A.showClippedValuesOnHover=true;isc.A.canDragRecordsOut=true;isc.A.initialSort=[{property:"outputGroup",direction:"ascending"},{property:"outputIndex",direction:"ascending"}];isc.A.defaultFields=[{name:"name",width:"*"},{name:"title",width:"*"},{name:"value",width:"*"},{name:"category",width:100,showIf:"return false;"},{name:"valueType",width:100},{name:"valueSubType",width:100},{name:"outputGroup",width:150,editorProperties:{valueField:"name",displayField:"title",editorType:"SelectItem",optionDataSource:"groupMetadataDS",dataSetType:"tree",autoOpenTree:"all",dataProperties:{dataFetchMode:"local"},pickListProperties:{autoFitFieldWidths:true,showHeader:true},pickListFields:[{name:"title",width:250,title:"Group"}]}},{name:"outputIndex",title:"Index",width:60}];isc.A.contextMenu={_constructor:"Menu",autoDraw:false,data:[{title:"Add After",click:function(_1,_2,_3,_4){_1.addVariableAfter(_1.getSelectedRecord())}},{title:"Add Before",click:function(_1,_2,_3,_4){_1.addVariableBefore(_1.getSelectedRecord())}},{title:"Edit Variable",click:function(_1,_2,_3,_4){_1.editVariable(_1.getSelectedRecord())}},{isSeparator:true},{title:"Clear Filter",click:function(_1,_2,_3,_4){_1.setCriteria(null)}},{isSeparator:true},{title:"Remove",click:function(_1,_2,_3,_4){_1.removeVariable(_1.getSelectedRecord())}}],width:150};isc.B.push(isc.A.recordClick=function isc_SkinVariablesGrid_recordClick(){this.creator.editor.editRecord(this.getSelectedRecord());this.creator.editor.updateUI()},isc.A.recordDoubleClick=function isc_SkinVariablesGrid_recordDoubleClick(){},isc.A.initWidget=function isc_SkinVariablesGrid_initWidget(){this.fields=this.defaultFields.duplicate();this.fields.add({name:"iscClass",width:150,valueIcons:isc.SkinMetadata.getClassIconValueIcons(),editorProperties:{valueMap:isc.SkinMetadata.getClassIconValueMap()},filterEditorProperties:{valueMap:isc.SkinMetadata.getClassIconValueMap()}});this.Super("initWidget",arguments)},isc.A.addVariableBefore=function isc_SkinVariablesGrid_addVariableBefore(_1){return},isc.A.addVariableAfter=function isc_SkinVariablesGrid_addVariableAfter(_1){return},isc.A.editVariable=function isc_SkinVariablesGrid_editVariable(_1){return},isc.A.removeVariable=function isc_SkinVariablesGrid_removeVariable(_1){return});isc.B._maxIndex=isc.C+7;isc.defineClass("SkinEditor","VLayout");isc.A=isc.SkinEditor.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.defaultSeriesName="Flat";isc.A.defaultSeriesThemeNames=["Tahoe","Stratus","Obsidian","Twilight"];isc.A.loadSeriesButtonDefaults={_constructor:"IButton",title:"Load Series",autoFit:true,click:function(){this.creator.loadSeries()}};isc.A.loadSeriesMetadataButtonDefaults={_constructor:"IButton",title:"Load Series Metadata",autoFit:true,click:function(){this.creator.currentSeries.readMetadataFile()}};isc.A.saveSeriesMetadataButtonDefaults={_constructor:"IButton",title:"Save Series Metadata",autoFit:true,click:function(){this.creator.currentSeries.writeMetadataFile()}};isc.A.saveSeriesBaseFileButtonDefaults={_constructor:"IButton",title:"Save Series SCSS file",autoFit:true,click:function(){this.creator.currentSeries.writeSeriesBaseFile()}};isc.A.renameVariableButtonDefaults={_constructor:"IButton",title:"Rename Variable",autoFit:true,click:function(){var _1=this.creator.variablesGrid,_2=_1.getSelectedRecord();if(!_2)return;isc.SkinFunc.editVariableName(_2,null,_1)}};isc.A.buttonLayoutDefaults={_constructor:"HLayout",width:"100%",height:1,layoutMargin:5,membersMargin:5};isc.A.bodyLayoutDefaults={_constructor:"HLayout",width:"100%",height:"100%",layoutMargin:5,membersMargin:5};isc.A.variablesLayoutDefaults={_constructor:"SkinVariablesLayout",width:"100%",height:"100%",layoutMargin:5};isc.A.skinTreeDefaults={_constructor:"TreeGrid",width:300,height:"100%",showResizeBar:true,dataFetchMode:"local",fields:[{name:"name"}],showOpenIcons:false,showDropIcons:false,showSelectedIcons:true,closedIconSuffix:"",nodeClick:function(_1,_2){this.creator.nodeClicked(_2)}};isc.A.variableMetadataDS=null;isc.A.groupMetadataDS=null;isc.B.push(isc.A.nodeClicked=function isc_SkinEditor_nodeClicked(_1){if(!_1)return;if(_1.id=="styleTester"){var _2="../colorTester.jsp?skin="+isc.getCurrentSkinName();window.open(_2)}else if(_1.id=="paletteTools"){isc.showPaletteTools(true)}else if(_1.id=="stateEditor"){var _2="stateEditor.jsp?skin="+isc.getCurrentSkinName();window.open(_2)}
if(_1.hasVariablesDS){this.setVariablesGridDataSource(_1.variablesDS||_1.classObj.variablesDS,_1.classObj.variablesRS)}},isc.A.showNodePane=function isc_SkinEditor_showNodePane(_1){switch(_1.id){case"seriesMetadata":this.setVariablesGridDataSource(this.currentSeries);default:}},isc.A.gridViewForOutput=function isc_SkinEditor_gridViewForOutput(){var _1=this.variablesGrid;_1.groupBy(["outputGroup"]);_1.setSort([{property:"outputIndex",direction:"ascending"}])},isc.A.initWidget=function isc_SkinEditor_initWidget(_1){this.Super("initWidget",arguments);this.initRibbon();this.addAutoChild("bodyLayout");this.addMember(this.bodyLayout);this.addAutoChild("skinTree");this.bodyLayout.addMember(this.skinTree);this.initSkinTree();this.addAutoChild("variablesLayout");this.bodyLayout.addMember(this.variablesLayout);this.variablesGrid=this.variablesLayout.grid;this.variableEditor=this.variablesLayout.editor;this.autoLoadSeries=true;if(this.autoLoadSeries){this.loadSeries()}},isc.A.initRibbon=function isc_SkinEditor_initRibbon(){var _1=function(_6,_7,_8){return isc.IconButton.create(isc.addProperties({title:_6,icon:"pieces/16/cube_blue.png",largeIcon:"pieces/48/cube_blue.png",click:_7},_8))};var _2=function(_6,_7,_8){return isc.IconMenuButton.create(isc.addProperties({title:_6,icon:"pieces/16/piece_blue.png",largeIcon:"pieces/48/piece_blue.png",click:_7},_8))}
var _3=[];if(2==1){_3.add(_1("Load Series",function(){var _4=this.seriesUI.defaultSeriesName,_5=this.seriesUI.defaultSeriesThemeNames.duplicate();this.seriesUI.loadSeries(_4,_5)},{seriesUI:this}));_3.add(_1("Read Metadata",function(){this.seriesUI.currentSeries.readAllMetadata()},{seriesUI:this}))}
_3.add(_1("Write Metadata",function(){this.seriesUI.currentSeries.writeAllMetadata()},{seriesUI:this}));_3.add(_1("Write SCSS Files",function(){this.seriesUI.currentSeries.writeAllOther()},{seriesUI:this}));this.seriesRibbonGroup=isc.RibbonGroup.create({title:"Series",numRows:1,colWidths:[40,"*"],controls:_3,autoDraw:false});this.ribbonBar=isc.RibbonBar.create({groupTitleAlign:"center",groupTitleOrientation:"top"});this.ribbonBar.addGroup(this.seriesRibbonGroup,0);this.addMember(this.ribbonBar,0)},isc.A.initSkinTree=function isc_SkinEditor_initSkinTree(){var _1=this.skinTree;var _2=isc.DS.get("variablesDS");_1.setData(isc.Tree.create({modelType:"children",nameProperty:"name",root:{id:"top",name:"Skin Manager",children:[{id:"seriesEditor",name:"Series Editor",children:[]},{id:"utilities",name:"Tools & Utilities",children:[{id:"styleTester",name:"Style Tester",children:[]},{id:"paletteTools",name:"Palette Tools",children:[]},{id:"stateEditor",name:"State Editor",children:[]}]}]}}));_1.getData().openAll()},isc.A.loadSeries=function isc_SkinEditor_loadSeries(_1,_2){_1=_1||this.defaultSeriesName;_2=_2||this.defaultSeriesThemeNames.duplicate();var _3=this;isc.SkinFunc.loadSeries(_1,_2,function(_4){_3.seriesLoaded(_4)})},isc.A.setVariablesGridDataSource=function isc_SkinEditor_setVariablesGridDataSource(_1,_2){this.variablesGrid.setDataSource(_1,this.variablesGrid.getFields());this.variablesGrid.setData(_2);this.variableEditor.setDataSource(_1)},isc.A.seriesLoaded=function isc_SkinEditor_seriesLoaded(_1){this.currentSeries=_1;var _2=this.skinTree.getData(),_3=_2.find("id","seriesEditor");var _4=_2.add({id:"_series_"+_1.seriesName,name:_1.seriesName+" Series",classObj:_1},_3);var _5=_2.add({id:_1.seriesName+"MetadataFile",name:"Skin Variables",hasVariablesDS:true,classObj:_1},_4);var _6=_2.add({id:_1.seriesName+"BaseFile",name:"Base SCSS File",classObj:_1},_4);var _7=_2.add({id:_1.seriesName+"SeriesThemes",name:"Themes",children:[]},_4);for(var i=0;i<_1.themes.length;i++){var _9=_1.themes[i],_10={};_10.id="_theme_"+_9.themeName;_10.name=_9.themeName;_10.hasVariablesDS=true
_10.classObj=_9;_10.children=[{id:"_theme_file_"+_10.name,name:"Theme SCSS File",classObj:_9},{id:"_theme_variables_"+_10.name,name:"Theme Variables",hasVariablesDS:true,classObj:_9},{id:"_theme_custom_"+_10.name,name:"Custom Styles",classObj:_9},{id:"_theme_showcase_"+_10.name,name:"Showcase Styles",classObj:_9},{id:"_theme_fonts_"+_10.name,name:"Theme Fonts",classObj:_9}];_2.add(_10,_7)}
_2.openFolders([_3,_4,_7]);this.skinTree.selectRecord(_5);this.nodeClicked(_5);this.delayCall("gridViewForOutput")});isc.B._maxIndex=isc.C+9;isc.defineClass("SkinVariablesLayout","VLayout");isc.A=isc.SkinVariablesLayout.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.membersMargin=10;isc.A.gridButtonLayoutDefaults={_constructor:"HLayout",width:"100%",height:1,layoutMargin:5,membersMargin:5};isc.A.viewAllButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/add.png",title:"View All",autoFit:true,autoParent:"gridButtonLayout",click:function(){var _1=this.creator.variablesGrid;_1.clearGroupBy();_1.setSort({property:"name",direction:"ascending"})}};isc.A.viewForOutputButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/sort.png",title:"View for Output",autoFit:true,autoParent:"gridButtonLayout",click:function(){this.creator.gridViewForOutput()}};isc.A.gridDefaults={_constructor:"SkinVariablesGrid",addVariableBefore:function(_1){this.creator.addVariable("before",_1)},addVariableAfter:function(_1){this.creator.addVariable("after",_1)},editVariable:function(_1){this.creator.editVariable(_1)},removeVariable:function(_1){this.creator.removeVariable(_1)}};isc.A.editorDefaults={_constructor:"SkinVariableEditor",width:"100%",height:1,overflow:"visible"};isc.A.variableMetadataDS=null;isc.A.groupMetadataDS=null;isc.B.push(isc.A.initWidget=function isc_SkinVariablesLayout_initWidget(){this.Super("initWidget",arguments);this.addAutoChild("grid",{dataSource:this.variableMetadataDS});this.addAutoChild("editor",{dataSource:this.variableMetadataDS,groupMetadataDS:this.groupMetadataDS})},isc.A.addVariable=function isc_SkinVariablesLayout_addVariable(_1,_2,_3){if(!_2&&!_3){isc.say("Select a record to copy from the top grid.");return}
var _4=this.variableMetadataDS.cacheData,_5=_3||_4.find("name",_2.name);if(_5){_5=this.grid.getCleanRecordData(_5);_5.id=_4.getProperty("id").max()+1;if(_1=="before")_5.outputIndex-=2;else if(_1=="after")_5.outputIndex+=2;else _5.outputIndex=10;_5.name=null;_5.title=null;_5.valueType=null;_5.valueSubType=null;_5.category=null;_5.derivesFrom=null;_5.basic=1;this.editor.addRecord(_5);return}},isc.A.editVariable=function isc_SkinVariablesLayout_editVariable(_1){this.editor.editRecord(_1);this.editor.disableUI(false)},isc.A.removeVariable=function isc_SkinVariablesLayout_removeVariable(_1){this.grid.removeData(_1)});isc.B._maxIndex=isc.C+4;isc.SkinFunc.editSkinVariable=function(_1,_2){var _3=isc.SkinVariableEditor.create({dataSource:_2});isc.Window.create({width:"80%",height:"80%",backgroundColor:"white",title:"Edit Skin Variable",children:[_3],autoCenter:true});_3.editRecord(_1)}
isc.defineClass("SkinVariableEditor","VLayout");isc.A=isc.SkinVariableEditor.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.membersMargin=10;isc.A.layoutMargin=10;isc.A.buttonLayoutDefaults={_constructor:"HLayout",width:"100%",height:1,membersMargin:10};isc.A.addButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/add.png",title:"Add Variable",click:function(){this.creator.addRecord()}};isc.A.editButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/edit.png",title:"Edit",click:function(){this.creator.disableUI(false)}};isc.A.saveButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/save.png",title:"Save",showDisabledIcon:false,click:function(){this.creator.saveRecord()}};isc.A.cancelButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/cancel.png",title:"Cancel",showDisabledIcon:false,click:function(){this.creator.cancelEdit()}};isc.A.renameButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/exclamation.png",title:"Rename",showDisabledIcon:false,click:function(){this.creator.renameVariable()}};isc.A.removeButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/remove.png",title:"Remove",showDisabledIcon:false,click:function(){this.creator.removeVariable()}};isc.A.editorDefaults={_constructor:"DynamicForm",width:"100%",numCols:8};isc.B.push(isc.A.initWidget=function isc_SkinVariableEditor_initWidget(){this.Super("initWidget",arguments);this.addAutoChild("buttonLayout");this.addMember(this.buttonLayout);this.addAutoChildren(["addButton","editButton","saveButton","cancelButton","renameButton","removeButton"]);this.buttonLayout.addMembers([this.addButton,this.editButton,this.saveButton,this.cancelButton,this.renameButton,this.removeButton]);this.defaultFields=[{name:"id",showIf:"false",width:"*"},{name:"name",blur:function(){var v=this.getValue();if(v&&v.length>0){var _2=this.form;v=v.trim();while(v.startsWith("$")){v=v.substring(1)};while(v.endsWith(":")){v=v.substring(0,v.length-1)};this.form.getItem("title").parseNameToTitle(v);v="$"+v;this.setValue(v);var _3=_2.getItem("valueType");var _4=_2.getItem("valueSubType");var _5=_2.getItem("category");_5.clearValue();_4.clearValue();_3.clearValue();var _6=v.lastIndexOf("_");var _7=(_6>=0?v.substring(_6):v).toLowerCase();if(_7=="$217z"||_7=="$2170"||_7=="$2171"){_4.clearValue();_3.setValue("color");_4.setValue("background");_5.setValue("color")}else if(_7=="$194e"||_7=="$2172"){_4.clearValue();_3.setValue("color");_4.setValue("border");_5.setValue("color")}else if(_7=="$194f"||_7=="$2173"){_4.clearValue();_3.setValue("color");_4.setValue("color");_5.setValue("color")}else if(_7.startsWith("$216g")){_4.clearValue();_5.setValue("border");_3.setValue("border");if(_7=="$216g")_4.setValue("border");else if(_7.contains("width"))_4.setValue("width");else if(_7.contains("radius"))_4.setValue("radius")}else if(_7.contains("padding")){_4.clearValue();_3.setValue("padding");_4.setValue("padding");_5.setValue("padding")}else if(_7.contains("margin")){_4.clearValue();_3.setValue("margin");_4.setValue("margin");_5.setValue("margin")}else if(_7.startsWith("$2174")){_4.clearValue();_5.setValue("font");_3.setValue("font");if(_7=="$2174"||_7.contains("family"))_4.setValue("family");else if(_7.contains("size"))_4.setValue("size");else if(_7.contains("weight"))_4.setValue("weight");else if(_7.contains("align"))_4.setValue("align")}else if(_7.contains("line")&&_7.contains("height")){_4.clearValue();_3.setValue("font");_4.setValue("lineheight");_5.setValue("font")}else if(_7.contains("text")&&_7.contains("align")){_4.clearValue();_3.setValue("font");_4.setValue("align");_5.setValue("font")}}}},{name:"title",width:"*",parseNameToTitle:function(_13){if(!_13||_13=="")return;var _8=_13[0].toUpperCase();for(var i=1;i<_13.length;i++){var _10=_13[i];if(_10=="_"){_8+=" ";i++;_10=_13[i];_8+=_10.toUpperCase()}else{_8+=_10}}
this.setValue(_8)}},{name:"valueType",width:"*",valueMap:this.getPickerValueMap("valueType"),changed:function(_2,_13,_11){_2.getItem("valueSubType").clearValue();_2.getItem("valueSubType").invalidateDisplayValueCache();_2.creator.filterValueSubTypeItem(_11)}},{name:"valueSubType",title:"Sub-type",editorType:"SelectItem",width:"*"},{name:"category",title:"Category",valueMap:this.getPickerValueMap("category")},{name:"value",blur:function(){var v=this.getValue();var _11=v;if(v&&v.length>0){v=v.trim();while(v.endsWith(";")){v=v.substring(0,v.length-1)};if(v!=_11)this.setValue(v);if(v.startsWith("$")&&!v.contains(" ")){var _12=this.form;this.form.dataSource.fetchData({"name":v},function(_13,_14){if(_14&&_14.length==1){_12.getItem("derivesFrom").setValue(_14[0].name)}})}}}},{name:"derivesFrom",editorProperties:{autoFetchData:true,addUnknownValues:false},editorType:"ComboBoxItem",optionDataSource:this.dataSource,valueField:"name",displayField:"name"},{name:"outputGroup",editorProperties:{valueField:"name",displayField:"title",editorType:"SelectItem",optionDataSource:"groupMetadataDS",dataSetType:"tree",autoOpenTree:"all",pickListProperties:{autoFitFieldWidths:true,showHeader:true},pickListFields:[{name:"title",width:250,title:"Group"}]}},{name:"outputIndex"},{name:"iscClass",valueIcons:isc.SkinMetadata.getClassIconValueIcons(),valueMap:isc.SkinMetadata.getClassIconValueMap()}];this.addAutoChild("editor",{dataSource:this.dataSource,fields:this.defaultFields});this.addMember(this.editor);if(this.record)this.editRecord(this.record);this.disableUI(true)},isc.A.getPickerValueMap=function isc_SkinVariableEditor_getPickerValueMap(_1){var _2=this.dataSource.cacheData;return _2.getProperty(_1).getUniqueItems()},isc.A.getValueSubTypeList=function isc_SkinVariableEditor_getValueSubTypeList(_1){var _2=this.dataSource.cacheData;var _3=!_1?_2:_2.findAll("valueType",_1);var _4=_3.getProperty("valueSubType").getUniqueItems();return _4},isc.A.filterValueSubTypeItem=function isc_SkinVariableEditor_filterValueSubTypeItem(_1){var _2=this.getValueSubTypeList(_1);var _3=this.editor.getItem("valueSubType");_3.invalidateDisplayValueCache();_3.setValueMap(_2)},isc.A.disableUI=function isc_SkinVariableEditor_disableUI(_1){this.updateUI(_1)},isc.A.updateUI=function isc_SkinVariableEditor_updateUI(_1){if(_1==null)_1=!this.addButton.isDisabled();this.addButton.setDisabled(!_1);this.editButton.setDisabled(!_1);this.renameButton.setDisabled(true);this.removeButton.setDisabled(this.editor.getValue("id")==null||this.editor.getSaveOperationType()=="add");this.saveButton.setDisabled(_1);this.cancelButton.setDisabled(_1);this.editor.setDisabled(_1)},isc.A.setDataSource=function isc_SkinVariableEditor_setDataSource(_1){this.dataSource=_1;this.editor.setDataSource(this.dataSource,isc.shallowClone(this.defaultFields))},isc.A.editRecord=function isc_SkinVariableEditor_editRecord(_1){this.$194q="edit";this.editor.editRecord(_1)},isc.A.cancelEdit=function isc_SkinVariableEditor_cancelEdit(){this.$194q="none";this.disableUI(true);this.editor.resetValues()},isc.A.getNextDSId=function isc_SkinVariableEditor_getNextDSId(){var _1=this.creator.variablesGrid.data.getProperty("id").max();return _1+1},isc.A.addRecord=function isc_SkinVariableEditor_addRecord(_1){_1=_1||{};this.$194q="add";this.disableUI(false);this.editor.clearValues();this.editor.editNewRecord(_1)},isc.A.clearRecord=function isc_SkinVariableEditor_clearRecord(){this.$194q=null;this.disableUI(true);this.editor.clearValues()},isc.A.renameVariable=function isc_SkinVariableEditor_renameVariable(){var _1=isc.SkinFunc.currentSeries,_2=this.editor.getItem("name").getValue();isc.logWarn("name is "+_2);isc.SkinFunc.editVariableName(_2,_1,this.creator.variablesGrid)},isc.A.removeVariable=function isc_SkinVariableEditor_removeVariable(){this.editor.getDataSource().removeData(this.editor.getValues());this.clearRecord();this.updateUI()},isc.A.saveRecord=function isc_SkinVariableEditor_saveRecord(_1){var _2=this;this.editor.saveData(function(_3,_4){if(_3.status==0){isc.say("Variable saved.");_2.clearRecord();if(_2.$194q=="add")_2.recordAdded(_4);else _2.recordSaved(_4)}})},isc.A.recordAdded=function isc_SkinVariableEditor_recordAdded(_1){},isc.A.recordSaved=function isc_SkinVariableEditor_recordSaved(_1){});isc.B._maxIndex=isc.C+17;isc.defineClass("SkinColorEditor","DynamicForm");isc.A=isc.SkinColorEditor.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.membersMargin=10;isc.A.layoutMargin=10;isc.A.buttonLayoutDefaults={_constructor:"HLayout",width:"100%",height:1,membersMargin:10};isc.A.addButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/add.png",title:"Add Variable",click:function(){this.creator.addRecord()}};isc.A.saveButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/save.png",title:"Save",click:function(){this.creator.saveRecord()}};isc.A.editorDefaults={_constructor:"DynamicForm",width:"100%",numCols:6};isc.B.push(isc.A.initWidget=function isc_SkinColorEditor_initWidget(){this.Super("initWidget",arguments);this.addAutoChild("buttonLayout");this.addMember(this.buttonLayout);this.addAutoChildren(["addButton","saveButton"]);this.buttonLayout.addMembers([this.addButton,this.saveButton]);this.addAutoChild("editor",{dataSource:this.dataSource});this.addMember(this.editor)},isc.A.setDataSource=function isc_SkinColorEditor_setDataSource(_1){this.dataSource=_1;this.editor.setDataSource(this.dataSource)},isc.A.editRecord=function isc_SkinColorEditor_editRecord(_1){this.$194q="edit";this.editor.editRecord(_1)},isc.A.addRecord=function isc_SkinColorEditor_addRecord(_1){this.$194q="add";this.editor.editNewRecord(_1)},isc.A.clearRecord=function isc_SkinColorEditor_clearRecord(){this.$194q=null;this.editor.clearValues()},isc.A.saveRecord=function isc_SkinColorEditor_saveRecord(_1){var _2=this;this.editor.saveData(function(_3,_4){if(!_3.status==0){isc.say("Variable saved.");_2.clearRecord();if(_2.$194q=="add")_2.recordAdded(_4);else _2.recordSaved(_4)}})},isc.A.recordAdded=function isc_SkinColorEditor_recordAdded(_1){},isc.A.recordSaved=function isc_SkinColorEditor_recordSaved(_1){});isc.B._maxIndex=isc.C+8;isc.defineClass("ColorTransformer","VLayout");isc.A=isc.ColorTransformer.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.autoDraw=true;isc.A.formDefaults={_constructor:"DynamicForm",numCols:6,minWidth:600,minColWidth:900,colWidths:[100,120,100,120,100,120],fields:[{name:"inputColor",width:"*",editorType:"ColorItem",title:"Color",changed:function(_1,_2,_3){_1.creator.setColor(_3)}},{name:"transform",editorType:"SelectItem",title:"Transform",width:"*",valueMap:isc.SkinFunc.transformTypes,changed:function(_1,_2,_3){if(_3=="custom"||_3=="none"){_1.hideItem("transformDelta");if(_3=="custom"){_1.showItem("customTransform")}}else{_1.hideItem("customTransform");_1.showItem("transformDelta")}
_1.creator.changeTransform(_3)}},{name:"transformedColor",editorType:"ColorItem",width:"*",title:"Result"},{name:"transformDelta",type:"integer",width:"*",editorType:"SliderItem",title:"Change By %",height:30,min:0,max:100,colSpan:"*",sliderProperties:{showRange:false},visible:false,changed:function(_1,_2,_3){_1.creator.changeTransformDelta(_3)}},{name:"customTransform",editorType:"TextAreaItem",title:"Custom",showHintInField:true,hint:"Javascript function-body that returns a color value",width:"*",height:60,colSpan:"*",visible:false,changeOnKeypress:false,changeOnEnter:true,changed:function(_1,_2,_3){_1.creator.changeCustomTransform(_3)}}]};isc.A.transform="none";isc.A.transformDelta=0;isc.B.push(isc.A.initWidget=function isc_ColorTransformer_initWidget(){this.Super("initWidget",arguments);this.addAutoChild("form");this.addMember(this.form);if(this.color)this.setColor(this.color)},isc.A.setColor=function isc_ColorTransformer_setColor(_1){this.inputColor=_1;this.color=isc.tinycolor(_1);if(this.transformDelta)this.startTransformDelta=this.transformDelta;this.updateForm()},isc.A.changeTransform=function isc_ColorTransformer_changeTransform(_1){this.transform=_1;this.updateForm()},isc.A.changeTransformDelta=function isc_ColorTransformer_changeTransformDelta(_1){this.transformDelta=_1;this.updateForm()},isc.A.changeCustomTransform=function isc_ColorTransformer_changeCustomTransform(_1){this.customTransform=_1;this.updateForm()},isc.A.updateForm=function isc_ColorTransformer_updateForm(){var c=isc.tinycolor(this.color);if(c.isValid()){var _2=c.toHexString();if(this.transform=="custom"){var _3=isc.isA.Function(this.customTransform)?this.customTransform:isc.$aq("color",this.customTransform);this.transformedColor=_3.apply(this,[c])}else if(this.transform=="none"){this.transformedColor=_2}else{this.transformedColor=isc.SkinFunc.transformColor(_2,this.transform,this.transformDelta)}
this.form.setValues({"inputColor":_2,"transform":this.transform,"transformDelta":this.transformDelta,"customTransform":this.customTransform,"transformedColor":this.transformedColor})}else{this.form.setValues({"inputColor":this.inputColor})}
if(this.transform=="custom")this.form.showItem("customTransform")
else if(this.transform!="none"){this.form.showItem("transformDelta")}});isc.B._maxIndex=isc.C+6;isc.defineClass("ColorTransformerItem","CanvasItem");isc.A=isc.ColorTransformerItem.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.height=1;isc.A.overflow="visible";isc.A.canvasConstructor="ColorTransformer";isc.B.push(isc.A.setValue=function isc_ColorTransformerItem_setValue(_1){var _2=_1==null?null:_1.split("::");if(_2&&_2.length>0){this.canvas.transformDelta=0;this.canvas.customTransform=null;this.canvas.transform=_2[1];if(_2[1]!="none"){if(_2.length>2){if(this.transform=="custom"){this.canvas.customTransform=_2[1]}else{this.canvas.transformDelta=_2[1]}}}
this.canvas.setColor(_2[0])}},isc.A.getValue=function isc_ColorTransformerItem_getValue(){var f=this.canvas,_2=f.transform;if(_2!="none"){_2+="::";if(_2=="custom"){_2+=f.customTransform}else{_2+=f.transformDelta}}
return _2});isc.B._maxIndex=isc.C+2;isc.defineClass("SkinVariableGroupEditor","VLayout");isc.A=isc.SkinVariableGroupEditor.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.buttonLayoutDefaults={_constructor:"HLayout",width:"100%",height:1};isc.A.addButtonDefaults={_constructor:"IButton",title:"Add Group",autoFit:true,autoParent:"buttonLayout",click:function(){this.creator.addGroup()}};isc.A.editButtonDefaults={_constructor:"IButton",title:"Edit",autoFit:true,autoParent:"buttonLayout",click:function(){this.creator.startEditing()}};isc.A.saveButtonDefaults={_constructor:"IButton",title:"Save",autoFit:true,autoParent:"buttonLayout",click:function(){this.creator.saveRecord()}};isc.A.cancelButtonDefaults={_constructor:"IButton",title:"Cancel",autoFit:true,autoParent:"buttonLayout",click:function(){this.creator.cancelEdit()}};isc.A.formDefaults={_constructor:"DynamicForm"};isc.B.push(isc.A.initWidget=function isc_SkinVariableGroupEditor_initWidget(){this.Super("initWidget",arguments);this.addAutoChild("buttonLayout");this.addMember(this.buttonLayout);this.addAutoChildren(["addButton","editButton","saveButton","cancelButton"]);var _1=[{name:"parentId",title:"Parent",valueField:"name",displayField:"title",optionDataSource:"groupMetadataDS",dataSetType:"tree",defaultValue:"none"},{name:"name"},{name:"title"},{name:"comment"},{name:"index"},{name:"iscClass",valueIcons:isc.SkinMetadata.getClassIconValueIcons(),valueMap:isc.SkinMetadata.getClassIconValueMap()}];this.addAutoChild("form",{dataSource:this.dataSource,fields:_1});this.addMember(this.form)},isc.A.editRecord=function isc_SkinVariableGroupEditor_editRecord(_1){this.form.editRecord(_1)},isc.A.editNewRecord=function isc_SkinVariableGroupEditor_editNewRecord(_1){this.form.editNewRecord(_1)},isc.A.saveRecord=function isc_SkinVariableGroupEditor_saveRecord(){var _1=this.form.getValues();if(!_1.parentId||_1.parentId=="")_1.parentId="none";if(this.form.saveOperationType=="add")this.dataSource.addData(_1);else this.dataSource.updateData(_1)
this.hide()},isc.A.cancelEdit=function isc_SkinVariableGroupEditor_cancelEdit(){this.hide()});isc.B._maxIndex=isc.C+5;isc.defineClass("SkinVariableGroupTree","TreeGrid");isc.A=isc.SkinVariableGroupTree.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.autoFetchData=true;isc.A.canAcceptDroppedRecords=true;isc.A.canReparentNodes=true;isc.A.dataFetchMode="local";isc.A.dataProperties={loadDataOnDemand:false,autoOpenRoot:"root"};isc.A.showFilterEditor=true;isc.A.allowFilterExpressions=true;isc.A.fields=[{name:"name",showIf:"false"},{name:"title",width:"*",canFilter:true},{name:"index",width:70}];isc.A.initialSort=[{property:"index",direction:"ascending"}];isc.A.sortByGroupfirst=true;isc.A.groupEditorDefaults={_constructor:"SkinVariableGroupEditor",backgroundColor:"white"};isc.A.contextMenu={_constructor:"Menu",autoDraw:false,data:[{title:"Add Child Group",click:function(_1,_2,_3,_4){_1.addChildGroup(_1.getSelectedRecord())}},{title:"Add Root Group",click:function(_1,_2,_3,_4){_1.addChildGroup(null)}},{title:"Edit Group",click:function(_1,_2,_3,_4){_1.editGroup(_1.getSelectedRecord())}},{title:"Remove Group",click:function(_1,_2,_3,_4){_1.removeGroup(_1.getSelectedRecord())}},{isSeparator:true},{title:"Add Variable",click:function(_1,_2,_3,_4){_1.addVariableToGroup(_1.getSelectedRecord(),null)}}],width:150};isc.B.push(isc.A.dataArrived=function isc_SkinVariableGroupTree_dataArrived(){this.data.openAll();var _1=this.data.getOpenList();_1.map(function(_2){_2.isFolder=true})},isc.A.dataChanged=function isc_SkinVariableGroupTree_dataChanged(){this.data.openAll();var _1=this.data.getOpenList();_1.map(function(_2){_2.isFolder=true})},isc.A.nodeClick=function isc_SkinVariableGroupTree_nodeClick(_1,_2,_3){if(!this.data.isOpen(_2))this.openFolder(_2);this.Super("nodeClick",arguments)},isc.A.initWidget=function isc_SkinVariableGroupTree_initWidget(){this.Super("initWidget",arguments);this.nodeIcon=this.folderIcon},isc.A.getGroupEditor=function isc_SkinVariableGroupTree_getGroupEditor(){if(!this.groupEditor){this.groupEditor=this.createAutoChild("groupEditor",{dataSource:this.dataSource})}
return this.groupEditor},isc.A.addChildGroup=function isc_SkinVariableGroupTree_addChildGroup(_1){var _2=this.getGroupEditor(),_3={parentId:null,iscClass:null};if(_1){_3.parentId=_1.name;_3.name=_1.name+"_";if(_1.iscClass){_3.iscClass=_1.iscClass;var _4=isc.Class.getClassIcon(_3.iscClass);if(_4){_3.icon=_4.src}}}
_2.editNewRecord(_3);this.showEditor()},isc.A.addVariableToGroup=function isc_SkinVariableGroupTree_addVariableToGroup(_1){this.creator.variablesLayout.addVariable("end",null,{outputGroup:_1.name})},isc.A.showEditor=function isc_SkinVariableGroupTree_showEditor(){var _1=this.getGroupEditor();if(!_1.isDrawn())_1.draw();_1.moveTo((isc.Page.getWidth()/2)-(_1.getWidth()/2),(isc.Page.getHeight()/2)-(_1.getHeight()/2));_1.show()},isc.A.editGroup=function isc_SkinVariableGroupTree_editGroup(_1){var _2=this.getGroupEditor();var _3=this.data.getCleanNodeData(_1);_2.editRecord(_3);this.showEditor()},isc.A.removeGroup=function isc_SkinVariableGroupTree_removeGroup(_1){this.getDataSource().removeData(_1)},isc.A.folderDrop=function isc_SkinVariableGroupTree_folderDrop(_1,_2,_3,_4){if(_4!=this){if(_4==this.creator.grid){for(var i=0;i<_1.length;i++){_1[i].outputGroup=_2.name;this.creator.grid.updateData(_1[i])}
return false}}
return this.Super("folderDrop",arguments)});isc.B._maxIndex=isc.C+11;isc.defineClass("SkinMetadataEditor","VLayout");isc.A=isc.SkinMetadataEditor.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.toolStripDefaults={_constructor:"SkinToolStrip"};isc.A.groupTreeDefaults={_constructor:"SkinVariableGroupTree",width:300,showResizeBar:true,autoParent:"bodyLayout",canEdit:true,nodeClick:function(_1,_2,_3){this.creator.showGroupVariables(_2)}};isc.A.variablesLayoutDefaults={_constructor:"SkinVariablesLayout",width:"*",height:"100%",autoParent:"bodyLayout"};isc.A.bodyLayoutDefaults={_constructor:"HLayout",width:"100%",height:"*"};isc.A.groupMetadataDS=null;isc.A.variableMetadataDS=null;isc.B.push(isc.A.initWidget=function isc_SkinMetadataEditor_initWidget(){this.Super("initWidget",arguments);var _1=isc.SkinMetadata;if(!this.variableMetadataDS)this.variableMetadataDS=_1.getVariableMetadataDS();if(!this.groupMetadataDS)this.groupMetadataDS=_1.getGroupMetadataDS();this.addAutoChild("toolStrip",{groupMetadataDS:this.groupMetadataDS,variableMetadataDS:this.variableMetadataDS});this.addAutoChild("bodyLayout");this.addMember(this.bodyLayout);this.addAutoChild("groupTree",{dataSource:this.groupMetadataDS});this.addAutoChild("variablesLayout",{variableMetadataDS:this.variableMetadataDS,groupMetadataDS:this.groupMetadataDS});this.grid=this.variablesLayout.grid},isc.A.showGroupVariables=function isc_SkinMetadataEditor_showGroupVariables(_1){this.grid.fetchData({fieldName:"outputGroup",operator:"iStartsWith",value:_1.name},null,{invalidateCache:true})},isc.A.getGroupEditor=function isc_SkinMetadataEditor_getGroupEditor(){return this.groupTree&&this.groupTree.groupEditor},isc.A.addChildGroup=function isc_SkinMetadataEditor_addChildGroup(_1){if(this.groupTree)this.groupTree.addChildGroup(_1)},isc.A.editGroupRecord=function isc_SkinMetadataEditor_editGroupRecord(_1){if(this.groupTree)this.groupTree.editGroup(_1)});isc.B._maxIndex=isc.C+5;isc.getButtonsPane=function(){var _1="colorTester_buttonsPane";if(isc.SkinUtil.testPanes[_1]!=null){return isc.SkinUtil.testPanes[_1]}
var _2=isc.Menu.create({autoDraw:false,showShadow:true,shadowDepth:10,data:[{title:"New",keyTitle:"Ctrl+N",icon:"[SKINIMG]actions/add.png"},{title:"Open",keyTitle:"Ctrl+O",icon:"[SKINIMG]actions/view.png"},{isSeparator:true},{title:"Save",keyTitle:"Ctrl+S",icon:"[SKINIMG]actions/save.png"},{title:"Search",icon:"[SKINIMG]actions/search.png"},{isSeparator:true},{title:"Recent Documents",icon:"[SKINIMG]actions/dynamic.png",submenu:[{title:"data.xml",checked:true},{title:"Component Guide.doc"},{title:"SmartClient.doc",checked:true},{title:"AJAX.doc"}]},{isSeparator:true},{title:"Print",enabled:false,keyTitle:"Ctrl+P",icon:"[SKINIMG]actions/print.png"}]});var _3=isc.ToolStripMenuButton.create({title:"File",menu:_2});var _4=isc.ToolStripButton.create({icon:"[SKIN]/RichTextEditor/print.png",title:"Print"});var _5=isc.ToolStripButton.create({icon:"[SKIN]/RichTextEditor/text_align_left.png",actionType:"radio",radioGroup:"textAlign"});var _6=isc.ToolStripButton.create({icon:"[SKIN]/RichTextEditor/text_align_right.png",actionType:"radio",radioGroup:"textAlign"});var _7=isc.ToolStripButton.create({icon:"[SKIN]/RichTextEditor/text_align_center.png",actionType:"radio",radioGroup:"textAlign"});var _8=isc.ToolStripButton.create({icon:"[SKIN]/RichTextEditor/text_bold.png",actionType:"checkbox",showFocused:false,showFocusOutline:true});var _9=isc.ToolStripButton.create({icon:"[SKIN]/RichTextEditor/text_italic.png",actionType:"checkbox",showFocused:false,showFocusOutline:true});var _10=isc.ToolStripButton.create({icon:"[SKIN]/RichTextEditor/text_underline.png",actionType:"checkbox",showFocused:false,showFocusOutline:true});var _11=isc.DynamicForm.create({showResizeBar:true,width:120,minWidth:50,numCols:1,fields:[{name:"selectFont",showTitle:false,width:"*",valueMap:{"courier":"<span style='font-family:courier'>Courier</span>","verdana":"<span style='font-family:verdana'>Verdana</span>","times":"<span style='font-family:times'>Times</span>"},defaultValue:"courier"}]});var _12=isc.DynamicForm.create({width:100,minWidth:50,numCols:1,fields:[{name:"selectZoom",showTitle:false,width:"*",valueMap:["50%","75%","100%","150%","200%","Fit"],defaultValue:"100%"}]});var _13=isc.ToolStrip.create({members:[_3,"separator",_4,"resizer",_8,_9,_10,"separator",_5,_6,_7,"separator",_11,"resizer",_12]});var _14={_constructor:"Menu",autoDraw:false,showShadow:true,shadowDepth:10,data:[{title:"Document",keyTitle:"Ctrl+D",icon:"[SKINIMG]actions/edit.png"},{title:"Picture",keyTitle:"Ctrl+P",icon:"[SKINIMG]actions/close.png"},{title:"Email",keyTitle:"Ctrl+E",icon:"[SKINIMG]actions/accept.png"}]};var _15=function(_27,_28){return isc.RibbonButton.create(isc.addProperties({title:_27,icon:"[SKINIMG]actions/add.png",largeIcon:"[SKINIMG]actions/add.png",click:"isc.say(this.title + ' button clicked');"},_28))};var _16=isc.RibbonGroup.create({title:"File (vertical icons)",numRows:2,colWidths:[40,"*"],titleAlign:"left",controls:[_15("New",{vertical:true,menu:_14,showMenuIconOver:false}),_15("Open",{vertical:true,largeIcon:"[SKINIMG]actions/accept.png"}),_15("Save",{vertical:true,largeIcon:"[SKINIMG]actions/save.png"}),_15("Save As",{vertical:true,menu:_14,largeIcon:"[SKINIMG]actions/add.png"})],autoDraw:false});var _17=isc.RibbonGroup.create({title:"Editing Tools",numRows:2,colWidths:[40,"*"],controls:[_15("Edit",{icon:"[SKINIMG]actions/edit.png"}),_15("Copy",{icon:"[SKINIMG]actions/refresh.png"}),_15("Undo",{menu:_14,showMenuIconOver:false,icon:"[SKINIMG]actions/add.png"}),_15("Redo",{menu:_14,icon:"[SKINIMG]actions/accept.png"})],autoDraw:false});var _18=isc.RibbonGroup.create({title:"Insert",numRows:2,colWidths:[40,"*"],controls:[_15("Picture",{vertical:true,menu:_14,largeIcon:"[SKINIMG]actions/add.png"}),_15("Link",{icon:"[SKINIMG]actions/edit.png"}),_15("Video",{icon:"[SKINIMG]actions/help.png"})],autoDraw:false});var _19=isc.RibbonBar.create({groupTitleAlign:"center",groupTitleOrientation:"top"});_19.addGroup(_16,0);_19.addGroup(_17,1);_19.addGroup(_18,2);var _20=isc.Menu.create({autoDismiss:false,fields:["title",{name:"canDismiss",width:16,showValueIconOnly:true,valueIcons:{"true":"[SKINIMG]actions/close.png"}}],data:[{name:"Item 1"},{name:"Item 2",canDismiss:true},{name:"Item 3",canDismiss:true}],itemClick:function(_27,_28){if(_28==1&&_27.canDismiss){this.removeItem(_27)}else{isc.say("You Selected '"+_27.name+"'.");this.hide()}}});var _21=isc.MenuButton.create({autoDraw:false,title:"Show Menu",menu:_20});var _22=isc.Button.create({autoFit:true,title:"CSS Button",iconSize:12,icon:"[SKINIMG]headerIcons/person.png"});var _23=isc.IButton.create({title:"Stretch Button",width:150,iconSize:12,icon:"[SKINIMG]headerIcons/person.png"});var _24=isc.ImgButton.create({width:18,height:18,src:"[SKIN]/ImgButton/button.png"});var _25=isc.NavigationBar.create({width:500,leftButtonTitle:"Back",rightButtonTitle:"Forward",showRightButton:true,title:"NavBar Title",navigationClick:function(_27){if(_27==="back"){isc.say("Back button clicked!")}else if(_27==="forward"){isc.say("Forward button clicked!")}}});var _26=isc.FlowLayout.create({layoutMargin:10,membersMargin:20,width:"100%",height:"100%",autoDraw:false,tiles:[_21,_22,_23,_24,_25,_13,_19]});isc.SkinUtil.testPanes[_1]=_26;return isc.SkinUtil.testPanes[_1]}
isc.getCubesPane=function(){var _1="colorTester_cubesPane";if(isc.SkinUtil.testPanes[_1]!=null){return isc.SkinUtil.testPanes[_1]}
var _2=[{quarter:"Q1, 2016",month:"January",region:"Western U.S.",product:"Pens",metric:"Revenue",_value:10000,percentNational:25},{quarter:"Q1, 2016",month:"January",region:"Western U.S.",product:"Chairs",metric:"Revenue",_value:50000,percentNational:45},{quarter:"Q1, 2016",month:"January",region:"Western U.S.",product:"Monitors",metric:"Revenue",_value:120000,percentNational:49},{quarter:"Q1, 2016",month:"January",region:"Western U.S.",product:"Pens",metric:"Profit",_value:2000,percentNational:25},{quarter:"Q1, 2016",month:"January",region:"Western U.S.",product:"Chairs",metric:"Profit",_value:5000,percentNational:45},{quarter:"Q1, 2016",month:"January",region:"Western U.S.",product:"Monitors",metric:"Profit",_value:44000,percentNational:59,_hilite:"over50"},{quarter:"Q1, 2016",month:"January",region:"Midwest U.S.",product:"Pens",metric:"Revenue",_value:8000,percentNational:20},{quarter:"Q1, 2016",month:"January",region:"Midwest U.S.",product:"Chairs",metric:"Revenue",_value:22000,percentNational:20},{quarter:"Q1, 2016",month:"January",region:"Midwest U.S.",product:"Monitors",metric:"Revenue",_value:20000,percentNational:8,_hilite:"under10"},{quarter:"Q1, 2016",month:"January",region:"Midwest U.S.",product:"Pens",metric:"Profit",_value:2000,percentNational:25},{quarter:"Q1, 2016",month:"January",region:"Midwest U.S.",product:"Chairs",metric:"Profit",_value:2000,percentNational:18},{quarter:"Q1, 2016",month:"January",region:"Midwest U.S.",product:"Monitors",metric:"Profit",_value:5000,percentNational:7,_hilite:"under10"},{quarter:"Q1, 2016",month:"January",region:"Eastern U.S.",product:"Pens",metric:"Revenue",_value:22000,percentNational:55,_hilite:"over50"},{quarter:"Q1, 2016",month:"January",region:"Eastern U.S.",product:"Chairs",metric:"Revenue",_value:40000,percentNational:36},{quarter:"Q1, 2016",month:"January",region:"Eastern U.S.",product:"Monitors",metric:"Revenue",_value:105000,percentNational:43},{quarter:"Q1, 2016",month:"January",region:"Eastern U.S.",product:"Pens",metric:"Profit",_value:4000,percentNational:50,_hilite:"over50"},{quarter:"Q1, 2016",month:"January",region:"Eastern U.S.",product:"Chairs",metric:"Profit",_value:4000,percentNational:36},{quarter:"Q1, 2016",month:"January",region:"Eastern U.S.",product:"Monitors",metric:"Profit",_value:25000,percentNational:34},{quarter:"Q1, 2016",month:"February",region:"Western U.S.",product:"Pens",metric:"Revenue",_value:12000,percentNational:23},{quarter:"Q1, 2016",month:"February",region:"Western U.S.",product:"Chairs",metric:"Revenue",_value:42000,percentNational:47},{quarter:"Q1, 2016",month:"February",region:"Western U.S.",product:"Monitors",metric:"Revenue",_value:160000,percentNational:40},{quarter:"Q1, 2016",month:"February",region:"Western U.S.",product:"Pens",metric:"Profit",_value:4000,percentNational:23},{quarter:"Q1, 2016",month:"February",region:"Western U.S.",product:"Chairs",metric:"Profit",_value:4000,percentNational:47},{quarter:"Q1, 2016",month:"February",region:"Western U.S.",product:"Monitors",metric:"Profit",_value:68000,percentNational:40},{quarter:"Q1, 2016",month:"February",region:"Midwest U.S.",product:"Pens",metric:"Revenue",_value:10000,percentNational:19},{quarter:"Q1, 2016",month:"February",region:"Midwest U.S.",product:"Chairs",metric:"Revenue",_value:12000,percentNational:13},{quarter:"Q1, 2016",month:"February",region:"Midwest U.S.",product:"Monitors",metric:"Revenue",_value:75000,percentNational:19},{quarter:"Q1, 2016",month:"February",region:"Midwest U.S.",product:"Pens",metric:"Profit",_value:3000,percentNational:20},{quarter:"Q1, 2016",month:"February",region:"Midwest U.S.",product:"Chairs",metric:"Profit",_value:1000,percentNational:11},{quarter:"Q1, 2016",month:"February",region:"Midwest U.S.",product:"Monitors",metric:"Profit",_value:32000,percentNational:17},{quarter:"Q1, 2016",month:"February",region:"Eastern U.S.",product:"Pens",metric:"Revenue",_value:31000,percentNational:58,_hilite:"over50"},{quarter:"Q1, 2016",month:"February",region:"Eastern U.S.",product:"Chairs",metric:"Revenue",_value:35000,percentNational:39},{quarter:"Q1, 2016",month:"February",region:"Eastern U.S.",product:"Monitors",metric:"Revenue",_value:164000,percentNational:41},{quarter:"Q1, 2016",month:"February",region:"Eastern U.S.",product:"Pens",metric:"Profit",_value:8000,percentNational:53,_hilite:"over50"},{quarter:"Q1, 2016",month:"February",region:"Eastern U.S.",product:"Chairs",metric:"Profit",_value:4000,percentNational:44},{quarter:"Q1, 2016",month:"February",region:"Eastern U.S.",product:"Monitors",metric:"Profit",_value:88000,percentNational:47},{quarter:"Q1, 2016",month:"March",region:"Western U.S.",product:"Pens",metric:"Revenue",_value:18000,percentNational:26},{quarter:"Q1, 2016",month:"March",region:"Western U.S.",product:"Chairs",metric:"Revenue",_value:25000,percentNational:54,_hilite:"over50"},{quarter:"Q1, 2016",month:"March",region:"Western U.S.",product:"Monitors",metric:"Revenue",_value:220000,percentNational:40},{quarter:"Q1, 2016",month:"March",region:"Western U.S.",product:"Pens",metric:"Profit",_value:9000,percentNational:29},{quarter:"Q1, 2016",month:"March",region:"Western U.S.",product:"Chairs",metric:"Profit",_value:2000,percentNational:40},{quarter:"Q1, 2016",month:"March",region:"Western U.S.",product:"Monitors",metric:"Profit",_value:112000,percentNational:38},{quarter:"Q1, 2016",month:"March",region:"Midwest U.S.",product:"Pens",metric:"Revenue",_value:7000,percentNational:10},{quarter:"Q1, 2016",month:"March",region:"Midwest U.S.",product:"Chairs",metric:"Revenue",_value:6000,percentNational:13},{quarter:"Q1, 2016",month:"March",region:"Midwest U.S.",product:"Monitors",metric:"Revenue",_value:135000,percentNational:25},{quarter:"Q1, 2016",month:"March",region:"Midwest U.S.",product:"Pens",metric:"Profit",_value:2000,percentNational:6,_hilite:"under10"},{quarter:"Q1, 2016",month:"March",region:"Midwest U.S.",product:"Chairs",metric:"Profit",_value:1000,percentNational:20},{quarter:"Q1, 2016",month:"March",region:"Midwest U.S.",product:"Monitors",metric:"Profit",_value:66000,percentNational:23},{quarter:"Q1, 2016",month:"March",region:"Eastern U.S.",product:"Pens",metric:"Revenue",_value:44000,percentNational:64,_hilite:"over50"},{quarter:"Q1, 2016",month:"March",region:"Eastern U.S.",product:"Chairs",metric:"Revenue",_value:15000,percentNational:33},{quarter:"Q1, 2016",month:"March",region:"Eastern U.S.",product:"Monitors",metric:"Revenue",_value:190000,percentNational:35},{quarter:"Q1, 2016",month:"March",region:"Eastern U.S.",product:"Pens",metric:"Profit",_value:20000,percentNational:65,_hilite:"over50"},{quarter:"Q1, 2016",month:"March",region:"Eastern U.S.",product:"Chairs",metric:"Profit",_value:2000,percentNational:40},{quarter:"Q1, 2016",month:"March",region:"Eastern U.S.",product:"Monitors",metric:"Profit",_value:115000,percentNational:39}];var _3=isc.CubeGrid.create({data:_2,width:800,height:400,hideEmptyFacetValues:true,valueFormat:"\u00A4,0.00",columnFacets:["quarter","month","metric"],rowFacets:["region","product"]});var _4=isc.FlowLayout.create({layoutMargin:10,membersMargin:20,width:"100%",height:"100%",autoDraw:false,tiles:[_3]});isc.SkinUtil.testPanes[_1]=_4;return isc.SkinUtil.testPanes[_1]}
isc.getFormItemsPane=function(){var _1="colorTester_formItemsPane";if(isc.SkinUtil.testPanes[_1]!=null){return isc.SkinUtil.testPanes[_1]}
var _2=function(_18){_18=_18||_6.getValue("readOnlyDisplayPicker");_10.setReadOnlyDisplay(_18);_12.setReadOnlyDisplay(_18);_13.setReadOnlyDisplay(_18);_14.setReadOnlyDisplay(_18)}
var _3=function(_5){_2();_10.setCanEdit(_5);_12.setCanEdit(_5);_13.setCanEdit(_5);_14.setCanEdit(_5)}
var _4=isc.IButton.create({title:"setCanEdit(false)",autoFit:true,autoDraw:false,click:function(){if(this.title=="setCanEdit(false)")this.setTitle("setCanEdit(true)");else this.setTitle("setCanEdit(false)");var _5=this.title=="setCanEdit(false)";_3(_5)}});var _6=isc.DynamicForm.create({numCols:2,colWidths:[120,140],wrapItemTitles:false,autoDraw:false,fields:[{name:"readOnlyDisplayPicker",title:"ReadOnly Display",width:"*",valueMap:["static","readOnly","disabled"],defaultValue:"disabled",changed:function(){_2(this.getValue())}}]});var _7=isc.ToolStrip.create({members:[_4,_6]});var _8=function(_18){if(_18=="animals"){return{"cat":"Cat","dog":"Dog","giraffe":"Giraffe","goat":"Goat","marmoset":"Marmoset","mouse":"Mouse"}}else if(_18=="countries"){return{"US":"United States","CH":"China","JA":"Japan","IN":"India","GM":"Germany","FR":"France","IT":"Italy","RS":"Russia","BR":"Brazil","CA":"Canada","MX":"Mexico","SP":"Spain"}}}
var _9=isc.Tree.create({modelType:"children",root:{name:"root",children:[{id:1000,name:"Marketing",children:[{id:1001,name:"Advertising"},{id:1002,name:"Community Relations"}]},{id:2000,name:"Sales",children:[{id:2001,name:"Channel Sales"},{id:2002,name:"Direct Sales"}]},{id:3000,name:"Manufacturing",children:[{id:3001,name:"Design"},{id:3002,name:"Development"},{id:3003,name:"QA"}]},{id:4000,name:"Services",children:[{id:4001,name:"Support"},{id:4002,name:"Consulting"}]}]}});isc.DataSource.create({ID:"clientOnlyUsersDS",clientOnly:true,fields:[{name:"id",title:"ID",type:"integer",primaryKey:true,hidden:true},{name:"name",title:"Name"}],cacheData:[{id:1,name:"Max"},{id:2,name:"Bethany"},{id:3,name:"Zach"},{id:4,name:"Francesca"}]});isc.DataSource.create({ID:"clientOnlyUserFavoritesDS",clientOnly:true,fields:[{name:"id",title:"ID",type:"integer",primaryKey:true,hidden:true},{name:"userID",type:"integer",foreignKey:"clientOnlyUsersDS.id",title:"User ID"},{name:"favoriteAnimal",title:"TextItem"},{name:"favoriteNumber",type:"number",title:"Slider"},{name:"hasFavoriteColor",title:"CheckBox - Has Favorite?",type:"boolean"},{name:"favoriteColor",title:"Radio - Favorite",valueMap:["Red","Green","Blue"]},{name:"favoriteDate",type:"date",title:"DateItem"},{name:"favoriteTime",type:"time",title:"TimeItem"},{name:"favoriteMusicGenres",multiple:true,title:"PickTreeItem",valueMap:["Alternative","Classical","Country","Folk","Hip Hop","Jazz","Pop","R&B","Rock","World","Other"]},{name:"favoriteVacationDestination",title:"SelectItem",valueMap:_8("countries")},{name:"comboBoxItem1",title:"ComboBoxItem",editorType:"ComboBoxItem",valueMap:_8("countries")},{name:"favoriteCuisines",multiple:true,title:"Favorite Cuisines",valueMap:_8("countries")},{name:"favoriteDepartment",title:"Favorite Department"}],cacheData:[{id:1,userID:1,favoriteAnimal:"Lemur",favoriteNumber:90,spinner:1,unstackedSpinner:1,hasFavoriteColor:false,favoriteDate:isc.Date.createLogicalDate(2000,0,1),favoriteTime:isc.Date.createLogicalTime(0,0),favoriteMusicGenres:["Folk"],favoriteVacationDestination:"JA",comboBoxItem1:"JA",favoriteCuisines:["IN","RS"],favoriteDepartment:4002},{id:2,userID:2,favoriteAnimal:"Zebra",favoriteNumber:12,spinner:2,unstackedSpinner:2,hasFavoriteColor:true,favoriteColor:"Orange",favoriteDate:isc.Date.createLogicalDate(2012,11,12),favoriteTime:isc.Date.createLogicalTime(12,12),favoriteMusicGenres:["Alternative","Hip Hop"],favoriteVacationDestination:"US",favoriteCuisines:["US","UK"],favoriteDepartment:3002},{id:3,userID:3,favoriteAnimal:"Elephant",favoriteNumber:10,spinner:3,unstackedSpinner:3,hasFavoriteColor:true,favoriteColor:"Green",favoriteDate:isc.Date.createLogicalDate(2010,9,10),favoriteTime:isc.Date.createLogicalTime(10,10),favoriteMusicGenres:["Country","Folk"],favoriteVacationDestination:"MX",favoriteCuisines:["GM","MX"],favoriteDepartment:1001},{id:4,userID:4,favoriteAnimal:"Blue Whale",favoriteNumber:55,spinner:4,unstackedSpinner:4,hasFavoriteColor:true,favoriteColor:"Blue",favoriteDate:isc.Date.createLogicalDate(2005,4,5),favoriteTime:isc.Date.createLogicalTime(12,0),favoriteMusicGenres:["Pop","R&B","Other"],favoriteVacationDestination:"SP",favoriteCuisines:["FR","IT","KS","SP"],favoriteDepartment:3001}]});var _10=isc.DynamicForm.create({ID:"pendingForm",autoDraw:false,autoFetchData:true,isGroup:true,groupTitle:"Pending Values - Change 'User' to see normal styles",initialCriteria:{userID:1},width:500,numCols:3,colWidths:[175,200,10],dataSource:isc.DS.get("clientOnlyUserFavoritesDS"),revertValueKey:"Escape",items:[{name:"userID",title:"User",editorType:"SelectItem",optionDataSource:isc.DS.get("clientOnlyUsersDS"),valueField:"id",displayField:"name",width:"*",changed:function(_18,_19,_20){_18.fetchData({userID:_20},function(_21,_22,_23){var _11=(_22!=null&&_22.length>=1&&!!_22[0].hasFavoriteColor)
_18.getItem("favoriteColor").setDisabled(!_11)})}},{name:"favoriteAnimal",width:"*",showPending:true},{name:"favoriteAnimal2",editorType:"TextAreaItem",height:40,width:"*",title:"TextArea",showPending:true},{name:"spinner",title:"Spinner",editorType:"SpinnerItem",writeStackedIcons:true,width:"*",min:0,max:10,step:0.5,wrapTitle:false,showPending:true},{name:"unstackedSpinner",title:"Unstacked Spinner",editorType:"SpinnerItem",writeStackedIcons:false,width:"*",min:0,max:10,step:0.5,wrapTitle:false,showPending:true},{name:"favoriteDate",editorType:"DateItem",width:"*",showPending:true},{name:"favoriteTime",editorType:"TimeItem",width:"*",showPending:true},{name:"favoriteMusicGenres",title:"MultiComboBoxItem",editorType:"MultiComboBoxItem",useInsertionOrder:false,width:"*",colSpan:"*",showPending:true},{name:"favoriteVacationDestination",wrapTitle:false,editorType:"SelectItem",width:"*",showPending:true},{name:"comboBoxItem1",wrapTitle:false,editorType:"ComboBoxItem",width:"*",showPending:true},{name:"favoriteCuisines",editorType:"SelectItem",title:"Old Value Hovers",width:"*",colSpan:"*",showPending:true,showOldValueInHover:true},{name:"favoriteDepartment",editorType:"PickTreeItem",title:"PickTreeItem",width:"*",displayField:"name",valueField:"id",valueTree:_9,showPending:true},{name:"favoriteNumber",editorType:"SliderItem",title:"SliderItem",width:"*",minValue:0,maxValue:100,showPending:true},{name:"hasFavoriteColor",type:"checkbox",width:"*",showPending:true,changed:function(_18,_19,_20){_18.getItem("favoriteColor").setDisabled(!_20)}},{name:"favoriteColor",type:"radioGroup",disabled:true,width:"*",showPending:true}]});var _12=isc.DynamicForm.create({width:360,showErrorStyle:true,autoDraw:false,colWidths:[190,200],showErrorText:true,errorOrientation:"bottom",isGroup:true,groupTitle:"Validation Errors",fields:[{name:"text",title:"Text",type:"text",required:true,width:"*"},{name:"colorPicker",title:"Color Picker",type:"color",required:true,width:"*"},{name:"textArea",title:"TextArea",type:"textArea",required:true,width:"*"},{name:"spinner",title:"Spinner",editorType:"SpinnerItem",writeStackedIcons:true,width:"*",min:0,max:10,step:0.5,wrapTitle:false,required:true},{name:"unstackedSpinner",title:"Unstacked Spinner",editorType:"SpinnerItem",writeStackedIcons:false,width:"*",min:0,max:10,step:0.5,wrapTitle:false,required:true},{name:"checkbox",title:"Checkbox",type:"checkbox",height:25,required:true,width:"*"},{name:"radioGroup",title:"Radio Group",type:"radioGroup",required:true,width:"*",valueMap:["Option 1","Option 2"]},{name:"validate",title:"Validate",type:"button",click:function(){this.form.validate()}}],values:{slider:4}});_12.validate();var _13=isc.DynamicForm.create({width:500,colWidths:[170,"*"],autoDraw:false,isGroup:true,groupTitle:"Select / Combo Controls",fields:[{name:"bugStatus",title:"ComboBox",hint:"<nobr>A simple comboBox</nobr>",editorType:"ComboBoxItem",valueMap:_8("animals")},{name:"countryName",title:"Databound ComboBox",hint:"<nobr>A databound comboBox</nobr>",editorType:"ComboBoxItem",optionDataSource:isc.DS.get("sp_country")},{name:"selectItem2",title:"Select with Styles",hint:"<nobr>A select with styled entries</nobr>",editorType:"SelectItem",valueMap:{"red":"<span style='color:#FF0000;'>Red</span>","green":"<span style='color:#00FF00;'>Green</span>","blue":"<span style='color:#0000FF;'>Blue</span>"}},{name:"selectItemMultipleGrid",title:"Select Multiple (Grid)",editorType:"SelectItem",multiple:true,multipleAppearance:"grid",valueMap:_8("animals")},{name:"selectItemMultiplePickList",title:"Select Multiple (PickList)",editorType:"SelectItem",multiple:true,multipleAppearance:"picklist",valueMap:_8("animals")}]});var _14=isc.DynamicForm.create({width:500,fixedColWidths:true,colWidths:[120,"*"],isGroup:true,autoDraw:false,groupTitle:"Date Controls",fields:[{name:"dateItem",title:"Date",hint:"<nobr>Picklist based date input</nobr>",editorType:"DateItem"},{name:"dateItem2",title:"Date",hint:"<nobr>Direct date input</nobr>",editorType:"DateItem",useTextField:true},{name:"timeItem",title:"Time",editorType:"TimeItem"},{name:"timeItem2",title:"Time",hint:"Picklist based time input",editorType:"TimeItem",useTextField:false},{name:"dri",title:"Date Range",width:400,editorType:"DateRangeItem",allowRelativeDates:true,fromDate:"$today",toDate:"-1m"},{name:"mdri",title:"Mini Date Range",editorType:"MiniDateRangeItem"},{name:"rdi",title:"Relative Date",editorType:"RelativeDateItem"}]});var _15=isc.DetailViewer.create({autoDraw:false,width:300,fields:[{name:"header",type:"header",value:"DetailViewer Header"},{name:"field1",title:"First Field"},{name:"field2",title:"Another Field"}],data:[{header:"DetailViewer Header",field1:"Value of the first field",field2:"Another value, with some longer text"}]});_10.fetchData({userId:1},function(_18,_19){_10.setValue("favoriteAnimal","Changed value");_10.setValue("favoriteAnimal2","Changed value");_10.setValue("favoriteNumber",73);_10.setValue("spinner",5);_10.setValue("unstackedSpinner",5);_10.setValue("favoriteDate",isc.Date.createLogicalDate(2012,11,12));_10.setValue("favoriteTime",isc.Date.createLogicalTime(12,12));_10.setValue("favoriteMusicGenres",["Country","Folk"]);_10.setValue("favoriteVacationDestination","US");_10.setValue("favoriteCuisines",["US","UK"]);_10.setValue("favoriteDepartment",3002);_10.setValue("hasFavoriteColor",true);_10.setValue("favoriteColor","Red");_10.getItem("favoriteColor").setDisabled(false)});var _16=isc.FlowLayout.create({layoutMargin:10,membersMargin:20,width:"100%",height:"100%",autoDraw:false,tiles:[_10,_12,_13,_14,_15]});var _17=isc.VLayout.create({layoutMargin:10,membersMargin:20,width:"100%",height:"100%",autoDraw:false,members:[_7,_16]});isc.SkinUtil.testPanes[_1]=_17;return isc.SkinUtil.testPanes[_1]}
isc.getGridsPane=function(){isc.DS.create({ID:"sp_employee",clientOnly:true,fields:[{name:"userOrder",title:"User Order",type:"integer",canEdit:false,hidden:true},{name:"Name",title:"Name",type:"text",length:128},{name:"EmployeeId",title:"Employee ID",type:"integer",primaryKey:true,required:true},{name:"ReportsTo",title:"Manager",type:"integer",required:true,foreignKey:"employees.EmployeeId",rootValue:"1",detail:true},{name:"Job",title:"Title",type:"text",length:128},{name:"Email",title:"Email",type:"text",length:128},{name:"EmployeeType",title:"Employee Type",type:"text",length:40},{name:"EmployeeStatus",title:"Status",type:"text",length:40},{name:"Salary",title:"Salary",type:"float"},{name:"OrgUnit",title:"Org Unit",type:"text",length:128},{name:"Gender",title:"Gender",type:"text",length:7,valueMap:["male","female"]},{name:"MaritalStatus",title:"Marital Status",type:"text",length:10,valueMap:["married","single"]}],cacheData:[{EmployeeId:"4",ReportsTo:"1",Name:"Charles Madigen",Job:"Chief Operating Officer",Phone:"x10962",Email:"cmadigan@server.com",OrgUnit:"Management",Salary:26200.00,Gender:"male",MaritalStatus:"married",EmployeeType:"full time",EmployeeStatus:"active",isOpen:true},{EmployeeId:"189",ReportsTo:"4",Name:"Gene Porter",Job:"Mgr Tech Plng IntIS T",Phone:"x30358",Email:"gporter@server.com",OrgUnit:"Management",Salary:18100.00,Gender:"female",MaritalStatus:"married",EmployeeType:"contract",EmployeeStatus:"LOA"},{EmployeeId:"265",ReportsTo:"189",Name:"Olivier Doucet",Job:"Asset Spec Lines Stns",Phone:"x22873",Email:"odoucet@server.com",OrgUnit:"Management",Salary:5450.00,Gender:"male",MaritalStatus:"married",EmployeeType:"part time",EmployeeStatus:"active"},{EmployeeId:"264",ReportsTo:"189",Name:"Cheryl Pearson",Job:"Dsl Sys Rep",Phone:"x17370",Email:"cpearson@server.com",OrgUnit:"Management",Salary:5650.00,Gender:"female",MaritalStatus:"single",EmployeeType:"full time",EmployeeStatus:"active"},{EmployeeId:"263",ReportsTo:"189",Name:"Priya Sambhus",Job:"Line Wrker A",Phone:"x21746",Email:"psambhus@server.com",OrgUnit:"Management",Salary:6100.00,Gender:"male",MaritalStatus:"married",EmployeeType:"full time",EmployeeStatus:"active"},{EmployeeId:"188",ReportsTo:"4",Name:"Rogine Leger",Job:"Mgr Syst P P",Phone:"x04145",Email:"rleger@server.com",OrgUnit:"Management",Salary:10500.00,Gender:"female",MaritalStatus:"single",EmployeeType:"contract",EmployeeStatus:"LOA",isOpen:true},{EmployeeId:"262",ReportsTo:"188",Name:"Jacques Desautels",Job:"Line Wrker A",Phone:"x12796",Email:"jdesautels@server.com",OrgUnit:"Management",Salary:7950.00,Gender:"female",MaritalStatus:"married",EmployeeType:"full time",EmployeeStatus:"LOA"},{EmployeeId:"261",ReportsTo:"188",Name:"Kay Monroe",Job:"Stn Opr",Phone:"x01941",Email:"kmonroe@server.com",OrgUnit:"Management",Salary:9500.00,Gender:"female",MaritalStatus:"married",EmployeeType:"full time",EmployeeStatus:"active"},{EmployeeId:"260",ReportsTo:"188",Name:"Francine Dugas",Job:"Fire Sec Off",Phone:"x13382",Email:"fdugas@server.com",OrgUnit:"Management",Salary:8900.00,Gender:"female",MaritalStatus:"single",EmployeeType:"full time",EmployeeStatus:"LOA"},{EmployeeId:"259",ReportsTo:"188",Name:"Jacques Leblanc",Job:"Purch Clk",Phone:"x30117",Email:"jleblanc@server.com",OrgUnit:"Management",Salary:9000.00,Gender:"female",MaritalStatus:"married",EmployeeType:"full time",EmployeeStatus:"LOA"},{EmployeeId:"258",ReportsTo:"188",Name:"Ren Xian",Job:"Mobile Eq Opr",Phone:"x03557",Email:"rxian@server.com",OrgUnit:"Management",Salary:6750.00,Gender:"male",MaritalStatus:"single",EmployeeType:"full time",EmployeeStatus:"active"},{EmployeeId:"257",ReportsTo:"188",Name:"Olivier Hebert",Job:"Met Read/Coll",Phone:"x21093",Email:"ohebert@server.com",OrgUnit:"Management",Salary:7900.00,Gender:"male",MaritalStatus:"married",EmployeeType:"contract",EmployeeStatus:"LOA"},{EmployeeId:"182",ReportsTo:"4",Name:"Tamara Kane",Job:"Mgr Site Services",Phone:"x14279",Email:"tkane@server.com",OrgUnit:"Management",Salary:11900.00,Gender:"female",MaritalStatus:"single",EmployeeType:"part time",EmployeeStatus:"active"},{EmployeeId:"195",ReportsTo:"182",Name:"Kai Kong",Job:"Stores Worker",Phone:"x08410",Email:"kkong@server.com",OrgUnit:"Management",Salary:9900.00,Gender:"female",MaritalStatus:"married",EmployeeType:"full time",EmployeeStatus:"active"},{EmployeeId:"194",ReportsTo:"182",Name:"Felicia Piper",Job:"Dsl Sys Rep",Phone:"x16613",Email:"fpiper@server.com",OrgUnit:"Management",Salary:8950.00,Gender:"female",MaritalStatus:"single",EmployeeType:"full time",EmployeeStatus:"LOA"},{EmployeeId:"193",ReportsTo:"182",Name:"Darcy Feeney",Job:"Inventory Ck",Phone:"x31751",Email:"dfeeney@server.com",OrgUnit:"Management",Salary:9900.00,Gender:"female",MaritalStatus:"married",EmployeeType:"full time",EmployeeStatus:"LOA"}]});isc.DS.create({ID:"sp_country",clientOnly:true,fields:[{name:"pk",type:"integer",hidden:true,primaryKey:true},{name:"countryCode",type:"text",title:"Code",required:true},{name:"countryName",type:"text",title:"Country",required:true},{name:"capital",type:"text",title:"Capital"},{name:"government",type:"text",title:"Government",length:500},{name:"continent",type:"text",title:"Continent",valueMap:["Europe","Asia","North America","Australia/Oceania","South America","Africa"]},{name:"member_g8",type:"boolean",title:"G8"},{name:"independence",type:"date",title:"Nationhood"},{name:"area",type:"float",title:"Area (km&amp;sup2;)",format:",0"},{name:"population",type:"integer",title:"Population",format:",0"},{name:"gdp",type:"float",title:"GDP",format:"&#x00A4;,0.0M"},{name:"article",type:"link",title:"Info",detail:"true"}],cacheData:[{continent:"North America",countryName:"United States",countryCode:"US",area:9631420,population:298444215,gdp:12360000,independence:new Date(1776,6,4),government:"federal republic",government_desc:2,capital:"Washington, DC",member_g8:true,article:"http://en.wikipedia.org/wiki/United_states",background:"Britain's American colonies broke with the mother country in 1776 and were recognized as the new nation of the United States of America following the Treaty of Paris in 1783. During the 19th and 20th centuries, 37 new states were added to the original 13 as the nation expanded across the North American continent and acquired a number of overseas possessions. The two most traumatic experiences in the nation's history were the Civil War (1861-65) and the Great Depression of the 1930s. Buoyed by victories in World Wars I and II and the end of the Cold War in 1991, the US remains the world's most powerful nation state. The economy is marked by steady growth, low unemployment and inflation, and rapid advances in technology."},{continent:"Asia",countryName:"China",countryCode:"CH",area:9596960,population:1313973713,gdp:8859000,government:"Communist state",government_desc:0,capital:"Beijing",member_g8:false,article:"http://en.wikipedia.org/wiki/China",background:"For centuries China stood as a leading civilization, outpacing the rest of the world in the arts and sciences, but in the 19th and early 20th centuries, the country was beset by civil unrest, major famines, military defeats, and foreign occupation. After World War II, the Communists under MAO Zedong established an autocratic socialist system that, while ensuring China's sovereignty, imposed strict controls over everyday life and cost the lives of tens of millions of people. After 1978, his successor DENG Xiaoping and other leaders focused on market-oriented economic development and by 2000 output had quadrupled. For much of the population, living standards have improved dramatically and the room for personal choice has expanded, yet political controls remain tight."},{continent:"Asia",countryName:"Japan",countryCode:"JA",area:377835,population:127463611,gdp:4018000,government:"constitutional monarchy with parliamentary government",government_desc:1,capital:"Tokyo",member_g8:true,article:"http://en.wikipedia.org/wiki/Japan",background:"In 1603, a Tokugawa shogunate (military dictatorship) ushered in a long period of isolation from foreign influence in order to secure its power. For 250 years this policy enabled Japan to enjoy stability and a flowering of its indigenous culture. Following the Treaty of Kanagawa with the US in 1854, Japan opened its ports and began to intensively modernize and industrialize. During the late 19th and early 20th centuries, Japan became a regional power that was able to defeat the forces of both China and Russia. It occupied Korea, Formosa (Taiwan), and southern Sakhalin Island. In 1931-32 Japan occupied Manchuria, and in 1937 it launched a full-scale invasion of China. Japan attacked US forces in 1941 - triggering America's entry into World War II - and soon occupied much of East and Southeast Asia. After its defeat in World War II, Japan recovered to become an economic power and a staunch ally of the US. While the emperor retains his throne as a symbol of national unity, actual power rests in networks of powerful politicians, bureaucrats, and business executives. The economy experienced a major slowdown starting in the 1990s following three decades of unprecedented growth, but Japan still remains a major economic power, both in Asia and globally. In 2005, Japan began a two-year term as a non-permanent member of the UN Security Council."},{continent:"Asia",countryName:"India",countryCode:"IN",area:3287590,population:1095351995,gdp:3611000,independence:new Date(1947,7,15),government:"federal republic",government_desc:2,capital:"New Delhi",member_g8:false,article:"http://en.wikipedia.org/wiki/India",background:"The Indus Valley civilization, one of the oldest in the world, dates back at least 5,000 years. Aryan tribes from the northwest infiltrated onto Indian lands about 1500 B.C.; their merger with the earlier Dravidian inhabitants created the classical Indian culture. Arab incursions starting in the 8th century and Turkish in the 12th were followed by those of European traders, beginning in the late 15th century. By the 19th century, Britain had assumed political control of virtually all Indian lands. Indian armed forces in the British army played a vital role in both World Wars. Nonviolent resistance to British colonialism led by Mohandas GANDHI and Jawaharlal NEHRU brought independence in 1947. The subcontinent was divided into the secular state of India and the smaller Muslim state of Pakistan. A third war between the two countries in 1971 resulted in East Pakistan becoming the separate nation of Bangladesh. Despite impressive gains in economic investment and output, India faces pressing problems such as the ongoing dispute with Pakistan over Kashmir, massive overpopulation, environmental degradation, extensive poverty, and ethnic and religious strife."},{continent:"Europe",countryName:"Germany",countryCode:"GM",area:357021,population:82422299,gdp:2504000,independence:new Date(1871,0,18),government:"federal republic",government_desc:2,capital:"Berlin",member_g8:true,article:"http://en.wikipedia.org/wiki/Germany",background:"As Europe's largest economy and second most populous nation, Germany remains a key member of the continent's economic, political, and defense organizations. European power struggles immersed Germany in two devastating World Wars in the first half of the 20th century and left the country occupied by the victorious Allied powers of the US, UK, France, and the Soviet Union in 1945. With the advent of the Cold War, two German states were formed in 1949: the western Federal Republic of Germany (FRG) and the eastern German Democratic Republic (GDR). The democratic FRG embedded itself in key Western economic and security organizations, the EC, which became the EU, and NATO, while the Communist GDR was on the front line of the Soviet-led Warsaw Pact. The decline of the USSR and the end of the Cold War allowed for German unification in 1990. Since then, Germany has expended considerable funds to bring Eastern productivity and wages up to Western standards. In January 1999, Germany and 10 other EU countries introduced a common European exchange currency, the euro."},{continent:"Europe",countryName:"United Kingdom",countryCode:"UK",area:244820,population:60609153,gdp:1830000,independence:new Date(1801,0,1),government:"constitutional monarchy",government_desc:1,capital:"London",member_g8:true,article:"http://en.wikipedia.org/wiki/United_kingdom",background:"Great Britain, the dominant industrial and maritime power of the 19th century, played a leading role in developing parliamentary democracy and in advancing literature and science. At its zenith, the British Empire stretched over one-fourth of the earth's surface. The first half of the 20th century saw the UK's strength seriously depleted in two World Wars. The second half witnessed the dismantling of the Empire and the UK rebuilding itself into a modern and prosperous European nation. As one of five permanent members of the UN Security Council, a founding member of NATO, and of the Commonwealth, the UK pursues a global approach to foreign policy; it currently is weighing the degree of its integration with continental Europe. A member of the EU, it chose to remain outside the Economic and Monetary Union for the time being. Constitutional reform is also a significant issue in the UK. The Scottish Parliament, the National Assembly for Wales, and the Northern Ireland Assembly were established in 1999, but the latter is suspended due to wrangling over the peace process."},{continent:"Europe",countryName:"France",countryCode:"FR",area:547030,population:60876136,gdp:1816000,government:"republic",government_desc:5,capital:"Paris",member_g8:true,article:"http://en.wikipedia.org/wiki/France",background:"Although ultimately a victor in World Wars I and II, France suffered extensive losses in its empire, wealth, manpower, and rank as a dominant nation-state. Nevertheless, France today is one of the most modern countries in the world and is a leader among European nations. Since 1958, it has constructed a presidential democracy resistant to the instabilities experienced in earlier parliamentary democracies. In recent years, its reconciliation and cooperation with Germany have proved central to the economic integration of Europe, including the introduction of a common exchange currency, the euro, in January 1999. At present, France is at the forefront of efforts to develop the EU's military capabilities to supplement progress toward an EU foreign policy."},{continent:"Europe",countryName:"Italy",countryCode:"IT",area:301230,population:58133509,gdp:1698000,independence:new Date(1861,2,17),government:"republic",government_desc:5,capital:"Rome",member_g8:true,article:"http://en.wikipedia.org/wiki/Italy",background:"Italy became a nation-state in 1861 when the regional states of the peninsula, along with Sardinia and Sicily, were united under King Victor EMMANUEL II. An era of parliamentary government came to a close in the early 1920s when Benito MUSSOLINI established a Fascist dictatorship. His disastrous alliance with Nazi Germany led to Italy's defeat in World War II. A democratic republic replaced the monarchy in 1946 and economic revival followed. Italy was a charter member of NATO and the European Economic Community (EEC). It has been at the forefront of European economic and political unification, joining the Economic and Monetary Union in 1999. Persistent problems include illegal immigration, organized crime, corruption, high unemployment, sluggish economic growth, and the low incomes and technical standards of southern Italy compared with the prosperous north."},{continent:"Asia",countryName:"Russia",countryCode:"RS",area:17075200,population:142893540,gdp:1589000,independence:new Date(1991,7,24),government:"federation",government_desc:3,capital:"Moscow",member_g8:true,article:"http://en.wikipedia.org/wiki/Russia",background:"Founded in the 12th century, the Principality of Muscovy, was able to emerge from over 200 years of Mongol domination (13th-15th centuries) and to gradually conquer and absorb surrounding principalities. In the early 17th century, a new Romanov Dynasty continued this policy of expansion across Siberia to the Pacific. Under PETER I (ruled 1682-1725), hegemony was extended to the Baltic Sea and the country was renamed the Russian Empire. During the 19th century, more territorial acquisitions were made in Europe and Asia. Repeated devastating defeats of the Russian army in World War I led to widespread rioting in the major cities of the Russian Empire and to the overthrow in 1917 of the imperial household. The Communists under Vladimir LENIN seized power soon after and formed the USSR. The brutal rule of Iosif STALIN (1928-53) strengthened communist rule and Russian dominance of the Soviet Union at a cost of tens of millions of lives. The Soviet economy and society stagnated in the following decades until General Secretary Mikhail GORBACHEV (1985-91) introduced glasnost (openness) and perestroika (restructuring) in an attempt to modernize Communism, but his initiatives inadvertently released forces that by December 1991 splintered the USSR into Russia and 14 other independent republics. Since then, Russia has struggled in its efforts to build a democratic political system and market economy to replace the strict social, political, and economic controls of the Communist period. While some progress has been made on the economic front, recent years have seen a recentralization of power under Vladimir PUTIN and the erosion of nascent democratic institutions. A determined guerrilla conflict still plagues Russia in Chechnya and threatens to destabilize the North Caucasus region."},{continent:"South America",countryName:"Brazil",countryCode:"BR",area:8511965,population:188078227,gdp:1556000,independence:new Date(1822,8,7),government:"federative republic",government_desc:3,capital:"Brasilia",member_g8:false,article:"http://en.wikipedia.org/wiki/Brazil",background:"Following three centuries under the rule of Portugal, Brazil became an independent nation in 1822 and a republic in 1889. By far the largest and most populous country in South America, Brazil overcame more than half a century of military intervention in the governance of the country when in 1985 the military regime peacefully ceded power to civilian rulers. Brazil continues to pursue industrial and agricultural growth and development of its interior. Exploiting vast natural resources and a large labor pool, it is today South America's leading economic power and a regional leader. Highly unequal income distribution remains a pressing problem."},{continent:"North America",countryName:"Canada",countryCode:"CA",area:9984670,population:33098932,gdp:1114000,independence:new Date(1867,6,1),government:"constitutional monarchy with parliamentary democracy and federation",government_desc:1,capital:"Ottawa",member_g8:true,article:"http://en.wikipedia.org/wiki/Canada",background:"A land of vast distances and rich natural resources, Canada became a self-governing dominion in 1867 while retaining ties to the British crown. Economically and technologically the nation has developed in parallel with the US, its neighbor to the south across an unfortified border. Canada's paramount political problem is meeting public demands for quality improvements in health care and education services after a decade of budget cuts. Canada also faces questions about integrity in government following revelations regarding a corruption scandal in the federal government that has helped revive the fortunes of separatists in predominantly francophone Quebec."},{continent:"North America",countryName:"Mexico",countryCode:"MX",area:1972550,population:107449525,gdp:1067000,independence:new Date(1810,8,16),government:"federal republic",government_desc:2,capital:"Mexico (Distrito Federal)",member_g8:false,article:"http://en.wikipedia.org/wiki/Mexico",background:"The site of advanced Amerindian civilizations, Mexico came under Spanish rule for three centuries before achieving independence early in the 19th century. A devaluation of the peso in late 1994 threw Mexico into economic turmoil, triggering the worst recession in over half a century. The nation continues to make an impressive recovery. Ongoing economic and social concerns include low real wages, underemployment for a large segment of the population, inequitable income distribution, and few advancement opportunities for the largely Amerindian population in the impoverished southern states. Elections held in July 2000 marked the first time since the 1910 Mexican Revolution that the opposition defeated the party in government, the Institutional Revolutionary Party (PRI). Vicente FOX of the National Action Party (PAN) was sworn in on 1 December 2000 as the first chief executive elected in free and fair elections."},{continent:"Europe",countryName:"Spain",countryCode:"SP",area:504782,population:40397842,gdp:1029000,independence:new Date(1492,0,1),government:"parliamentary monarchy",government_desc:4,capital:"Madrid",member_g8:false,article:"http://en.wikipedia.org/wiki/Spain",background:"Spain's powerful world empire of the 16th and 17th centuries ultimately yielded command of the seas to England. Subsequent failure to embrace the mercantile and industrial revolutions caused the country to fall behind Britain, France, and Germany in economic and political power. Spain remained neutral in World Wars I and II, but suffered through a devastating civil war (1936-39). A peaceful transition to democracy following the death of dictator Francisco FRANCO in 1975, and rapid economic modernization (Spain joined the EU in 1986), have given Spain one of the most dynamic economies in Europe and made it a global champion of freedom. Continuing challenges include Basque Fatherland and Liberty (ETA) terrorism and relatively high unemployment."},{continent:"Asia",countryName:"South Korea",countryCode:"KS",area:98480,population:48846823,gdp:965300,independence:new Date(1945,7,15),government:"republic",government_desc:5,capital:"Seoul",member_g8:false,article:"http://en.wikipedia.org/wiki/South_korea",background:"Korea was an independent kingdom for much of the past millennium. Following its victory in the Russo-Japanese War in 1905, Japan occupied Korea; five years later it formally annexed the entire peninsula. After World War II, a Republic of Korea (ROK) was set up in the southern half of the Korean Peninsula while a Communist-style government was installed in the north (the DPRK). During the Korean War (1950-53), US troops and UN forces fought alongside soldiers from the ROK to defend South Korea from DPRK attacks supported by China and the Soviet Union. An armistice was signed in 1953, splitting the peninsula along a demilitarized zone at about the 38th parallel. Thereafter, South Korea achieved rapid economic growth with per capita income rising to roughly 14 times the level of North Korea. In 1993, KIM Yo'ng-sam became South Korea's first civilian president following 32 years of military rule. South Korea today is a fully functioning modern democracy. In June 2000, a historic first North-South summit took place between the South's President KIM Tae-chung and the North's leader KIM Jong Il."},{continent:"Asia",countryName:"Indonesia",countryCode:"ID",area:1919440,population:245452739,gdp:865600,independence:new Date(1945,7,17),government:"republic",government_desc:5,capital:"Jakarta",member_g8:false,article:"http://en.wikipedia.org/wiki/Indonesia",background:"The Dutch began to colonize Indonesia in the early 17th century; the islands were occupied by Japan from 1942 to 1945. Indonesia declared its independence after Japan's surrender, but it required four years of intermittent negotiations, recurring hostilities, and UN mediation before the Netherlands agreed to relinquish its colony. Indonesia is the world's largest archipelagic state and home to the world's largest Muslim population. Current issues include: alleviating poverty, preventing terrorism, consolidating democracy after four decades of authoritarianism, implementing financial sector reforms, stemming corruption, and holding the military and police accountable for human rights violations. Indonesia was the nation worst hit by the December 2004 tsunami, which particularly affected Aceh province causing over 100,000 deaths and over $4 billion in damage. An additional earthquake in March 2005 created heavy destruction on the island of Nias. Reconstruction in these areas may take up to a decade. In 2005, Indonesia reached a historic peace agreement with armed separatists in Aceh, but it continues to face a low intensity separatist guerilla movement in Papua."}]});var _1="colorTester_gridsPane";if(isc.SkinUtil.testPanes[_1]!=null){return isc.SkinUtil.testPanes[_1]}
var _2=300;var _3=isc.ListGrid.create({width:_2,height:200,dataSource:isc.DS.get("sp_country"),data:isc.DS.get("sp_country").cacheData,canEdit:true,fields:[{name:"countryName"},{name:"capital"},{name:"continent"}],showFilterEditor:true,initialSort:{property:"countryName",direction:"ascending"},selectionAppearance:"checkbox",dataArrived:function(){if(!this.$194r){this.$194r=true;this.selectRecord(this.data.get(1))}}});var _4=isc.ListGrid.create({width:_2,height:200,headerHeight:52,dataSource:isc.DS.get("sp_country"),data:isc.DS.get("sp_country").cacheData,dataFetchMode:"local",canEdit:true,initialSort:{property:"countryName",direction:"ascending"},showGridSummary:true,fields:[{name:"countryName"},{name:"capital"},{name:"continent"},{name:"population",summaryFunction:"sum",showGridSummary:true}],headerSpans:[{fields:["countryName","capital"],title:"Country"},{fields:["continent","population"],title:"Population"}],dataArrived:function(){if(!this.$194r){this.$194r=true;this.selectRecord(this.data.get(1))}}});var _5=isc.ListGrid.create({width:_2,height:200,alternateRecordStyles:true,dataSource:isc.DS.get("sp_country"),data:isc.DS.get("sp_country").cacheData,fields:[{name:"countryName"},{name:"capital"},{name:"continent"}],initialSort:[{property:"countryName",direction:"ascending"}],expansionFieldImageShowSelected:false,canExpandRecords:true,expansionMode:"detail",expansionDetailField:"background",dataArrived:function(){if(!this.$194r){this.$194r=true;this.$194s=true;this.selectAndExpandRecord()}},selectAndExpandRecord:function(){this.selectRecord(this.data.get(1));this.expandRecord(this.data.get(1))}});var _6=isc.ListGrid.create({width:_2,height:200,dataSource:isc.DS.get("sp_country"),data:isc.DS.get("sp_country").cacheData,fields:[{name:"countryName"},{name:"capital"},{name:"population",title:"Total Pop.",summaryFunction:"count",showGroupSummary:true}],canEdit:true,groupStartOpen:"all",groupByField:'continent',initialSort:{property:"countryName",direction:"descending"},showGroupSummary:true,dataArrived:function(){if(!this.$194r){this.$194r=true;this.$194s=true;this.selectRecord(this.data.get(1))}},groupTreeChanged:function(){if(this.$194s){this.$194s=false;this.selectRecord(1)}}});var _7=isc.ListGrid.create({width:_2,height:200,dataSource:isc.DS.get("sp_country"),data:isc.DS.get("sp_country").cacheData,fields:[{name:"countryName"},{name:"continent"},{name:"population",summaryFunction:"sum",showGroupSummary:true}],canEdit:true,groupStartOpen:"all",groupByField:'continent',initialSort:{property:"countryName",direction:"descending"},showGroupSummary:true,showGroupSummaryInHeader:true,dataArrived:function(){if(!this.$194r){this.$194r=true;this.$194s=true;this.selectRecord(this.data.get(1))}},groupTreeChanged:function(){if(this.$194s){this.$194s=false;this.selectRecord(1)}}});var _8=isc.ListGrid.create({width:_2,height:200,dataSource:isc.DS.get("sp_country"),data:isc.DS.get("sp_country").cacheData,canEdit:true,fields:[{name:"countryName"},{name:"capital"},{name:"continent"}],showRowNumbers:true,showFilterEditor:true,initialSort:{property:"countryName",direction:"ascending"},dataArrived:function(){if(!this.$194r){this.$194r=true;this.selectRecord(this.data.get(1))}}});var _9=isc.TreeGrid.create({ID:"tgMultiColumn",width:_2,height:200,canReorderRecords:true,canAcceptDroppedRecords:true,dropIconSuffix:"into",closedIconSuffix:"",showSelectedIcons:true,data:isc.Tree.create({modelType:"parent",rootValue:"1",nameProperty:"Name",idField:"EmployeeId",parentIdField:"ReportsTo",openProperty:"isOpen",data:isc.DS.get("sp_employee").cacheData}),fields:[{name:"Name"},{name:"Job"}]});var _10=isc.FlowLayout.create({layoutMargin:10,membersMargin:20,width:"100%",height:"100%",autoDraw:false,tiles:[_3,_4,_5,_6,_7,_8,_9]});isc.SkinUtil.testPanes[_1]=_10;return isc.SkinUtil.testPanes[_1]}
isc.getTabsPane=function(){var _1="colorTester_tabsPane";if(isc.SkinUtil.testPanes[_1]!=null){return isc.SkinUtil.testPanes[_1]}
var _2="[TOOLS]skinTools/images/pawn_blue.png";this.getHeaderIcon=function(_11){var _3=isc.Media.getStockIcon(_11,"name","headerIcons");if(_3){return _3.src}}
this.getTabs=function(_11,_12){var _4=[{title:_11?"Selected":null,icon:this.getHeaderIcon("Person"),iconSize:12,pane:isc.Img.create({autoDraw:true,width:48,height:48,src:_2})},{title:_11?"Closeable":null,icon:this.getHeaderIcon("Person"),iconSize:12,canClose:true,pane:isc.Img.create({autoDraw:true,width:48,height:48,src:_2})},{title:_11?"Disabled":null,icon:this.getHeaderIcon("Person"),iconSize:12,disabled:true,showDisabledIcon:false,pane:isc.Img.create({autoDraw:true,width:48,height:48,src:_2})},{title:_11?"Extra Long Title":null,icon:this.getHeaderIcon("Person"),iconSize:12,pane:isc.Img.create({autoDraw:true,width:48,height:48,src:_2})}];return _4}
var _5=isc.TabSet.create({tabBarPosition:"top",width:370,height:100,titleEditEvent:"doubleClick",tabs:this.getTabs(true)});var _6=isc.TabSet.create({tabBarPosition:"bottom",width:370,height:100,titleEditEvent:"doubleClick",tabs:this.getTabs(true)});var _7=isc.TabSet.create({tabBarPosition:"left",width:120,height:220,defaultTabHeight:24,tabs:this.getTabs(false,true)});var _8=isc.TabSet.create({tabBarPosition:"right",width:120,height:220,showTabTitle:false,defaultTabHeight:24,tabs:this.getTabs(false,true)});var _9=isc.VLayout.create({membersMargin:20,width:1,height:1,autoDraw:false,members:[_5,_6]});var _10=isc.FlowLayout.create({layoutMargin:10,membersMargin:20,width:"100%",height:"100%",autoDraw:false,tiles:[_9,_7,_8]});isc.SkinUtil.testPanes[_1]=_10;return isc.SkinUtil.testPanes[_1]}
isc.getWidgetsPane=function(){var _1="colorTester_widgetsPane";if(isc.SkinUtil.testPanes[_1]!=null){return isc.SkinUtil.testPanes[_1]}
var _2=isc.ListGrid.create({fields:[{type:"text",title:"System",name:"system"},{type:"text",title:"Monitor Name",name:"monitor"}],canEdit:true,editEvent:"click",autoDraw:false})
var _3=isc.HTMLFlow.create({ID:"statusReport",padding:5,border:"1px solid #808080",autoDraw:false,setNewStatus:function(_14){this.setContents(_14+": <span style='color:green;font-weight:bold'>Normal</span><br>")}});var _4=isc.ImgButton.create({autoDraw:false,src:"[SKIN]actions/add.png",size:16,showFocused:false,showRollOver:false,showDown:false,click:"lgTest1.startEditingNew();return false;"});var _5=isc.ImgButton.create({autoDraw:false,src:"[SKIN]actions/remove.png",size:16,showFocused:false,showRollOver:false,showDown:false,click:"lgTest1.removeSelectedData();return false;"});var _6=isc.DynamicForm.create({height:1,width:75,numCols:1,autoDraw:false,fields:[{name:"system",type:"select",width:150,showTitle:false,valueMap:["Development","Staging","Production"],defaultValue:"Development",change:"statusReport.setNewStatus(value)",click:"return false;"}]});var _7=isc.SectionStack.create({sections:[{items:_2,title:"Monitors",controls:[_4,_5],expanded:true},{items:_3,title:"Status",controls:_6,expanded:true}],visibilityMode:"multiple",animateSections:true,height:300,width:300,autoDraw:false,overflow:"hidden"})
_3.setNewStatus(_6.getValue("system"));var _8=isc.ColorPicker.create({autoDraw:false,isModal:false,autoDismiss:false});var _9=isc.DateChooser.create({autoDraw:false});var _10=isc.DateChooser.create({autoDraw:false,showWeekChooser:true,showFiscalYearChooser:true});var _11=isc.Menu.create({autoDraw:true,autoDismiss:false,autoDismissOnBlur:false,data:[{title:"New",keyTitle:"Ctrl+N",icon:"[SKINIMG]actions/add.png"},{title:"Open",keyTitle:"Ctrl+O",icon:"[SKINIMG]actions/view.png"},{isSeparator:true},{title:"Save",keyTitle:"Ctrl+S",icon:"[SKINIMG]actions/save.png"},{title:"Search",icon:"[SKINIMG]actions/search.png"},{isSeparator:true},{title:"Recent Documents",icon:"[SKINIMG]actions/dynamic.png",submenu:[{title:"data.xml",checked:true},{title:"Component Guide.doc"},{title:"SmartClient.doc",checked:true},{title:"AJAX.doc"}]},{isSeparator:true},{title:"Print",enabled:false,keyTitle:"Ctrl+P",icon:"[SKINIMG]actions/print.png"}]});_11.show();var _12=isc.RichTextEditor.create({autoDraw:false,height:200});var _13=isc.FlowLayout.create({layoutMargin:10,membersMargin:20,width:"100%",height:"100%",autoDraw:false,tiles:[_7,_9,_10,_11,_8,_12]});isc.SkinUtil.testPanes[_1]=_13;return isc.SkinUtil.testPanes[_1]}
isc.getWindowsPane=function(){var _1="colorTester_windowsPane";if(isc.SkinUtil.testPanes[_1]!=null){return isc.SkinUtil.testPanes[_1]}
isc.defineClass("HelpCanvas","Canvas").addProperties({autoDraw:false,defaultWidth:300,padding:10,contents:"<b>Severity 1</b> - Critical problem<br>System is unavailable in production or is corrupting data - the error severely impacts user-operations.<br><br><b>Severity 2</b> - Major problem<br>An important function of the system is not available in production - user-operations are restricted."});var _2=isc.Window.create({title:"Auto-sizing window",autoDraw:false,autoSize:true,canDragReposition:true,canDragResize:true,items:[isc.HelpCanvas.create()]});var _3=isc.Window.create({width:200,height:150,title:"Normal window",canDragReposition:true,canDragResize:true,autoDraw:false,items:[isc.HelpCanvas.create()]});var _4=isc.Window.create({title:"Window with footer",width:300,height:150,canDragResize:true,showFooter:true,autoDraw:false,items:[isc.Label.create({contents:"Click me",align:"center",padding:5,height:"100%",click:function(){_4.setStatus("Click at: "+isc.EventHandler.getX()+", "+isc.EventHandler.getY())}})]});var _5=isc.Dialog.create({title:"Dialog with Title",width:300,height:150,canDragResize:true,showFooter:false,autoDraw:false,message:"Text describing the purpose of this dialog and/or options to continue.",icon:"[SKIN]ask.png",buttons:[isc.Button.create({title:"OK"}),isc.Button.create({title:"Cancel"})]});var _6=isc.Canvas.create({width:300,height:60,autoDraw:false,contents:"This is a <a class='notifyMessageActionLink' href='javascript:void'>Message notification.</a>",styleName:"notifyMessage"});var _7=isc.Canvas.create({width:300,height:60,autoDraw:false,contents:"This is a <a class='notifyWarningActionLink' href='javascript:void'>Warning notification.</a>",styleName:"notifyWarn"});var _8=isc.Canvas.create({width:300,height:60,autoDraw:false,contents:"This is an <a class='notifyErrorActionLink' href='javascript:void'>Error notification.</a>",styleName:"notifyError"});var _9=isc.MultiSortDialog.create({height:200,autoDraw:false,isModal:false,fields:isc.getValues(isc.DS.get("sp_employee").getFields()),initialSort:[{property:"EmployeeId",direction:"ascending"}]});var _10=isc.MultiGroupDialog.create({height:200,isModal:false,autoDraw:false,fields:isc.getValues(isc.DS.get("sp_employee").getFields())});var _11=isc.FlowLayout.create({layoutMargin:10,membersMargin:20,width:"100%",height:"100%",autoDraw:false,tiles:[_2,_3,_4,_5,_6,_7,_8,_9,_10]});isc.SkinUtil.testPanes[_1]=_11;return isc.SkinUtil.testPanes[_1]}
isc.getCalendarsPane=function(){var _1="colorTester_calendarsPane";if(isc.SkinUtil.testPanes[_1]!=null){return isc.SkinUtil.testPanes[_1]}
var _2=new Date;var _3=_2.getDate()-_2.getDay();var _4=_2.getMonth();var _5=_2.getFullYear();var _6=[{eventId:1,name:"Meeting",description:"Shareholders meeting: monthly forecast report",startDate:new Date(_5,_4,_3+2,9),endDate:new Date(_5,_4,_3+2,14)},{eventId:2,name:"Realtor",description:"This canvas is styled by color settings on the CalendarEvent",startDate:new Date(_5,_4,_3+3,8),endDate:new Date(_5,_4,_3+3,10),headerTextColor:"black",headerBackgroundColor:"orange",headerBorderColor:"darkorange",textColor:"darkgreen",borderColor:"darkorange",backgroundColor:"#ffffcc"},{eventId:3,name:"Soccer",description:"Little league soccer finals",startDate:new Date(_5,_4,_3+4,13),endDate:new Date(_5,_4,_3+4,16)},{eventId:4,name:"Sleep",description:"Catch up on sleep",startDate:new Date(_5,_4,_3+4,5),endDate:new Date(_5,_4,_3+4,9)},{eventId:5,name:"Inspection",description:"This canvas is styled and disabled by custom styleName and canEdit settings on the CalendarEvent",startDate:new Date(_5,_4,_3+4,10),endDate:new Date(_5,_4,_3+4,12),styleName:"testStyle",canEdit:false},{eventId:6,name:"Airport run",description:"This canvas is styled by color settings on the CalendarEvent",startDate:new Date(_5,_4,_3+4,1),endDate:new Date(_5,_4,_3+4,3),headerTextColor:"white",headerBackgroundColor:"green",headerBorderColor:"green",textColor:"darkgreen",borderColor:"darkgreen",backgroundColor:"lightgreen"},{eventId:7,name:"Dinner Party",description:"Prepare elaborate meal for friends",startDate:new Date(_5,_4,_3+4,17),endDate:new Date(_5,_4,_3+4,20)},{eventId:8,name:"Poker",description:"Poker at Steve's house",startDate:new Date(_5,_4,_3+4,21),endDate:new Date(_5,_4,_3+4,23)},{eventId:9,name:"Meeting",description:"Board of directors meeting: discussion of next months strategy",startDate:new Date(_5,_4,_3+5,11),endDate:new Date(_5,_4,_3+5,15)}];isc.DataSource.create({ID:"eventDS",fields:[{name:"eventId",primaryKey:true,type:"sequence"},{name:"name"},{name:"description"},{name:"startDate",type:"datetime"},{name:"endDate",type:"datetime"}],clientOnly:true,testData:_6});var _2=new Date();var y=_2.getFullYear();var m=_2.getMonth();var d=_2.getDate();var _10=[{eventId:1,startDate:new Date(y,m,d,8,0),endDate:new Date(y,m,d,12,0),name:"Development Meeting",description:"This canvas is styled and disabled by custom styleName and canEdit settings on the CalendarEvent",lane:"charlesMadigen",styleName:"testStyle",canEdit:false},{eventId:2,startDate:new Date(y,m,d,14,0),endDate:new Date(y,m,d,18,0),name:"Mgmt Meeting",description:"Management Meeting",lane:"charlesMadigen"},{eventId:3,startDate:new Date(y,m,d,4,0),endDate:new Date(y,m,d,12,0),name:"Data Cleansing",description:"This canvas is styled by color settings on the CalendarEvent",lane:"tamaraKane",headerTextColor:"black",headerBackgroundColor:"orange",headerBorderColor:"darkorange",textColor:"darkgreen",borderColor:"darkorange",backgroundColor:"#ffffcc"},{eventId:4,startDate:new Date(y,m,d,7,30),endDate:new Date(y,m,d,12,0),name:"Data Migration",description:"Data Migration",lane:"tamaraKane"},{eventId:5,startDate:new Date(y,m,d,13,0),endDate:new Date(y,m,d,16,0),name:"Documentation",description:"Product documentation",lane:"tamaraKane"},{eventId:6,startDate:new Date(y,m,d,8,0),endDate:new Date(y,m,d,20,0),name:"Support",description:"Telephone Support",lane:"darcyFeeney"},{eventId:7,startDate:new Date(y,m,d,11,0),endDate:new Date(y,m,d,11,30),name:"Break",description:"Morning break",lane:"darcyFeeney"},{eventId:8,startDate:new Date(y,m,d,16,0),endDate:new Date(y,m,d,16,30),name:"Break",description:"Afternoon break",lane:"darcyFeeney"},{eventId:9,startDate:new Date(y,m,d,0,0),endDate:new Date(y,m,d,8,0),name:"Premium Support",description:"This canvas is styled by color settings on the CalendarEvent",lane:"kaiKong",headerTextColor:"white",headerBackgroundColor:"green",headerBorderColor:"green",textColor:"darkgreen",borderColor:"darkgreen",backgroundColor:"lightgreen"},{eventId:10,startDate:new Date(y,m,d,20,0),endDate:new Date(y,m,d,23,59),name:"Support",description:"Premium Support (overnight response)",lane:"kaiKong"},{eventId:11,startDate:new Date(y,m,d,8,0),endDate:new Date(y,m,d,12,0),name:"Development Meeting",description:"Development Meeting",lane:"shellyFewel"},{eventId:12,startDate:new Date(y,m,d,13,30),endDate:new Date(y,m,d,17,30),name:"Team Meeting",description:"Developer Team Meeting",lane:"shellyFewel"}];var _11=isc.Calendar.create({width:400,height:300,autoDraw:false,dataSource:isc.DS.get("eventDS"),autoFetchData:true,showWeekView:false,showMonthView:false});var _12=isc.Calendar.create({width:400,height:300,autoDraw:false,dataSource:isc.DS.get("eventDS"),autoFetchData:true,showDayView:false,showMonthView:false});var _13=isc.Calendar.create({width:400,height:300,autoDraw:false,dataSource:isc.DS.get("eventDS"),autoFetchData:true,showDayView:false,showWeekView:false});var _14=[{name:"charlesMadigen",title:"Charles Madigen"},{name:"tamaraKane",title:"Tamara Kane"},{name:"darcyFeeney",title:"Darcy Feeney"},{name:"kaiKong",title:"Kai Kong"},{name:"shellyFewel",title:"Shelly Fewel"}];var _15=isc.Calendar.create({width:400,height:300,autoDraw:false,data:_10,lanes:_14,showWeekView:false,showMonthView:false,showTimelineView:false,chosenDate:new Date(),showDayLanes:true,canEditLane:true});var _16=isc.Calendar.create({width:400,height:300,autoDraw:false,showDayView:false,showWeekView:false,showOtherDays:false,showDayHeaders:false,showDateChooser:false,showDatePickerButton:false,showAddEventButton:false,disableWeekends:false,dataSource:isc.DS.get("eventDS"),autoFetchData:true,canCreateEvents:false,getDayBodyHTML:function(_23,_24,_25,_26,_27){var _17=_23.getDate()+" ";if(_24&&_24.length>0){_17+=this.imgHTML("[SKINIMG]actions/approve.png",16,16,"image")}
return _17},dayBodyClick:function(_23,_24,_25,_26,_27){var _18="";if(_24.length==0)_18="No events";for(var i=0;i<_24.length;i++){_18+=_24[i].name+"<BR/>"}
isc.say(_18,{title:_23.toUSShortDate()})}});var _20=isc.Calendar.create({width:400,height:300,autoDraw:false,dataSource:isc.DS.get("eventDS"),autoFetchData:true,showDayView:false,showMonthView:false,showWeekends:false,showWorkday:true,scrollToWorkday:true});var _21=isc.Calendar.create({width:400,height:300,autoDraw:false,dataSource:isc.DS.get("eventDS"),autoFetchData:true,showMonthView:false,showColumnLayouts:true});var _22=isc.FlowLayout.create({layoutMargin:10,membersMargin:20,width:"100%",height:"100%",autoDraw:false,tiles:[_11,_12,_13,_15,_20,_16,_21]});isc.SkinUtil.testPanes[_1]=_22;return isc.SkinUtil.testPanes[_1]}
isc.getTimelinesPane=function(){var _1="colorTester_timelinesPane";if(isc.SkinUtil.testPanes[_1]!=null){return isc.SkinUtil.testPanes[_1]}
var _2=[{endDate:"2016-07-09T23:59:59.000",name:"Add new Timeline view",description:"Add a new calendar Timeline component",taskId:1,startDate:"2016-07-03T00:00:00.000",lane:"darcyFeeney"},{endDate:"2016-07-07T23:59:59.000",name:"PDF Import/Export",description:"Implement native PDF import/export",taskId:3,startDate:"2016-07-02T00:00:00.000",lane:"garretMonroe"},{endDate:"2016-07-05T23:59:59.000",name:"Calculated Fields",description:"Formula and Summary fields for ListGrid",taskId:4,startDate:"2016-07-01T00:00:00.000",lane:"charlesMadigen"},{endDate:"2016-07-15T23:59:59.000",name:"ListGrid cell-level selection",description:"Implement spreadsheet-like selection in ListGrid",taskId:5,startDate:"2016-07-08T00:00:00.000",lane:"charlesMadigen"},{endDate:"2016-07-21T23:59:59.000",name:"Text import",description:"Server text-import",taskId:6,startDate:"2016-07-17T00:00:00.000",lane:"charlesMadigen"},{endDate:"2016-07-12T23:59:59.000",name:"TabIndex enhancements",description:"Enhance formItem tabindex handling",taskId:7,startDate:"2016-07-10T00:00:00.000",lane:"kaiKong"},{endDate:"2016-07-04T23:59:59.000",name:"Reify skin",description:"Skinning changes",taskId:8,startDate:"2016-07-01T00:00:00.000",lane:"shellyFewel"},{endDate:"2016-07-03T23:59:59.000",name:"DataSource Transaction-handling",description:"New transaction features",taskId:9,startDate:"2016-07-01T00:00:00.000",lane:"tamaraKane"},{endDate:"2016-07-21T23:59:59.000",name:"New Samples",description:"Add 20 samples for the following new features: ...",taskId:10,startDate:"2016-07-05T00:00:00.000",lane:"tamaraKane"},{endDate:"2016-07-15T23:59:59.000",name:"Localization",description:"Extend i18n support",taskId:11,startDate:"2016-07-10T00:00:00.000",lane:"darcyFeeney"},{endDate:"2016-07-19T23:59:59.000",name:"New Language Packs",description:"Add these 4 new language packs: ...",taskId:12,startDate:"2016-07-17T00:00:00.000",lane:"darcyFeeney"},{endDate:"2016-07-12T23:59:59.000",name:"ComponentXML",description:"Add the following features and update documentation: ...",taskId:13,startDate:"2016-07-06T00:00:00.000",lane:"shellyFewel"},{endDate:"2016-07-20T23:59:59.000",name:"TileGrid",description:"Change styling on builtin tiles as follows: ...",taskId:14,startDate:"2016-07-15T00:00:00.000",lane:"shellyFewel"},{endDate:"2016-07-09T23:59:59.000",canEdit:false,name:"Dev Meeting",description:"Weekly dev meeting",eventWindowStyle:"testStyle",taskId:16,startDate:"2016-07-09T00:00:00.000",lane:"charlesMadigen"},{endDate:"2016-07-16T23:59:59.000",canEdit:false,name:"Dev Meeting",description:"Weekly dev meeting",eventWindowStyle:"testStyle",taskId:17,startDate:"2016-07-16T00:00:00.000",lane:"charlesMadigen"},{endDate:"2016-07-10T23:59:59.000",name:"Oracle enhancements",description:"Add the following 11g-specific enhancements: ...",taskId:18,startDate:"2016-07-08T00:00:00.000",lane:"garretMonroe"},{endDate:"2016-07-15T23:59:59.000",name:"Client export",description:"Excel export alterations",taskId:19,startDate:"2016-07-12T00:00:00.000",lane:"garretMonroe"},{endDate:"2016-07-21T23:59:59.000",name:"Record Components",description:"New ListGrid recordComponent modes: ...",taskId:20,startDate:"2016-07-17T00:00:00.000",lane:"garretMonroe"},{endDate:"2016-07-05T23:59:59.000",name:"SQLDataSource",description:"Enhancements to customSQL support",taskId:21,startDate:"2016-07-03T00:00:00.000",lane:"kaiKong"},{endDate:"2016-07-09T23:59:59.000",name:"includeFrom",description:"Update support via includeFrom",taskId:22,startDate:"2016-07-07T00:00:00.000",lane:"kaiKong"},{endDate:"2016-07-17T23:59:59.000",name:"FileItem",description:"Add milti-file upload support",taskId:23,startDate:"2016-07-15T00:00:00.000",lane:"kaiKong"},{endDate:"2016-07-20T23:59:59.000",name:"Doc viewer",description:"Enhance documentation viewer with these additional syntax-hilites: ...",taskId:24,startDate:"2016-07-19T00:00:00.000",lane:"kaiKong"}];_2.map(function(_9){_9.startDate=new this.Date(_9.startDate);_9.endDate=new this.Date(_9.endDate)});isc.DataSource.create({ID:"tasks",clientOnly:true,allowAdvancedCriteria:true,fields:[{name:"taskId",hidden:true,type:"sequence",primaryKey:true},{name:"name",title:"Name",type:"text",required:true},{name:"description",title:"Description",type:"text"},{name:"startDate",title:"Start Date",type:"datetime",required:true},{name:"endDate",title:"End Date",type:"datetime",required:true},{name:"lane",title:"Lane",type:"text",required:true},{name:"eventWindowStyle",type:"text"},{name:"canEdit",hidden:true,type:"boolean"}],testData:_2});var _3=[{name:"charlesMadigen",title:"Charles Madigen",devGroup:"Managers"},{name:"tamaraKane",title:"Tamara Kane",devGroup:"Developers"},{name:"darcyFeeney",title:"Darcy Feeney",devGroup:"Managers"},{name:"kaiKong",title:"Kai Kong",devGroup:"Developers"},{name:"shellyFewel",title:"Shelly Fewel",devGroup:"Managers"},{name:"garretMonroe",title:"Garret Monroe",devGroup:"Developers"}];var _4=isc.DateUtil.getStartOf(new Date(2016,6,5),"W");var _5=_4.duplicate();_5.setDate(_5.getDate()+20);var _6=isc.Timeline.create({height:451,width:500,autoDraw:false,startDate:_4,endDate:_5,dataSource:isc.DS.get("tasks"),autoFetchData:true,lanes:_3,headerLevels:[{unit:"week"},{unit:"day"}],laneFields:[{name:"title",title:"Developer",minWidth:120,autoFitWidth:true}],canEditLane:true,showEventDescriptions:false,columnsPerPage:5});var _4=isc.DateUtil.getStartOf(new Date(2016,6,5),"W");var _5=_4.duplicate();_5.setDate(_5.getDate()+20);var _7=isc.Timeline.create({width:500,height:451,autoDraw:false,startDate:_4,endDate:_5,dataSource:isc.DS.get("tasks"),autoFetchData:true,lanes:_3,headerLevels:[{unit:"week"},{unit:"day"}],canEditLane:true,showEventDescriptions:false,columnsPerPage:5,laneEventPadding:2,disableWeekends:false,canGroupLanes:true,laneGroupByField:"devGroup",laneFields:[{name:"title",title:"Developer",minWidth:120,autoFitWidth:true},{name:"devGroup",hidden:true}]});var _8=isc.FlowLayout.create({layoutMargin:10,membersMargin:20,width:"100%",height:"100%",autoDraw:false,tiles:[_6,_7]});isc.SkinUtil.testPanes[_1]=_8;return isc.SkinUtil.testPanes[_1]}
isc._nonDebugModules=(isc._nonDebugModules!=null?isc._nonDebugModules:[]);isc._nonDebugModules.push('SkinUtil');isc.checkForDebugAndNonDebugModules();isc._moduleEnd=isc._SkinUtil_end=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc.Log&&isc.Log.logIsInfoEnabled('loadTime'))isc.Log.logInfo('SkinUtil module init time: '+(isc._moduleEnd-isc._moduleStart)+'ms','loadTime');delete isc.definingFramework;if(isc.Page)isc.Page.handleEvent(null,"moduleLoaded",{moduleName:'SkinUtil',loadTime:(isc._moduleEnd-isc._moduleStart)});}else{if(window.isc&&isc.Log&&isc.Log.logWarn)isc.Log.logWarn("Duplicate load of module 'SkinUtil'.");}
