/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.annotations.DataSourceAnnotations;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.MultipleFieldCriteriaTransformer;
import com.isomorphic.datasource.AuditDSGenerator;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSFieldOrderType;
import com.isomorphic.datasource.DSFileSpec;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DSTransaction;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.DynamicDSGenerator;
import com.isomorphic.datasource.ExecDataSource;
import com.isomorphic.datasource.FileDataSource;
import com.isomorphic.datasource.IType;
import com.isomorphic.datasource.IncludeFromInfo;
import com.isomorphic.datasource.JSExpressionType;
import com.isomorphic.datasource.MemoryDataSource;
import com.isomorphic.datasource.NoOpDataSource;
import com.isomorphic.datasource.ODataDataSource;
import com.isomorphic.datasource.ProjectFileDataSource;
import com.isomorphic.datasource.ProvidesAdditionalFields;
import com.isomorphic.datasource.RESTDataSource;
import com.isomorphic.datasource.RelationFieldInfo;
import com.isomorphic.datasource.SimpleType;
import com.isomorphic.datasource.UnionDataSource;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.interfaces.ICDIBeanManager;
import com.isomorphic.interfaces.ISpringBeanFactory;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.CanvasRefExpression;
import com.isomorphic.js.DataSourceRefExpression;
import com.isomorphic.js.JSExpression;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.mail.GmailAttachmentDataSource;
import com.isomorphic.mail.GmailMessageDataSource;
import com.isomorphic.rpc.ServerObject;
import com.isomorphic.servlet.PreCache;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.DefaultValidators;
import com.isomorphic.util.ErrorMessage;
import com.isomorphic.util.ErrorReport;
import com.isomorphic.util.IOUtil;
import com.isomorphic.xml.XML;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BasicDataSource
extends DataSource {
    private static Logger log = new Logger(BasicDataSource.class.getName());
    public static String DATASOURCE_AUTO_CREATE_AUDIT_TABLE_KEY = "autoCreateAuditTable";
    public static String GLOBAL_AUTO_CREATE_AUDIT_TABLE_KEY = "audit.autoCreateTables";
    protected Map ds2NativeFieldMap;
    protected Map native2DSFieldMap;
    protected Map derivedClientToServerFieldMap;
    protected Map derivedServerToClientFieldMap;
    protected Map dsFields = null;
    protected List<DSField> dsMultipleFields = null;
    protected List<String> primaryKeys;
    protected String superDSName = null;
    public BasicDataSource superDS = null;
    public DataSource autoDeriveDS = null;
    protected Set<String> auditNeverFields;
    protected Set<String> auditOnChangeFields;
    protected Set<String> auditOnReqChangeFields;
    protected Map<String, Set<String>> validatorsDependentFields;
    protected DSRequest downloadDsRequest;
    private final MultipleFieldCriteriaTransformer multipleFieldCriteriaTransformer = new MultipleFieldCriteriaTransformer(this);
    public static AuditDSGenerator auditGenerator;
    public static int numRecords;
    List needsRefQuotedForGradient = Arrays.asList("DrawBlockConnector", "DrawCurve", "DrawGroup", "DrawImage", "DrawItem", "DrawLabel", "DrawLine", "DrawLinePath", "DrawOval", "DrawPane", "DrawPath", "DrawPolygon", "DrawRect", "DrawSector", "DrawShape", "DrawTriangle", "DrawDiamond");
    private boolean _inLogAttributeNotDeclaredMessage = false;
    public static int numFields;
    public static final String CACHED_TYPE = "__cachedType";

    public static DataSource fromConfig(Map theConfig, DSRequest dsRequest) throws Exception {
        DataSource ds;
        String dsType;
        block35: {
            String ID = (String)theConfig.get("ID");
            dsType = BasicDataSource.getType(theConfig);
            if (dsType == null) {
                dsType = theConfig.get("tableName") != null ? "sql" : "basic";
            }
            String serverClass = (String)theConfig.get("serverConstructor");
            ds = null;
            if (serverClass != null) {
                String springIndicator = "spring:";
                String cdiIndicator = "cdi:";
                if (serverClass.indexOf(springIndicator) == 0) {
                    String beanId = serverClass.substring(springIndicator.length());
                    log.debug("Looking up Spring bean '" + beanId + "' as implementer for DataSource " + ID);
                    try {
                        ISpringBeanFactory beanFactory = (ISpringBeanFactory)InterfaceProvider.load("ISpringBeanFactory");
                        Object dataSourceInstance = beanFactory.getBean(ISCFile.servletContext, beanId);
                        if (dataSourceInstance instanceof DataSource) {
                            ds = (DataSource)dataSourceInstance;
                            break block35;
                        }
                        log.warning("Couldn't create DataSource " + ID + " by looking up Spring bean '" + beanId + "', creating as a normal DataSource.  The object returned by the Spring lookup was " + (dataSourceInstance == null ? "null" : "of type " + dataSourceInstance.getClass().getName()));
                    }
                    catch (Exception e) {
                        log.warning("Couldn't create DataSource " + ID + " by looking up Spring bean '" + beanId + "', creating as a normal DataSource.  The Spring lookup failed as follows: " + DataTools.getStackTrace(e));
                    }
                } else if (serverClass.indexOf(cdiIndicator) == 0) {
                    String beanId = serverClass.substring(cdiIndicator.length());
                    log.debug("Looking up CDI bean '" + beanId + "' as implementer for DataSource " + ID);
                    try {
                        ICDIBeanManager beanManager = (ICDIBeanManager)InterfaceProvider.load("ICDIBeanManager");
                        Object dataSourceInstance = beanManager.getBean(beanId);
                        if (dataSourceInstance instanceof DataSource) {
                            ds = (DataSource)dataSourceInstance;
                            break block35;
                        }
                        log.warning("Couldn't create DataSource " + ID + " by looking up CDI bean '" + beanId + "', creating as a normal DataSource.  The object returned by the CDI lookup was " + (dataSourceInstance == null ? "null" : "of type " + dataSourceInstance.getClass().getName()));
                    }
                    catch (Exception e) {
                        log.warning("Couldn't create DataSource " + ID + " by looking up CDI bean '" + beanId + "', creating as a normal DataSource.  The CDI lookup failed as follows: " + DataTools.getStackTrace(e));
                    }
                } else {
                    try {
                        log.debug("Using class " + serverClass + " as implementer for DataSource " + ID);
                        ds = (DataSource)Reflection.newInstance(serverClass, new Object[0]);
                    }
                    catch (Exception e) {
                        log.warning("Couldn't create DataSource " + ID + " as an instance of class '" + serverClass + "', creating as a normal DataSource.  Problem was:\n" + DataTools.getStackTrace(e));
                    }
                }
            }
        }
        if (ds == null) {
            if (dsType.equals("table") || dsType.equals("sql")) {
                ds = (DataSource)InterfaceProvider.load("SQLDataSource");
            } else if (dsType.equals("exec")) {
                ds = new ExecDataSource();
            } else if (dsType.equals("rest")) {
                ds = new RESTDataSource();
            } else if (dsType.equals("odata")) {
                ds = new ODataDataSource();
            } else if (dsType.equals("stream")) {
                ds = (DataSource)InterfaceProvider.load("StreamDataSource");
            } else if (dsType.equals("metaModel")) {
                ds = (DataSource)InterfaceProvider.load("MetaModelDataSource");
            } else if (dsType.equals("hibernate")) {
                ds = (DataSource)InterfaceProvider.load("HibernateDataSource");
            } else if (dsType.equals("jpa1")) {
                ds = (DataSource)InterfaceProvider.load("JPADataSource");
            } else if (dsType.equals("jpa")) {
                ds = (DataSource)InterfaceProvider.load("JPA2DataSource");
            } else if (dsType.equals("LDAP")) {
                ds = (DataSource)InterfaceProvider.load("LDAPDataSource");
                ds = (DataSource)InterfaceProvider.load("HibernateDataSource");
            } else {
                ds = dsType.equals("file") ? new FileDataSource() : (dsType.equals("memory") ? new MemoryDataSource() : (dsType.equals("session") ? (DataSource)InterfaceProvider.load("SessionDataSource") : (dsType.equals("projectFile") ? new ProjectFileDataSource() : (dsType.equals("gmailMessage") ? new GmailMessageDataSource() : (dsType.equals("gmailAttachment") ? new GmailAttachmentDataSource() : (dsType.equals("noop") ? new NoOpDataSource() : (dsType.equals("union") ? BasicDataSource.getUnionDataSourceInstance(theConfig, dsRequest) : new BasicDataSource())))))));
            }
        }
        ds.initialize(theConfig, dsRequest);
        return ds;
    }

    private static BasicDataSource getUnionDataSourceInstance(Map theConfig, DSRequest dsReq) {
        String unionString = (String)theConfig.get("unionOf");
        if (unionString == null) {
            log.warn("ERROR: \"union\" dataSource \"" + theConfig.get("ID") + "\" does not specify a \"unionOf\" property.  Cannot create");
            return new BasicDataSource();
        }
        if (unionString.trim().length() == 0) {
            log.warn("ERROR: \"union\" dataSource \"" + theConfig.get("ID") + "\" specifies an empty \"unionOf\" property.  Cannot create");
            return new BasicDataSource();
        }
        if (unionString.indexOf(",") == -1) {
            log.warn("ERROR: \"union\" dataSource \"" + theConfig.get("ID") + "\" specifies an invalid \"unionOf\" property - must be a comma-separated list of DataSource names.  Cannot create");
            return new BasicDataSource();
        }
        String[] unionDsNames = unionString.trim().split(",");
        boolean allSql = true;
        for (String unionDsName : unionDsNames) {
            try {
                unionDsName = unionDsName.trim();
                DataSource workDs = null;
                if (dsReq != null) {
                    workDs = dsReq.getCachedDataSourceInstance(unionDsName);
                }
                if (workDs == null) {
                    workDs = DataSourceManager.get(unionDsName, dsReq);
                    if (dsReq != null) {
                        dsReq.cacheDataSourceInstance(unionDsName, workDs);
                    }
                }
                if (workDs == null) {
                    log.warn("ERROR: \"union\" dataSource \"" + theConfig.get("ID") + "\" specifies unknown dataSource \"" + unionDsName + "\" in its \"unionOf\" property.  Cannot create");
                    return new BasicDataSource();
                }
                if (workDs.isSQLDataSource()) continue;
                allSql = false;
                break;
            }
            catch (Exception e) {
                log.warn((Object)("Caught exception when evaluating the \"unionOf\" property of \"union\" dataSource \"" + theConfig.get("ID") + "\".  Cannot create"), e);
                return new BasicDataSource();
            }
        }
        if (allSql || Boolean.TRUE.equals(theConfig.get("_forceSQLUnionDataSource"))) {
            try {
                log.debug("Returning an instance of SQLUnionDataSource for \"union\" dataSource \"" + theConfig.get("ID") + "\"");
                return (UnionDataSource)InterfaceProvider.load("SQLUnionDataSource");
            }
            catch (Exception e) {
                log.warn((Object)("Caught exception when trying to load SQLUnionDataSource for \"union\" dataSource \"" + theConfig.get("ID") + "\".  Cannot create"), e);
                return new BasicDataSource();
            }
        }
        log.debug("Returning an instance of base UnionDataSource for \"union\" dataSource \"" + theConfig.get("ID") + "\"");
        return new UnionDataSource();
    }

    @Override
    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        super.init(theConfig, dsRequest);
        if (!this.dsConfig.containsKey("progressiveLoadingThreshold")) {
            this.dsConfig.put("progressiveLoadingThreshold", 200000);
        }
        if (!this.dsConfig.containsKey("lookAhead")) {
            this.dsConfig.put("lookAhead", 1);
        }
        if (!this.dsConfig.containsKey("endGap")) {
            this.dsConfig.put("endGap", 20);
        }
        this.ds2NativeFieldMap = new LinkedHashMap();
        this.native2DSFieldMap = new HashMap();
        this.derivedServerToClientFieldMap = new HashMap();
        this.derivedClientToServerFieldMap = new HashMap();
        this.primaryKeys = new ArrayList<String>();
        this.validatorsDependentFields = new HashMap<String, Set<String>>();
        if (this.dsConfig.get("fields") == null) {
            this.dsConfig.put("fields", new HashMap());
        }
        this.superDSName = this.dsConfig.getString("inheritsFrom");
        this.superDS = this.getSuper(dsRequest);
        Object autoDerive = this.dsConfig.get("autoDeriveSchema");
        if (autoDerive != null && autoDerive.toString().equalsIgnoreCase("true") && this.autoDeriveDS == null) {
            this.createAutoDeriveDS();
        }
        if (this.autoDeriveDS instanceof BasicDataSource) {
            this.superDS = (BasicDataSource)this.autoDeriveDS;
            this.superDSName = this.superDS.dsName;
        }
        if (this.superDS != null) {
            DataTools.addAsList(this.fieldList, this.superDS._getFieldNames());
        }
        if (this.dsConfig.get("allowAdvancedCriteria") == null && this.dsConfig.get("willHandleAdvancedCriteria") == null) {
            this.dsConfig.put("allowAdvancedCriteria", this.allowAdvancedCriteria());
        }
        this.buildFieldData();
        HashMap<String, DataSource> inInitState = BasicDataSource.getInInitState();
        inInitState.put(this.getName(), this);
        if (this.handlesRelations()) {
            this.relationFields = new HashMap();
            for (Object object : this._getFieldNames()) {
                String relatedFieldName;
                String relatedDSName;
                DataSource relatedDS;
                String type;
                String foreignKey;
                String fieldName = (String)object;
                DSField field = this.getField(fieldName);
                if (field.isMultiple()) {
                    foreignKey = field.getForeignKey();
                    type = field.getType();
                    if (foreignKey != null) {
                        relatedDS = this;
                        relatedDSName = this.getName();
                        relatedFieldName = foreignKey;
                        if (foreignKey.contains(".")) {
                            relatedDSName = foreignKey.substring(0, foreignKey.lastIndexOf("."));
                            relatedFieldName = foreignKey.substring(foreignKey.lastIndexOf(".") + 1);
                            relatedDS = inInitState.get(relatedDSName);
                            if (relatedDS == null) {
                                relatedDS = DataSourceManager.getDataSource(relatedDSName);
                            }
                            if (relatedDS != null) {
                                if (this.getClass().isInstance(relatedDS) || relatedDS.getClass().isInstance(this)) {
                                    if (this.getConfigName().equals(relatedDS.getConfigName())) {
                                        if (relatedDS.getField(relatedFieldName) == null) {
                                            log.warn("Related data source '" + relatedDSName + "' does not contain related field '" + relatedFieldName + "' for field '" + fieldName + "'. Treating as simple field.");
                                            relatedDSName = null;
                                            relatedFieldName = null;
                                        }
                                    } else {
                                        log.warn("Related data source '" + relatedDSName + "' for field '" + fieldName + "' uses different config '" + relatedDS.getConfigName() + "'. This data source uses config '" + this.getConfigName() + "'. Treating as simple field.");
                                        relatedDSName = null;
                                        relatedFieldName = null;
                                    }
                                } else {
                                    log.warn("Related data source '" + relatedDSName + "' for field '" + fieldName + "' is not compatible with this data source. Treating as simple field.");
                                    relatedDSName = null;
                                    relatedFieldName = null;
                                }
                            } else {
                                log.warn("Can not load related data source '" + relatedDSName + "' for field '" + fieldName + "'. Treating as simple field.");
                                relatedDSName = null;
                                relatedFieldName = null;
                            }
                        } else if (this.getField(relatedFieldName) == null) {
                            log.warn("Related data source '" + relatedDSName + "' does not contain related field '" + relatedFieldName + "' for field '" + fieldName + "'. Treating as simple field.");
                            relatedDSName = null;
                            relatedFieldName = null;
                        }
                        if (relatedFieldName == null) continue;
                        if (BasicDataSource.getBuiltinType(type) == null) {
                            if (relatedDSName.equals(type)) {
                                this.relationFields.put(fieldName, new RelationFieldInfo(fieldName, type, relatedDSName, relatedFieldName, true, true));
                                this.getField(fieldName).put("type", type);
                                continue;
                            }
                            log.warn("Related data source '" + relatedDSName + "' does not match declared field type  '" + type + "' for field '" + fieldName + "'. Treating as simple field.");
                            relatedDSName = null;
                            relatedFieldName = null;
                            continue;
                        }
                        type = relatedDS.getField(relatedFieldName).getType();
                        if ("sequence".equals(type)) {
                            type = "integer";
                        }
                        this.relationFields.put(fieldName, new RelationFieldInfo(fieldName, type, relatedDSName, relatedFieldName, false, true));
                        this.getField(fieldName).put("type", type);
                        continue;
                    }
                    if (BasicDataSource.getBuiltinType(type) != null) continue;
                    relatedDS = inInitState.get(type);
                    if (relatedDS == null) {
                        relatedDS = DataSourceManager.getDataSource(type);
                    }
                    if (relatedDS != null) {
                        if (this.getClass().isInstance(relatedDS) || relatedDS.getClass().isInstance(this)) {
                            if (this.getConfigName().equals(relatedDS.getConfigName())) {
                                this.relationFields.put(fieldName, new RelationFieldInfo(fieldName, type, relatedDS.getName(), relatedDS.getPrimaryKey(), true, true));
                                continue;
                            }
                            log.warn("Related data source '" + type + "' for field '" + fieldName + "' uses different config '" + relatedDS.getConfigName() + "'. This data source uses config '" + this.getConfigName() + "'. Treating as simple field.");
                            continue;
                        }
                        log.warn("Related data source '" + type + "' for field '" + fieldName + "' is not compatible with this data source. Treating as simple field.");
                        continue;
                    }
                    log.warn("Can not load related data source '" + type + "' for field '" + fieldName + "'. Treating as simple field.");
                    continue;
                }
                foreignKey = field.getForeignKey();
                type = field.getType();
                if (foreignKey != null) {
                    relatedDS = this;
                    relatedDSName = this.getName();
                    relatedFieldName = foreignKey;
                    if (foreignKey.contains(".")) {
                        relatedDSName = foreignKey.substring(0, foreignKey.lastIndexOf("."));
                        relatedFieldName = foreignKey.substring(foreignKey.lastIndexOf(".") + 1);
                        relatedDS = inInitState.get(relatedDSName);
                        if (relatedDS == null) {
                            relatedDS = DataSourceManager.getDataSource(relatedDSName);
                        }
                        if (relatedDS != null) {
                            if (this.getClass().isInstance(relatedDS) || relatedDS.getClass().isInstance(this)) {
                                if (this.getConfigName().equals(relatedDS.getConfigName())) {
                                    if (relatedDS.getField(relatedFieldName) == null) {
                                        log.warn("Related data source '" + relatedDSName + "' does not contain related field '" + relatedFieldName + "' for field '" + fieldName + "'. Treating as simple field.");
                                        relatedDSName = null;
                                        relatedFieldName = null;
                                    }
                                } else {
                                    log.warn("Related data source '" + relatedDSName + "' for field '" + fieldName + "' uses different config '" + relatedDS.getConfigName() + "'. This data source uses config '" + this.getConfigName() + "'. Treating as simple field.");
                                    relatedDSName = null;
                                    relatedFieldName = null;
                                }
                            } else {
                                log.warn("Related data source '" + relatedDSName + "' for field '" + fieldName + "' is not compatible with this data source. Treating as simple field.");
                                relatedDSName = null;
                                relatedFieldName = null;
                            }
                        } else {
                            log.warn("Can not load related data source '" + relatedDSName + "' for field '" + fieldName + "'. Treating as simple field.");
                            relatedDSName = null;
                            relatedFieldName = null;
                        }
                    } else if (this.getField(relatedFieldName) == null) {
                        log.warn("Related data source '" + relatedDSName + "' does not contain related field '" + relatedFieldName + "' for field '" + fieldName + "'. Treating as simple field.");
                        relatedDSName = null;
                        relatedFieldName = null;
                    }
                    if (relatedFieldName == null) continue;
                    if (BasicDataSource.getBuiltinType(type) == null) {
                        if (relatedDSName.equals(type)) {
                            this.relationFields.put(fieldName, new RelationFieldInfo(fieldName, type, relatedDSName, relatedFieldName, true, false));
                            this.getField(fieldName).put("type", type);
                            continue;
                        }
                        log.warn("Related data source '" + relatedDSName + "' does not match declared field type  '" + type + "' for field '" + fieldName + "'. Treating as simple field.");
                        relatedDSName = null;
                        relatedFieldName = null;
                        continue;
                    }
                    type = relatedDS.getField(relatedFieldName).getType();
                    if ("sequence".equals(type)) {
                        type = "integer";
                    }
                    this.relationFields.put(fieldName, new RelationFieldInfo(fieldName, type, relatedDSName, relatedFieldName, false, false));
                    this.getField(fieldName).put("type", type);
                    this.getField(fieldName).put("valueXPath", fieldName + "/" + relatedFieldName);
                    continue;
                }
                if (BasicDataSource.getBuiltinType(type) != null) continue;
                relatedDS = inInitState.get(type);
                if (relatedDS == null) {
                    relatedDS = DataSourceManager.getDataSource(type);
                }
                if (relatedDS != null) {
                    if ((this.getClass().isInstance(relatedDS) || relatedDS.getClass().isInstance(this)) && relatedDS.handlesRelations()) {
                        if (this.getConfigName().equals(relatedDS.getConfigName())) {
                            this.relationFields.put(fieldName, new RelationFieldInfo(fieldName, type, relatedDS.getName(), relatedDS.getPrimaryKey(), true, false));
                            continue;
                        }
                        log.warn("Related data source '" + type + "' for field '" + fieldName + "' uses different config '" + relatedDS.getConfigName() + "'. This data source uses config '" + this.getConfigName() + "'. Treating as simple field.");
                        continue;
                    }
                    log.warn("Related data source '" + type + "' for field '" + fieldName + "' is not compatible with this data source. Treating as simple field.");
                    continue;
                }
                log.warn("Can not load related data source '" + type + "' for field '" + fieldName + "'. Treating as simple field.");
            }
        }
        this.includeFromFields = new HashMap();
        for (Object object : this.getFields()) {
            DSField field = (DSField)object;
            IncludeFromInfo includeFromInfo = this.getIncludeFromInfo(field, dsRequest);
            if (includeFromInfo == null) continue;
            this.includeFromFields.put(field.getName(), includeFromInfo);
        }
        if (this.dsConfig.getBoolean((Object)"audit", false) && this.dsConfig.getBoolean((Object)"generateAuditDS", true)) {
            String auditId = this.dsConfig.getString("auditDataSourceID", "audit_" + this.getID());
            if (auditGenerator == null) {
                auditGenerator = new AuditDSGenerator();
                log.debug("Adding AuditDSGenerator");
                DataSource.addDynamicDSGenerator((DynamicDSGenerator)auditGenerator, "audit_");
            }
            if (!auditId.startsWith("audit_")) {
                Pattern pattern = Pattern.compile(Pattern.quote(auditId));
                log.debug("Adding AuditDSGenerator targeted at " + auditId);
                DataSource.addDynamicDSGenerator((DynamicDSGenerator)auditGenerator, pattern);
            }
            if (!auditGenerator.hasMappingFor(auditId)) {
                auditGenerator.addMapping(auditId, this.getID());
            }
        }
        this.dsMultipleFields = new LinkedList<DSField>();
        ValidationContext vc = new ValidationContext();
        for (String fieldNameObj : this._getFieldNames()) {
            String fieldName = fieldNameObj;
            DSField field = this.getField(fieldName);
            if (!field.isMultiple()) continue;
            this.dsMultipleFields.add(field);
            if (field.getMultipleStorage() != null || field.getForeignKey() != null) continue;
            if (BasicDataSource.getBuiltinType(field.getType()) != null) {
                log.debug("undefined multipleStorage was set to 'simpleString' for field " + field.getName());
                field.put("multipleStorage", "simpleString");
                continue;
            }
            try {
                IType t = this.getSimpleType(field.getType(), vc);
                if (t != null || !(t instanceof SimpleType)) continue;
                log.debug("undefined multipleStorage was set to 'simpleString' for field " + field.getName());
                field.put("multipleStorage", "simpleString");
            }
            catch (Exception e) {
                log.warning("Error getting field type for field '" + field.getName() + "'. The exception was " + DataTools.getStackTrace(e));
            }
        }
        vc.freeResources();
        inInitState.remove(this.getName());
    }

    public Map ds2NativeFieldMap() {
        return this.ds2NativeFieldMap;
    }

    @Override
    public Map native2DSFieldMap() {
        return this.native2DSFieldMap;
    }

    public String getSuperDSName() {
        return this.superDSName;
    }

    protected void createAutoDeriveDS() throws Exception {
        this.createAutoDeriveDS((Map)((Object)this.dsConfig));
    }

    protected void createAutoDeriveDS(Map theConfig) throws Exception {
        String ID = (String)theConfig.get("ID") + "_inheritsFrom";
        Object dsObject = DataStructCache.getCachedObjectWithNoConfigFile(ID);
        if (dsObject instanceof DataSource) {
            this.autoDeriveDS = (DataSource)dsObject;
            return;
        }
        String beanName = (String)theConfig.get("schemaBean");
        if (beanName == null) {
            beanName = (String)theConfig.get("beanClassName");
        }
        if (beanName == null) {
            return;
        }
        HashMap<String, String> soConfig = new HashMap<String, String>();
        ServerObject serverObject = null;
        RequestContext context = new RequestContext();
        context.servletContext = ISCFile.servletContext;
        if (beanName.indexOf(46) == -1) {
            soConfig.put("bean", beanName);
            soConfig.put("lookupStyle", "spring");
            try {
                serverObject = new ServerObject(soConfig, context, "Looking up schemaBean as Spring bean for datasource: " + this.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (serverObject == null) {
            soConfig.put("className", beanName);
            soConfig.put("lookupStyle", "new");
            serverObject = new ServerObject(soConfig, context, "Looking up schemaBean as direct Java object for datasource: " + this.getName());
        }
        if (serverObject == null) {
            log.warn("DataSource " + this.getName() + ": Failed to look up schemaBean '" + beanName + "' as either a Spring bean or a direct Java object");
            return;
        }
        Object soInstance = serverObject.getInstance();
        if (soInstance == null) {
            log.warn("DataSource " + this.getName() + ": Failed to instantiate schemaBean '" + beanName + "'");
            return;
        }
        try {
            Map parentConfig = null;
            try {
                parentConfig = DataSourceAnnotations.getDataSourceConfigFromAnnotatedClass(soInstance.getClass(), false, false, (String)theConfig.get("serverType"), (String)theConfig.get("serverConstructor"));
            }
            catch (NoClassDefFoundError ncdfe) {
                log.debug("NoClassDefFoundError when trying annotations, almost certainly because we have no javax.persistence on the classpath. Annotations are not available.");
            }
            if (parentConfig == null) {
                Object[] params = new Object[]{soInstance.getClass().getName()};
                parentConfig = (Map)Reflection.invokeNonVisibleStaticMethod("com.isomorphic.tools.DataSourceTools", "_getDataSourceConfigFromJavaClass", params);
            }
            if (parentConfig != null) {
                parentConfig.put("ID", ID);
                parentConfig.put((String)"serverType", theConfig.get("serverType"));
                if (theConfig.get("tableName") != null) {
                    parentConfig.put("tableName", theConfig.get("tableName"));
                }
                if (theConfig.get("quoteTableName") != null) {
                    parentConfig.put("quoteTableName", theConfig.get("quoteTableName"));
                }
                parentConfig.put("__autoConstruct", "DataSource");
                this.autoDeriveDS = BasicDataSource.fromConfig(parentConfig, null);
                DataStructCache.addCachedObjectWithNoConfigFile(ID, this.autoDeriveDS);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception trying to invoke DataSourceTools method", e);
        }
    }

    @Override
    public DataSource getAutoDeriveDS() {
        return this.autoDeriveDS;
    }

    @Override
    protected BasicDataSource getSuper() {
        return this.getSuper(null, null);
    }

    @Override
    protected BasicDataSource getSuper(ValidationContext context) {
        return this.getSuper(null, context);
    }

    protected BasicDataSource getSuper(DSRequest dsRequest) {
        return this.getSuper(dsRequest, null);
    }

    protected BasicDataSource getSuper(DSRequest dsRequest, ValidationContext context) {
        if (this.autoDeriveDS instanceof BasicDataSource) {
            this.superDS = (BasicDataSource)this.autoDeriveDS;
            this.superDSName = this.superDS.dsName;
        }
        if (this.superDS == null && this.superDSName != null) {
            boolean fromContext = false;
            boolean fromDSRequest = false;
            log.debug("Looking up superDS of DataSource " + this.getName() + ": '" + this.superDSName + "'");
            try {
                if (context != null) {
                    this.superDS = context.getType(this.superDSName);
                }
                if (this.superDS != null) {
                    fromContext = true;
                } else {
                    if (dsRequest != null) {
                        this.superDS = (BasicDataSource)dsRequest.getCachedDataSourceInstance(this.superDSName);
                    }
                    if (this.superDS != null) {
                        fromDSRequest = true;
                    } else {
                        this.superDS = (BasicDataSource)DataSourceManager.getDataSource(this.superDSName, dsRequest);
                    }
                }
                if (this.superDS != null) {
                    if (context != null && !fromContext) {
                        context.addToTypeCache(this.superDSName, this.superDS);
                    }
                    if (dsRequest != null && !fromDSRequest) {
                        dsRequest.cacheDataSourceInstance(this.superDSName, this.superDS);
                    }
                }
            }
            catch (Exception e) {
                log.warning("Exception loading DataSource " + this.superDSName + ": " + DataTools.getStackTrace(e));
            }
            if (this.superDS == null) {
                log.warning("DataSource " + this.getName() + " declared to inherit from DataSource " + this.superDSName + " which could not be loaded");
                this.superDSName = null;
            }
        }
        return this.superDS;
    }

    public String getProperty(String key) {
        return this.dsConfig.getString(key, null);
    }

    public Object getObjectProperty(String key) {
        return this.dsConfig.get(key);
    }

    public List getListProperty(String key) {
        return (List)this.dsConfig.get(key);
    }

    public DataTypeMap getMapProperty(String key) {
        return this.dsConfig.getMap(key);
    }

    public List<String> getPatternMultiWildcards() {
        LinkedList<String> multiWildcards = new LinkedList<String>();
        Object patternMultiWildcard = this.dsConfig.get("patternMultiWildcard");
        if (patternMultiWildcard == null) {
            multiWildcards.add("*");
        } else if (patternMultiWildcard instanceof String) {
            multiWildcards.add(patternMultiWildcard.toString());
        } else if (patternMultiWildcard instanceof List) {
            multiWildcards.addAll((List)patternMultiWildcard);
        }
        return multiWildcards;
    }

    public List<String> getPatternSingleWildcards() {
        LinkedList<String> singleWildcards = new LinkedList<String>();
        Object patternSingleWildcard = this.dsConfig.get("patternSingleWildcard");
        if (patternSingleWildcard == null) {
            singleWildcards.add("%");
            singleWildcards.add("?");
        } else if (patternSingleWildcard instanceof String) {
            singleWildcards.add(patternSingleWildcard.toString());
        } else if (patternSingleWildcard instanceof List) {
            singleWildcards.addAll((List)patternSingleWildcard);
        }
        return singleWildcards;
    }

    protected void buildFieldData() throws Exception {
        Object origRawFields = this.dsConfig.get("fields");
        if (origRawFields instanceof List) {
            for (Object fieldObject : (List)origRawFields) {
                String includeFrom;
                Map field;
                if (!(fieldObject instanceof Map) || (field = (Map)fieldObject).containsKey("name") || (includeFrom = (String)field.get("includeFrom")) == null) continue;
                if (includeFrom.contains(".")) {
                    includeFrom = includeFrom.substring(includeFrom.lastIndexOf(".") + 1);
                }
                field.put("name", includeFrom);
            }
            this.dsConfig.put("fields", DataTools.indexOnProperty((List)origRawFields, "name"));
        }
        this.dsFields = DataTools.mapMerge(this.getRawFields(), new LinkedHashMap());
        ArrayList<String> allFields = new ArrayList<String>(this.fieldList);
        allFields.addAll(this.dsFields.keySet());
        LinkedHashMap newFields = new LinkedHashMap();
        for (String fieldName : this.dsFields.keySet()) {
            Object validatorsObj;
            String type;
            Object fd = this.dsFields.get(fieldName);
            newFields.put(fieldName, fd);
            if (!(fd instanceof Map)) {
                log.warn(this.dsName + ": specification of field '" + fieldName + "' invalid: " + DataTools.prettyPrint(fd));
                continue;
            }
            Map fieldData = (Map)fd;
            String typeId = type = (String)fieldData.get("type");
            ArrayList<String> seenTypes = new ArrayList<String>();
            Map typeDef = this.getSimpleTypeDef(typeId);
            while (typeDef != null) {
                typeId = (String)typeDef.get("inheritsFrom");
                if (typeId != null) {
                    if (seenTypes.contains(typeId)) {
                        throw new Exception("Simple type '" + typeId + "' or one of the types it inherits from is inherited from one of its children which creates an infinite loop.");
                    }
                    seenTypes.add(typeId);
                }
                typeDef = this.getSimpleTypeDef(typeId);
            }
            if (this.simpleTypeInheritsFrom(type, "binary")) {
                Map<String, Boolean> map;
                String nativeName = (String)fieldData.get("nativeName");
                String metadataName = DataTools.getListEntry(allFields, fieldName + "_filename");
                if (metadataName == null) {
                    HashMap<String, Object> filename = new HashMap<String, Object>();
                    filename.put("name", fieldName + "_filename");
                    filename.put("type", "text");
                    filename.put("length", 255L);
                    filename.put("title", "Name");
                    filename.put("hidden", Boolean.TRUE);
                    filename.put("canEdit", Boolean.FALSE);
                    filename.put("customSQL", fieldData.get("customSQL"));
                    if (nativeName != null) {
                        filename.put("nativeName", nativeName + "_filename");
                    }
                    newFields.put(fieldName + "_filename", filename);
                } else {
                    map = (HashMap<String, Boolean>)this.dsFields.get(metadataName);
                    if (map == null) {
                        map = new HashMap<String, Boolean>();
                    }
                    if (!map.containsKey("hidden")) {
                        map.put("hidden", Boolean.TRUE);
                    }
                    if (!map.containsKey("canEdit")) {
                        map.put("canEdit", Boolean.FALSE);
                    }
                    if (!map.containsKey("customSQL")) {
                        map.put("customSQL", (Boolean)fieldData.get("customSQL"));
                    }
                    newFields.put(metadataName, map);
                }
                metadataName = DataTools.getListEntry(allFields, fieldName + "_filesize");
                if (metadataName == null) {
                    HashMap<String, Object> filesize = new HashMap<String, Object>();
                    filesize.put("name", fieldName + "_filesize");
                    filesize.put("type", "number");
                    filesize.put("title", "Size");
                    filesize.put("hidden", Boolean.TRUE);
                    filesize.put("canEdit", Boolean.FALSE);
                    filesize.put("customSQL", fieldData.get("customSQL"));
                    if (nativeName != null) {
                        filesize.put("nativeName", nativeName + "_filesize");
                    }
                    newFields.put(fieldName + "_filesize", filesize);
                } else {
                    map = (Map)this.dsFields.get(metadataName);
                    if (map == null) {
                        map = new HashMap();
                    }
                    if (!map.containsKey("hidden")) {
                        map.put("hidden", Boolean.TRUE);
                    }
                    if (!map.containsKey("canEdit")) {
                        map.put("canEdit", Boolean.FALSE);
                    }
                    if (!map.containsKey("customSQL")) {
                        map.put("customSQL", (Boolean)fieldData.get("customSQL"));
                    }
                    newFields.put(metadataName, map);
                }
                metadataName = DataTools.getListEntry(allFields, fieldName + "_date_created");
                if (metadataName == null) {
                    HashMap<String, Object> date_created = new HashMap<String, Object>();
                    date_created.put("name", fieldName + "_date_created");
                    date_created.put("type", "datetime");
                    date_created.put("title", "Date Created");
                    date_created.put("hidden", Boolean.TRUE);
                    date_created.put("canEdit", Boolean.FALSE);
                    date_created.put("customSQL", fieldData.get("customSQL"));
                    if (nativeName != null) {
                        date_created.put("nativeName", nativeName + "_date_created");
                    }
                    newFields.put(fieldName + "_date_created", date_created);
                } else {
                    map = (Map)this.dsFields.get(metadataName);
                    if (map == null) {
                        map = new HashMap();
                    }
                    if (!map.containsKey("hidden")) {
                        map.put("hidden", Boolean.TRUE);
                    }
                    if (!map.containsKey("canEdit")) {
                        map.put("canEdit", Boolean.FALSE);
                    }
                    if (!map.containsKey("customSQL")) {
                        map.put("customSQL", (Boolean)fieldData.get("customSQL"));
                    }
                    newFields.put(metadataName, map);
                }
            }
            if ((validatorsObj = fieldData.get("validators")) == null) continue;
            List validators = DataTools.makeListIfSingle(validatorsObj);
            for (Object validatorObj : validators) {
                String validatorType = null;
                Object errorMessage = null;
                Object applyWhen = null;
                if (validatorObj instanceof String) {
                    validatorType = (String)validatorObj;
                } else if (validatorObj instanceof Map) {
                    validatorType = (String)((Map)validatorObj).get("type");
                    errorMessage = ((Map)validatorObj).get("errorMessage");
                    applyWhen = ((Map)validatorObj).get("applyWhen");
                }
                this.updateFieldValidatorsMap(fieldName, (Map)validatorObj);
                if (!"required".equals(validatorType)) continue;
                fieldData.put("required", true);
                if (errorMessage != null) {
                    fieldData.put("requiredMessage", errorMessage);
                } else {
                    errorMessage = fieldData.get("requiredMessage");
                    if (errorMessage == null || "".equals(errorMessage)) {
                        errorMessage = this.getConfig().get("requiredMessage");
                        fieldData.put("requiredMessage", errorMessage);
                    }
                }
                if (applyWhen == null) continue;
                fieldData.put("conditionallyRequired", true);
            }
        }
        if (this instanceof ProvidesAdditionalFields) {
            newFields.putAll(((ProvidesAdditionalFields)((Object)this)).getAdditionalFields());
        }
        this.dsFields = newFields;
        for (String fieldName : new ArrayList(this.dsFields.keySet())) {
            Object valueMapEnum;
            Map fieldData = null;
            if (this.dsFields.get(fieldName) instanceof ArrayList) {
                String errorMessage = "Loading of DataSource '" + fieldName + "' failed: list of DataSourceFields is not of expected type. Required core schema files under {isomorphicDir}/system/schema may be missing or unreadable. This typically results from skipping installation steps. If using SmartGWT, verify your <inherits> and run a GWT compile.  If using SmartClient, verify you have copied the correct folders from Pro or better smartclientSDK.  Installation instructions are linked from the QuickStart Guide.";
                log.warn(errorMessage);
                throw new Exception(errorMessage);
            }
            fieldData = (Map)this.dsFields.get(fieldName);
            DSField field = null;
            if (!(fieldData instanceof DSField)) {
                field = new DSField(fieldData, this);
                this.dsFields.put(fieldName, field);
            } else {
                field = (DSField)((Object)fieldData);
            }
            if (!field.containsKey("name")) {
                field.put("name", fieldName);
            }
            if (field.getType() == null) {
                field.put("type", "text");
            }
            if (!this.fieldList.contains(fieldName)) {
                this.fieldList.add(fieldName);
            }
            String valueXPath = field.getValueXPath();
            if (!this.hasFieldXPaths && valueXPath != null && !"".equals(valueXPath.trim())) {
                this.hasFieldXPaths = true;
            }
            if (field.isDerived()) {
                if (field.getNativeName() == null) {
                    this.derivedClientToServerFieldMap.put(fieldName, fieldName);
                } else {
                    this.derivedClientToServerFieldMap.put(fieldName, field.getNativeName());
                }
            } else {
                if (!field.ignore() && field.getIncludeFrom() == null) {
                    if (field.getNativeName() == null) {
                        this.ds2NativeFieldMap.put(fieldName, fieldName);
                    } else {
                        String fieldTableName = field.getProperty("tableName");
                        String dsTableName = (String)this.dsConfig.get("tableName");
                        if (fieldTableName != null && dsTableName != null && !fieldTableName.equals(dsTableName)) {
                            String nativeName = fieldTableName + "." + field.getNativeName();
                            if (!this.ds2NativeFieldMap.containsValue(nativeName)) {
                                this.ds2NativeFieldMap.put(fieldName, nativeName);
                            } else {
                                log.warn("Datasource '" + this.getID() + "' has multiple fields with the same nativeName and tableName combination - '" + nativeName + "'. This is not allowed.");
                            }
                        } else if (!this.ds2NativeFieldMap.containsValue(field.getNativeName())) {
                            this.ds2NativeFieldMap.put(fieldName, field.getNativeName());
                        } else {
                            log.warn("Datasource '" + this.getID() + "' has multiple fields with the same nativeName='" + field.getNativeName() + "'. This is not allowed.");
                        }
                    }
                }
                if (field.isPrimaryKey()) {
                    this.primaryKeys.add(fieldName);
                }
            }
            if (field.containsKey("valueMapEnum") && (valueMapEnum = field.get("valueMapEnum")) != null) {
                Class valueEnumClass = null;
                try {
                    valueEnumClass = Reflection.classForName(valueMapEnum.toString());
                }
                catch (Exception ex) {
                    log.warn("Failed to instantiate enumeration " + valueMapEnum.toString() + " specified in \"valueMapEnum\" property.");
                }
                if (valueEnumClass != null) {
                    if (valueEnumClass.isEnum()) {
                        if (this.dsConfig.get("enumTranslateStrategy") == null) {
                            Map<Object, String> enumValues = Reflection.getEnumValues(valueEnumClass, "intEnum".equals(field.getType()));
                            field.put("valueMap", enumValues);
                            fieldData.put("valueMap", enumValues);
                        } else {
                            String enumTranslateStrategy = this.getEnumTranslateStrategy();
                            if (!"bean".equals(enumTranslateStrategy)) {
                                Map<Object, String> enumValues = Reflection.getEnumValues(valueEnumClass, enumTranslateStrategy);
                                field.put("valueMap", enumValues);
                                fieldData.put("valueMap", enumValues);
                            }
                        }
                    } else {
                        log.warn("Class " + valueMapEnum.toString() + " specified in \"valueMapEnum\" property is not enumeration.");
                    }
                }
            }
            if (field.get("canFilter") != null || !field.getBoolean("stringInBrowser", false)) continue;
            field.put("canFilter", Boolean.FALSE);
            ((Map)this.getRawFields().get(field.getName())).put("canFilter", Boolean.FALSE);
        }
        this.registerAuditModeForFields();
        this.renameSpecialAuditFields();
        this.native2DSFieldMap = DataTools.reverseMap(this.ds2NativeFieldMap);
        this.derivedServerToClientFieldMap = DataTools.reverseMap(this.derivedClientToServerFieldMap);
        Object rawTypes = this.dsConfig.get("types");
        if (rawTypes instanceof List) {
            this.dsConfig.put("types", DataTools.indexOnProperty((List)rawTypes, "ID"));
        }
    }

    private void registerAuditModeForFields() {
        block12: for (String fieldName : this.dsFields.keySet()) {
            DSField field = (DSField)this.dsFields.get(fieldName);
            String audit = (String)field.get("audit");
            if (!field.containsKey("audit")) {
                if (field.isBinary()) {
                    if (this.auditOnChangeFields == null) {
                        this.auditOnChangeFields = new HashSet<String>();
                    }
                    this.auditOnChangeFields.add(fieldName);
                    continue;
                }
                if (this.isBinaryMetadata(field)) {
                    DSField workBinary = this.getAssociatedBinaryField(field);
                    audit = workBinary != null ? workBinary.getString("audit", "change") : "change";
                }
            }
            if (audit == null) continue;
            switch (audit) {
                case "never": {
                    if (this.auditNeverFields == null) {
                        this.auditNeverFields = new HashSet<String>();
                    }
                    this.auditNeverFields.add(fieldName);
                    continue block12;
                }
                case "changeRequest": {
                    if (this.auditOnReqChangeFields == null) {
                        this.auditOnReqChangeFields = new HashSet<String>();
                    }
                    this.auditOnReqChangeFields.add(fieldName);
                }
                case "change": {
                    if (this.auditOnChangeFields == null) {
                        this.auditOnChangeFields = new HashSet<String>();
                    }
                    this.auditOnChangeFields.add(fieldName);
                    continue block12;
                }
                case "always": {
                    continue block12;
                }
            }
            boolean auditBool = field.getBoolean("audit");
            log.warn("Resolved deprecated or invalid value '" + field.get("audit") + "' for DSField " + fieldName + " audit property as " + (auditBool ? "'always'" : "'never'") + "; must be one of 'always', 'change', or 'never'");
        }
    }

    protected DSField getAssociatedBinaryField(DSField field) {
        String fieldName = field.getName();
        if (fieldName == null) {
            return null;
        }
        fieldName = fieldName.endsWith("_filename") ? fieldName.substring(0, fieldName.length() - "_filename".length()) : (fieldName.endsWith("_filesize") ? fieldName.substring(0, fieldName.length() - "_filesize".length()) : (fieldName.endsWith("_date_created") ? fieldName.substring(0, fieldName.length() - "_date_created".length()) : null));
        return this.getField(fieldName);
    }

    public Map getAuditRecord(DSRequest req, Map values) throws Exception {
        return this.getAuditRecord(req, values, null);
    }

    public Map getAuditRecord(DSRequest req, Map inValues, Map oldValues) throws Exception {
        String fieldName;
        List<String> auditFields;
        HashMap<String, Object> values = new HashMap<String, Object>(inValues);
        if (!"remove".equals(req.getOperationType())) {
            this.populateAuditOnRequestChangeValues(req, values);
        }
        this.removeNeverAuditValues(req, values);
        if (oldValues != null) {
            this.removeUnchangedAuditChangeValues(req, values, oldValues);
        }
        if ((auditFields = this.auditDS._getFieldNames()).contains(fieldName = this.getAuditChangedFieldsFieldName())) {
            if (oldValues != null) {
                List<String> changedFields = this.getUpdateChangedFields(req, oldValues);
                if (changedFields != null) {
                    values.put(fieldName, changedFields);
                }
            } else if ("update".equals(req.getOperationType())) {
                log.warn("getAuditRecord() was called with a null 'oldValues' - cannot determine which fields have changed values");
            }
        } else {
            log.warn("When saving audit record, the 'changed fields' field is not defined, ignoring!");
        }
        fieldName = this.getAuditUserFieldName();
        if (auditFields.contains(fieldName)) {
            values.put(fieldName, req.getUserId());
        } else {
            log.warn("When saving audit record, the user field is not defined, ignoring!");
        }
        fieldName = this.getAuditTypeFieldName();
        if (auditFields.contains(fieldName)) {
            values.put(fieldName, req.getOperationType());
        } else {
            log.warn("When saving audit record, the type field is not defined, ignoring!");
        }
        fieldName = this.getAuditTimestampFieldName();
        if (auditFields.contains(fieldName)) {
            values.put(fieldName, new Date());
        } else {
            log.warn("When saving audit record, the timestamp field is not defined, ignoring!");
        }
        return values;
    }

    protected void writeMultiAudits(List valueSets, DSRequest originatingDSRequest) throws Exception {
        if (!"add".equals(originatingDSRequest.getOperationType())) {
            log.warn("writeMultiAudits() was called for an operation of type '" + originatingDSRequest.getOperationType() + "'.  This method only works for 'add' operations - cannot continue");
            return;
        }
        Map sequences = this.getSequences();
        if (sequences != null && sequences.keySet().size() > 0) {
            log.warn("writeMultiAudits() called for dataSource '" + this.getID() + "', but the dataSource has at least one sequence field.  We cannot write multi-audit records for dataSources with sequence fields - bailing");
            return;
        }
        DataSource auditDS = this.getAuditDataSource();
        DSRequest auditReq = new DSRequest(auditDS, "add");
        if (originatingDSRequest != null) {
            auditReq.setRPCManager(originatingDSRequest.getRPCManager());
            auditReq.setParameter("multiInsertStrategy", originatingDSRequest.getParameter("multiInsertStrategy"));
        }
        ArrayList<Map> auditSets = new ArrayList<Map>();
        Iterator i = valueSets.iterator();
        while (i.hasNext()) {
            Map<String, Object> valueSet = this.getRecord(i.next());
            auditSets.add(this.getAuditRecord(originatingDSRequest, valueSet));
        }
        auditReq.setValues(auditSets);
        auditReq.execute();
    }

    protected void populateAuditOnRequestChangeValues(DSRequest req, Map values) {
        if (this.auditOnReqChangeFields == null) {
            return;
        }
        Map updatedValues = req.getValues();
        if (updatedValues == null) {
            return;
        }
        for (String fieldName : this.auditOnReqChangeFields) {
            if (!updatedValues.containsKey(fieldName)) continue;
            values.put(fieldName, updatedValues.get(fieldName));
        }
    }

    protected void removeNeverAuditValues(DSRequest req, Map values) {
        if (this.auditNeverFields == null) {
            return;
        }
        for (String fieldName : this.auditNeverFields) {
            values.remove(fieldName);
        }
    }

    protected void removeUnchangedAuditChangeValues(DSRequest req, Map values, Map lastValues) {
        if (this.auditOnChangeFields == null) {
            return;
        }
        HashMap updatedValues = req.getValues();
        if (updatedValues == null) {
            updatedValues = new HashMap();
        }
        for (String fieldName : this.auditOnChangeFields) {
            if (updatedValues.containsKey(fieldName) && this.valuesDiffer(fieldName, values, lastValues)) continue;
            values.remove(fieldName);
        }
    }

    boolean isAuditOnChangeField(String fieldName) {
        return this.auditOnChangeFields != null && this.auditOnChangeFields.contains(fieldName);
    }

    boolean isAuditNeverField(String fieldName) {
        return this.auditNeverFields != null && this.auditNeverFields.contains(fieldName);
    }

    private void renameSpecialAuditFields() {
        Map<String, String> specialFields = AuditDSGenerator.specialFields;
        block0: for (String configName : specialFields.keySet()) {
            String result = AuditDSGenerator.getSpecialAuditFieldName(configName, specialFields.get(configName), this);
            if (this.getField(result) == null) continue;
            log.warn("Special audit field " + result + " is already defined, trying to add a suffix.");
            int counter = 2;
            while (true) {
                String tmpName;
                if (this.getField(tmpName = result + counter) == null) {
                    log.debug("Using " + tmpName + " for " + configName + ".");
                    this.dsConfig.put(configName, tmpName);
                    result = tmpName;
                    continue block0;
                }
                ++counter;
            }
        }
    }

    private void updateFieldValidatorsMap(String fieldName, Map validatorObj) {
        Object dependentFieldsObj = validatorObj.get("dependentFields");
        if (dependentFieldsObj == null) {
            return;
        }
        List dependentFields = DataTools.makeListIfSingle(dependentFieldsObj);
        for (String dependentField : dependentFields) {
            Set<String> fieldsToValidate = this.validatorsDependentFields.get(dependentField);
            if (fieldsToValidate == null) {
                fieldsToValidate = new HashSet<String>();
                this.validatorsDependentFields.put(dependentField, fieldsToValidate);
            }
            fieldsToValidate.add(fieldName);
        }
    }

    public Map getExpandedDs2NativeFieldMap() {
        Map fieldMap = new LinkedHashMap();
        if (this.getSuper() != null) {
            fieldMap = this.getSuper().getExpandedDs2NativeFieldMap();
        }
        DataTools.mapMerge(this.ds2NativeFieldMap, fieldMap);
        return fieldMap;
    }

    @Override
    public DSField getField(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        DSField field = (DSField)this.dsFields.get(fieldName);
        if (this.getSuper() != null) {
            DSField ancestor = this.getSuper().getField(fieldName);
            if (ancestor == null) {
                return field;
            }
            if (field == null) {
                field = ancestor;
            } else {
                Map merged = DataTools.mapUnion((Map)((Object)field), (Map)((Object)ancestor));
                field.putAll(merged);
            }
        }
        return field;
    }

    public String getClientConstructor() {
        String constructor = (String)this.dsConfig.get("instanceConstructor");
        if (constructor == null) {
            constructor = (String)this.dsConfig.get("Constructor");
        }
        return constructor;
    }

    @Override
    public List<String> getPrimaryKeys() {
        List<Object> pks = new ArrayList();
        if (this.getSuper() != null) {
            pks = this.getSuper().getPrimaryKeys();
        }
        DataTools.addAll(pks, this.primaryKeys);
        return DataTools.removeDuplicates(pks);
    }

    public Map getDerivedNativeToDSFieldMap() {
        return this.derivedServerToClientFieldMap;
    }

    public Map getDerivedDSToNativeFieldMap() {
        return this.derivedClientToServerFieldMap;
    }

    @Override
    public boolean inheritsFrom(String dsName) {
        return this.getName().equals(dsName) || this.getSuper() != null && this.getSuper().inheritsFrom(dsName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object toRecords(Object data) throws Exception {
        ValidationContext vc = new ValidationContext();
        try {
            Object object = this.toRecords(data, vc);
            return object;
        }
        finally {
            vc.freeResources();
        }
    }

    @Override
    public Object toRecords(Object data, ValidationContext context) throws Exception {
        if (data instanceof List) {
            List recordList = (List)data;
            long start = System.currentTimeMillis();
            Object result = this.toRecords(recordList, context);
            long end = System.currentTimeMillis();
            if (log != null && log.isDebugEnabled()) {
                log.debug("Done validating " + recordList.size() + " '" + this.getName() + "'s at path '" + context.getPath() + "': " + (end - start) + "ms" + (recordList.size() == 0 ? "" : " (avg " + (end - start) / (long)recordList.size() + ")"));
            }
            return result;
        }
        long start = System.currentTimeMillis();
        Object result = this.toRecord(data, context);
        long end = System.currentTimeMillis();
        if (log != null && log.isDebugEnabled()) {
            log.debug("Done validating a '" + this.getName() + "' at path '" + context.getPath() + "': " + (end - start) + "ms");
        }
        return result;
    }

    public Object toRecords(List data, ValidationContext context) throws Exception {
        if (data == null) {
            return null;
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug("Validating " + data.size() + " '" + this.getName() + "'s at path '" + context.getPath() + "'");
        }
        ArrayList<Object> records = new ArrayList<Object>();
        boolean addIndex = !"".equals(context.getPath());
        for (int i = 0; i < data.size(); ++i) {
            if (addIndex) {
                context.addPath("" + i);
            }
            records.add(this.toRecord(data.get(i), context));
            if (!addIndex) continue;
            context.removePathSegment();
        }
        return records;
    }

    @Override
    public Object toRecord(Object data, ValidationContext context) throws Exception {
        if (data == null) {
            return null;
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug("Validating a '" + this.getName() + "' at path '" + context.getPath() + "'");
        }
        ++numRecords;
        if (data instanceof Element) {
            return this.elementAsRecord((Element)data, context);
        }
        if (!(data instanceof Map)) {
            if (!context.idAllowed() || !(data instanceof String)) {
                Logger.validation.warn("Unexpected Java type '" + data.getClass() + "' passed to DataSource '" + this.getName() + "' at path '" + context.getPath() + "'");
            }
            return data;
        }
        LinkedHashMap<String, Object> record = (LinkedHashMap<String, Object>)data;
        if (record.keySet().size() == 1 && (record.get("ref") instanceof String || record.get("withID") instanceof String)) {
            String expression = (String)record.get("ref");
            if (expression == null || expression.length() == 0) {
                expression = (String)record.get("withID");
            }
            return new CanvasRefExpression(expression);
        }
        context.addPath(this.getName());
        context.addToTemplateContext("dataSource", this);
        DSRequest request = context.getDSRequest();
        record = new LinkedHashMap<String, Object>(record);
        HashSet<String> addedNullValuesForValidators = new HashSet<String>();
        context.put("addedNullValuesForValidators", addedNullValuesForValidators);
        if (request != null && "update".equals(request.getOperationType()) && this.validatorsDependentFields.size() > 0) {
            HashSet keys = new HashSet(record.keySet());
            for (String fieldName : keys) {
                Set<String> fieldsToValidate;
                DSField field = (DSField)this.dsFields.get(fieldName);
                if (field != null && field.isPrimaryKey() || (fieldsToValidate = this.validatorsDependentFields.get(fieldName)) == null) continue;
                for (String fieldToValidate : fieldsToValidate) {
                    if (record.containsKey(fieldToValidate)) continue;
                    record.put(fieldToValidate, null);
                    addedNullValuesForValidators.add(fieldToValidate);
                }
            }
        }
        HashSet<String> addedNullValues = new HashSet<String>();
        context.put("addedNullValues", addedNullValues);
        HashSet<String> addedPKValues = new HashSet<String>();
        if (request != null && ("update".equals(request.getOperationType()) || "validate".equals(request.getOperationType()))) {
            for (DSField field : this.getFields()) {
                if (field.isConditionallyRequired() && !record.containsKey(field.getName())) {
                    record.put(field.getName(), null);
                    addedNullValues.add(field.getName());
                }
                if (request.getAllowMultiUpdate() || !field.isPrimaryKey() || record.containsKey(field.getName())) continue;
                record.put(field.getName(), request.getCriteriaValue(field.getName()));
                addedPKValues.add(field.getName());
            }
        }
        HashSet keys = new HashSet(record.keySet());
        for (String fieldName : keys) {
            DSField field = this.getField(fieldName);
            Object value = record.get(fieldName);
            if (field == null) {
                this.handleExtraValue(record, fieldName, value, context);
                continue;
            }
            if (value instanceof JSExpression) continue;
            record.put(fieldName, this.validateFieldValue(record, field, value, context));
        }
        this.checkStructure(record, context);
        this.checkAutoConstruct(record, context);
        this.validateRecord(record, context);
        Iterator i = addedNullValues.iterator();
        while (i.hasNext()) {
            record.remove(i.next());
        }
        context.remove("addedNullValues");
        i = addedPKValues.iterator();
        while (i.hasNext()) {
            record.remove(i.next());
        }
        i = addedNullValuesForValidators.iterator();
        while (i.hasNext()) {
            record.remove(i.next());
        }
        context.removePathSegment();
        return record;
    }

    protected void validateRecord(Map record, ValidationContext context) throws Exception {
        if (record == null) {
            return;
        }
        ErrorReport currentErrors = context.getCurrentErrorReport();
        ErrorReport errors = this.validateRecord(record, currentErrors, context);
        if (errors != null && currentErrors == null) {
            for (Object fieldName : errors.keySet()) {
                Object error = errors.get(fieldName);
                if (error == null) continue;
                context.addError((String)fieldName, error);
            }
        }
    }

    protected void handleExtraValue(Map record, String fieldName, Object value, ValidationContext context) throws Exception {
        Map vMap;
        if (value == null) {
            return;
        }
        if ("strictValidation".equals(fieldName)) {
            return;
        }
        if (value instanceof Map && (vMap = (Map)value).size() == 2 && vMap.containsKey("strictValidation") && vMap.containsKey("#text")) {
            return;
        }
        Logger.validation.debug("Value provided for unknown field: " + this.getName() + "." + fieldName + ": value is: " + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object elementAsRecord(Element element, ValidationContext context) throws Exception {
        Boolean strictValidation = (Boolean)context.get("strictValidation");
        if (strictValidation == null) {
            strictValidation = config.getBoolean("schema.strict.all");
        }
        Boolean strictValidationToRestore = strictValidation;
        context.addStrictModePath(this.getName());
        String elementFullName = context.getStrictModePath();
        Boolean elementStrictValidation = config.getBoolean("schema.strict." + elementFullName);
        if (elementStrictValidation != null) {
            strictValidation = elementStrictValidation;
        }
        if ("false".equals(this.getProperty("strictValidation"))) {
            strictValidation = Boolean.FALSE;
        }
        if (!PreCache.isCachingFinished()) {
            strictValidation = Boolean.FALSE;
        }
        try {
            String elementExplicitStrict;
            DataSource dsType;
            String declaredType;
            IType elementType = this.getExplicitType(element, context);
            if (elementType != null && elementType instanceof SimpleType) {
                log.debug("elementAsRecord using explicitly declared simple type: " + elementType.getName() + " at: " + context.getPath());
                Object object = ((SimpleType)elementType).create(element, context);
                return object;
            }
            if (elementType == null) {
                elementType = this.findElementType(element, context);
            }
            if (elementType != null && elementType instanceof DataSource && !(declaredType = (dsType = (DataSource)elementType).getName()).equals(this.getName())) {
                Object result;
                if (!(dsType.inheritsFrom(this.getName()) || declaredType.equals("JSExpression") || declaredType.equals("JS") || this.getName().equals("Object"))) {
                    Logger.validation.warn("Element is an instance of type " + dsType.getName() + ", which does not inherit from declared field type " + this.getName() + " at " + context.getPath());
                }
                Logger.validation.debug(this.getName() + " delegating validation to type: " + dsType.getName() + " at " + context.getPath());
                context.removeStrictModePathSegment();
                Object object = result = dsType.toRecords(element, context);
                return object;
            }
            if (element.hasAttributes() && (element.hasAttribute("ref") && element.getAttribute("ref").length() > 0 || element.hasAttribute("withID") && element.getAttribute("withID").length() > 0) && (element.getAttributes().getLength() == 1 || elementType != null && "DataSource".equals(elementType.getName())) && XML.getElementChildren(element).size() == 0) {
                DSField parentField;
                IType parentType;
                Object eparent;
                String expression = element.getAttribute("ref");
                if (expression == null || expression.length() == 0) {
                    expression = element.getAttribute("withID");
                }
                if ("fillGradient".equals(element.getNodeName())) {
                    String type;
                    eparent = (Element)element.getParentNode();
                    parentType = this.getExplicitType((Element)eparent, context);
                    if (parentType == null) {
                        parentType = this.findElementType((Element)eparent, context);
                    }
                    if (this.needsRefQuotedForGradient.contains(type = parentType.getName()) && (JSTranslater.isValidJSIdentifier(element.getAttribute("ref")) || JSTranslater.isValidJSIdentifier(element.getAttribute("withID")))) {
                        log.debug("ref is for a fillGradient item inside a DrawItem. Returning as string, to make sure gets quoted correctly");
                        String string = expression;
                        return string;
                    }
                }
                if (elementType != null && "DataSource".equals(elementType.getName())) {
                    context.removeStrictModePathSegment();
                    eparent = new DataSourceRefExpression(expression);
                    return eparent;
                }
                eparent = (Element)element.getParentNode();
                parentType = this.getExplicitType((Element)eparent, context);
                if (parentType == null) {
                    parentType = this.findElementType((Element)eparent, context);
                }
                if (parentType instanceof DataSource && (parentField = ((DataSource)parentType).getField(element.getTagName())) != null && "DataSource".equals(parentField.getType())) {
                    context.removeStrictModePathSegment();
                    DataSourceRefExpression dataSourceRefExpression = new DataSourceRefExpression(expression);
                    return dataSourceRefExpression;
                }
                context.removeStrictModePathSegment();
                eparent = new CanvasRefExpression(expression);
                return eparent;
            }
            context.addPath(XML.getXPathSegment(element));
            LinkedHashMap<String, Object> record = new LinkedHashMap<String, Object>();
            String oldBundleName = null;
            String oldBundleEncoding = null;
            if ("DataSource".equals(this.getName()) || "SimpleType".equals(this.getName())) {
                oldBundleName = context.getBundleName();
                oldBundleEncoding = context.getBundleEncoding();
                context.setBundleName(null);
                context.setBundleEncoding(null);
                NodeList children = element.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    String name = child.getNodeName();
                    if (!name.equals("fmt:bundle") || !(child instanceof Element)) continue;
                    Map childAttrs = XML.attributesToMap((Element)child);
                    String basename = (String)childAttrs.get("basename");
                    context.setBundleName(basename);
                    context.setBundleEncoding((String)childAttrs.get("encoding"));
                    break;
                }
                if (context.getBundleName() == null) {
                    String fieldName = context.getFieldName();
                    int index = fieldName.indexOf("@ID=");
                    if (index == -1) {
                        index = fieldName.indexOf("@loadID=");
                    }
                    if (index == -1) {
                        log.warn("Attempting to set default i18n resource bundle name, encountered an unexpected context fieldName property: " + fieldName);
                    } else {
                        int index1 = fieldName.indexOf("=", index);
                        int index2 = fieldName.indexOf("]", index);
                        int index3 = fieldName.indexOf(",", index);
                        if (index2 > 0 && (index2 < index3 || index3 == -1)) {
                            context.setBundleName(fieldName.substring(index1 + 1, index2));
                        } else if (index3 > 0) {
                            context.setBundleName(fieldName.substring(index1 + 1, index3));
                        } else {
                            log.warn("Attempting to set default i18n resource bundle name, did not find delimiting ']' or comma in the context fieldName property: " + fieldName);
                        }
                    }
                }
                if (context.getBundleName() == null) {
                    context.setBundleName(oldBundleName);
                }
                if (context.getBundleEncoding() == null) {
                    context.setBundleEncoding(oldBundleEncoding);
                }
            }
            if (!Boolean.FALSE.equals(strictValidation) && "false".equalsIgnoreCase(elementExplicitStrict = element.getAttribute("strictValidation"))) {
                strictValidation = Boolean.FALSE;
            }
            Map attributes = XML.attributesToMap(element);
            for (String attrName : attributes.keySet()) {
                boolean schemaExplicitStrict;
                DSField field = this.getField(attrName);
                Object attrValue = attributes.get(attrName);
                if (field == null) {
                    if (Boolean.TRUE.equals(strictValidation) && !this.isMethodExists(this, attrName)) {
                        this.logAttributeNotDeclaredMessage(context, this.getName(), attrName, elementFullName + " " + context.getPath());
                    }
                    record.put(attrName, attrValue);
                    this.handleExtraValue(record, attrName, attrValue, context);
                    continue;
                }
                if (!Boolean.FALSE.equals(strictValidation) && !(schemaExplicitStrict = field.getBoolean("strictValidation", true))) {
                    strictValidation = Boolean.FALSE;
                }
                if (field.isMultiple() && this.simpleTypeInheritsFrom(field.getType(), "string")) {
                    attrValue = attrValue == null || "".equals(((String)attrValue).trim()) ? new ArrayList() : DataTools.buildList(((String)attrValue).split(","));
                }
                context.put("strictValidation", strictValidation);
                record.put(attrName, this.validateFieldValue(record, field, attrValue, context));
            }
            List children = XML.getElementChildren(element);
            for (Element child : children) {
                Element indirectChild;
                DSField field;
                String elementExplicitStrict2;
                if (!Boolean.FALSE.equals(strictValidation) && "false".equalsIgnoreCase(elementExplicitStrict2 = child.getAttribute("strictValidation"))) {
                    strictValidation = Boolean.FALSE;
                }
                String fieldName = child.getTagName();
                elementStrictValidation = config.getBoolean("schema.strict." + elementFullName + "." + fieldName);
                if (elementStrictValidation != null) {
                    strictValidation = elementStrictValidation;
                }
                if ((field = this.getField(fieldName)) == null) {
                    if (Boolean.TRUE.equals(strictValidation) && !this.isMethodExists(this, fieldName)) {
                        this.logAttributeNotDeclaredMessage(context, this.getName(), fieldName, elementFullName + " " + context.getPath());
                    }
                } else {
                    boolean schemaExplicitStrict;
                    if (!Boolean.FALSE.equals(strictValidation) && !(schemaExplicitStrict = field.getBoolean("strictValidation", true))) {
                        strictValidation = Boolean.FALSE;
                    }
                    context.put("strictValidation", strictValidation);
                }
                if (child.hasAttribute("_isc_name")) {
                    fieldName = child.getAttributeNS(null, "_isc_name");
                    child.removeAttribute("_isc_name");
                }
                if ((elementType = this.getExplicitType(child, context)) != null) {
                    DataTools.putCombinedList(record, fieldName, this.validateFieldValue(record, fieldName, elementType, child, context));
                    continue;
                }
                List indirectChildren = XML.getElementChildren(child);
                boolean haveSingleJSExpression = false;
                if (field != null && field.isMultiple() && indirectChildren.size() == 1) {
                    Element onlyChild = (Element)indirectChildren.get(0);
                    IType type = this.getExplicitType(onlyChild, context);
                    if (type == null) {
                        type = this.findElementType(onlyChild, context);
                    }
                    if (type instanceof JSExpressionType) {
                        haveSingleJSExpression = true;
                    }
                }
                if (field != null && field.isMultiple() && !haveSingleJSExpression) {
                    Object value;
                    context.addStrictModePath(fieldName);
                    if (!indirectChildren.isEmpty()) {
                        value = indirectChildren;
                        DataTools.putCombinedList(record, fieldName, this.validateFieldValue(record, field, value, context));
                    } else if (!"true".equals(child.getAttribute("xsi:nil"))) {
                        if (child.hasAttributes()) {
                            DataTools.putCombinedList(record, fieldName, this.validateFieldValue(record, field, child, context));
                        } else {
                            value = XML.toSimpleValue(child);
                            if (value != null && !"".equals(((String)value).trim())) {
                                if (field.isMultiple() && "validOperators".equals(field.getName())) {
                                    DataTools.putCombinedList(record, fieldName, this.validateFieldValue(record, field, value, context));
                                } else if (field.isCommaSeparated()) {
                                    List<String> values = DataTools.buildList(((String)value).split(","));
                                    DataTools.putCombinedList(record, fieldName, this.validateFieldValue(record, field, values, context));
                                } else if (field.canFallbackToSingle()) {
                                    DataTools.putCombinedList(record, fieldName, this.validateFieldValue(record, field, child, context));
                                } else if (context.idAllowed()) {
                                    if (!record.containsKey(fieldName)) {
                                        record.put(fieldName, value);
                                    }
                                } else if (!record.containsKey(fieldName)) {
                                    record.put(fieldName, new JSExpression((String)value));
                                }
                            } else if (!record.containsKey(fieldName)) {
                                record.put(fieldName, new ArrayList());
                            }
                        }
                    }
                    context.removeStrictModePathSegment();
                    continue;
                }
                if (indirectChildren.size() == 1 && (elementType = this.findElementType(indirectChild = (Element)indirectChildren.get(0), context)) != null && !Boolean.TRUE.equals(context.get("skipSpecialTreatmentOfSingleIndirectChild")) && (field == null || field.getBoolean("flattenSingleChild", true))) {
                    String moveToField;
                    if (field != null && (moveToField = field.getProperty("moveTo")) != null) {
                        fieldName = moveToField;
                    }
                    DataTools.putCombinedList(record, fieldName, this.validateFieldValue(record, fieldName, elementType, indirectChild, context));
                    continue;
                }
                if (field != null) {
                    String moveToField = field.getProperty("moveTo");
                    if (moveToField != null) {
                        fieldName = moveToField;
                    }
                    DataTools.putCombinedList(record, fieldName, this.validateFieldValue(record, field, child, context));
                    continue;
                }
                this.handleExtraElementValue(record, fieldName, child, indirectChildren, context);
            }
            context.put("strictValidation", strictValidation);
            context.put("elementFullName", elementFullName);
            if (children.isEmpty()) {
                String value = XML.toSimpleValue(element);
                if (value == null || "".equals(value.trim())) {
                    value = XML.getElementText(element);
                }
                if (value != null && !"".equals(value.trim())) {
                    if (attributes.isEmpty()) {
                        Object object;
                        if (context.idAllowed()) {
                            object = value;
                            return object;
                        }
                        object = new JSExpression(value);
                        return object;
                    }
                    record.put("#text", value);
                }
            }
            this.checkStructure(record, context);
            this.checkAutoConstruct(record, context);
            if ("DataSource".equals(this.getName())) {
                context.setBundleName(oldBundleName);
                context.setBundleEncoding(oldBundleEncoding);
            }
            this.validateRecord(record, context);
            context.removePathSegment();
            context.removeStrictModePathSegment();
            LinkedHashMap<String, Object> linkedHashMap = record;
            return linkedHashMap;
        }
        finally {
            context.put("strictValidation", strictValidationToRestore);
        }
    }

    private void logAttributeNotDeclaredMessage(ValidationContext context, String name, String attrName, String additionalInfo) throws Exception {
        if (this._inLogAttributeNotDeclaredMessage) {
            return;
        }
        this._inLogAttributeNotDeclaredMessage = true;
        if ("Object".equals(name)) {
            return;
        }
        if ("DataSource".equals(name) && "Constructor".equals(attrName)) {
            return;
        }
        if ("DataSourceField".equals(name) && "propertiesOnly".equals(attrName)) {
            return;
        }
        if ("DataSourceField".equals(name)) {
            DSField field;
            this._inLogAttributeNotDeclaredMessage = true;
            DataSource formItemType = (DataSource)this.getType("FormItem", context);
            this._inLogAttributeNotDeclaredMessage = false;
            DSField dSField = field = formItemType == null ? null : formItemType.getField(attrName);
            if (field != null || this.isMethodExists(formItemType, attrName)) {
                return;
            }
        }
        Logger.validation.warning("attribute '" + attrName + "' is not declared in Component Schema '{" + name + ".ds.xml}' and strict mode is enabled.  See 'Strict Mode' overview in the documentation for details." + additionalInfo);
    }

    private boolean isMethodExists(DataSource ds, String methodName) {
        List methods = (List)ds.dsConfig.get("methods");
        if (methods != null) {
            for (Object methodObject : methods) {
                Map methodData = (Map)methodObject;
                if (!methodName.equals(methodData.get("name"))) continue;
                return true;
            }
        }
        return false;
    }

    protected void handleExtraElementValue(Map record, String fieldName, Element child, List indirectChildren, ValidationContext context) throws Exception {
        Object value = null;
        if (indirectChildren.size() == 0 && !child.hasAttributes()) {
            value = XML.toSimpleValue(child);
        } else if ("true".equals(child.getAttribute("xsi:nil"))) {
            value = null;
        } else {
            Map mapValue;
            BasicDataSource objectDS = context.getType("Object");
            value = ((DataSource)objectDS).toRecord(child, context);
            if (value instanceof Map && (mapValue = (Map)value).size() == 1 && mapValue.containsKey("Action")) {
                value = mapValue.get("Action");
            }
        }
        if (!record.containsKey(fieldName)) {
            record.put(fieldName, value);
        } else {
            DataTools.putCombinedList(record, fieldName, value);
        }
        this.handleExtraValue(record, fieldName, value, context);
    }

    protected Object validateFieldValue(Map record, DSField field, Object value, ValidationContext context) throws Exception {
        return this.validateFieldValue(record, field.getName(), null, value, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object validateFieldValue(Map record, String fieldName, IType declaredType, Object value, ValidationContext context) throws Exception {
        ++numFields;
        context.addPath(fieldName);
        context.addToTemplateContext("field", this.getField(fieldName));
        context.addToTemplateContext("record", record);
        try {
            Object object;
            IType fieldType;
            block25: {
                DataSource ds;
                Object strictValidationS;
                IType type;
                DSField field = this.getField(fieldName);
                fieldType = this.getFieldType(fieldName, context);
                IType iType = type = declaredType != null ? declaredType : fieldType;
                if (type == null && field != null) {
                    Logger.validation.warning("No such type '" + field.getType() + "', not processing field value at " + context.getPath());
                    Object object2 = value;
                    return object2;
                }
                Boolean strictValidation = Boolean.TRUE.equals(context.get("strictValidation"));
                if (fieldType instanceof DataSource && "false".equals(strictValidationS = (ds = (DataSource)fieldType).getConfig().getString("strictValidation"))) {
                    strictValidation = Boolean.FALSE;
                }
                if (strictValidation.booleanValue()) {
                    if (type == null && field == null) {
                        this.logAttributeNotDeclaredMessage(context, this.getName(), fieldName, context.getPath());
                    }
                    if (value instanceof Element) {
                        Map attributes = XML.attributesToMap((Element)value);
                        for (Object attributeNameObject : attributes.keySet()) {
                            String attributeName = (String)attributeNameObject;
                            String prop = field != null ? field.getProperty(attributeName) : null;
                            String name = this.getName();
                            DSField attributeField = null;
                            if (fieldType instanceof DataSource) {
                                DataSource attributeFieldDataSource = (DataSource)fieldType;
                                attributeField = attributeFieldDataSource.getField(attributeName);
                                name = attributeFieldDataSource.getName();
                            }
                            if (prop != null || attributeField != null) continue;
                            this.logAttributeNotDeclaredMessage(context, name, attributeName, context.getPath());
                        }
                    }
                }
                if (Logger.validation.isDebugEnabled()) {
                    Logger.validation.debug("Validating field:\n" + context.getPath() + " as " + this.getName() + "." + fieldName + " type: " + type.getName());
                }
                boolean enabledIdAllowed = false;
                boolean enabledPropertiesOnly = false;
                try {
                    if (field != null && field.isPropertiesOnly() && !context.isPropertiesOnly()) {
                        context.setPropertiesOnly();
                        enabledPropertiesOnly = true;
                    }
                    if (field != null && field.getBoolean("idAllowed") && !context.idAllowed()) {
                        context.setIdAllowed();
                        enabledIdAllowed = true;
                    }
                    if (field == null) {
                        if (type != null && "Process".equals(type.getName()) && !context.isPropertiesOnly()) {
                            context.setPropertiesOnly();
                            enabledPropertiesOnly = true;
                        }
                        if (type != null && ("UserSummary".equals(type.getName()) || "UserFormula".equals(type.getName())) && !context.isPropertiesOnly()) {
                            context.setPropertiesOnly();
                            enabledPropertiesOnly = true;
                        }
                    }
                    context.setCurrentRecord(record);
                    context.setCurrentDataSource(this);
                    object = type.create(value, context);
                    if (enabledPropertiesOnly) {
                        context.setPropertiesOnly(false);
                    }
                    if (!enabledIdAllowed) break block25;
                    context.setIdAllowed(false);
                }
                catch (Throwable throwable) {
                    if (enabledPropertiesOnly) {
                        context.setPropertiesOnly(false);
                    }
                    if (enabledIdAllowed) {
                        context.setIdAllowed(false);
                    }
                    if (fieldType instanceof DataSource) {
                        // empty if block
                    }
                    throw throwable;
                }
            }
            if (!(fieldType instanceof DataSource)) {
                // empty if block
            }
            return object;
        }
        finally {
            context.removePathSegment();
        }
    }

    public void checkStructure(Map record, ValidationContext context) {
        for (String fieldName : this._getFieldNames()) {
            Object value;
            DSField field = this.getField(fieldName);
            if (!this.checkRequired(record, field, value = record.get(fieldName), context) || value == null && !record.containsKey(fieldName) && !field.isConditionallyRequired()) continue;
            if (value instanceof JSExpression) {
                return;
            }
            if (field.isMultiple() && !field.canFallbackToSingle() && value != null) {
                value = DataTools.makeListIfSingle(value);
            }
            record.put(fieldName, value);
            if (field.getUniqueProperty() == null) continue;
            value = DataTools.indexOnProperty(DataTools.makeListIfSingle(value), field.getUniqueProperty());
            record.put(fieldName, value);
        }
    }

    public boolean checkRequired(Map record, DSField field, Object value, ValidationContext context) {
        try {
            DefaultValidators.ValidatorFunc required2;
            ErrorMessage error;
            if (field.isRequiredForRecord(record, this, context) && (error = (required2 = DefaultValidators.getBuiltinValidator("required")).validate(new HashMap(), value, field.getName(), record, context)) != null) {
                context.addError(field.getName(), error);
                return false;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception thrown during isRequiredForRecord() call; falling back to the \"required\" setting", e);
            return field.isRequired();
        }
        return true;
    }

    public void checkAutoConstruct(Map record, ValidationContext context) {
        String scClassName;
        boolean propertiesOnly = context.isPropertiesOnly() || DataTools.getBoolean(record, "propertiesOnly");
        String constructor = (String)record.get("constructor");
        if (constructor == null) {
            constructor = this.getClientConstructor();
        }
        if (constructor != null) {
            if (!propertiesOnly) {
                record.put("__autoConstruct", constructor);
            } else {
                record.put("_constructor", constructor);
            }
            if (record.containsKey("constructor")) {
                record.remove("constructor");
            }
        }
        if (!record.containsKey("scClassName") && (scClassName = this.dsConfig.getString("scClassName")) != null) {
            record.put("scClassName", scClassName);
        }
    }

    public IType findElementType(Element element, ValidationContext context) throws Exception {
        if (element == null) {
            return null;
        }
        String tagName = element.getTagName();
        IType type = this.getType(tagName, context);
        return type;
    }

    public IType getExplicitType(Element element, ValidationContext context) throws Exception {
        IType type = null;
        String xsType = element.getAttribute("xsi:type");
        if (xsType != null) {
            if (xsType.startsWith("xsd:")) {
                xsType = xsType.substring(4);
            }
            if ((type = this.getType(xsType, context)) != null) {
                return type;
            }
        }
        String constructor = element.getAttribute("constructor");
        type = this.getType(constructor, context);
        return type;
    }

    protected IType getFieldType(String fieldName, ValidationContext context) throws Exception {
        SimpleType type;
        HashMap<String, String> relatedRecordValidator;
        boolean isEnumType;
        ArrayList fieldValidators;
        IType baseType;
        String typeId;
        DSField field;
        block30: {
            boolean explicitExists;
            block31: {
                block33: {
                    block32: {
                        field = this.getField(fieldName);
                        if (field == null) {
                            return null;
                        }
                        typeId = field.getType();
                        baseType = this.getType(typeId, context);
                        if (baseType instanceof DataSource) {
                            return baseType;
                        }
                        if (field.get("fields") != null) {
                            HashMap<String, Object> aConfig = new HashMap<String, Object>();
                            aConfig.put("fields", field.get("fields"));
                            return DataSource.fromConfig(aConfig, context.getDSRequest());
                        }
                        fieldValidators = field.get("validators");
                        isEnumType = this.simpleTypeInheritsFrom(typeId, "enum") || this.simpleTypeInheritsFrom(typeId, "intEnum");
                        relatedRecordValidator = null;
                        if (!this.dsConfig.getBoolean((Object)"validateRelatedRecords", false) || field.getForeignKey() == null) break block30;
                        explicitExists = false;
                        if (fieldValidators == null) break block31;
                        if (!(fieldValidators instanceof String)) break block32;
                        if (!"hasRelatedRecord".equals(fieldValidators)) break block31;
                        explicitExists = true;
                        break block31;
                    }
                    if (!(fieldValidators instanceof Map)) break block33;
                    String type2 = (String)((Map)((Object)fieldValidators)).get("type");
                    if (!"hasRelatedRecord".equals(type2)) break block31;
                    explicitExists = true;
                    break block31;
                }
                if (fieldValidators instanceof List) {
                    for (Object val : (List)fieldValidators) {
                        Map map;
                        if (val instanceof String) {
                            if (!"hasRelatedRecord".equals(val)) continue;
                            explicitExists = true;
                            continue;
                        }
                        if (!(val instanceof Map) || !"hasRelatedRecord".equals((map = (Map)val).get("type"))) continue;
                        explicitExists = true;
                        break;
                    }
                }
            }
            if (!explicitExists) {
                relatedRecordValidator = new HashMap<String, String>();
                relatedRecordValidator.put("type", "hasRelatedRecord");
            }
        }
        if (fieldValidators == null && relatedRecordValidator == null) {
            if (isEnumType || field.getLength() != null) {
                fieldValidators = new ArrayList();
            } else {
                return baseType;
            }
        }
        if ((type = (SimpleType)field.get(CACHED_TYPE)) != null) {
            return type;
        }
        Object typeValidators = null;
        if (baseType != null) {
            typeValidators = ((SimpleType)baseType).getValidators();
            String simpleBaseTypeId = this.getSimpleBaseType(typeId);
            if (simpleBaseTypeId != null) {
                SimpleType simpleBaseType = (SimpleType)this.getType(simpleBaseTypeId, context);
                ((SimpleType)baseType).setSimpleBaseType(simpleBaseType);
            }
        }
        int fieldValidatorsIndex = typeValidators != null ? ((List)typeValidators).size() : 0;
        ArrayList<DataTypeMap> allValidators = DataTools.makeListIfSingle(DataTools.combineAsLists(typeValidators, fieldValidators));
        if ((allValidators = DataTools.makeListIfSingle(DataTools.combineAsLists(allValidators, relatedRecordValidator))) == null) {
            allValidators = new ArrayList<DataTypeMap>();
        }
        boolean enumValidatorFound = false;
        Long length = field.getLength();
        boolean lengthValidatorFound = false;
        Collection list = null;
        for (Object e : allValidators) {
            if (!(e instanceof Map)) continue;
            Map validator = (Map)e;
            if ("isOneOf".equals(validator.get("type")) || "inSet".equals(validator.get("type"))) {
                enumValidatorFound = true;
                if (!validator.containsKey("list")) {
                    if (list == null) {
                        list = this.getLegalValues(field);
                    }
                    if (list == null || list.size() == 0) {
                        log.warn("invalid " + validator.get("type") + " validator with no validator.list and no field.valueMap at field: " + fieldName + " of type: " + typeId);
                        continue;
                    }
                    validator.put("list", list);
                }
            }
            if (length == null || !"lengthRange".equals(validator.get("type")) || !validator.containsKey("max")) continue;
            Long max = null;
            try {
                String stringParam = validator.get("max").toString();
                stringParam = stringParam.trim();
                int decimalIndex = stringParam.indexOf(".");
                if (decimalIndex != -1 && Integer.parseInt(stringParam.substring(decimalIndex + 1)) == 0) {
                    stringParam = stringParam.substring(0, decimalIndex);
                }
                max = Long.valueOf(stringParam);
            }
            catch (NumberFormatException e2) {
                max = null;
            }
            if (max == null || max > length) continue;
            lengthValidatorFound = true;
        }
        if (isEnumType && !enumValidatorFound) {
            if (list == null) {
                list = this.getLegalValues(field);
            }
            if (list == null || list.size() == 0) {
                log.warn("invalid field of enum type has no field.valueMap at field: " + fieldName + " of type: " + typeId);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("for field: " + fieldName + " adding automatically generated inSet validator with values: " + DataTools.prettyPrint(list));
                }
                allValidators.add(fieldValidatorsIndex++, DataTools.buildMap("type", "inSet", "list", list));
            }
        }
        if (length != null && !lengthValidatorFound) {
            if (log.isDebugEnabled()) {
                log.debug("for field: " + fieldName + "adding automatically generated lengthRange validator for length:" + length);
            }
            allValidators.add(fieldValidatorsIndex++, DataTools.buildMap("type", "lengthRange", "max", length));
        }
        if (Logger.validation.isDebugEnabled()) {
            Logger.validation.debug("Creating field validator for field " + this.getName() + "." + field.getName() + ", of simple type: " + field.getType() + ", with inline validators: " + fieldValidators + ", and type validators: " + typeValidators);
        }
        type = new SimpleType(typeId, allValidators);
        field.put(CACHED_TYPE, type);
        return type;
    }

    protected Collection getLegalValues(DSField field) throws Exception {
        Map typeDef;
        Map localType;
        String typeId = field.getType();
        Object valueMap = field.get("valueMap");
        if (valueMap == null && (localType = this.getLocalType(typeId)) != null) {
            valueMap = localType.get("valueMap");
        }
        if (valueMap == null && (typeDef = BasicDataSource.getBuiltinType(typeId)) != null) {
            valueMap = typeDef.get("valueMap");
        }
        Collection<Object> list = null;
        if (valueMap instanceof Map) {
            list = ((Map)valueMap).keySet();
        } else if (valueMap instanceof Collection) {
            list = (Collection)valueMap;
        }
        return list;
    }

    protected IType makeType(String typeId, Map typeDef) throws Exception {
        if (typeDef == null) {
            return null;
        }
        SimpleType type = (SimpleType)typeDef.get(CACHED_TYPE);
        if (type != null) {
            return type;
        }
        if (Logger.validation.isDebugEnabled()) {
            Logger.validation.debug("Creating simple type validator for simple type: " + typeId);
        }
        type = new SimpleType(typeId, this.getSimpleTypeValidators(typeDef), typeDef);
        typeDef.put(CACHED_TYPE, type);
        return type;
    }

    protected IType getType(String typeId, ValidationContext context) throws Exception {
        Map typeDef = BasicDataSource.getBuiltinType(typeId);
        if (typeDef != null) {
            return this.makeType(typeId, typeDef);
        }
        typeDef = this.getLocalType(typeId, context);
        if (typeDef != null) {
            log.debug("Using local type " + typeId);
            if (typeDef.get("fields") != null) {
                DataSource ds = context.getType(typeId);
                if (ds == null) {
                    ds = DataSource.fromConfig(typeDef, context.getDSRequest());
                }
                return ds;
            }
            return this.makeType(typeId, typeDef);
        }
        DataSource ds = this.findDataSource(typeId, context);
        if (ds != null) {
            return ds;
        }
        return this.getSimpleType(typeId, context);
    }

    @Override
    protected Map getSimpleTypeDef(String typeId) {
        if (typeId == null) {
            return null;
        }
        Map typeDef = super.getSimpleTypeDef(typeId);
        if (typeDef != null) {
            return typeDef;
        }
        try {
            String typeConfigFile = DataStructCache.getInstanceFile(typeId, "datasources", "type");
            if (typeConfigFile == null) {
                return null;
            }
            typeDef = (Map)DataStructCache.loadInstance(typeConfigFile, typeId, "type");
            if (typeDef != null && typeDef.get("fields") == null) {
                return typeDef;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public IType getSimpleType(String typeId, ValidationContext context) throws Exception {
        if (this.dsConfig == null) {
            this.dsConfig = new DataTypeMap();
        }
        return context.getCustomSimpleType(typeId, this);
    }

    public Object getSimpleTypeValidators(Map type) throws Exception {
        Object validators = type.get("validators");
        String parentTypeID = (String)type.get("inheritsFrom");
        while (parentTypeID != null) {
            Map parentType = this.getSimpleTypeDef(parentTypeID);
            Object parentValidators = parentType.get("validators");
            validators = DataTools.combineAsLists(parentValidators, validators);
            parentTypeID = (String)parentType.get("inheritsFrom");
        }
        return validators;
    }

    protected DataSource findDataSource(String dsName, ValidationContext context) throws Exception {
        boolean frameworkSchemaOnly;
        if (dsName == null) {
            return null;
        }
        Map type = this.getLocalType(dsName);
        if (type != null && type.get("fields") != null) {
            log.debug("Getting DataSource " + dsName + " as a locally defined type");
            DataSource ds = context.getType(dsName);
            if (ds == null) {
                ds = DataSource.fromConfig(type, context.getDSRequest());
            }
            return ds;
        }
        boolean bl = frameworkSchemaOnly = "Object".equals(this.dsName) || "DataSource".equals(this.dsName);
        if (frameworkSchemaOnly) {
            return context.getType(dsName, DataTools.buildMap("frameworkSchemaOnly", true));
        }
        return context.getType(dsName);
    }

    @Override
    public Map selectUnique(Map constraints) throws Exception {
        return this.fetchSingle(DataTools.subsetMap(constraints, this.primaryKeys));
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean shouldAutoStartTransaction(DSRequest req, boolean ignoreExistingTransaction) throws Exception {
        if (req == null) return false;
        if (req.getDsTransaction() == null) {
            return false;
        }
        if (!ignoreExistingTransaction && this.getTransactionObject(req) != null) {
            return false;
        }
        if (!this.shouldAutoJoinTransaction(req)) {
            return false;
        }
        DSTransaction dsTransaction = req.getDsTransaction();
        if (this.isModificationRequest(req)) {
            if (!this.policyShouldOverrideConfig(req)) return true;
            if (dsTransaction.getTransactionPolicy() != 4) return true;
            return false;
        }
        if (this.policyShouldOverrideConfig(req)) {
            int policy = dsTransaction.getTransactionPolicy();
            if (policy == 4) {
                return false;
            }
            if (policy == 3) {
                return true;
            }
            if (policy == 2) {
                return dsTransaction.requestQueueIncludesUpdates();
            }
            if (policy != 1) return false;
            return false;
        }
        int policy = this.inferConfigTransactionPolicy(req);
        if (policy == 3) {
            return true;
        }
        if (policy != 2) return false;
        return dsTransaction.requestQueueIncludesUpdates();
    }

    private int inferConfigTransactionPolicy(DSRequest req) throws Exception {
        Boolean reqOverride;
        if (req != null && req.getDsTransaction() != null && (reqOverride = req.shouldJoinTransaction()) != null) {
            return reqOverride != false ? 3 : 4;
        }
        Boolean work = this.autoJoinAtOperationLevel(req);
        if (work != null) {
            return work != false ? 3 : 4;
        }
        work = this.autoJoinAtDataSourceLevel();
        if (work != null) {
            return work != false ? 3 : 4;
        }
        int tp = this.getProviderLevelTransactionPolicy(req);
        if (tp != 0) {
            return tp;
        }
        tp = this.getGlobalLevelTransactionPolicy(req);
        return 4;
    }

    public boolean shouldAutoJoinTransaction(DSRequest dsRequest) throws Exception {
        Boolean work;
        if (dsRequest != null && dsRequest.getDsTransaction() != null) {
            Boolean reqOverride = dsRequest.shouldJoinTransaction();
            if (reqOverride != null) {
                return reqOverride;
            }
            if (dsRequest.isCacheSyncRequest() || dsRequest.isConcatFetchRequest()) {
                return this.shouldAutoJoinTransaction(dsRequest.getPrimaryDSRequest());
            }
        }
        if ((work = this.autoJoinAtOperationLevel(dsRequest)) == null && (work = this.autoJoinAtDataSourceLevel()) == null) {
            if (dsRequest != null && dsRequest.getDsTransaction() != null) {
                DSTransaction dsTransaction = dsRequest.getDsTransaction();
                int policy = dsTransaction.getTransactionPolicy();
                if (policy == 4) {
                    return false;
                }
                if (policy == 3) {
                    return true;
                }
                if (policy == 2) {
                    return dsTransaction.requestQueueIncludesUpdates();
                }
                if (policy == 1) {
                    return dsTransaction.requestQueueIncludesPriorUpdate(dsRequest);
                }
            }
            if ((work = this.autoJoinAtProviderLevel(dsRequest)) == null) {
                work = this.autoJoinAtGlobalLevel(dsRequest);
            }
        }
        return work != null && work != false;
    }

    protected boolean policyShouldOverrideConfig(DSRequest req) throws Exception {
        Boolean work;
        if (req != null && req.getDsTransaction() != null) {
            Boolean reqOverride = req.shouldJoinTransaction();
            if (reqOverride != null) {
                return reqOverride;
            }
            if (req.getDsTransaction().getTransactionPolicy() == 0) {
                return false;
            }
        }
        if ((work = this.autoJoinAtOperationLevel(req)) == null) {
            work = this.autoJoinAtDataSourceLevel();
        }
        return work == null;
    }

    protected Boolean autoJoinAtOperationLevel(DSRequest req) throws Exception {
        DataTypeMap operationBinding = req.getDataSource().getOperationBinding(req.getOperationType(), req.getOperationId());
        if (operationBinding == null) {
            return null;
        }
        return operationBinding.getBoolean("autoJoinTransactions");
    }

    protected Boolean autoJoinAtDataSourceLevel() {
        return this.dsConfig.getBoolean("autoJoinTransactions");
    }

    protected Boolean autoJoinAtProviderLevel(DSRequest req) throws Exception {
        return null;
    }

    public int getProviderLevelTransactionPolicy(DSRequest req) throws Exception {
        return 0;
    }

    protected Boolean autoJoinAtGlobalLevel(DSRequest req) {
        String autoJoin = config.getString("autoJoinTransactions");
        if (autoJoin == null) {
            return null;
        }
        if (autoJoin.equalsIgnoreCase("true") || autoJoin.equalsIgnoreCase("ALL")) {
            return Boolean.TRUE;
        }
        if (autoJoin.equalsIgnoreCase("false") || autoJoin.equalsIgnoreCase("NONE")) {
            return Boolean.FALSE;
        }
        if (req != null && req.getDsTransaction() != null) {
            if (autoJoin.equalsIgnoreCase("FROM_FIRST_CHANGE")) {
                return req.getDsTransaction().requestQueueIncludesUpdates();
            }
            if (autoJoin.equalsIgnoreCase("ANY_CHANGE")) {
                return req.getDsTransaction().requestQueueIncludesUpdates();
            }
        }
        return null;
    }

    protected int getGlobalLevelTransactionPolicy(DSRequest req) {
        String autoJoin = config.getString("autoJoinTransactions");
        if (autoJoin == null) {
            return 0;
        }
        if (autoJoin.equalsIgnoreCase("true") || autoJoin.equalsIgnoreCase("ALL")) {
            return 3;
        }
        if (autoJoin.equalsIgnoreCase("false") || autoJoin.equalsIgnoreCase("NONE")) {
            return 4;
        }
        if (autoJoin.equalsIgnoreCase("FROM_FIRST_CHANGE")) {
            return 1;
        }
        if (autoJoin.equalsIgnoreCase("ANY_CHANGE")) {
            return 2;
        }
        return 0;
    }

    public boolean getReturnToTop() {
        return DataTools.asBoolean(this.dsConfig.get("returnToTop"), true);
    }

    public DataSource getAuditDataSource() {
        return this.getAuditDataSource(null);
    }

    public DataSource getAuditDataSource(DSRequest dsRequest) {
        if (!this.dsConfig.getBoolean((Object)"audit", false)) {
            return null;
        }
        if (this.auditDS == null) {
            String auditId = this.dsConfig.getString("auditDataSourceID");
            if (auditId == null) {
                auditId = "audit_" + this.getID();
            }
            try {
                DataTypeMap<String, Boolean> flags = new DataTypeMap<String, Boolean>();
                flags.put("allowFileSourceLookup", false);
                this.auditDS = DataSourceManager.getDataSource(auditId, dsRequest, flags);
            }
            catch (Exception e) {
                log.warn((Object)"There was an error retrieving audit DataSource:", e);
            }
            if (this.auditDS == null && !this.dsConfig.getBoolean((Object)"generateAuditDS", true)) {
                log.warn("Failed to retrieve manual audit DS '" + auditId + "'; make sure you've defined and imported it");
            }
        }
        return this.auditDS;
    }

    @Override
    public DSResponse executeClientExport(DSRequest req) throws Exception {
        req.setExportResults(true);
        DSResponse resp = new DSResponse(this);
        resp.setData(req.getRawValues());
        return resp;
    }

    @Override
    public DSResponse executeStoreTestData(DSRequest req) throws Exception {
        Object values = req.getRawValues();
        String fileName = (String)req.getParameter("fileName");
        if (fileName != null) {
            fileName = config.getPath("webRoot") + "/" + fileName;
            fileName = ISCFile.canonicalizePath(fileName);
        }
        String tagName = "item";
        DataSource ds = req.getDataSource();
        if (ds != null) {
            DataSource testDs;
            if (fileName == null) {
                fileName = ds.getTestFileName();
            }
            if (fileName == null && ds.getConfig().containsKey("sourceDataSourceID") && (testDs = DataSourceManager.getDataSource(ds.getConfig().get("sourceDataSourceID") + "_testData", null)) != null) {
                fileName = "ds://" + ds.getConfig().get("sourceDataSourceID") + "_testData/" + ds.getName() + ".data.xml";
            }
            if (fileName == null && !ISCFile.newInstance(fileName = "ds://" + ds.getConfig().get("sourceDataSourceID") + "/test_data/" + ds.getName() + ".data.xml").exists()) {
                fileName = null;
            }
            if (fileName == null) {
                fileName = config.getPath("webRoot") + "/test_data/" + ds.getName() + ".data.xml";
                fileName = ISCFile.canonicalizePath(fileName);
            }
            tagName = ds.getName();
        }
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("<List>\n");
        List data = (List)values;
        for (Object record : data) {
            XML.recordToXML(tagName, (Map)record, stringWriter, true, false, ds, req);
        }
        stringWriter.write("</List>");
        String testDataContent = stringWriter.toString();
        if (fileName.startsWith("ds://")) {
            DSFileSpec dsFileSpec = new DSFileSpec(fileName);
            DataSource testDs = DataSourceManager.getDataSource(dsFileSpec.getDataSourceName(), null);
            testDs.saveFile(dsFileSpec, testDataContent);
        } else {
            boolean saveFileBuiltinIsEnabled;
            List enabledBuiltinMethods = config.getList("RPCManager.enabledBuiltinMethods");
            boolean bl = saveFileBuiltinIsEnabled = enabledBuiltinMethods != null && (enabledBuiltinMethods.contains("saveFile") || enabledBuiltinMethods.contains("*"));
            if (!saveFileBuiltinIsEnabled) {
                throw new Exception("\"storeTestData\" operation cannot be used unless \"saveFile\" Builtin-RPC is enabled");
            }
            File f = new File(fileName);
            File dir = f.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            IOUtil.atomicWrite(testDataContent, fileName);
        }
        return new DSResponse(this);
    }

    @Override
    public DSResponse executeGetTestData(DSRequest req) throws Exception {
        String testFileName;
        BasicDataSource ds = this;
        Reader testDataReader = null;
        if (ds != null && (testFileName = ds.getTestFileName()) != null) {
            if (testFileName.startsWith("ds:/")) {
                DSFileSpec dsFileSpec = new DSFileSpec(testFileName);
                DataSource testDs = DataSourceManager.getDataSource(dsFileSpec.getDataSourceName(), null);
                testDataReader = testDs.getFile(dsFileSpec);
            } else {
                InputStream is = null;
                try {
                    is = DataTools.inputStreamForFilename(testFileName);
                    testDataReader = new InputStreamReader(is);
                }
                catch (Exception e) {
                    log.error((Object)"Unable to Load test data.", e);
                }
            }
        }
        DSResponse dsResponse = new DSResponse((DataSource)this, 0);
        dsResponse.setData((Object)DataTools.buildMap("testData", testDataReader));
        return dsResponse;
    }

    @Override
    public void freeQueueResources(DSRequest req) {
        if (this.downloadDsRequest != null) {
            try {
                DataSourceManager.free(this.downloadDsRequest.getDataSource());
                this.downloadDsRequest = null;
            }
            catch (Exception e) {
                log.warn((Object)"Exception while freeing download DSRequest", e);
            }
        }
        this.clearState();
        super.freeQueueResources(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAutoCreateAuditTableActive() {
        String auditAutoCreate = (String)Config.getProperty(GLOBAL_AUTO_CREATE_AUDIT_TABLE_KEY);
        if (auditAutoCreate != null && "true".equals(auditAutoCreate)) {
            return true;
        }
        if (this.dsConfig.getBoolean((Object)"audit", false) && this.dsConfig.getBoolean((Object)DATASOURCE_AUTO_CREATE_AUDIT_TABLE_KEY, false)) {
            return true;
        }
        if (auditGenerator != null && auditGenerator.hasMappingFor(this.getID())) {
            DataSource auditedDS = null;
            try {
                auditedDS = DataSourceManager.getDataSource(auditGenerator.getMappingFor(this.getID()));
                if (auditedDS.getConfig().getBoolean((Object)"audit", false) && auditedDS.getConfig().getBoolean((Object)DATASOURCE_AUTO_CREATE_AUDIT_TABLE_KEY, false)) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception ex) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (auditedDS != null) {
                    DataSourceManager.free(auditedDS);
                }
            }
        }
        return false;
    }

    @Override
    protected boolean isValidSubclass() {
        return true;
    }

    @Override
    public void transformMultipleFields(DSRequest req) {
        if ("false".equals(this.dsConfig.get("transformMultipleFields"))) {
            log.warn("transformMultipleFields is set to false for DataSource " + this.getName());
            return;
        }
        DataTypeMap binding = this.getOperationBinding(req);
        if (binding != null && "false".equals(binding.get("transformMultipleFields"))) {
            log.warn("transformMultipleFields is set to false for operationBinding on DataSource " + this.getName());
            return;
        }
        if (BasicDataSource.isFetch(req.getOperationType()) && !this.getMultipleFields().isEmpty()) {
            Map<String, Object> criteriaMap = req.getCriteria();
            if (!this.isAdvancedCriteria(criteriaMap) && this.dsConfig.getBoolean((Object)"transformSimpleCriteria", "sql".equals(this.getType()))) {
                for (DSField field : this.dsMultipleFields) {
                    if (!criteriaMap.containsKey(field.getName())) continue;
                    criteriaMap = req.getAdvancedCriteria(criteriaMap).getCriteriaAsMap();
                    break;
                }
            }
            if (this.isAdvancedCriteria(criteriaMap)) {
                req.setCriteria(this.multipleFieldCriteriaTransformer.transform(criteriaMap));
            }
        } else if (!BasicDataSource.isFetch(req.getOperationType())) {
            List valueSets = req.getValueSets();
            for (Map valueSet : valueSets) {
                for (DSField dsField : this.getMultipleFields()) {
                    StringBuffer result;
                    String sep;
                    ArrayList values;
                    String multipleStorage;
                    Object value = valueSet.get(dsField.getName());
                    if (value == null) continue;
                    String multipleSeparator = dsField.getMultipleStorageSeparator();
                    if (multipleSeparator == null) {
                        multipleSeparator = dsField.getMultipleValueSeparator();
                    }
                    if ("simpleString".equals(multipleStorage = dsField.getMultipleStorage())) {
                        values = (ArrayList)value;
                        sep = "";
                        result = new StringBuffer();
                        for (Object arrayValue : values) {
                            result.append(sep);
                            result.append(this.convertToSchemaValue(dsField, arrayValue));
                            sep = multipleSeparator;
                        }
                        valueSet.put(dsField.getName(), result.toString());
                        continue;
                    }
                    if (!"json".equals(multipleStorage)) continue;
                    values = (ArrayList)value;
                    sep = "";
                    result = new StringBuffer();
                    result.append("[");
                    for (Object arrayValue : values) {
                        result.append(sep);
                        result.append(this.convertToSchemaValue(dsField, arrayValue));
                        sep = ",";
                    }
                    result.append("]");
                    valueSet.put(dsField.getName(), result.toString());
                }
            }
        }
    }

    private String convertToSchemaValue(DSField field, Object value) {
        if (value == null) {
            log.warn("Value is null, skipping transform");
            return null;
        }
        String type = field.getType();
        if ("date".equals(type) || "time".equals(type) || "datetime".equals(type)) {
            Date date = (Date)value;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS zzz");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            String res = sdf.format(date);
            if ("json".equals(field.getMultipleStorage())) {
                res = "new Date(\"" + res + "\")";
            }
            return res;
        }
        if ("int".equals(type) || "integer".equals(type) || "intEnum".equals(type)) {
            return value.toString();
        }
        if ("float".equals(type) || "decimal".equals(type) || "double".equals(type)) {
            return value.toString();
        }
        if ("text".equals(type)) {
            if ("json".equals(field.getMultipleStorage())) {
                return "\"" + this.textToJson(value.toString()) + "\"";
            }
            return value.toString();
        }
        if (field.isJSON()) {
            try {
                return JSTranslater.strict().toJS(value);
            }
            catch (Exception e) {
                log.error((Object)("Unable to convert value for field: " + field.getName() + " - returning null"), e);
                return null;
            }
        }
        log.warn("Field " + field.getName() + " has value type " + field.getType() + " which is unhandled. Returning toString()");
        return value.toString();
    }

    private String textToJson(String text) {
        if (text == null) {
            return null;
        }
        return text.replace("\"", "\\\"");
    }

    private String textFromJson(String text) {
        if (text == null) {
            return null;
        }
        String res = text.replace("\\\"", "\"");
        return res;
    }

    private Object convertFromSchemaValue(DSField field, String value) {
        if (value == null) {
            return null;
        }
        if ("null".equals(value)) {
            return null;
        }
        String fieldName = field.getName();
        String type = field.getType();
        if ("date".equals(type) || "datetime".equals(type) || "time".equals(type)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS zzz");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                return sdf.parse(value);
            }
            catch (ParseException e) {
                log.warn((Object)("Error converting back " + value + " to UTC date"), e);
                return null;
            }
        }
        if ("int".equals(type) || "integer".equals(type) || "intEnum".equals(type)) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException ex) {
                log.warn((Object)("Error converting back " + value + " to Long"), ex);
                return null;
            }
        }
        if ("float".equals(type) || "decimal".equals(type) || "double".equals(type)) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException ex) {
                log.warn((Object)("Error converting back " + value + " to Double"), ex);
                return null;
            }
        }
        if ("text".equals(type)) {
            if ("json".equals(field.getMultipleStorage())) {
                return this.textFromJson(value.substring(1, value.length() - 1));
            }
            return value;
        }
        return value;
    }

    @Override
    public void transformMultipleFields(DSResponse res) {
        List<DSField> fields;
        boolean hadDS;
        String ot = res.getOperationType();
        if ("false".equals(this.dsConfig.get("transformMultipleFields"))) {
            log.warn("response:transformMultipleFields is set to false for DataSource " + this.getName());
            return;
        }
        boolean wasContainer = res.getData() != null && res.getData() instanceof List;
        boolean bl = hadDS = res.getDataSource() != null;
        if (!hadDS) {
            res.setDataSource(this);
        }
        if ((fields = this.getMultipleFields()) == null || fields.size() == 0) {
            return;
        }
        List records = res.getRecords();
        if (!hadDS) {
            res.setDataSource(null);
        }
        ArrayList<Map> result = new ArrayList<Map>();
        if (records == null) {
            log.warn("There are no records to be transformed by transformMultipleFields!");
            return;
        }
        boolean workWasDone = false;
        for (Object record : records) {
            if (!(record instanceof Map)) continue;
            Map mrecord = (Map)record;
            for (DSField f : fields) {
                String multipleStorage;
                DSField dsField = f;
                Object value = mrecord.get(dsField.getName());
                if (value == null) continue;
                String multipleSeparator = dsField.getMultipleStorageSeparator();
                if (multipleSeparator == null) {
                    multipleSeparator = dsField.getMultipleValueSeparator();
                }
                if ("none".equals(multipleStorage = dsField.getMultipleStorage())) {
                    log.debug("Field " + dsField.getName() + " is multiple, but multipleStorage 'none'. Skipping processing.");
                    continue;
                }
                if ("simpleString".equals(multipleStorage)) {
                    if (!(value instanceof String)) continue;
                    if (((String)value).length() == 0) {
                        mrecord.put(dsField.getName(), new ArrayList());
                        workWasDone = true;
                        continue;
                    }
                    String[] castedValue = DataTools.split((String)value, multipleSeparator);
                    ArrayList<Object> convertedValue = new ArrayList<Object>();
                    for (String val : castedValue) {
                        convertedValue.add(this.convertFromSchemaValue(dsField, val));
                    }
                    mrecord.put(dsField.getName(), convertedValue);
                    workWasDone = true;
                    continue;
                }
                if (!"json".equals(multipleStorage)) continue;
                String jsonValue = "";
                if (value instanceof String) {
                    jsonValue = (String)value;
                } else {
                    if (value instanceof ArrayList) {
                        ArrayList v = (ArrayList)value;
                        log.warn("Value is already ArrayList, skipping conversion");
                        continue;
                    }
                    jsonValue = value.toString();
                }
                JSTranslater jst = JSTranslater.get();
                Object parsed = null;
                try {
                    parsed = jst.fromJS(jsonValue);
                }
                catch (UnconvertableException uce) {
                    log.warn("JSON string is unconvertable during multipleStorage processing of field " + this.getID() + "." + dsField.getName() + ".  JSON text was: " + jsonValue);
                }
                mrecord.put(dsField.getName(), parsed);
                workWasDone = true;
            }
            result.add(mrecord);
        }
        if (workWasDone) {
            log.debug("response:Records were changed, updating dsResponse data, operation is " + ot);
            if (wasContainer) {
                res.setData(result);
            } else if (result.size() != 1) {
                log.error("Transformation error: When starting, dsResponse.data was record, and at the end there are more than 1 items in the list, returning first one");
                res.setData(result.get(0));
            } else {
                log.debug("When starting, dsResponse.data was record, storing record to dsResponse.data.");
                res.setData(result.get(0));
            }
        }
    }

    protected List<DSField> getMultipleFields() {
        return this.dsMultipleFields;
    }

    public static List<Map<String, Object>> sortDSFields(List<Map<String, Object>> dsFields) {
        dsFields.sort(DSFieldOrderType.ID_ALPHABETIC.getComparator());
        return dsFields;
    }

    public boolean isSequenceModeNone() {
        return false;
    }

    public String getMultiInsertStrategy() {
        return null;
    }

    public Long getMultiInsertBatchSize() {
        return null;
    }

    public String getMultiInsertNonMatchingStrategy() {
        return null;
    }

    static {
        numRecords = 0;
        numFields = 0;
    }
}

