/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scheduler;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.scheduler.QuartzBasicDataSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.quartz.Scheduler;

public class QuartzScheduler
extends QuartzBasicDataSource {
    public DSResponse executeFetch(DSRequest req) throws Exception {
        DSResponse response = new DSResponse();
        response.setDataSource((DataSource)this);
        response.setSuccess();
        ArrayList<Map> data = new ArrayList<Map>();
        data.add(this.getSchedulerStatusRecord());
        response.setData(data);
        return response;
    }

    public DSResponse executeCustom(DSRequest req) throws Exception {
        DSResponse response = new DSResponse();
        response.setDataSource((DataSource)this);
        response.setSuccess();
        String op = req.getOperation();
        if (op.equals("start")) {
            this.startup();
        } else if (op.equals("shutdown")) {
            this.shutdown();
        } else if (op.equals("standby")) {
            this.standby();
        }
        return response;
    }

    private void startup() throws Exception {
        QuartzScheduler.getScheduler().start();
    }

    private void shutdown() throws Exception {
        QuartzScheduler.getScheduler().shutdown();
        scheduler = QuartzScheduler.instantiateScheduler();
    }

    private void standby() throws Exception {
        QuartzScheduler.getScheduler().standby();
    }

    private Map getSchedulerStatusRecord() throws Exception {
        Scheduler s = QuartzScheduler.getScheduler();
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("name", s.getSchedulerName());
        if (s.isShutdown()) {
            record.put("state", 0);
        } else if (s.isInStandbyMode()) {
            record.put("state", 1);
        } else {
            record.put("state", 2);
        }
        return record;
    }
}

