/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource.cachesync;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.cachesync.RequestValuesStrategy;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GenericRequestValuesPlusKeysStrategy
extends RequestValuesStrategy {
    private static Logger log = new Logger(GenericRequestValuesPlusKeysStrategy.class);

    @Override
    public List getCacheSyncData(DSRequest request, DSResponse response) throws Exception {
        request.setAttribute("_calledFromGetKeys", true);
        List responseData = super.getCacheSyncData(request, response);
        request.removeAttribute("_calledFromGetKeys");
        if (!this.isCacheSyncFetchAllowed(request, response)) {
            return responseData;
        }
        DataSource ds = request.getDataSource();
        List<String> keys = ds.getPrimaryKeys();
        Object dsRespData = response.getParameter("data");
        ArrayList<Object> dsRespDataList = null;
        if (dsRespData instanceof List) {
            dsRespDataList = (ArrayList<Object>)dsRespData;
        } else if (dsRespData instanceof Map) {
            dsRespDataList = new ArrayList<Object>();
            dsRespDataList.add(dsRespData);
        }
        if (dsRespData == null) {
            log.warn("There was no response data returned from the add operation for DataSource '" + ds.getName() + "', operationBinding '" + request.getOperationId() + "'. Cache sync data will be partial");
        } else if (dsRespDataList == null) {
            log.warn("The response data returned from the add operation for DataSource '" + ds.getName() + "', operationBinding '" + request.getOperationId() + "' is not a List. Cache sync data will be partial");
        } else if (responseData.size() != dsRespDataList.size()) {
            log.warn("Number of request value records and response value records differs.  Not able to map response value keys, cache sync data will be partial");
        } else {
            for (int i = 0; i < responseData.size(); ++i) {
                Map baseRecord = (Map)responseData.get(i);
                Map respRecord = (Map)dsRespDataList.get(i);
                for (int j = 0; j < keys.size(); ++j) {
                    if (respRecord.containsKey(keys.get(j))) {
                        baseRecord.put(keys.get(j), respRecord.get(keys.get(j)));
                        continue;
                    }
                    log.warn("Response record " + i + " is missing a value for key field '" + keys.get(j) + "'.  Cache sync data will be partial");
                }
            }
        }
        return responseData;
    }
}

