/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.Relation;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLMetaData;
import com.isomorphic.sql.SQLOrderClause;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.velocity.Velocity;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLServerDriver
extends SQLDriver {
    private static Logger log = new Logger(SQLServerDriver.class.getName());
    private static boolean USE_SEQUENCES = Config.getGlobal().getBoolean((Object)"sql.SQLServer.use.sequences", false);
    private static Map<String, Boolean> _supportsMilliseconds = new HashMap<String, Boolean>();
    private static Map<String, Boolean> _supportsOffsetFetch = new HashMap<String, Boolean>();
    private static Map<String, Float> _version = new HashMap<String, Float>();
    private static Map<String, Boolean> _supportsSQLLimit = new HashMap<String, Boolean>();

    public static boolean useSequences(DataSource ds) {
        if (ds != null && ds.getConfig().get((Object)"useSequences") != null) {
            return ds.getConfig().getBoolean((Object)"useSequences", false);
        }
        return USE_SEQUENCES;
    }

    public SQLServerDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
    }

    @Override
    public boolean supportsRegexp() throws Exception {
        return false;
    }

    @Override
    public boolean supportsNativeReplace() {
        return false;
    }

    @Override
    public boolean supportsMilliseconds() {
        if (!_supportsMilliseconds.containsKey(this.dbName)) {
            try {
                _supportsMilliseconds.put(this.dbName, this._getVersion(this.dbName) >= 10.0f);
            }
            catch (Exception e) {
                log.info((Object)("supportsMilliseconds on db: " + this.dbName + " threw exception: " + e.toString()));
                _supportsMilliseconds.put(this.dbName, false);
            }
        }
        return _supportsMilliseconds.get(this.dbName);
    }

    @Override
    public boolean supportsOffsetFetch() {
        if (!_supportsOffsetFetch.containsKey(this.dbName)) {
            try {
                _supportsOffsetFetch.put(this.dbName, this._getVersion(this.dbName) >= 11.0f && config.getBoolean((Object)"sql.sqlserver.use.offset.fetch", true));
            }
            catch (Exception e) {
                log.info((Object)("supportsOffsetFetch on db: " + this.dbName + " threw exception: " + e.toString()));
                _supportsOffsetFetch.put(this.dbName, false);
            }
        }
        return _supportsOffsetFetch.get(this.dbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float _getVersion(String dbName) throws Exception {
        Map<String, Float> map = _version;
        synchronized (map) {
            if (!_version.containsKey(dbName)) {
                SQLMetaData md = new SQLMetaData(dbName, this.getOrCreateConnection());
                String version = md.getMetaData().getDatabaseProductVersion();
                log.debug((Object)("SQL Server version is '" + version + "'"));
                if (version.indexOf(".") > 0) {
                    version = version.substring(0, version.indexOf("."));
                }
                if (version.lastIndexOf(" ") > 0) {
                    version = version.substring(version.lastIndexOf(" ") + 1);
                }
                _version.put(dbName, Float.valueOf(Float.parseFloat(version)));
            }
            return _version.get(dbName).floatValue();
        }
    }

    @Override
    public boolean supportsFieldComparison(String columnType, String otherColumnType) {
        if (columnType != null && otherColumnType != null) {
            if (columnType.equals(otherColumnType)) {
                return true;
            }
            boolean isInteger = DataSource.simpleTypeInheritsFromBuiltInType((String)columnType, (String)"integer");
            boolean isFloat = DataSource.simpleTypeInheritsFromBuiltInType((String)columnType, (String)"float");
            boolean isIntegerOther = DataSource.simpleTypeInheritsFromBuiltInType((String)otherColumnType, (String)"integer");
            boolean isFloatOther = DataSource.simpleTypeInheritsFromBuiltInType((String)otherColumnType, (String)"float");
            if ((isInteger || isFloat) && (isIntegerOther || isFloatOther)) {
                return true;
            }
        }
        return super.supportsFieldComparison(columnType, otherColumnType);
    }

    @Override
    public boolean supportsSQLLimit() {
        if (!_supportsSQLLimit.containsKey(this.dbName)) {
            try {
                _supportsSQLLimit.put(this.dbName, this._getVersion(this.dbName) >= 9.0f);
            }
            catch (Exception e) {
                log.info((Object)("supportsSQLLimit on db: " + this.dbName + " threw exception: " + e.toString()));
                _supportsSQLLimit.put(this.dbName, false);
            }
        }
        return _supportsSQLLimit.get(this.dbName);
    }

    @Override
    public String limitQuery(String query, long startRow, long batchSize, List outputColumns, String orderClauseString, String computedOrderClause, DSRequest req, List dataSources, Map context) throws Exception {
        if (this.supportsOffsetFetch()) {
            return this.limitQueryUsingOffsetFetch(query, startRow, batchSize, orderClauseString, computedOrderClause, context);
        }
        String convertedOrderClause = null;
        if (!"$defaultOrderClause".equals(orderClauseString) && orderClauseString != null && !"".equals(orderClauseString)) {
            convertedOrderClause = orderClauseString;
        } else {
            SQLOrderClause orderClause = new SQLOrderClause(req, dataSources, true, true);
            DataSource ds = (DataSource)dataSources.get(0);
            if (ds instanceof SQLDataSource) {
                DataTypeMap opBinding = ds.getOperationBinding(req);
                SQLDataSource cfr_ignored_0 = (SQLDataSource)ds;
                List customValueFields = SQLDataSource.getCustomValueFields((Map)opBinding);
                if (customValueFields == null) {
                    SQLDataSource cfr_ignored_1 = (SQLDataSource)ds;
                    customValueFields = SQLDataSource.getCustomFields((Map)opBinding);
                }
                orderClause.setCustomValueFields(customValueFields);
            }
            if (req.getSortBy() == null || req.getSortBy().length() == 0) {
                List summaryFields = req.isSummary() ? req.getSummaryFields() : null;
                ArrayList pkList = new ArrayList();
                for (Object pk : ds.getPrimaryKeys()) {
                    if (summaryFields == null || !summaryFields.contains(pk)) continue;
                    pkList.add(pk);
                }
                if (!pkList.isEmpty()) {
                    log.debug((Object)("Using PK as default sorter: " + (Object)((Object)orderClause)));
                    orderClause.setSortBy(pkList);
                } else {
                    for (String _fieldName : ds.getFieldNames()) {
                        if (summaryFields == null || !summaryFields.contains(_fieldName)) continue;
                        log.debug((Object)("Using first field as default sorter: " + _fieldName));
                        ArrayList<String> sortBy = new ArrayList<String>();
                        sortBy.add(_fieldName);
                        orderClause.setSortBy(sortBy);
                        break;
                    }
                }
            }
            convertedOrderClause = orderClause.getSQLString();
        }
        convertedOrderClause = Velocity.evaluateAsString((String)convertedOrderClause, (Map)context);
        if (convertedOrderClause == null || convertedOrderClause.equals("")) {
            convertedOrderClause = computedOrderClause;
        }
        query = "SELECT TOP 100 PERCENT " + query.substring("SELECT".length());
        query = "SELECT * FROM (SELECT *, ROW_NUMBER() OVER (ORDER BY " + convertedOrderClause + ") AS rowID FROM (" + query + ") x) y WHERE y.rowID BETWEEN " + (startRow + 1L) + " AND " + (startRow + batchSize);
        return query;
    }

    private List tokenizeOrderClause(String input) {
        ArrayList<String> result = new ArrayList<String>();
        char[] chars = input.toCharArray();
        StringBuffer sb = new StringBuffer();
        boolean inQuotes = false;
        boolean toggleQuotes = this.openQuote().equals(this.closeQuote());
        for (int i = 0; i < chars.length; ++i) {
            char current = chars[i];
            if (current == this.openQuote().charAt(0)) {
                inQuotes = toggleQuotes ? !inQuotes : true;
            } else if (current == this.closeQuote().charAt(0)) {
                inQuotes = false;
            }
            if (current == ',' && !inQuotes) {
                result.add(sb.toString());
                sb = new StringBuffer();
                continue;
            }
            sb.append(current);
        }
        result.add(sb.toString());
        return result;
    }

    public String limitQueryUsingOffsetFetch(String query, long startRow, long batchSize, String baseOrderClause, String computedOrderClause, Map context) {
        String q = query;
        if (computedOrderClause != null && computedOrderClause.trim().length() > 0) {
            q = baseOrderClause == null || baseOrderClause.trim().length() == 0 || "$defaultOrderClause".equals(baseOrderClause) && (context.get("defaultOrderClause") == null || ((String)context.get("defaultOrderClause")).trim().length() == 0) ? q + " ORDER BY " : q + ", ";
            q = q + computedOrderClause;
        }
        return q + " OFFSET " + startRow + " ROWS FETCH NEXT " + batchSize + " ROWS ONLY";
    }

    @Override
    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        if (this.dbConnection == null && req == null) {
            throw new Exception("no connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        if (SQLServerDriver.useSequences((DataSource)ds)) {
            return primaryKeys;
        }
        if (sequencesNotPresent.size() > 1) {
            throw new Exception("SQLServer supports only one IDENTITY column");
        }
        boolean useGlobalIdentity = this._sqlConfig.getBoolean((Object)"useGlobalIdentity", false);
        String ident = useGlobalIdentity ? "@@IDENTITY" : "SCOPE_IDENTITY()";
        Object obj = SQLServerDriver.getScalarResult("SELECT " + ident, this.dbConnection, this.dbName, this, req);
        if (obj == null) {
            log.warn((Object)("Attempt to obtain generated keys using " + ident + " returned null.  This is a known problem with all relatively recent SQL Server JDBC drivers. Please use sequenceMode 'jdbcDriver' to avoid this error."));
        } else {
            Long sequenceValue = Long.valueOf(obj.toString());
            primaryKeys.put(sequencesNotPresent.get(0), sequenceValue);
        }
        return primaryKeys;
    }

    @Override
    public String formatValue(Object value) {
        return value.toString();
    }

    @Override
    public String sqlInTransform(Object value, DSField field, SQLDataSource ds, boolean addLiteralPrefix, boolean noEscape) throws Exception {
        String transformed = super.sqlInTransform(value, field, ds, addLiteralPrefix, noEscape);
        if (addLiteralPrefix) {
            return this.getLiteralPrefix(field, ds) + transformed;
        }
        return transformed;
    }

    @Override
    public String sqlFilterTransform(Object value, DSField field, SQLDataSource ds, String filterStyle) {
        String transformed = this.escapeValueForFilter(value.toString().toLowerCase(), filterStyle);
        return this.getLiteralPrefix(field, ds) + transformed;
    }

    @Override
    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + output;
        }
        return output;
    }

    @Override
    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    @Override
    public String escapeValueForFilter(Object value, String filterStyle) {
        if (value == null) {
            return null;
        }
        String rtn = "'";
        if (!"startsWith".equals(filterStyle)) {
            rtn = rtn + "%";
        }
        return rtn + this.escapeValueUnquoted(value, true) + "%'";
    }

    @Override
    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String strValue = value.toString();
        String escaped = this.matcher.reset(strValue).usePattern(SINGLE_QUOTE_PATTERN).replaceAll(SINGLE_QUOTE_ESCAPE);
        if (escapeForFilter && this.shouldEscapeLikeValue(strValue)) {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(PERCENT_PATTERN).replaceAll(PERCENT_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(UNDERSCORE_PATTERN).replaceAll(UNDERSCORE_ESCAPE);
        }
        return escaped;
    }

    @Override
    public String escapeClause(Object value) {
        return !config.getBoolean((Object)"sql.sqlserver.suppress.unneeded.escape", false) || value != null && this.shouldEscapeLikeValue(value.toString()) ? " {ESCAPE '\\'}" : "";
    }

    @Override
    public String getNextSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        if (SQLServerDriver.useSequences((DataSource)ds)) {
            String sequenceName = this.getSequenceName(columnName, ds);
            if (sequenceName == null) {
                return null;
            }
            String schema = "";
            if (ds != null) {
                schema = ds.getSchemaName();
                schema = schema == null ? "" : schema + ".";
            }
            return "NEXT VALUE FOR " + schema + sequenceName;
        }
        throw new Exception("Not Supported");
    }

    public String getCurrentSequenceValue(String columnName) throws Exception {
        throw new Exception("Not Supported");
    }

    @Override
    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        String expr = "CASE " + column;
        for (String rawValue : valueMap.keySet()) {
            String actualValue = this.transformActualValueForSort(rawValue, column, request);
            String displayValue = this.getLocalizedDisplayValue(valueMap.get(rawValue), request);
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN " + actualValue + " THEN " + displayValue;
        }
        expr = expr + " END";
        return expr;
    }

    @Override
    public InputStream handleInputStream(InputStream in) throws Exception {
        return super.handleInputStream(in);
    }

    @Override
    public String getLiteralPrefix(DSField field, BasicDataSource ds) {
        try {
            if (field != null && "text".equals(ds.getSimpleBaseType(field.getType())) && "ntext".equals(field.get((Object)"sqlStorageStrategy"))) {
                return "N";
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error in SQLServerDriver.getLiteralPrefix", (Throwable)e);
        }
        return "";
    }

    @Override
    public String generateJoinClause(String escapedTo, String escapedFrom, Relation relation) {
        return escapedFrom + (relation.getJoinType() == 1 ? " *" : " ") + "= " + escapedTo;
    }

    @Override
    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName;
    }

    @Override
    public String sqlConcat(String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuffer sql = new StringBuffer();
        for (String s : strings) {
            if (sql.length() > 0) {
                sql.append(" + ");
            }
            sql.append(s);
        }
        return sql.toString();
    }

    @Override
    public boolean aliasRequiredForSubselect() {
        return true;
    }

    @Override
    public boolean shouldParameterizeNullValues(boolean isMultiInserting) {
        return false;
    }

    @Override
    public String getDummyQuery() {
        return "SELECT 1 AS abc";
    }

    public int maxAllowedSequenceColumns() {
        return 1;
    }

    @Override
    protected boolean supportsGetGeneratedKeys(Connection conn, DataSource ds) throws SQLException {
        if (SQLServerDriver.useSequences(ds)) {
            return false;
        }
        return super.supportsGetGeneratedKeys(conn, ds);
    }

    @Override
    protected void logGeneratedKeysWarning(DataSource ds) {
        if (!SQLServerDriver.useSequences(ds)) {
            log.warn((Object)(ds.getName() + ": SequenceMode is JDBC_DRIVER but the driver is not GENERATED_KEYS capable"));
        }
    }

    @Override
    public boolean toleratesExplicitSequenceValues() throws Exception {
        return false;
    }

    @Override
    protected boolean defaultForceInsensitive() {
        return false;
    }
}

