/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Reflection;
import com.isomorphic.base.Service;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Log4jLogger;
import com.isomorphic.log.Slf4jLogger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.event.SubstituteLoggingEvent;

public class LogEventDataSourceDispatcher
extends Service {
    LinkedBlockingQueue queue;
    String uniqueProcessIdentifier = UUID.randomUUID().toString();
    AtomicLong sequence = new AtomicLong();

    public LogEventDataSourceDispatcher() {
        this.setInterval(0);
        this.setDisableLogging(true);
    }

    public void setQueue(LinkedBlockingQueue queue) {
        this.queue = queue;
    }

    @Override
    public Object execute() throws Exception {
        try {
            Map scEvent = this.convertLogEvent(this.queue.take());
            return new DSRequest("ISCLogEvent", "add").setValues(scEvent).execute();
        }
        catch (Exception e) {
            System.out.println("Unable to dispatch log event: " + ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    protected Map convertLogEvent(Object obj) throws Exception {
        Map mdc = null;
        if (obj instanceof Map) {
            mdc = (Map)((Map)obj).get("mdc");
            obj = ((Map)obj).get("event");
        }
        if (obj instanceof LoggingEvent) {
            return this.convertLog4jEvent((LoggingEvent)obj, mdc);
        }
        if (obj instanceof SubstituteLoggingEvent) {
            return this.convertSlf4jEvent((SubstituteLoggingEvent)obj, mdc);
        }
        throw new Exception("Unsupported event type: " + obj.getClass().getName());
    }

    protected Map convertLog4jEvent(LoggingEvent event, Map mdc) throws Exception {
        HashMap<String, Object> scEvent = new HashMap<String, Object>();
        scEvent.put("pk", this.uniqueProcessIdentifier + this.sequence.getAndIncrement());
        String loggerName = event.getLoggerName();
        int lastDotIndex = loggerName.lastIndexOf(".");
        if (lastDotIndex != -1) {
            loggerName = loggerName.substring(lastDotIndex + 1);
        }
        scEvent.put("loggerName", loggerName);
        scEvent.put("timeStamp", new Date(event.getTimeStamp()));
        scEvent.put("logMessage", event.getMessage());
        scEvent.put("threadName", event.getThreadName());
        scEvent.put("level", Log4jLogger.fromLog4j.get(event.getLevel()).toInteger());
        if (mdc != null) {
            scEvent.put("mdc", mdc);
        }
        if (event.getThrowableInformation() != null) {
            Throwable t = event.getThrowableInformation().getThrowable();
            scEvent.put("throwable", ExceptionUtils.getStackTrace((Throwable)Reflection.getRealTargetException(t)));
        }
        return scEvent;
    }

    protected Map convertSlf4jEvent(SubstituteLoggingEvent event, Map mdc) throws Exception {
        Throwable t;
        HashMap<String, Object> scEvent = new HashMap<String, Object>();
        scEvent.put("pk", this.uniqueProcessIdentifier + this.sequence.getAndIncrement());
        String loggerName = event.getLoggerName();
        int lastDotIndex = loggerName.lastIndexOf(".");
        if (lastDotIndex != -1) {
            loggerName = loggerName.substring(lastDotIndex + 1);
        }
        scEvent.put("loggerName", loggerName);
        scEvent.put("timeStamp", new Date(event.getTimeStamp()));
        scEvent.put("logMessage", event.getMessage());
        scEvent.put("threadName", event.getThreadName());
        scEvent.put("level", Slf4jLogger.fromSlf4j.get(event.getLevel()).toInteger());
        if (mdc != null) {
            scEvent.put("mdc", mdc);
        }
        if ((t = event.getThrowable()) != null) {
            scEvent.put("throwable", ExceptionUtils.getStackTrace((Throwable)Reflection.getRealTargetException(t)));
        }
        return scEvent;
    }
}

