/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.hibernate.HibernateDSGenerator;
import com.isomorphic.jpa.JPADSGenerator;
import com.isomorphic.sql.SQLDSGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataSourceTools
extends Base {
    public static Map getDataSourceConfigFromTable(String tableName, String schema, String serverType, String dbName, String timestampType, boolean returnSQLTypes) throws Exception {
        if ("hibernate".equals(serverType)) {
            return HibernateDSGenerator.getConfigFromTable((String)tableName, (String)schema);
        }
        SQLDSGenerator gen = new SQLDSGenerator(tableName, schema, dbName, serverType, timestampType, returnSQLTypes);
        return gen.generate();
    }

    public static Map getDataSourceConfigFromHibernateMapping(String entityName) throws Exception {
        return HibernateDSGenerator.getConfigFromMapping((String)entityName, null, (boolean)false, (boolean)false);
    }

    public static Map getDataSourceConfigFromJPAClass(String className) throws Exception {
        return JPADSGenerator.getDataSourceConfigFromJPAClass((String)className, (boolean)false);
    }

    public static Object getDataSourceConfigFromJavaClass(String className) throws Exception {
        return DataSourceTools._getDataSourceConfigFromJavaClass(className);
    }

    static Object _getDataSourceConfigFromJavaClass(String className) throws Exception {
        Class c = Reflection.classForName((String)className);
        if (c == null) {
            Package p = Package.getPackage(className);
            if (p == null) {
                return "Package not found for Class: " + className;
            }
            return "Class not found: " + className;
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("ID", className.substring(className.lastIndexOf(46) + 1));
        config.put("dataSourceVersion", String.valueOf(1));
        config.put("serverType", "generic");
        config.put("beanClassName", className);
        config.put("xmlFromConfig", "true");
        Config iscConfig = Config.getGlobal();
        if (iscConfig != null) {
            String version = iscConfig.getString((Object)"iscVersion") + " " + iscConfig.getString((Object)"iscPackageDate");
            config.put("generatedBy", version);
        }
        List fields = Reflection.getBeanFields((String)className);
        config.put("fields", fields);
        return config;
    }
}

