/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.taglib;

import com.isomorphic.taglib.LoadModulesTag;
import com.isomorphic.taglib.LoadSkinTag;
import com.isomorphic.util.DataTools;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class LoadISCTag
extends LoadModulesTag {
    public String skin = null;
    public String skinDir = null;
    public Boolean useSimpleNames = Boolean.TRUE;

    @Override
    public int doStartTag() throws JspException {
        this.init();
        try {
            JspWriter out = this.pageContext.getOut();
            String isomorphicURI = this.getIsomorphicURI();
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            if (request.getAttribute("isc_loadISCTag") != null) {
                throw new Exception("Multiple loadISC tags on page - not allowed (check your jsp includes).");
            }
            request.setAttribute("isc_loadISCTag", new Object());
            if (!this.useSimpleNames.booleanValue()) {
                out.write("<SCRIPT>window.isc_useSimpleNames = false;</SCRIPT>\n");
            }
            if (config.getBoolean((Object)"loadISC.useModules", false)) {
                this.outputModules(this.pageContext, true);
            } else {
                out.write("<SCRIPT>window.isomorphicDir='" + isomorphicURI + "';</SCRIPT>\n");
                out.write("<SCRIPT SRC=\"" + this.addVersion(isomorphicURI + "system/Isomorphic_SmartClient" + (this.suffix != null ? (this.suffix.startsWith("_") ? this.suffix : "_" + this.suffix) : "") + ".js"));
                out.write("\"></SCRIPT>\n");
            }
            LoadSkinTag.outputSkin((Writer)out, this.skin, this.skinDir, this);
            this.outputLocale(this.pageContext);
        }
        catch (Throwable e) {
            this.log.error((Object)"Exception while attempting to process a loadISC tag.", e);
            throw new JspException(DataTools.getStackTrace(e));
        }
        return 0;
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkinDir(String skinDir) {
        this.skinDir = skinDir;
    }

    public String getSkinDir() {
        return this.skinDir;
    }

    public void setUseSimpleNames(String useSimpleNames) {
        this.useSimpleNames = Boolean.valueOf(useSimpleNames);
    }

    public String getUseSimpleNames() {
        return this.useSimpleNames.toString();
    }
}

