/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonTypeCoercer;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.SimplePropertyDescriptor;
import org.openqa.selenium.json.TypeCoercer;

class InstanceCoercer
extends TypeCoercer<Object> {
    private final JsonTypeCoercer coercer;

    InstanceCoercer(JsonTypeCoercer coercer) {
        this.coercer = Objects.requireNonNull(coercer);
    }

    @Override
    public boolean test(Class aClass) {
        return this.getConstructor(aClass) != null;
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, Object> apply(Type type) {
        Constructor<?> constructor = this.getConstructor(type);
        return (jsonInput, setter) -> {
            try {
                Map<String, TypeAndWriter> allWriters;
                Object instance = constructor.newInstance(new Object[0]);
                switch (setter) {
                    case BY_FIELD: {
                        allWriters = this.getFieldWriters(constructor);
                        break;
                    }
                    case BY_NAME: {
                        allWriters = this.getBeanWriters(constructor);
                        break;
                    }
                    default: {
                        throw new JsonException("Cannot determine how to find fields: " + (Object)setter);
                    }
                }
                jsonInput.beginObject();
                ArrayList<TypeAndWriter> usedWriters = new ArrayList<TypeAndWriter>();
                while (jsonInput.hasNext()) {
                    String key = jsonInput.nextName();
                    TypeAndWriter writer = allWriters.get(key);
                    if (writer == null) {
                        jsonInput.skipValue();
                        continue;
                    }
                    usedWriters.add(writer);
                    Object value = this.coercer.coerce((JsonInput)jsonInput, writer.type, (PropertySetting)((Object)setter));
                    writer.writer.accept(instance, value);
                }
                jsonInput.endObject();
                allWriters.values().stream().filter(w -> !usedWriters.contains(w)).forEach(w -> {
                    try {
                        w.writer.accept(instance, null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                });
                return instance;
            }
            catch (ReflectiveOperationException e) {
                throw new JsonException(e);
            }
        };
    }

    private Map<String, TypeAndWriter> getFieldWriters(Constructor<?> constructor) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Class<?> current = constructor.getDeclaringClass(); current != Object.class; current = current.getSuperclass()) {
            fields.addAll(Arrays.asList(current.getDeclaredFields()));
        }
        return fields.stream().filter(field -> !Modifier.isFinal(field.getModifiers())).filter(field -> !Modifier.isTransient(field.getModifiers())).peek(field -> field.setAccessible(true)).collect(Collectors.toMap(Field::getName, field -> {
            TypeAndWriter tw = new TypeAndWriter();
            tw.type = field.getGenericType();
            tw.writer = (instance, value) -> {
                try {
                    field.set(instance, value);
                }
                catch (IllegalAccessException e) {
                    throw new JsonException(e);
                }
            };
            return tw;
        }));
    }

    private Map<String, TypeAndWriter> getBeanWriters(Constructor<?> constructor) {
        return Stream.of(SimplePropertyDescriptor.getPropertyDescriptors(constructor.getDeclaringClass())).filter(desc -> desc.getWriteMethod() != null).collect(Collectors.toMap(SimplePropertyDescriptor::getName, desc -> {
            TypeAndWriter tw = new TypeAndWriter();
            tw.type = desc.getWriteMethod().getGenericParameterTypes()[0];
            tw.writer = (instance, value) -> {
                Method method = desc.getWriteMethod();
                method.setAccessible(true);
                try {
                    method.invoke(instance, value);
                }
                catch (ReflectiveOperationException e) {
                    throw new JsonException(e);
                }
            };
            return tw;
        }));
    }

    private Constructor<?> getConstructor(Type type) {
        Class target = this.getClss(type);
        try {
            Constructor constructor = target.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (ReflectiveOperationException e) {
            throw new JsonException(e);
        }
    }

    private Class getClss(Type type) {
        Type rawType;
        Class target = null;
        if (type instanceof Class) {
            target = (Class)type;
        } else if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
            target = (Class)rawType;
        }
        if (target == null) {
            throw new JsonException("Cannot determine base class");
        }
        return target;
    }

    private class TypeAndWriter {
        public Type type;
        public BiConsumer<Object, Object> writer;

        private TypeAndWriter() {
        }
    }
}

