/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Service;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.util.DataTools;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

public class DataSourceDispatcher
extends Service {
    public static LinkedBlockingQueue queue = new LinkedBlockingQueue();

    @Override
    public void completeInit() throws Exception {
        this.interval = 0;
    }

    @Override
    public String getLogContext() {
        return "DataSource dispatcher";
    }

    public DataSourceDispatcher() {
        this.setInterval(0);
    }

    @Override
    public Object execute() throws Exception {
        try {
            DSRequest dsRequest;
            Object obj = queue.take();
            if (obj instanceof DSRequest) {
                dsRequest = (DSRequest)obj;
            } else {
                dsRequest = new DSRequest();
                DataTypeMap<String, String> opts = new DataTypeMap<String, String>();
                opts.put("invokeNonConformingSetters", "true");
                DataTools.setProperties((Map)obj, (Object)dsRequest, opts);
            }
            return dsRequest.execute();
        }
        catch (Exception e) {
            this.log.error("Error dispatching DSRequest: " + e.getMessage());
            return null;
        }
    }
}

