/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ClasspathExtension;
import org.openqa.selenium.firefox.internal.Extension;
import org.openqa.selenium.firefox.internal.FileExtension;
import org.openqa.selenium.net.UrlChecker;
import org.openqa.selenium.remote.service.DriverService;

public class XpiDriverService
extends DriverService {
    private final Lock lock = new ReentrantLock();
    private final int port;
    private final FirefoxBinary binary;
    private final FirefoxProfile profile;
    private File profileDir;

    private XpiDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment, FirefoxBinary binary, FirefoxProfile profile, File logFile) throws IOException {
        super(executable, port, args, environment);
        Preconditions.checkState((port > 0 ? 1 : 0) != 0, (Object)"Port must be set");
        this.port = port;
        this.binary = binary;
        this.profile = profile;
        String firefoxLogFile = System.getProperty("webdriver.firefox.logfile");
        if (firefoxLogFile != null) {
            if ("/dev/stdout".equals(firefoxLogFile)) {
                this.sendOutputTo(System.out);
            } else if ("/dev/stderr".equals(firefoxLogFile)) {
                this.sendOutputTo(System.err);
            } else if ("/dev/null".equals(firefoxLogFile)) {
                this.sendOutputTo(ByteStreams.nullOutputStream());
            } else {
                this.sendOutputTo(new FileOutputStream(firefoxLogFile));
            }
        } else if (logFile != null) {
            this.sendOutputTo(new FileOutputStream(logFile));
        } else {
            this.sendOutputTo(ByteStreams.nullOutputStream());
        }
    }

    @Override
    protected URL getUrl(int port) throws MalformedURLException {
        return new URL("http", "localhost", port, "/hub");
    }

    @Override
    public void start() throws IOException {
        this.lock.lock();
        try {
            this.profile.setPreference("webdriver_firefox_port", this.port);
            this.addWebDriverExtension(this.profile);
            this.profileDir = this.profile.layoutOnDisk();
            this.binary.setOutputWatcher(this.getOutputStream());
            this.binary.startProfile(this.profile, this.profileDir, "-foreground");
            this.waitUntilAvailable();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void waitUntilAvailable() throws MalformedURLException {
        try {
            URL status = new URL(this.getUrl(this.port).toString() + "/status");
            new UrlChecker().waitUntilAvailable(45L, TimeUnit.SECONDS, status);
        }
        catch (UrlChecker.TimeoutException e) {
            throw new WebDriverException("Timed out waiting 45 seconds for Firefox to start.", e);
        }
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            this.binary.quit();
            this.profile.cleanTemporaryModel();
            this.profile.clean(this.profileDir);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addWebDriverExtension(FirefoxProfile profile) {
        if (profile.containsWebDriverExtension()) {
            return;
        }
        profile.addExtension("webdriver", this.loadCustomExtension().orElse(XpiDriverService.loadDefaultExtension()));
    }

    private Optional<Extension> loadCustomExtension() {
        String xpiProperty = System.getProperty("webdriver.firefox.driver");
        if (xpiProperty != null) {
            File xpi = new File(xpiProperty);
            return Optional.of(new FileExtension(xpi));
        }
        return Optional.empty();
    }

    private static Extension loadDefaultExtension() {
        return new ClasspathExtension(FirefoxProfile.class, "/" + FirefoxProfile.class.getPackage().getName().replace(".", "/") + "/webdriver.xpi");
    }

    public static XpiDriverService createDefaultService() {
        try {
            return (XpiDriverService)new Builder().build();
        }
        catch (WebDriverException e) {
            throw new IllegalStateException(e.getMessage(), e.getCause());
        }
    }

    static XpiDriverService createDefaultService(Capabilities caps) {
        Object binary;
        Builder builder = (Builder)new Builder().usingAnyFreePort();
        FirefoxProfile profile = Stream.of(() -> (FirefoxProfile)caps.getCapability("firefox_profile"), () -> FirefoxProfile.fromJson((String)caps.getCapability("firefox_profile")), () -> ((FirefoxOptions)caps).getProfile(), () -> (FirefoxProfile)((Map)caps.getCapability("moz:firefoxOptions")).get("profile"), () -> FirefoxProfile.fromJson((String)((Map)caps.getCapability("moz:firefoxOptions")).get("profile")), () -> {
            Map options = (Map)caps.getCapability("moz:firefoxOptions");
            FirefoxProfile toReturn = new FirefoxProfile();
            ((Map)options.get("prefs")).forEach((key, value) -> {
                if (value instanceof Boolean) {
                    toReturn.setPreference((String)key, (Boolean)value);
                }
                if (value instanceof Integer) {
                    toReturn.setPreference((String)key, (Integer)value);
                }
                if (value instanceof String) {
                    toReturn.setPreference((String)key, (String)value);
                }
            });
            return toReturn;
        }).map(supplier -> {
            try {
                return (FirefoxProfile)supplier.get();
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElse(null);
        if (profile != null) {
            builder.withProfile(profile);
        }
        if ((binary = caps.getCapability("firefox_binary")) != null) {
            FirefoxBinary actualBinary;
            if (binary instanceof FirefoxBinary) {
                actualBinary = (FirefoxBinary)binary;
            } else if (binary instanceof String) {
                actualBinary = new FirefoxBinary(new File(String.valueOf(binary)));
            } else {
                throw new IllegalArgumentException("Expected binary to be a string or a binary: " + binary);
            }
            builder.withBinary(actualBinary);
        }
        return (XpiDriverService)builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @FunctionalInterface
    private static interface ThrowingSupplier<V>
    extends Supplier<V> {
        public V throwingGet() throws Exception;

        @Override
        default public V get() {
            try {
                return this.throwingGet();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    public static class Builder
    extends DriverService.Builder<XpiDriverService, Builder> {
        private FirefoxBinary binary = null;
        private FirefoxProfile profile = null;

        @Override
        public int score(Capabilities capabilites) {
            return capabilites.getCapability("marionette") == Boolean.FALSE ? 5 : 0;
        }

        public Builder withBinary(FirefoxBinary binary) {
            this.binary = (FirefoxBinary)Preconditions.checkNotNull((Object)binary);
            return this;
        }

        public Builder withProfile(FirefoxProfile profile) {
            this.profile = (FirefoxProfile)Preconditions.checkNotNull((Object)profile);
            return this;
        }

        @Override
        protected File findDefaultExecutable() {
            if (this.binary == null) {
                return new FirefoxBinary().getFile();
            }
            return this.binary.getFile();
        }

        @Override
        protected ImmutableList<String> createArgs() {
            return ImmutableList.of((Object)"-foreground");
        }

        @Override
        protected XpiDriverService createDriverService(File exe, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                return new XpiDriverService(exe, port, args, environment, this.binary == null ? new FirefoxBinary() : this.binary, this.profile == null ? new FirefoxProfile() : this.profile, this.getLogFile());
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

