/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.xml;

import com.isomorphic.auth.AuthenticatedUser;
import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.datasource.DSFileSpec;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.ProjectLoadSettings;
import com.isomorphic.xml.Screen;
import com.isomorphic.xml.XML;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Project
implements IToJSON {
    private static Config config = Config.getGlobal();
    private static Logger log = new Logger(Project.class.getName());
    private static String storageDS = config.getString("project.vbProjectsDS");
    private static String fileType = "proj";
    private static String fileFormat = "xml";
    DataTypeMap data;
    String xml;
    DataTypeMap metadata;

    public Project(String xml, Map metadata) throws Exception {
        this(Project.dataFromXML(xml), metadata);
        this.xml = xml;
    }

    public Project(Map data, Map metadata) {
        this.data = new DataTypeMap(data);
        this.metadata = metadata == null ? new DataTypeMap() : new DataTypeMap(metadata);
    }

    private static Map dataFromXML(String xml) throws Exception {
        return (Map)XML.toDSRecords(new StringReader(xml));
    }

    public static Project load(String name) throws Exception {
        return Project.load((Object)DataTools.buildMap("fileName", name));
    }

    public static Project load(String name, String ownerId) throws Exception {
        return Project.load((Object)DataTools.buildMap("fileName", name, "ownerId", ownerId));
    }

    public static Project load(Object criteria) throws Exception {
        List<Project> resultsMatchingCriteria = Project.list(criteria);
        if (resultsMatchingCriteria.size() == 0) {
            return null;
        }
        if (resultsMatchingCriteria.size() > 1) {
            log.warn("Multiple Projects (" + resultsMatchingCriteria.size() + ") matched criteria for load() - using the latest one.  Criteria: " + DataTools.prettyPrint(criteria));
        }
        return resultsMatchingCriteria.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Project> list(Object criteria) throws Exception {
        if (criteria == null) {
            criteria = new HashMap();
        }
        if (criteria instanceof Map) {
            Map m = criteria;
            if (m.get("fileType") == null) {
                m.put("fileType", fileType);
            }
            if (m.get("fileFormat") == null) {
                m.put("fileFormat", fileFormat);
            }
        } else {
            AdvancedCriteria c = (AdvancedCriteria)((Object)criteria);
            if (c.getFieldValue("fileType") == null) {
                c.addCriteria("fileType", DefaultOperators.Equals, fileType);
            }
            if (c.getFieldValue("fileFormat") == null) {
                c.addCriteria("fileFormat", DefaultOperators.Equals, fileFormat);
            }
        }
        ArrayList<Project> results = new ArrayList<Project>();
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            List<Map<String, Object>> files = ds.listFiles(criteria, (Map)((Object)DataTools.buildMap("sortBy", "-fileLastModified")));
            for (Map<String, Object> metadata : files) {
                String xml = ds.getFileAsString(new DSFileSpec(metadata));
                results.add(new Project(xml, metadata));
            }
        }
        finally {
            DataSourceManager.free(ds);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project persist() throws Exception {
        StringWriter sw = new StringWriter();
        String tagName = this.data.getString("__autoConstruct");
        if (tagName == null) {
            throw new Exception("Encountered top-level component with no _constructor: " + DataTools.prettyPrint(this));
        }
        DataSource transformDS = null;
        try {
            transformDS = DataSourceManager.get(tagName);
        }
        finally {
            DataSourceManager.free(transformDS);
        }
        XML.recordToXML(tagName, (Map)((Object)this.data), sw, false, false, transformDS, null);
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            Map<String, Object> metadataAsSaved = ds.saveFile(new DSFileSpec((Map)((Object)this.metadata)), sw.toString());
            Project project = Project.load(metadataAsSaved);
            return project;
        }
        finally {
            DataSourceManager.free(ds);
        }
    }

    public void _persistXML() throws Exception {
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            ds.saveFile(new DSFileSpec((Map)((Object)this.metadata)), this.xml);
        }
        finally {
            DataSourceManager.free(ds);
        }
    }

    public void remove() throws Exception {
        if (this.getName() == null) {
            throw new Exception("Cannot remove a Project that has not yet been persisted");
        }
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            ds.removeFile(new DSFileSpec((Map)((Object)this.metadata)));
        }
        finally {
            DataSourceManager.free(ds);
        }
    }

    @Override
    public void toJSON(Writer out, JSTranslater jsTrans) throws UnconvertableException, IOException {
        jsTrans.toJS((Object)this.data, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project rename(String newName) throws Exception {
        if (this.getName() == null) {
            throw new Exception("Cannot rename a Project that has not yet been persisted");
        }
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            List<Map<String, Object>> renamedFiles = ds.renameFile(new DSFileSpec((Map)((Object)this.metadata)), new DSFileSpec((Map)((Object)DataTools.buildMap("fileName", newName))));
            Map<String, Object> metadataAsSaved = renamedFiles.get(0);
            Project project = Project.load(metadataAsSaved);
            return project;
        }
        finally {
            DataSourceManager.free(ds);
        }
    }

    public String getName() {
        return this.metadata.getString("fileName");
    }

    public DataTypeMap getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map metadata) {
        this.metadata = new DataTypeMap(metadata);
    }

    public String getOwner() {
        return this.metadata.getString("ownerId");
    }

    public void setOwner(String owner) {
        this.metadata.put("ownerId", owner);
    }

    public List<String> getScreenNames() {
        return (List)this.data.xpathGetList("screens/root/children/fileName");
    }

    public List<Screen> getScreens() throws Exception {
        List<String> screenNames = this.getScreenNames();
        if (screenNames == null) {
            return null;
        }
        ArrayList<Screen> screens = new ArrayList<Screen>();
        for (String screenName : screenNames) {
            screens.add(Screen.load(screenName, this.getOwner()));
        }
        return screens;
    }

    public String getCurrentScreenName() {
        return this.data.getString("currentScreenFileName");
    }

    public void setCurrentScreenName(String currentScreenName) {
        this.data.put("currentScreenFileName", currentScreenName);
    }

    public List<String> getDataSourceNames() {
        return (List)this.data.xpathGetList("datasources/dsName");
    }

    public String getAuthProvider() {
        Object o = this.data.xpathGetList("authentication/provider");
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof ArrayList && !((ArrayList)o).isEmpty()) {
            return (String)((ArrayList)o).get(0);
        }
        return null;
    }

    public void setAuthProvider(String authProvider) {
        this.data.xpathSet("authentication/provider", authProvider);
    }

    public Map getAuthUser(String userId) {
        List users = (List)this.data.xpathGetList("authentication/users");
        for (Map user : users) {
            if (!userId.equals((String)user.get("userId"))) continue;
            return user;
        }
        return null;
    }

    public Map getAuthCurrentUser() {
        Object o = this.data.xpathGetList("authentication/lastSelectedUser");
        if (o == null) {
            return null;
        }
        String lastSelectedUser = null;
        if (o instanceof String) {
            lastSelectedUser = (String)o;
        }
        if (o instanceof ArrayList) {
            lastSelectedUser = (String)((ArrayList)o).get(0);
        }
        if (lastSelectedUser != null) {
            return this.getAuthUser(lastSelectedUser);
        }
        return null;
    }

    public List<String> getAuthUserIds() {
        return (List)this.data.xpathGetList("authentication/users/userId");
    }

    public List<Map> getAuthUsers() {
        return (List)this.data.xpathGetList("authentication/users");
    }

    public List<String> getAuthAvailableRoleNames() {
        return (List)this.data.xpathGetList("authentication/availableRoles/name");
    }

    public List<Map> getAuthAvailableRoles() {
        return (List)this.data.xpathGetList("authentication/availableRoles");
    }

    public static Project _load(String name, String ownerId) throws Exception {
        Project project = null;
        String projectFile = DataStructCache.getInstanceFile(name, "project", "proj");
        if (projectFile != null) {
            String xml = ISCFile.newInstance(projectFile).getAsString();
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("fileName", name);
            metadata.put("fileFormat", "xml");
            metadata.put("fileType", "proj");
            project = new Project(xml, metadata);
        }
        if (project == null) {
            project = ownerId == null ? Project.load(name) : Project.load(name, ownerId);
        }
        return project;
    }

    public static String getLoadScript(String projectName) throws Exception {
        return Project.getLoadScript(projectName, new ProjectLoadSettings());
    }

    public static String getLoadScript(String projectName, List<String> screenNames) throws Exception {
        ProjectLoadSettings settings = new ProjectLoadSettings();
        settings.setScreenNames(screenNames);
        return Project.getLoadScript(projectName, settings);
    }

    public static String getLoadScript(String projectNames, ProjectLoadSettings settings) throws Exception {
        String callbackJS;
        boolean allowNonOwnerFetch = config.getBoolean((Object)"security.allowNonOwnerFetch", false);
        String[] names = projectNames.split(",");
        if (names.length < 1) {
            throw new IllegalArgumentException("Invalid projectNames value supplied");
        }
        HashSet<String> screens = new HashSet<String>();
        HashSet<String> missing = new HashSet<String>();
        Project first = Project._load(names[0], allowNonOwnerFetch ? null : settings.ownerId);
        if (first == null) {
            missing.add(names[0]);
        } else {
            screens.addAll(first.getScreenNames());
        }
        String current = settings.getCurrentScreenName();
        if (current == null && first != null) {
            current = first.getCurrentScreenName();
        }
        if (settings.getScreenNames() != null && !settings.getScreenNames().isEmpty()) {
            screens.addAll(settings.getScreenNames());
        }
        if (Boolean.TRUE == settings.getSingleScreenMode()) {
            screens = new HashSet();
            screens.add(current);
        }
        for (int i = 1; i < names.length; ++i) {
            Project next = Project._load(names[i], allowNonOwnerFetch ? null : settings.ownerId);
            if (next == null) {
                missing.add(names[i]);
                continue;
            }
            screens.addAll(next.getScreenNames());
        }
        JSTranslater jsTrans = JSTranslater.instance();
        StringWriter out = new StringWriter();
        jsTrans.toJSVariable(screens, "projectScreens", out);
        jsTrans.toJSVariable(current, "currentScreen", out);
        jsTrans.toJSVariable(settings.locale, "locale", out);
        jsTrans.toJSVariable(settings.shareId, "shareId", out);
        jsTrans.toJSVariable(settings.mockMode, "mockMode", out);
        if (first != null) {
            AuthenticatedUser authenticatedUser;
            String authProvider = first.getAuthProvider();
            Object currentUser = null;
            List<Object> userRoles = new ArrayList();
            List<Object> availableRoles = new ArrayList();
            if ("inlineSampleUsers".equals(authProvider)) {
                String roles;
                authenticatedUser = settings.getCurrentUser();
                if (authenticatedUser != null) {
                    currentUser = authenticatedUser;
                    userRoles = authenticatedUser.getRoles();
                } else {
                    String roles2;
                    String testUserId = settings.getTestUserId();
                    if (testUserId != null && (currentUser = first.getAuthUser(testUserId)) != null && (roles2 = (String)currentUser.get("roles")) != null) {
                        userRoles = DataTools.simpleSplit(roles2, ",");
                    }
                }
                if (currentUser == null && (roles = (String)(currentUser = first.getAuthCurrentUser()).get("roles")) != null) {
                    userRoles = DataTools.simpleSplit(roles, ",");
                }
                availableRoles = first.getAuthAvailableRoleNames();
            } else if ("sql".equals(authProvider)) {
                authenticatedUser = settings.getCurrentUser();
                currentUser = authenticatedUser;
                userRoles = authenticatedUser.getRoles();
                List dbRoles = new DSRequest("hostedRoles", "fetch").execute().getRecords();
                for (Map record : dbRoles) {
                    availableRoles.add((String)record.get("name"));
                }
            }
            if (currentUser != null) {
                Boolean dbSuper;
                String superUser;
                ((Writer)out).append("\nif (isc.Auth) {\n");
                ((Writer)out).append("    isc.Auth.setAvailableRoles(");
                jsTrans.toJS(availableRoles, out);
                ((Writer)out).append(");\n");
                ((Writer)out).append("    isc.Auth.setCurrentUser(");
                jsTrans.toJS(currentUser, out);
                ((Writer)out).append(");\n");
                if (userRoles != null) {
                    ((Writer)out).append("    isc.Auth.setRoles(");
                    jsTrans.toJS(userRoles, out);
                    ((Writer)out).append(");\n");
                }
                if ((superUser = (String)currentUser.get("superUser")) == null && (dbSuper = (Boolean)currentUser.get("isSuperUser")) != null) {
                    superUser = dbSuper.toString();
                }
                if (Boolean.parseBoolean(superUser)) {
                    ((Writer)out).append("    isc.Auth.setSuperUser(true);\n");
                }
                ((Writer)out).append("}\n");
            }
            ((Writer)out).append("\nif (isc.Auth) {\n");
            ((Writer)out).append("    isc.Auth.logOutURL='auth/logout.jsp';\n");
            ((Writer)out).append("    isc.Auth.resetPasswordURL='auth/login.jsp?emailPassword=true&USERNAME=${userId}';\n");
            ((Writer)out).append("}\n");
        }
        for (String p : missing) {
            ((Writer)out).append("isc.logWarn(\"Project '" + p + "' not found.  If the name is correct, please check that the project is shared with you.\");");
        }
        ((Writer)out).append("\nvar requestParams = {params: {defaultScreen: currentScreen}};\n");
        ((Writer)out).append("if (shareId != null) isc.addProperties(requestParams.params, {shareId:shareId});\n");
        ((Writer)out).append("if (mockMode != null) isc.addProperties(requestParams.params, {mockMode:mockMode});\n");
        ((Writer)out).append("isc.RPCManager.cacheScreens(projectScreens, function (data, rpcResponse) {\n");
        if (settings.drawFirstScreen == null || settings.drawFirstScreen.booleanValue()) {
            ((Writer)out).append("    if (!isc.RPCManager.isScreenCached(currentScreen)) { \n");
            ((Writer)out).append("      isc.say('Unable to load screen \\''+currentScreen+'\\' - if the name is correct, please check that the containing project or the screen is shared with you.', {title: 'Unable to load screen'}); \n");
            ((Writer)out).append("      return; \n");
            ((Writer)out).append("    } \n");
            ((Writer)out).append("    var screen = isc.RPCManager.createScreen(currentScreen);\n");
            ((Writer)out).append("    if (screen && !screen.isDrawn()) screen.draw();\n");
        }
        if ((callbackJS = settings.getCallbackJS()) != null) {
            ((Writer)out).append("    " + callbackJS + "\n");
        }
        ((Writer)out).append("}, locale, requestParams);\n");
        return ((Object)out).toString();
    }
}

