/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.mail;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.api.services.gmail.Gmail;
import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;

public class GmailService {
    private static Logger log = new Logger(GmailService.class.getName());
    private static Config config;
    private static final String APPLICATION_NAME = "GmailBasicDataSource";
    private static String DATA_STORE_DIR;
    private static String CLIENT_SECRET_FILE;
    private static final JsonFactory JSON_FACTORY;
    private static HttpTransport HTTP_TRANSPORT;
    private static final List<String> SCOPES;

    protected static Credential authorize(String userId) throws IOException {
        FileInputStream in = new FileInputStream(CLIENT_SECRET_FILE);
        GoogleClientSecrets clientSecrets = GoogleClientSecrets.load((JsonFactory)JSON_FACTORY, (Reader)new InputStreamReader(in));
        FileDataStoreFactory factory = new FileDataStoreFactory(new File(DATA_STORE_DIR + userId));
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder(HTTP_TRANSPORT, JSON_FACTORY, clientSecrets, SCOPES).setDataStoreFactory((DataStoreFactory)factory).setAccessType("offline").build();
        Credential credential = flow.loadCredential("user");
        return credential;
    }

    public static Gmail getGmailService(String userId) throws IOException {
        Credential credential = GmailService.authorize(userId);
        return new Gmail.Builder(HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)credential).setApplicationName(APPLICATION_NAME).build();
    }

    static {
        JSON_FACTORY = JacksonFactory.getDefaultInstance();
        SCOPES = Arrays.asList("https://www.googleapis.com/auth/gmail.labels", "https://www.googleapis.com/auth/gmail.readonly");
        config = new Config();
        config = Config.getGlobal();
        DATA_STORE_DIR = config.getString("gmail.dataStoreDir");
        CLIENT_SECRET_FILE = config.getString("gmail.clientSecretFile");
        try {
            HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

