/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.js;

import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceBeanFilter;
import com.isomorphic.js.IBeanFilter;
import com.isomorphic.js.KeepPropertiesBeanFilter;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class JSONFilter
implements Iterator {
    protected Logger log = new Logger(this);
    Object obj;
    IBeanFilter beanFilter;
    private Iterator iterator;

    public JSONFilter(Object obj, String dataSource, boolean dropExtraFields) {
        this.init(obj, new DataSourceBeanFilter(dataSource, dropExtraFields));
    }

    public JSONFilter(Object obj, DataSource dataSource, boolean dropExtraFields) {
        this.init(obj, new DataSourceBeanFilter(dataSource, dropExtraFields));
    }

    public JSONFilter(Object obj, Collection propsToKeep) {
        this.init(obj, propsToKeep);
    }

    public JSONFilter(Object obj, Object[] propsToKeep) {
        this.init(obj, DataTools.arrayToList(propsToKeep));
    }

    public JSONFilter(Object obj, IBeanFilter beanFilter) {
        this.init(obj, beanFilter);
    }

    private void init(Object obj, Collection propsToKeep) {
        this.init(obj, new KeepPropertiesBeanFilter(propsToKeep));
    }

    private void init(Object obj, IBeanFilter beanFilter) {
        this.obj = obj;
        this.beanFilter = beanFilter;
    }

    public IBeanFilter getBeanFilter() {
        return this.beanFilter;
    }

    public Object getObj() {
        return this.obj;
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.iterator();
        }
        return this.iterator == null ? false : this.iterator.hasNext();
    }

    public Object next() {
        if (this.iterator == null) {
            this.iterator = this.iterator();
        }
        try {
            return this.iterator == null ? null : this.getBeanFilter().filter(this.iterator.next());
        }
        catch (Exception e) {
            this.log.warn((Object)"Exception filtering JSONFilter entry", e);
            return null;
        }
    }

    @Override
    public void remove() {
        if (this.iterator == null) {
            this.iterator = this.iterator();
        }
        if (this.iterator != null) {
            this.iterator.remove();
        }
    }

    protected Iterator iterator() {
        if (this.obj == null) {
            return null;
        }
        if (this.obj instanceof Iterator) {
            return (Iterator)this.obj;
        }
        if (this.obj instanceof Collection) {
            return ((Collection)this.obj).iterator();
        }
        if (this.obj instanceof Object[]) {
            return Arrays.asList((Object[])this.obj).iterator();
        }
        return new SingleObjectIterator(this.obj);
    }

    protected static class SingleObjectIterator
    implements Iterator {
        private Object data;
        private boolean iterated = false;

        public SingleObjectIterator(Object data) {
            this.data = data;
        }

        @Override
        public boolean hasNext() {
            return !this.iterated;
        }

        public Object next() {
            this.iterated = true;
            return this.data;
        }

        @Override
        public void remove() {
        }
    }
}

