/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.io;

import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;

public class SequenceReader
extends Reader {
    private Iterator readers = null;
    private Reader currentReader = null;

    public SequenceReader(List readerList) {
        this.readers = readerList.iterator();
        try {
            this.nextReader();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public SequenceReader(Object sourceOne, Object sourceTwo) {
        this.readers = DataTools.buildList(sourceOne, sourceTwo).iterator();
        try {
            this.nextReader();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public SequenceReader(Object sourceOne, Object sourceTwo, Object sourceThree) {
        this.readers = DataTools.buildList(sourceOne, sourceTwo, sourceThree).iterator();
        try {
            this.nextReader();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int read() throws IOException {
        if (this.currentReader == null) {
            return -1;
        }
        int character = this.currentReader.read();
        if (character == -1) {
            this.nextReader();
            return this.read();
        }
        return character;
    }

    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        if (this.currentReader == null) {
            return -1;
        }
        int numRead = this.currentReader.read(buffer, offset, length);
        if (numRead <= 0) {
            this.nextReader();
            return this.read(buffer, offset, length);
        }
        return numRead;
    }

    @Override
    public void close() throws IOException {
        do {
            this.nextReader();
        } while (this.currentReader != null);
    }

    final void nextReader() throws IOException {
        if (this.currentReader != null) {
            this.currentReader.close();
        }
        this.currentReader = this.readers.hasNext() ? IOUtil.makeReader(this.readers.next()) : null;
    }
}

