/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.cdi;

import com.isomorphic.interfaces.ICDIBeanManager;
import com.isomorphic.log.Logger;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CDIBeanManager
implements ICDIBeanManager {
    protected static Logger log = new Logger(CDIBeanManager.class.getName());
    protected static BeanManager beanManager;

    public Object getBeanManager() throws Exception {
        block5: {
            if (beanManager == null) {
                InitialContext context = new InitialContext();
                try {
                    beanManager = (BeanManager)context.lookup("java:comp/env/BeanManager");
                }
                catch (NamingException ne) {
                    log.info((Object)"Unable to find BeanManager via java:comp/env/BeanManager - will try java:comp/BeanManager");
                    if (beanManager != null) break block5;
                    try {
                        beanManager = (BeanManager)context.lookup("java:comp/BeanManager");
                    }
                    catch (NamingException ne2) {
                        log.info((Object)"Unable to find BeanManager via java:comp/env/BeanManager");
                        throw ne2;
                    }
                }
            }
        }
        return beanManager;
    }

    public Object getBean(String beanName) throws Exception {
        this.getBeanManager();
        Iterator i = beanManager.getBeans(beanName).iterator();
        if (!i.hasNext()) {
            throw new RuntimeException("Failed to get bean '" + beanName + "' from CDI BeanManager");
        }
        Bean bean = (Bean)i.next();
        CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
        Object o = beanManager.getReference(bean, (Type)bean.getBeanClass(), ctx);
        return o;
    }

    public Object getBean(Type beanType) throws Exception {
        this.getBeanManager();
        Iterator i = beanManager.getBeans(beanType, new Annotation[0]).iterator();
        if (!i.hasNext()) {
            throw new RuntimeException("Failed to get bean of type '" + beanType + "' from CDI BeanManager");
        }
        Bean bean = (Bean)i.next();
        CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
        Object o = beanManager.getReference(bean, (Type)bean.getBeanClass(), ctx);
        return o;
    }
}

