/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;

class MultipartValueStream
extends InputStream {
    public static final String HEADER_ENCODING = "iso-8859-1";
    private InputStream in;
    private byte[] boundaryBytes;
    private int matchedBoundaryBytes;
    private byte[] readAheadBytes;
    private int readAheadBufferStartI;
    private int readAheadBufferEndI;
    private boolean boundaryReached = false;
    private boolean finalBoundaryReached = false;

    public MultipartValueStream(InputStream in, String boundary) throws IOException {
        this.in = in;
        this.boundaryBytes = ("\r\n" + boundary).getBytes(HEADER_ENCODING);
        this.matchedBoundaryBytes = 0;
        this.readAheadBytes = new byte[this.boundaryBytes.length];
        if (in.read(this.readAheadBytes, 0, this.readAheadBytes.length) != this.readAheadBytes.length) {
            throw new IOException("end of stream before boundary found!");
        }
        for (int i = 0; i < this.readAheadBytes.length; ++i) {
            if (this.readAheadBytes[i] == this.boundaryBytes[this.matchedBoundaryBytes]) {
                ++this.matchedBoundaryBytes;
                continue;
            }
            this.matchedBoundaryBytes = 0;
            if (this.readAheadBytes[i] != this.boundaryBytes[0]) continue;
            this.matchedBoundaryBytes = 1;
        }
        this.readAheadBufferStartI = 0;
        this.readAheadBufferEndI = this.readAheadBytes.length - 1;
    }

    public int read() throws IOException {
        int underlyingRead;
        if (this.boundaryReached) {
            return -1;
        }
        if (this.matchedBoundaryBytes == this.boundaryBytes.length) {
            this.boundaryReached = true;
            byte[] buf = new byte[2];
            if (this.in.read(buf) != 2) {
                throw new IOException("end of stream before boundary found!");
            }
            String readStr = new String(buf, HEADER_ENCODING);
            if (readStr.equals("--")) {
                if (this.in.read(buf) != 2) {
                    throw new IOException("invalid end of final boundary found!");
                }
                readStr = new String(buf, HEADER_ENCODING);
                if (!readStr.equals("\r\n")) {
                    throw new IOException("invalid end of final boundary found!");
                }
                this.finalBoundaryReached = true;
            } else if (readStr.equals("\r\n")) {
                this.finalBoundaryReached = false;
            } else {
                throw new IOException("invalid end of boundary found!");
            }
            return -1;
        }
        char returnByte = (char)this.readAheadBytes[this.readAheadBufferStartI];
        ++this.readAheadBufferStartI;
        if (this.readAheadBufferStartI == this.readAheadBytes.length) {
            this.readAheadBufferStartI = 0;
        }
        if ((underlyingRead = this.in.read()) == -1) {
            throw new IOException("end of stream before boundary found!");
        }
        ++this.readAheadBufferEndI;
        if (this.readAheadBufferEndI == this.readAheadBytes.length) {
            this.readAheadBufferEndI = 0;
        }
        this.readAheadBytes[this.readAheadBufferEndI] = (byte)underlyingRead;
        if (this.readAheadBytes[this.readAheadBufferEndI] == this.boundaryBytes[this.matchedBoundaryBytes]) {
            ++this.matchedBoundaryBytes;
        } else {
            this.matchedBoundaryBytes = 0;
            if (this.readAheadBytes[this.readAheadBufferEndI] == this.boundaryBytes[0]) {
                this.matchedBoundaryBytes = 1;
            }
        }
        return returnByte;
    }

    public boolean encounteredFinalBoundary() throws ServletException {
        if (!this.boundaryReached) {
            throw new ServletException("have not reached boundary yet!");
        }
        return this.finalBoundaryReached;
    }
}

