/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class WebRootExistsTask
extends Task {
    private static Logger log = new Logger(WebRootExistsTask.class.getName());
    private String propertyName;

    public void execute() throws BuildException {
        String webRoot;
        Config config = Config.getGlobal();
        if (config == null) {
            try {
                config = Config.initGlobalConfig();
            }
            catch (Exception ex) {
                throw new BuildException("Failed to initialize configuration.", (Throwable)ex);
            }
        }
        if ("__AUTODETECT__".equals(webRoot = config.getPath("webRoot"))) {
            webRoot = this.getProject().getBaseDir().getAbsolutePath() + File.separator + "war";
        }
        webRoot = webRoot + File.separator + config.getPath("isomorphicPathRootRelative");
        log.info((Object)("Testing web root: " + webRoot));
        File markerFile = new File(webRoot);
        try {
            markerFile = markerFile.getAbsoluteFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (markerFile.exists()) {
            this.getProject().setProperty(this.propertyName, "true");
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }
}

