/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.tools.BuiltinRPC;
import com.isomorphic.util.BMPRContents;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ReifyTools {
    private static Logger log = new Logger(ReifyTools.class.getName());
    protected static long nextDBInstanceId = 1L;
    protected static long nextDSInstanceId = 1L;

    public static BMPRContents createBMPRContents(String dbPath) throws Exception {
        BMPRContents contents = new BMPRContents();
        String dbName = null;
        try {
            dbName = ReifyTools.createSQLiteDatabase(dbPath);
            contents.addRecords("info", ReifyTools.getProjectInfo(dbName));
            contents.addRecords("branch", ReifyTools.getProjectBranches(dbName, null));
            contents.addRecords("resource", ReifyTools.getProjectResources(dbName, null));
        }
        finally {
            if (dbName != null) {
                ReifyTools.dropSQLiteDatabase(dbName);
            }
        }
        return contents;
    }

    public static Map getBMPRInfo(String dbPath) throws Exception {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        String dbName = null;
        try {
            dbName = ReifyTools.createSQLiteDatabase(dbPath);
            info.put("info", ReifyTools.getProjectAttributes(dbName));
            info.put("branches", ReifyTools.getProjectBranches(dbName, null));
        }
        finally {
            if (dbName != null) {
                ReifyTools.dropSQLiteDatabase(dbName);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> getBMPRResources(String dbPath, String branchName) throws Exception {
        List<Map<String, Object>> resources = null;
        String dbName = null;
        try {
            dbName = ReifyTools.createSQLiteDatabase(dbPath);
            String branchId = ReifyTools.getBranchIdForName(dbName, branchName);
            resources = ReifyTools.getProjectResources(dbName, branchId);
        }
        finally {
            if (dbName != null) {
                ReifyTools.dropSQLiteDatabase(dbName);
            }
        }
        return resources;
    }

    private static String createSQLiteDatabase(String dbPath) throws Exception {
        String dbName = ReifyTools.getNextDatabaseName();
        Config sqlConfig = new Config();
        sqlConfig.put((Object)"database.type", (Object)"generic");
        sqlConfig.put((Object)"interface.type", (Object)"DriverManager");
        sqlConfig.put((Object)"interface.credentialsInURL", (Object)"false");
        sqlConfig.put((Object)"driver", (Object)"org.sqlite.JDBC");
        sqlConfig.put((Object)"driver.networkProtocol", (Object)"tcp");
        sqlConfig.put((Object)"driver.url", (Object)("jdbc:sqlite:" + dbPath));
        sqlConfig.put((Object)"pool.enabled", (Object)"false");
        SQLDriver.configure((String)dbName, (Config)sqlConfig);
        return dbName;
    }

    private static void dropSQLiteDatabase(String dbName) {
        SQLDriver.purgeSqlConfig((String)dbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNextDatabaseName() {
        Class<ReifyTools> clazz = ReifyTools.class;
        synchronized (ReifyTools.class) {
            long instanceId = nextDBInstanceId++;
            // ** MonitorExit[var2] (shouldn't be in output)
            return "_bmpr_db_" + instanceId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNextDataSourceID(String tableName) {
        Class<ReifyTools> clazz = ReifyTools.class;
        synchronized (ReifyTools.class) {
            long instanceId = nextDSInstanceId++;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            return "_bmpr_" + tableName + "_" + instanceId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Map<String, Object>> getProjectResources(String dbName, String branchId) throws Exception {
        ArrayList<Map<String, Object>> resources = new ArrayList<Map<String, Object>>();
        String dsName = ReifyTools.getNextDataSourceID("resources");
        try {
            DataSource resourcesDS = BuiltinRPC.getDataSourceFromTable("RESOURCES", "sql", dbName, dsName);
            DSRequest request = new DSRequest(resourcesDS, "fetch");
            if (branchId != null) {
                request.setCriteria("BRANCHID", (Object)branchId);
            }
            DSResponse response = request.execute();
            List records = response.getRecords();
            for (Map record : records) {
                String id = (String)record.get("ID");
                String attributes = (String)record.get("ATTRIBUTES");
                String data = (String)record.get("DATA");
                Map resourceAttributes = ReifyTools.getMapFromJson(attributes);
                Boolean trashed = (Boolean)resourceAttributes.get("trashed");
                if (Boolean.TRUE.equals(trashed)) continue;
                String kind = (String)resourceAttributes.get("kind");
                Object resourceData = null;
                resourceData = "asset".equals(kind) || "otherAsset".equals(kind) ? data : ReifyTools.getMapFromJson(data);
                LinkedHashMap<String, Object> resource = new LinkedHashMap<String, Object>();
                resource.put("ID", id);
                resource.put("attributes", resourceAttributes);
                resource.put("data", resourceData);
                if (record.get("ATTRIBUTES") != null) {
                    resource.put("branchId", record.get("BRANCHID"));
                }
                resources.add(resource);
            }
        }
        finally {
            DataStructCache.removeCachedObjectWithNoConfigFile((String)dsName);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Map<String, Object>> getProjectInfo(String dbName) throws Exception {
        List records = null;
        String dsName = ReifyTools.getNextDataSourceID("info");
        try {
            DataSource infoDS = BuiltinRPC.getDataSourceFromTable("INFO", "sql", dbName, dsName);
            DSRequest request = new DSRequest(infoDS, "fetch");
            DSResponse response = request.execute();
            records = response.getRecords();
        }
        finally {
            DataStructCache.removeCachedObjectWithNoConfigFile((String)dsName);
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getProjectAttributes(String dbName) throws Exception {
        Map attributes = null;
        String dsName = ReifyTools.getNextDataSourceID("info");
        try {
            DataSource infoDS = BuiltinRPC.getDataSourceFromTable("INFO", "sql", dbName, dsName);
            DSRequest request = new DSRequest(infoDS, "fetch");
            request.setCriteria("NAME", (Object)"ArchiveAttributes");
            DSResponse response = request.execute();
            Map record = response.getRecord();
            String value = (String)record.get("VALUE");
            attributes = ReifyTools.getMapFromJson(value);
        }
        finally {
            DataStructCache.removeCachedObjectWithNoConfigFile((String)dsName);
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Map<String, Object>> getProjectBranches(String dbName, String branchName) throws Exception {
        ArrayList<Map<String, Object>> branches = new ArrayList<Map<String, Object>>();
        String dsName = ReifyTools.getNextDataSourceID("branches");
        try {
            DataSource branchesDS = BuiltinRPC.getDataSourceFromTable("BRANCHES", "sql", dbName, dsName);
            DSRequest request = new DSRequest(branchesDS, "fetch");
            DSResponse response = request.execute();
            List records = response.getRecords();
            for (Map record : records) {
                String id = (String)record.get("ID");
                String attributes = (String)record.get("ATTRIBUTES");
                Map branchAttributes = ReifyTools.getMapFromJson(attributes);
                if (branchName != null && !id.equals(branchName) && !branchName.equals(branchAttributes.get("branchName"))) continue;
                if (branchName != null) {
                    branchAttributes.put("_ID", id);
                }
                branches.add(branchAttributes);
            }
        }
        finally {
            DataStructCache.removeCachedObjectWithNoConfigFile((String)dsName);
        }
        return branches;
    }

    private static String getBranchIdForName(String dbName, String branchName) throws Exception {
        if (branchName == null || "Master".equals(branchName)) {
            return "Master";
        }
        List<Map<String, Object>> branches = ReifyTools.getProjectBranches(dbName, branchName);
        return !branches.isEmpty() ? (String)branches.get(0).get("_ID") : null;
    }

    private static Map getMapFromJson(String json) throws UnconvertableException {
        JSTranslater jsTrans = new JSTranslater();
        return (Map)jsTrans.fromJS(json);
    }
}

