/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.openapi;

import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.Validator;
import com.isomorphic.log.Logger;
import com.isomorphic.openapi.ValidationDescriptions;
import com.isomorphic.rpc.RestRequestParser;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.LocaleMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class SpecificationContextEditor {
    private static final Logger log = new Logger(SpecificationContextEditor.class.getName());
    private static final String BASE64_EXAMPLE = "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";
    private static final Map<String, Map<String, Object>> DATATYPE_MAP = new LinkedHashMap<String, Map<String, Object>>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void editDataSourceContext(String id, Map<String, Object> context) {
        DataSource ds = null;
        try {
            ds = DataSourceManager.getDataSource(id, new DSRequest());
            context.put("id", ds.getID());
            String defaultTextMatchStyle2332 = "exact";
            if (ds.getConfig().get("defaultTextMatchStyle") != null) {
                defaultTextMatchStyle2332 = (String)ds.getConfig().get("defaultTextMatchStyle");
            }
            context.put("defaultTextMatchStyle", defaultTextMatchStyle2332);
            String jsonPrefix = (String)ds.getConfig().get("jsonPrefix");
            String jsonSuffix = (String)ds.getConfig().get("jsonSuffix");
            if (jsonPrefix != null) {
                context.put("jsonPrefix", jsonPrefix);
            }
            if (jsonSuffix != null) {
                context.put("jsonSuffix", jsonSuffix);
            }
            ArrayList primaryKeys = new ArrayList();
            ArrayList<DataTypeMap> foreignKeys = new ArrayList<DataTypeMap>();
            final ArrayList fields = new ArrayList();
            LinkedHashSet<String> required2 = new LinkedHashSet<String>();
            for (DSField field : ds.getFields()) {
                String[] stringArray;
                if (!field.canView() || field.ignore() || field.isInapplicable() || !field.getBoolean(this.getExclusionAttribute(), true)) continue;
                LinkedHashMap<String, Object> fieldMap = new LinkedHashMap<String, Object>();
                fieldMap.put("name", field.getName());
                Map<String, Object> type = DATATYPE_MAP.get(field.getType());
                if (type != null) {
                    String converted = String.valueOf(type.get("type"));
                    fieldMap.put("type", converted);
                    fieldMap.put("format", type.get("format"));
                    String sample = String.valueOf(type.get("sample"));
                    if (field.getLength() != null && field.getLength() < (long)sample.length()) {
                        sample = sample.substring(0, field.getLength().intValue());
                    }
                    fieldMap.put("sample", sample);
                } else {
                    fieldMap.put("type", "string");
                    fieldMap.put("format", field.getType());
                    fieldMap.put("sample", "\"formatted string\"");
                }
                fieldMap.put("description", field.getProperty("prompt"));
                fieldMap.put("title", field.getTitle());
                fieldMap.put("maxLength", field.getLength());
                if (field.isRequired() || field.isPrimaryKey() && !"sequence".equals(field.getType())) {
                    fieldMap.put("required", true);
                    required2.add(field.getName());
                }
                if (!field.isRequired() && !field.isPrimaryKey()) {
                    fieldMap.put("nullable", true);
                }
                if (!field.getBoolean("canEdit") || !field.getBoolean("canSave")) {
                    fieldMap.put("readOnly", true);
                }
                HashSet<String> restrictions = new HashSet<String>();
                if (this.isViewRestricted(field)) {
                    restrictions.add("view");
                }
                if (this.isAddRestricted(field)) {
                    restrictions.add("add");
                }
                if (this.isUpdateRestricted(field)) {
                    restrictions.add("update");
                }
                fieldMap.put("restrictions", restrictions);
                String fk = field.getForeignKey();
                if (fk != null) {
                    String[] split = fk.split("\\.");
                    if (split.length == 2) {
                        DataTypeMap map = DataTools.buildMap("ds", split[0], "field", split[1]);
                        fieldMap.put("fk", (Object)map);
                        foreignKeys.add(DataTools.buildMap(new Object[]{field.getName(), map}));
                    } else {
                        log.warn(String.format("Field %s.%s has an invalid foreign key specification: '%s'", ds.getName(), field.getName(), field.getForeignKey()));
                    }
                }
                DataTypeMap<String, Object> fieldValueMap = field.getValueMap();
                HashMap fieldMapValueMap = new HashMap();
                if (fieldValueMap != null) {
                    Object[] keys = fieldValueMap.keySet().toArray(new Object[0]);
                    fieldMap.put("enum", keys);
                    fieldMap.put("sample", keys[0]);
                    for (Map.Entry entry : fieldValueMap.entrySet()) {
                        Object key = entry.getKey();
                        Object val = entry.getValue();
                        if (val instanceof LocaleMessage) {
                            String i18n = ((LocaleMessage)val).getMessage(Locale.US);
                            fieldMapValueMap.put(key, i18n);
                            continue;
                        }
                        fieldMapValueMap.put(key, String.valueOf(val));
                    }
                    fieldMap.put("valueMap", fieldMapValueMap);
                }
                ArrayList<Map> fieldMapValidatorConfigs = new ArrayList<Map>();
                ArrayList fieldValidatorConfigs = field.getValidators();
                if (ds.getConfig().getBoolean((Object)"validateRelatedRecords", false) && field.getForeignKey() != null && (fieldValidatorConfigs == null || DataTools.findAll(fieldValidatorConfigs, "type", "hasRelatedRecord").isEmpty()) && (stringArray = field.getForeignKey().split("\\.")).length == 2) {
                    HashMap<String, String> v = new HashMap<String, String>();
                    v.put("type", "hasRelatedRecord");
                    v.put("relatedDataSource", stringArray[0]);
                    v.put("relatedField", stringArray[1]);
                    if (fieldValidatorConfigs == null) {
                        fieldValidatorConfigs = new ArrayList();
                    }
                    fieldValidatorConfigs.add(v);
                }
                if (fieldValidatorConfigs != null) {
                    for (Map validatorConfig : fieldValidatorConfigs) {
                        Validator v = new Validator(validatorConfig, (BasicDataSource)ds);
                        if (v.isClientOnly()) continue;
                        String vt = v.getType();
                        if ("integerRange".equals(vt) || "floatRange".equals(vt) || "floatLimit".equals(vt)) {
                            if (Boolean.valueOf((String)validatorConfig.get("exclusive")).booleanValue()) {
                                fieldMap.put("exclusiveMinimum", validatorConfig.get("min"));
                                fieldMap.put("exclusiveMaximum", validatorConfig.get("max"));
                                continue;
                            }
                            fieldMap.put("minimum", validatorConfig.get("min"));
                            fieldMap.put("maximum", validatorConfig.get("max"));
                            continue;
                        }
                        if ("lengthRange".equals(vt)) {
                            fieldMap.put("minLength", validatorConfig.get("min"));
                            fieldMap.put("maxLength", validatorConfig.get("max"));
                            continue;
                        }
                        if ("regexp".equals(vt)) {
                            fieldMap.put("pattern", validatorConfig.get("expression"));
                            continue;
                        }
                        if ("required".equals(vt)) {
                            required2.add(field.getName());
                            continue;
                        }
                        if ("isOneOf".equals(vt) || "inSet".equals(vt)) {
                            if (!validatorConfig.containsKey("list")) continue;
                            fieldMap.put("enum", validatorConfig.get("list"));
                            fieldMap.remove("valueMap");
                            continue;
                        }
                        if ("readOnly".equals(vt)) {
                            String fieldAppearance = v.getProperty("fieldAppearance");
                            if (fieldAppearance != null && !"readonly".equals(fieldAppearance) && !"disabled".equals(fieldAppearance)) continue;
                            fieldMap.put("readOnly", true);
                            continue;
                        }
                        class MapRestringer {
                            MapRestringer() {
                            }

                            Map restring(Map<String, Object> map) {
                                HashMap<String, Object> result = new HashMap<String, Object>();
                                for (Map.Entry<String, Object> entry : map.entrySet()) {
                                    String key = entry.getKey();
                                    Object value = entry.getValue();
                                    if (value instanceof Map) {
                                        ((Map)value).putAll(this.restring((Map)value));
                                    }
                                    if (value instanceof String) {
                                        String escaped = String.valueOf(value).replace("\"", "\\\"");
                                        value = "\"" + escaped.trim() + "\"";
                                    }
                                    result.put(key, value);
                                }
                                return result;
                            }
                        }
                        Map restrung = new MapRestringer().restring(validatorConfig);
                        restrung.put("description", ValidationDescriptions.getDescription(v));
                        DataTools.removeNullValuedKeys(restrung);
                        fieldMapValidatorConfigs.add(restrung);
                    }
                }
                if (!fieldMapValidatorConfigs.isEmpty()) {
                    fieldMap.put("validators", fieldMapValidatorConfigs);
                }
                DataTools.removeNullValuedKeys(fieldMap);
                if (field.isPrimaryKey()) {
                    fieldMap.put("primaryKey", true);
                    primaryKeys.add(fieldMap);
                }
                context.put("pathSupportsPrimaryKeySegment", ds.getPrimaryKeys().size() == 1);
                fields.add(fieldMap);
            }
            List pkNames = DataTools.getProperty(primaryKeys, "name");
            context.put("fields", fields);
            context.put("requiredFields", required2);
            context.put("primaryKeys", primaryKeys);
            context.put("primaryKeyFieldNames", pkNames.isEmpty() ? "None" : StringUtils.join((Collection)pkNames, (String)", "));
            context.put("foreignKeys", foreignKeys);
            HashMap<String, Object> fetch = new HashMap<String, Object>();
            fetch.put("operationType", "fetch");
            fetch.put("parameters", fields);
            fetch.put("outputs", fields);
            fetch.put("payloadFormat", "array");
            HashMap<String, Object> add = new HashMap<String, Object>();
            add.put("operationType", "add");
            add.put("parameters", DataTools.setDisjunction(fields, DataTools.findAll(fields, "format", "sequence")));
            add.put("outputs", fields);
            add.put("required", required2);
            add.put("payloadFormat", "record");
            HashMap<String, Object> update = new HashMap<String, Object>();
            update.put("operationType", "update");
            update.put("parameters", fields);
            update.put("outputs", fields);
            update.put("payloadFormat", "any");
            if (this.isAllowMultiUpdate(ds, null)) {
                update.put("allowMultiUpdate", true);
            } else {
                update.put("required", pkNames);
            }
            HashMap<String, Object> remove = new HashMap<String, Object>();
            remove.put("operationType", "remove");
            remove.put("outputs", primaryKeys);
            remove.put("payloadFormat", "record");
            if (this.isAllowMultiUpdate(ds, null)) {
                remove.put("allowMultiUpdate", true);
                remove.put("parameters", fields);
            } else {
                remove.put("parameters", primaryKeys);
                remove.put("required", pkNames);
            }
            HashMap<String, Object> custom = new HashMap<String, Object>();
            custom.put("operationType", "custom");
            custom.put("outputs", fields);
            custom.put("parameters", fields);
            custom.put("payloadFormat", "any");
            HashMap<String, Map> defaultOperations = new HashMap<String, Map>();
            defaultOperations.put("fetch", fetch);
            defaultOperations.put("add", add);
            defaultOperations.put("update", update);
            defaultOperations.put("remove", remove);
            defaultOperations.put("custom", custom);
            context.put("defaultOperations", defaultOperations);
            HashSet<String> hiddenDefaults = new HashSet<String>();
            for (Map op : defaultOperations.values()) {
                String string = String.valueOf(op.get("operationType"));
                if (this.includeOperationBinding(ds, op)) continue;
                hiddenDefaults.add(string);
            }
            List explicitBindingConfigs = ds.getOperationBindings();
            if (explicitBindingConfigs != null) {
                ArrayList<Map<String, Object>> namedOperations = new ArrayList<Map<String, Object>>();
                for (Map binding : explicitBindingConfigs) {
                    String operationType = String.valueOf(binding.get("operationType"));
                    if (!this.includeOperationBinding(ds, binding)) {
                        if (binding.get("operationId") != null) continue;
                        hiddenDefaults.add(operationType);
                        continue;
                    }
                    if (binding.get("operationId") == null) {
                        hiddenDefaults.remove(operationType);
                    }
                    Map props = DataTools.subsetMap(binding, DataTools.buildList("operationId", "operationType"));
                    props.putAll((Map)defaultOperations.get(operationType));
                    Collection httpMethod = RestRequestParser.HTTP_METHOD_MAP.get((Object)operationType);
                    props.put("httpMethod", httpMethod.iterator().next());
                    Boolean providesMissingKeys = Boolean.valueOf(String.valueOf(binding.get("providesMissingKeys")));
                    if ("update".equals(operationType) || "remove".equals(operationType)) {
                        if (this.isAllowMultiUpdate(ds, binding)) {
                            if ("update".equals(operationType)) {
                                props.put("httpMethod", "patch");
                            }
                            props.put("required", new HashSet());
                            props.put("parameters", fields);
                            props.put("outputs", fields);
                            props.put("allowMultiUpdate", true);
                            props.put("payloadFormat", "any");
                        } else {
                            if ("update".equals(operationType)) {
                                props.put("httpMethod", "put");
                            }
                            props.put("payloadFormat", "record");
                        }
                        if (providesMissingKeys.booleanValue()) {
                            props.put("required", new HashSet());
                        }
                    }
                    if (binding.get("outputs") != null) {
                        String css = String.valueOf(binding.get("outputs"));
                        List<String> outputs = DataTools.commaSeparatedStringToList(css);
                        ArrayList list = new ArrayList();
                        for (String name : outputs) {
                            List existing = DataTools.findAll(fields, "name", name);
                            if (!existing.isEmpty()) {
                                list.add(existing.get(0));
                                continue;
                            }
                            DataTypeMap extra = DataTools.buildMap("name", name, "type", "string", "format", "custom", "sample", "unknown", "restrictions", new ArrayList());
                            list.add(extra);
                        }
                        props.put("outputs", list);
                    }
                    class CriteriaFieldResolver {
                        CriteriaFieldResolver() {
                        }

                        void resolve(String name, List<Map<String, Object>> parameters) {
                            List defined = DataTools.findAll(fields, "name", name);
                            if (!defined.isEmpty()) {
                                List existing = DataTools.findAll(parameters, "name", name);
                                if (existing.isEmpty()) {
                                    parameters.add((Map<String, Object>)defined.get(0));
                                }
                            } else {
                                DataTypeMap extra = DataTools.buildMap("name", name, "type", "string", "format", "custom", "sample", "unknown", "restrictions", new ArrayList());
                                extra.put("description", "Custom field metadata undetected.  If necessary, contact support for description, type, format, etc.");
                                parameters.add(0, (Map<String, Object>)((Object)extra));
                            }
                        }
                    }
                    CriteriaFieldResolver resolver = new CriteriaFieldResolver();
                    String clause = null;
                    if (binding.get("whereClause") != null) {
                        clause = String.valueOf(binding.get("whereClause"));
                    }
                    if (binding.get("customSQL") != null) {
                        clause = String.valueOf(binding.get("customSQL"));
                    }
                    if (binding.get("customJQL") != null) {
                        clause = String.valueOf(binding.get("customJQL"));
                    }
                    if (binding.get("customHQL") != null) {
                        clause = String.valueOf(binding.get("customHQL"));
                    }
                    ArrayList<Map<String, Object>> parameters = new ArrayList<Map<String, Object>>();
                    Map defaultOp = (Map)defaultOperations.get(operationType);
                    List defaultParameters = (List)defaultOp.get("parameters");
                    parameters.addAll(defaultParameters);
                    if (clause != null) {
                        String regex = "(?:\\$advancedCriteria\\.|\\$criteria\\.)([^\\s]+)";
                        Pattern p = Pattern.compile(regex);
                        Matcher m = p.matcher(clause);
                        if (!clause.contains("$defaultWhereClause")) {
                            parameters.clear();
                        }
                        while (m.find()) {
                            String criteria = m.group(1);
                            resolver.resolve(criteria, parameters);
                        }
                    }
                    if (binding.get("requiredCriterion") != null) {
                        String str = String.valueOf(binding.get("requiredCriterion"));
                        List<String> criterion = DataTools.commaSeparatedStringToList(str);
                        for (String name : criterion) {
                            resolver.resolve(name, parameters);
                        }
                        props.put("required", criterion);
                    }
                    DataTools.removeDuplicates(parameters);
                    if (!parameters.isEmpty()) {
                        props.put("parameters", parameters);
                    }
                    if (binding.get("operationId") != null) {
                        namedOperations.add(props);
                        continue;
                    }
                    defaultOperations.put(operationType, props);
                }
                this.setNonNullableOutputs(ds.getID(), namedOperations);
                context.put("namedOperations", namedOperations);
            }
            this.setNonNullableOutputs(ds.getID(), defaultOperations.values());
            for (String string : hiddenDefaults) {
                defaultOperations.remove(string);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                try {
                    DataSourceManager.free(ds);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            DataSourceManager.free(ds);
        }
        catch (Exception defaultTextMatchStyle2332) {}
        DataTools.removeNullValuedKeys(context);
    }

    private void setNonNullableOutputs(String ds, Collection<Map<String, Object>> operations) {
        for (Map<String, Object> op : operations) {
            List outputs = (List)op.get("outputs");
            if (outputs == null || outputs.isEmpty()) {
                // empty if block
            }
            op.put("requiredOutputs", DataTools.findAll(outputs, "required", true));
        }
    }

    private boolean isViewRestricted(DataTypeMap<String, Object> config) {
        return config.containsKey("viewRequires") || config.containsKey("viewRequiresRole") || config.containsKey("viewRequiresAuthentication");
    }

    private boolean isAddRestricted(DataTypeMap<String, Object> config) {
        return config.containsKey("editRequires") || config.containsKey("editRequiresRole") || config.containsKey("editRequiresAuthentication") || config.containsKey("initRequires") || config.containsKey("initRequiresRole") || config.containsKey("initRequiresAuthentication");
    }

    private boolean isUpdateRestricted(DataTypeMap<String, Object> config) {
        return config.containsKey("editRequires") || config.containsKey("editRequiresRole") || config.containsKey("editRequiresAuthentication") || config.containsKey("updateRequires") || config.containsKey("updateRequiresRole") || config.containsKey("updateRequiresAuthentication");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void editOpenAPIContext(Map<String, Object> context) {
        ArrayList listing = new ArrayList();
        for (String id : DataSourceManager.getDefinedDataSourceIdentifiers()) {
            DataSource ds;
            block22: {
                block21: {
                    ds = null;
                    ds = DataSourceManager.getDataSource(id, new DSRequest());
                    if (ds != null) break block21;
                    log.warn("Unable to fetch datasource instance for name: " + id + " - skipping");
                    try {
                        DataSourceManager.free(ds);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if ("OrderItem".equals(ds.getID())) {
                    log.warn("breakpoint");
                }
                if (this.includeDataSource(ds)) break block22;
                log.warn("Datasource specification " + id + " excluded by filter - skipping");
                try {
                    DataSourceManager.free(ds);
                }
                catch (Exception exception) {}
                continue;
            }
            LinkedHashMap<String, Object> map2333333332 = new LinkedHashMap<String, Object>();
            map2333333332.put("id", ds.getID());
            map2333333332.put("config", ds.getConfig());
            map2333333332.put("primaryKey", ds.getPrimaryKey());
            map2333333332.put("pathSupportsPrimaryKeySegment", ds.getPrimaryKeys().size() == 1);
            List<String> defaultOperations = DataTools.buildList("fetch", "add", "update", "remove");
            map2333333332.put("defaultOperations", defaultOperations);
            List operationBindings = ds.getOperationBindings();
            if (operationBindings != null) {
                ArrayList<Map> paths = new ArrayList<Map>();
                for (Map binding : operationBindings) {
                    if (!this.includeOperationBinding(ds, binding)) {
                        if (binding.get("operationId") != null) continue;
                        defaultOperations.remove(binding.get("operationType"));
                        continue;
                    }
                    if (binding.get("operationId") == null) continue;
                    paths.add(DataTools.subsetMap(binding, DataTools.buildList("operationId", "operationType")));
                }
                map2333333332.put("config", ds.getConfig());
                map2333333332.put("namedOperations", paths);
            }
            listing.add(map2333333332);
            try {
                DataSourceManager.free(ds);
            }
            catch (Exception map2333333332) {}
            continue;
            catch (Exception e) {
                try {
                    log.error((Object)("Unable to fetch datasource instance for name: " + id + " - skipping"), e);
                }
                catch (Throwable throwable) {
                    try {
                        DataSourceManager.free(ds);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    DataSourceManager.free(ds);
                }
                catch (Exception exception) {}
            }
        }
        context.put("dataSources", listing);
    }

    public void editFrameworkContext(Map<String, Object> context) {
    }

    protected boolean includeDataSource(DataSource ds) {
        if (ds == null) {
            return false;
        }
        if (ds.getType().equals("component")) {
            return false;
        }
        if (ds.isServerOnly()) {
            return false;
        }
        String requiresExpression = ds.getConfig().getString("requires");
        if ("false".equalsIgnoreCase(requiresExpression)) {
            return false;
        }
        if (ds.getFields() == null || ds.getFields().isEmpty()) {
            return false;
        }
        String attr = this.getExclusionAttribute();
        boolean include = ds.getConfig().getBoolean((Object)attr, true);
        return include;
    }

    protected boolean includeOperationBinding(DataSource ds, Map<String, Object> bindingConfig) {
        String requiresExpression;
        String operationType = (String)bindingConfig.get("operationType");
        if (DataSource.isUpdate(operationType) || DataSource.isRemove(operationType)) {
            if (ds.getFields().size() <= ds.getPrimaryKeys().size()) {
                return false;
            }
            if ((ds.getPrimaryKeys() == null || ds.getPrimaryKeys().isEmpty()) && !this.isAllowMultiUpdate(ds, bindingConfig)) {
                return false;
            }
        }
        if ("false".equalsIgnoreCase(requiresExpression = (String)bindingConfig.get("requires"))) {
            return false;
        }
        String attr = this.getExclusionAttribute();
        return bindingConfig.get(attr) == null || Boolean.valueOf(attr) != false;
    }

    protected boolean isAllowMultiUpdate(DataSource ds, Map<String, Object> bindingConfig) {
        String dsMultiUpdatePolicy = ds.getConfig().getString("defaultMultiUpdatePolicy");
        String defaultMultiUpdatePolicy = Config.getGlobal().getString(" datasources.defaultMultiUpdatePolicy");
        String multiUpdatePolicy = dsMultiUpdatePolicy != null ? dsMultiUpdatePolicy : defaultMultiUpdatePolicy;
        Boolean allowMultiUpdatesByDefault = "never".equalsIgnoreCase(multiUpdatePolicy);
        if (bindingConfig == null) {
            return allowMultiUpdatesByDefault;
        }
        String allowMultiUpdateString = String.valueOf(bindingConfig.get("allowMultiUpdate"));
        Boolean allowMultiUpdatesExplicitly = !"null".equals(allowMultiUpdateString) && Boolean.valueOf(allowMultiUpdateString) != false;
        return allowMultiUpdatesExplicitly != false || allowMultiUpdatesByDefault != false && allowMultiUpdatesExplicitly == false;
    }

    private String getExclusionAttribute() {
        return Config.getGlobal().getString("openapi.filter", "apidoc");
    }

    static {
        DATATYPE_MAP.put("text", (Map<String, Object>)((Object)DataTools.buildMap("type", "string", "sample", "string")));
        DATATYPE_MAP.put("boolean", (Map<String, Object>)((Object)DataTools.buildMap("type", "boolean", "sample", true)));
        DATATYPE_MAP.put("integer", (Map<String, Object>)((Object)DataTools.buildMap("type", "integer", "sample", 1000)));
        DATATYPE_MAP.put("float", (Map<String, Object>)((Object)DataTools.buildMap("type", "number", "format", "float", "sample", 1.05)));
        DATATYPE_MAP.put("date", (Map<String, Object>)((Object)DataTools.buildMap("type", "string", "format", "date", "sample", "2006-01-10")));
        DATATYPE_MAP.put("datetime", (Map<String, Object>)((Object)DataTools.buildMap("type", "string", "format", "date-time", "sample", "2006-01-10T12:22:04-04:00")));
        DATATYPE_MAP.put("time", (Map<String, Object>)((Object)DataTools.buildMap("type", "string", "format", "time", "sample", "22:01:45")));
        DATATYPE_MAP.put("enum", (Map<String, Object>)((Object)DataTools.buildMap("type", "string")));
        DATATYPE_MAP.put("intEnum", (Map<String, Object>)((Object)DataTools.buildMap("type", "integer")));
        DATATYPE_MAP.put("sequence", (Map<String, Object>)((Object)DataTools.buildMap("type", "number", "format", "sequence", "sample", 9999)));
        DATATYPE_MAP.put("link", (Map<String, Object>)((Object)DataTools.buildMap("type", "number", "format", "link", "sample", "https://www.smartclient.com")));
        DATATYPE_MAP.put("image", (Map<String, Object>)((Object)DataTools.buildMap("type", "string", "format", "link", "sample", "https://www.smartclient.com/favicon.ico")));
        DATATYPE_MAP.put("binary", (Map<String, Object>)((Object)DataTools.buildMap("type", "string", "format", "byte", "sample", BASE64_EXAMPLE)));
        DATATYPE_MAP.put("imageFile", (Map<String, Object>)((Object)DataTools.buildMap("type", "string", "format", "byte", "sample", BASE64_EXAMPLE)));
        DATATYPE_MAP.put("modifier", (Map<String, Object>)((Object)DataTools.buildMap("type", "string", "sample", "username")));
        DATATYPE_MAP.put("modifierTimestamp", (Map<String, Object>)((Object)DataTools.buildMap("type", "string", "format", "datetime", "sample", "2006-01-10T12:22:04-04:00")));
        DATATYPE_MAP.put("creator", (Map<String, Object>)((Object)DataTools.buildMap("type", "string", "sample", "username")));
        DATATYPE_MAP.put("creatorTimestamp", (Map<String, Object>)((Object)DataTools.buildMap("type", "string", "format", "datetime", "sample", "2006-01-10T12:22:04-04:00")));
        DATATYPE_MAP.put("password", (Map<String, Object>)((Object)DataTools.buildMap("type", "string", "sample", "secret")));
        DATATYPE_MAP.put("ntext", (Map<String, Object>)((Object)DataTools.buildMap("type", "string", "sample", "string")));
        DATATYPE_MAP.put("phoneNumber", (Map<String, Object>)((Object)DataTools.buildMap("type", "string", "sample", "520-555-1234")));
    }
}

