/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.transaction.IsolatedWork;
import org.hibernate.engine.transaction.Isolater;
import org.hibernate.exception.JDBCExceptionHelper;

public abstract class TransactionHelper {
    protected abstract Serializable doWorkInCurrentTransaction(Connection var1, String var2) throws SQLException;

    public Serializable doWorkInNewTransaction(final SessionImplementor session) throws HibernateException {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Work
        implements IsolatedWork {
            Serializable generatedValue;

            Work() {
            }

            @Override
            public void doWork(Connection connection) throws HibernateException {
                String sql = null;
                try {
                    this.generatedValue = TransactionHelper.this.doWorkInCurrentTransaction(connection, sql);
                }
                catch (SQLException sqle) {
                    throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not get or update next value", sql);
                }
            }
        }
        Work work = new Work();
        Isolater.doIsolatedWork(work, session);
        return work.generatedValue;
    }
}

