/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.base.Init;
import com.isomorphic.base.InitListener;
import com.isomorphic.base.Reflection;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BaseFilter
implements Filter {
    protected FilterConfig filterConfig;
    protected ServletContext servletContext;
    protected static Config config;
    protected static String webRoot;
    protected Logger log;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.servletContext = filterConfig.getServletContext();
        Init.go(filterConfig.getServletContext(), true);
        config = Config.getGlobal();
        webRoot = config.getPath("webRoot");
        String className = this.getClass().getName();
        String filterName = filterConfig.getFilterName();
        if (filterName == null) {
            filterName = className;
        }
        String logPrefix = null;
        if (!className.endsWith(filterName)) {
            logPrefix = filterName;
        }
        this.log = new Logger(this.getClass().getName(), logPrefix);
        ServletTools.applyConfigToServletOrFilter(this, filterConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        boolean wasIgnored = Logger.threadIgnored();
        boolean mustPopLogContext = false;
        try {
            if (ServletTools.ignoreLog((HttpServletRequest)request)) {
                Logger.ignoreThread();
            }
            boolean hadThreadLocal = RequestContext.getThreadLocal() != null;
            RequestContext requestContext = RequestContext.instance(this.servletContext, request, response);
            if (hadThreadLocal) {
                RequestContext.pushThreadLocal(requestContext);
            }
            mustPopLogContext = ServletTools.pushClientLogContext((HttpServletRequest)request);
            this._doFilter(request, response, chain);
        }
        catch (Throwable e) {
            this.handleError((HttpServletResponse)response, "BaseFilter Global Exception", e);
        }
        finally {
            if (mustPopLogContext && !InitListener.isRegistered) {
                Logger.popContext();
            }
            if (wasIgnored) {
                Logger.observeThread();
            }
            RequestContext.popThreadLocal();
        }
    }

    public void _doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        throw new ServletException("BaseFilter is not for direct use.");
    }

    public void handleError(HttpServletResponse response, Throwable t) {
        this.handleError(response, this.getClass().getName() + " top-level exception", t);
    }

    public void handleError(HttpServletResponse response, String errorMessage, Throwable t) {
        this.log.forceError((Object)errorMessage, Reflection.getRealTargetException(t));
        ServletTools.handleServletError(response, errorMessage, t);
    }

    public void destroy() {
    }
}

