/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.test.tools;

import com.isomorphic.base.Config;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.Operator;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.log.Logger;
import com.isomorphic.tools.DataImport;
import com.isomorphic.tools.SQLImport;
import com.isomorphic.util.ErrorReport;
import java.io.FileReader;
import java.io.Reader;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataImportTests {
    private static Logger log = new Logger(DataImportTests.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DSResponse importToDataSourceCSV() {
        DSResponse dsResponse = new DSResponse();
        long result = 0L;
        String error = null;
        DataSource ds = null;
        String dataSourceName = "tasks";
        try {
            String path = Config.getGlobal().getPath("webRoot") + "/isomorphic/QA/DataImport/";
            FileReader in = new FileReader(path + "dataImportTest.csv");
            DataImport dataImport = new DataImport();
            HashMap<String, String> mapTranslators = new HashMap<String, String>();
            mapTranslators.put("taskId", "com.isomorphic.tools.DataImport.ParseNumber");
            mapTranslators.put("startDate", "com.isomorphic.tools.DataImport.ParseDateTime");
            mapTranslators.put("endDate", "com.isomorphic.tools.DataImport.ParseDateTime");
            result = dataImport.importToDataSource((Reader)in, (Map)null, mapTranslators, dataSourceName);
            if (result != 2L) {
                error = "The saved records in the DataBase are not two as expected";
            } else {
                ds = DataSourceManager.getDataSource((String)dataSourceName, null);
                AdvancedCriteria adCriteria = new AdvancedCriteria((Operator)DefaultOperators.Or, new Criterion[]{new SimpleCriterion("lane", "equals", (Object)"tamaraKane-a1"), new SimpleCriterion("lane", "equals", (Object)"darcyFeeney-a1")});
                List list = ds.fetch((Object)adCriteria);
                if (list.size() != 2) {
                    error = "The fetched records are not two as expected";
                } else {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Map rec = (Map)list.get(0);
                    if (format.parse(rec.get("startDate").toString()).compareTo(format.parse("2012-07-02 10:55:00")) != 0) {
                        error = "startDate(" + rec.get("startDate").toString() + ") not stored in the database as expected(2012-07-02 10:55:00). Rec 1.";
                    } else if (format.parse(rec.get("endDate").toString()).compareTo(format.parse("2012-07-03 11:55:00")) != 0) {
                        error = "endDate(" + rec.get("endDate").toString() + ") not stored in the database as expected(2012-07-03 11:55:00). Rec 1.";
                    } else {
                        rec = (Map)list.get(1);
                        if (format.parse(rec.get("startDate").toString()).compareTo(format.parse("2013-08-02 15:55:00")) != 0) {
                            error = "startDate(" + rec.get("startDate").toString() + ") not stored in the database as expected(2013-08-02 15:55:00). Rec 2.";
                        } else if (format.parse(rec.get("endDate").toString()).compareTo(format.parse("2013-08-05 20:55:00")) != 0) {
                            error = "endDate(" + rec.get("endDate").toString() + ") not stored in the database as expected(2013-08-05 20:55:00). Rec 2.";
                        }
                    }
                    ds.remove(list.get(0));
                    ds.remove(list.get(1));
                }
            }
            if (error != null) {
                dsResponse.setStatus(-1);
                dsResponse.setData((Object)error);
            }
            if (ds == null) return dsResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            dsResponse.setStatus(-1);
            dsResponse.setData((Object)e.getMessage());
            return dsResponse;
        }
        finally {
            if (ds != null) {
                DataSourceManager.freeDataSource(ds);
            }
        }
        DataSourceManager.freeDataSource((DataSource)ds);
        return dsResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DSResponse importToDataSourceJSON() {
        DSResponse dsResponse = new DSResponse();
        long result = 0L;
        String error = null;
        DataSource ds = null;
        String dataSourceName = "supplyItemHB";
        try {
            String path = Config.getGlobal().getPath("webRoot") + "/isomorphic/QA/DataImport/";
            FileReader in = new FileReader(path + "dataImportTest.json");
            DataImport dataImport = new DataImport(DataImport.ImportFormat.JSON, null);
            result = dataImport.importToDataSource((Reader)in, (Map)null, (Map)null, dataSourceName);
            if (result != 2L) {
                error = "The saved records in the DataBase are not two as expected";
            } else {
                ds = DataSourceManager.getDataSource((String)dataSourceName, null);
                AdvancedCriteria adCriteria = new AdvancedCriteria((Operator)DefaultOperators.Or, new Criterion[]{new SimpleCriterion("itemName", "equals", (Object)"Glue UHU Clear Gum 6000ml"), new SimpleCriterion("itemName", "equals", (Object)"Glue UHU Clear Gum 7000ml")});
                List list = ds.fetch((Object)adCriteria);
                if (list.size() != 2) {
                    error = "The fetched records are not two as expected";
                } else {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    Map rec = (Map)list.get(0);
                    if (!rec.get("unitCost").toString().equals("0.69")) {
                        error = "unitCost(" + rec.get("unitCost").toString() + ") not stored in the database as expected(0.69). Rec 1.";
                    } else if (format.parse(rec.get("nextShipment").toString()).compareTo(format.parse("2014-08-02")) != 0) {
                        error = "nextShipment(" + rec.get("nextShipment").toString() + ") not stored in the database as expected(2014-08-02). Rec 1.";
                    } else {
                        rec = (Map)list.get(1);
                        if (!rec.get("unitCost").toString().equals("0.58")) {
                            error = "unitCost(" + rec.get("unitCost").toString() + ") not stored in the database as expected(0.58). Rec 2.";
                        } else if (format.parse(rec.get("nextShipment").toString()).compareTo(format.parse("2014-07-15")) != 0) {
                            error = "nextShipment(" + rec.get("nextShipment").toString() + ") not stored in the database as expected(2014-07-15). Rec 2.";
                        }
                    }
                    ds.remove(list.get(0));
                    ds.remove(list.get(1));
                }
            }
            if (error != null) {
                dsResponse.setStatus(-1);
                dsResponse.setData((Object)error);
            }
            if (ds == null) return dsResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            dsResponse.setStatus(-1);
            dsResponse.setData((Object)e.getMessage());
            return dsResponse;
        }
        finally {
            if (ds != null) {
                DataSourceManager.freeDataSource(ds);
            }
        }
        DataSourceManager.freeDataSource((DataSource)ds);
        return dsResponse;
    }

    public DSResponse importToRowsCSV() throws Exception {
        DSResponse dsResponse = new DSResponse();
        List list = null;
        try {
            String path = Config.getGlobal().getPath("webRoot") + "/isomorphic/QA/DataImport/";
            FileReader in = new FileReader(path + "dataImportTest.csv");
            DataImport dataImport = new DataImport();
            HashMap<String, String> mapTranslators = new HashMap<String, String>();
            mapTranslators.put("taskId", "com.isomorphic.tools.DataImport.ParseNumber");
            mapTranslators.put("startDate", "com.isomorphic.tools.DataImport.ParseDateTime");
            mapTranslators.put("endDate", "com.isomorphic.tools.DataImport.ParseDateTime");
            list = dataImport.importToRows((Reader)in, (Map)null, mapTranslators);
            String error = null;
            if (list.size() == 2) {
                Map rec = (Map)list.get(0);
                if (!(rec.get("taskId") instanceof BigInteger)) {
                    error = "taskId is not a BigInteger.";
                }
                if (!(rec.get("startDate") instanceof Date)) {
                    error = "startDate is not a Date.";
                }
                if (!((rec = (Map)list.get(1)).get("endDate") instanceof Date)) {
                    error = "endDate is not a Date.";
                }
                if (!(rec.get("description") instanceof String)) {
                    error = "description is not a String.";
                }
            } else {
                error = "Records are not two as expected";
            }
            if (error != null) {
                dsResponse.setStatus(-1);
                dsResponse.setData((Object)error);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            dsResponse.setStatus(-1);
            dsResponse.setData((Object)e.getMessage());
        }
        return dsResponse;
    }

    public DSResponse importToRowsCSVDisplayMapped() throws Exception {
        DSResponse dsResponse = new DSResponse();
        List list = null;
        try {
            String path = Config.getGlobal().getPath("webRoot") + "/isomorphic/QA/DataImport/";
            FileReader in = new FileReader(path + "import_widgets.csv");
            DataImport dataImport = new DataImport();
            list = dataImport.importAndValidateDSRows(in, "import_widgets", DataImport.ImportFormat.CSV, ",");
            Map errors = dataImport.getErrors();
            List<ErrorReport> valErrors = dataImport.getValidationErrors();
            String error = null;
            if (list.size() == 10) {
                Map rec = (Map)list.get(0);
                if (!(rec.get("code") instanceof String)) {
                    error = "code is a " + rec.get("code").getClass().getName();
                }
                if (!(rec.get("description") instanceof String)) {
                    error = "description is a " + rec.get("description").getClass().getName();
                }
                if (!(rec.get("price") instanceof Double)) {
                    error = "price is a " + rec.get("price").getClass().getName();
                }
                if (!(rec.get("color") instanceof Long)) {
                    error = "color is a " + rec.get("color").getClass().getName();
                }
                if (!(rec.get("size") instanceof Long)) {
                    error = "size is a " + rec.get("size").getClass().getName();
                }
                if (!"Orange".equals((rec = (Map)list.get(1)).get("color"))) {
                    error = "color not 'Orange':  " + rec.get("color");
                }
                if (!((rec = (Map)list.get(2)).get("size") instanceof Long) || ((Long)rec.get("size")).intValue() != 5) {
                    error = "size is not a Long wrapping 5, it is a " + rec.get("size").getClass().getName() + ", its value is " + rec.get("size");
                }
                if (valErrors.size() != 7) {
                    error = "Expected data validation errors on 7 rows, there are actually " + valErrors.size();
                } else {
                    for (int i = 0; i < valErrors.size(); ++i) {
                        Map valerr = (Map)valErrors.get(i);
                        int rowNum = ((Number)valerr.get("rowNum")).intValue();
                        if (rowNum == 1 || rowNum == 2 || rowNum == 5 || rowNum == 6 || rowNum == 7 || rowNum == 8 || rowNum == 9) continue;
                        error = "Unexpectedly found data validation errors on row " + i;
                        break;
                    }
                }
            } else {
                error = "Expected 10 records, there are actually " + list.size();
            }
            if (error != null) {
                dsResponse.setStatus(-1);
                dsResponse.setData((Object)error);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            dsResponse.setStatus(-1);
            dsResponse.setData((Object)e.getMessage());
        }
        return dsResponse;
    }

    public DSResponse importToRowsCSVDisplayMapped2() throws Exception {
        DSResponse dsResponse = new DSResponse();
        List list = null;
        try {
            String path = Config.getGlobal().getPath("webRoot") + "/isomorphic/QA/DataImport/";
            FileReader in = new FileReader(path + "import_widgets.csv");
            DataImport dataImport = new DataImport();
            list = dataImport.importAndValidateDSRows(in, "import_widgets2", DataImport.ImportFormat.CSV, ",");
            String error = null;
            if (list.size() == 10) {
                for (int i = 0; i < 10; ++i) {
                    String color;
                    Map rec = (Map)list.get(i);
                    String string = color = rec.get("color") == null ? null : rec.get("color").toString();
                    if (color == null || color.equals("Orange") || color.equals("2") || color.equals("-1")) continue;
                    error = "'color' is expected to be -1 for all imported records as hard coded in 'lookUpID' operation (specific operation configured in batchUploadOperationId)";
                    break;
                }
            } else {
                error = "Expected 10 records, there are actually " + list.size();
            }
            if (error != null) {
                dsResponse.setStatus(-1);
                dsResponse.setData((Object)error);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            dsResponse.setStatus(-1);
            dsResponse.setData((Object)e.getMessage());
        }
        return dsResponse;
    }

    public DSResponse importToRowsMapDisplayMapped() throws Exception {
        DSResponse dsResponse = new DSResponse();
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", "W1");
            map.put("color", "green");
            DataImport dataImport = new DataImport();
            Map rec = dataImport.importDataSourceRecord(map, "import_widgets");
            String error = null;
            if (!(rec.get("code") instanceof String)) {
                error = "code is a " + rec.get("code").getClass().getName();
            }
            if (!(rec.get("color") instanceof Integer)) {
                error = "color is a " + rec.get("color").getClass().getName();
            }
            if (error != null) {
                dsResponse.setStatus(-1);
                dsResponse.setData((Object)error);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            dsResponse.setStatus(-1);
            dsResponse.setData((Object)e.getMessage());
        }
        return dsResponse;
    }

    public DSResponse importToRowsJSON() throws Exception {
        DSResponse dsResponse = new DSResponse();
        List list = null;
        try {
            String path = Config.getGlobal().getPath("webRoot") + "/isomorphic/QA/DataImport/";
            FileReader in = new FileReader(path + "dataImportTest.json");
            DataImport dataImport = new DataImport(DataImport.ImportFormat.JSON, null);
            HashMap<String, String> mapTranslators = new HashMap<String, String>();
            mapTranslators.put("unitCost", "com.isomorphic.tools.DataImport.ParseFloat");
            mapTranslators.put("nextShipment", "com.isomorphic.tools.DataImport.ParseDate");
            list = dataImport.importToRows((Reader)in, (Map)null, mapTranslators);
            String error = null;
            if (list.size() != 2) {
                error = "Records are not two as expected";
            }
            if (error != null) {
                dsResponse.setStatus(-1);
                dsResponse.setData((Object)error);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            dsResponse.setStatus(-1);
            dsResponse.setData((Object)e.getMessage());
        }
        return dsResponse;
    }

    public DSResponse checkSQLImportImportDataFromXMLData() throws Exception {
        DataSource ds;
        DSResponse dsResponse = new DSResponse();
        try {
            ds = DataSourceManager.getDataSource((String)"tasks2", null);
        }
        catch (Exception e) {
            throw new Exception("Problem instantiating datasource tasks\n" + e.toString());
        }
        try {
            String error = null;
            boolean resp = SQLImport.importData(ds);
            if (!resp) {
                error = "Test data were not imported successfully!";
            }
            if (error != null) {
                dsResponse.setStatus(-1);
                dsResponse.setData((Object)error);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            dsResponse.setStatus(-1);
            dsResponse.setData((Object)e.getMessage());
        }
        return dsResponse;
    }

    public DSResponse importToRowsCSVWithQuotedDelimiter() throws Exception {
        DSResponse dsResponse = new DSResponse();
        List list = null;
        try {
            String path = Config.getGlobal().getPath("webRoot") + "/isomorphic/QA/DataImport/";
            FileReader in = new FileReader(path + "dataImportTest2.csv");
            DataImport dataImport = new DataImport();
            list = dataImport.importToRows((Reader)in, (Map)null, (Map)null);
            String error = null;
            if (list.size() == 2) {
                String expected = "ListGrid,\",\" field autoSize";
                Map rec = (Map)list.get(0);
                Object actual = rec.get("name");
                if (!expected.equals(actual)) {
                    error = "Delimiter inside quoted string seem to be broken";
                    log.error((Object)("importToRowsCSVWithQuotedDelimiter test failed. Expected value: [[" + expected + "]], but got: [[" + actual + "]]"));
                }
            } else {
                error = "Records are not two as expected";
            }
            if (error != null) {
                dsResponse.setStatus(-1);
                dsResponse.setData((Object)error);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            dsResponse.setStatus(-1);
            dsResponse.setData((Object)e.getMessage());
        }
        return dsResponse;
    }

    public DSResponse importToRowsCSVWithMultilineValues() throws Exception {
        DSResponse dsResponse = new DSResponse();
        List list = null;
        try {
            String path = Config.getGlobal().getPath("webRoot") + "/isomorphic/QA/DataImport/";
            FileReader in = new FileReader(path + "dataImportTest3.csv");
            DataImport dataImport = new DataImport();
            list = dataImport.importToRows((Reader)in, (Map)null, (Map)null);
            String error = null;
            if (list.size() == 2) {
                Object actual;
                Map rec = (Map)list.get(0);
                String newLine = System.getProperty("line.separator");
                String expected = "ListGrid " + newLine + "field " + newLine + "autoSize";
                if (!expected.equals(actual = rec.get("name"))) {
                    error = "Quoted multiline value seem to be broken";
                    log.error((Object)("importToRowsCSVWithMultilineValues test failed. Expected value: [[" + expected + "]], but got: [[" + actual + "]]"));
                }
            } else {
                error = "Records are not two as expected";
            }
            if (error != null) {
                dsResponse.setStatus(-1);
                dsResponse.setData((Object)error);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            dsResponse.setStatus(-1);
            dsResponse.setData((Object)e.getMessage());
        }
        return dsResponse;
    }
}

