/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.Operation;
import com.isomorphic.webdriver.SeleneseTestOptions;
import com.isomorphic.webdriver.SmartClientWebDriver;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.htmlparser.Tag;
import org.htmlparser.util.NodeList;
import org.htmlparser.visitors.NodeVisitor;
import org.openqa.selenium.TimeoutException;

class SeleneseTestCaseParser
extends NodeVisitor {
    private static final String DETAILS_SEPARATOR = "ISC_DEVELOPER_MESSAGES: ";
    private static final String MESSAGES_SEPARATOR = "ISC_SERVER_LOG_MESSAGES: ";
    private SmartClientWebDriver driver;
    private boolean found = false;
    private boolean successful = true;
    private SeleneseTestOptions options;
    private PrintStream output;
    private boolean debug;
    private boolean close;
    private boolean abort;
    private long speed;
    private Date start;
    private Map<String, Object> varMap = new HashMap<String, Object>();

    protected Object storeVariable(String key, Object value, boolean updateJavaScript) {
        if (updateJavaScript) {
            this.driver.storeVariable(key, value);
        }
        return this.varMap.put(key, value);
    }

    public SeleneseTestCaseParser(SmartClientWebDriver driver, String baseUrl, PrintStream output, boolean debug, SeleneseTestOptions options, boolean close) {
        if (driver != null) {
            try {
                this.driver = driver;
                if (baseUrl != null) {
                    driver.setBaseUrl(baseUrl);
                }
                driver.setServerLogMode(options.getServerLogMode());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.successful = false;
            }
        }
        this.options = options;
        this.output = output;
        this.debug = debug;
        this.close = close;
        this.start = new Date();
    }

    public boolean timedOut() {
        if (this.options == null) {
            return false;
        }
        Integer timeout = this.options.getTimeout();
        if (timeout == null) {
            return false;
        }
        Date now = new Date();
        return now.getTime() - this.start.getTime() > (long)(timeout * 1000);
    }

    public void visitTag(Tag tag) {
        NodeList children;
        if (this.abort) {
            return;
        }
        Object result = null;
        Operation operation = null;
        String label = null;
        boolean mapped = true;
        String name = tag.getTagName();
        if ("tr".equalsIgnoreCase(name) && (children = tag.getChildren()).size() == 6) {
            long delay;
            this.found = true;
            try {
                RowVisitor rowVisitor = null;
                rowVisitor = new RowVisitor(this.output);
                children.visitAllNodesWith((NodeVisitor)rowVisitor);
                operation = rowVisitor.getOperation(this);
                if (this.debug) {
                    System.err.println(operation.toString());
                }
                result = operation.execute();
            }
            catch (NoSuchMethodException e) {
                String action = "skipping";
                if (this.output != null && operation != null) {
                    action = "adding a comment and " + action;
                }
                System.err.println("!!! Unable to map a command from the Selenium HTML file - " + action + ".  " + e.getMessage());
                mapped = false;
            }
            catch (Throwable t) {
                Throwable cause;
                if (t instanceof InvocationTargetException && (cause = t.getCause()) != null) {
                    t = cause;
                }
                if (this.output != null && operation != null) {
                    String[] lines;
                    label = "^^^ " + t.getClass().getCanonicalName() + " ^^^";
                    String message = t.getMessage();
                    if (message != null && (lines = message.split("(\r)?\n")).length > 0) {
                        label = label + ": " + lines[0];
                    }
                }
                t.printStackTrace();
                this.successful = false;
            }
            if (operation == null) {
                return;
            }
            if (this.output != null) {
                if (!mapped) {
                    this.output.print("//");
                }
                this.output.println("    " + operation.toJavaString());
                if (operation.getAndWait()) {
                    this.output.println("//    driver.pause(3000L);");
                }
                if (label != null) {
                    this.output.println("//  " + label);
                }
            }
            if (operation.isVerify() || operation.isWaitFor() || operation.isAssert()) {
                if (result == null) {
                    result = Boolean.FALSE;
                }
                boolean bl = this.successful = this.successful && (Boolean)result != false;
                if (result.equals(Boolean.FALSE) && mapped && this.output != null) {
                    this.output.println("//  ^^^ " + operation.getOperator() + " Failed ^^^");
                }
            }
            if (operation.isWaitFor() && !this.successful) {
                this.abort = true;
                return;
            }
            if (this.timedOut()) {
                String status = this.successful ? "no failures" : "failures";
                throw new TimeoutException("Timed out in " + this.options.getTimeout() + " seconds with " + status);
            }
            long l = delay = this.debug ? 5000L : this.speed;
            if (delay > 0L) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean getResult() {
        List<String> messages;
        if (!this.found) {
            System.err.println("!!! No valid selenese found");
        }
        if (this.getSaveMessages() && !(messages = this.driver.getClientLogs()).isEmpty()) {
            System.err.println("ISC_DEVELOPER_MESSAGES: \n" + String.join((CharSequence)"\n", messages));
        }
        if (this.getServerLogMode() != null && !(messages = this.driver.getServerLogs()).isEmpty()) {
            System.err.println("ISC_SERVER_LOG_MESSAGES: \n" + String.join((CharSequence)"\n", messages));
        }
        if (this.driver != null && this.close) {
            this.driver.quit();
        }
        return this.successful && this.found;
    }

    void setSpeed(long speed) {
        this.speed = speed;
    }

    SeleneseTestOptions getOptions() {
        return this.options;
    }

    boolean hasDriver() {
        return this.driver != null;
    }

    SmartClientWebDriver getDriver() {
        return this.driver;
    }

    boolean getAdvancedVars() {
        return this.options != null ? this.options.getAdvancedVars() : false;
    }

    private boolean getSaveMessages() {
        return this.options != null ? this.options.getSaveMessages() : false;
    }

    private String getServerLogMode() {
        return this.options != null ? this.options.getServerLogMode() : null;
    }

    private String getMappedVarRegEx(boolean targetJavaScript) {
        if (this.varMap.size() == 0) {
            return null;
        }
        String prefix = targetJavaScript ? "(?!=[A-Za-z_])storedVars\\[(?:\"|'|\\\\\")(" : "\\$\\{(";
        String suffix = targetJavaScript ? ")(?:\"|'|\\\\\")\\]" : ")\\}";
        StringBuffer regex = new StringBuffer();
        for (String scriptVar : this.varMap.keySet()) {
            regex.append(regex.length() > 0 ? "|" : prefix);
            regex.append(scriptVar);
        }
        return regex.append(suffix).toString();
    }

    Object expandVariables(String operand, boolean targetJavaScript) {
        String expanded;
        String regex;
        if (this.getAdvancedVars()) {
            targetJavaScript = false;
        }
        if ((regex = this.getMappedVarRegEx(targetJavaScript)) == null) {
            return operand;
        }
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(operand);
        StringBuffer result = new StringBuffer();
        int end = 0;
        while (m.find()) {
            int start = m.start();
            if (end < start) {
                result.append(operand.substring(end, start));
            }
            end = m.end();
            String key = operand.substring(start, end).replaceFirst(regex, "$1");
            Object value = this.varMap.get(key);
            value = targetJavaScript && value instanceof String ? "\"" + ((String)value).replace("\"", "\\\"") + "\"" : String.valueOf(value);
            result.append(value);
        }
        if (end < operand.length()) {
            result.append(operand.substring(end));
        }
        return Operation.isLong(expanded = result.toString()) ? Long.valueOf(Long.parseLong(expanded)) : expanded;
    }

    String replaceVarsWithJava(String operand, boolean targetJavaScript) {
        String regex;
        if (this.getAdvancedVars()) {
            targetJavaScript = false;
        }
        if ((regex = this.getMappedVarRegEx(targetJavaScript)) == null) {
            return operand;
        }
        return operand.replaceAll(regex, "\" + $1 + \"").replaceAll("(\\s)*\\+(\\s)*\"\"((\\s)*$)?", "");
    }

    private static class RowVisitor
    extends NodeVisitor {
        private int col = 0;
        private String operator;
        private String operand1;
        private String operand2;

        public RowVisitor(PrintStream output) {
        }

        public void reset() {
            this.col = 0;
        }

        public Operation getOperation(SeleneseTestCaseParser parser) {
            return new Operation(this.operator, this.operand1, this.operand2, parser);
        }

        public void visitTag(Tag tag) {
            String name = tag.getTagName();
            if ("td".equalsIgnoreCase(name)) {
                if (this.col == 0) {
                    this.operator = tag.getChildren().asString();
                    ++this.col;
                } else if (this.col == 1) {
                    if (tag.getChildren() != null) {
                        this.operand1 = tag.getChildren().asString();
                        this.operand1 = StringEscapeUtils.unescapeHtml((String)this.operand1);
                    } else {
                        this.operand1 = null;
                    }
                    ++this.col;
                } else if (this.col == 2) {
                    if (tag.getChildren() != null) {
                        this.operand2 = tag.getChildren().asString();
                        this.operand2 = StringEscapeUtils.unescapeHtml((String)this.operand2);
                    } else {
                        this.operand2 = null;
                    }
                    this.reset();
                }
            }
        }
    }
}

