/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples.server.ormDataSource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.examples.Country;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;

public class ORMDataSource
extends BasicDataSource {
    private static Configuration hibernateConfig = null;
    private static SessionFactory sessionFactory = null;

    public DSResponse executeAdd(DSRequest req) throws Exception {
        Map createdRecord = this.createRecord(req.getValues());
        return new DSResponse((DataSource)this, (Object)createdRecord);
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        List records = this.fetchRecords(req.getCriteria());
        return new DSResponse((DataSource)this, (Object)records);
    }

    public DSResponse executeRemove(DSRequest req) throws Exception {
        Map removedRecord = this.removeRecord(req.getValues().get(this.getPrimaryKey()));
        return new DSResponse((DataSource)this, (Object)removedRecord);
    }

    public DSResponse executeUpdate(DSRequest req) throws Exception {
        Map updatedRecord = this.updateRecord(req.getValues());
        return new DSResponse((DataSource)this, (Object)updatedRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map createRecord(Map values) {
        Country record = new Country();
        this.setProperties(values, record);
        Session ses = null;
        Transaction tx = null;
        try {
            ses = ORMDataSource.getSession();
            tx = ses.beginTransaction();
            ses.saveOrUpdate((Object)record);
            tx.commit();
            Map map = this.getProperties(record);
            return map;
        }
        finally {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            if (ses != null) {
                ses.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List fetchRecords(Map criteria) {
        Session ses = null;
        Transaction tx = null;
        try {
            ses = ORMDataSource.getSession();
            tx = ses.beginTransaction();
            Query q = ses.createQuery("from com.isomorphic.examples.Country");
            List records = q.list();
            tx.commit();
            List list = records;
            return list;
        }
        finally {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            if (ses != null) {
                ses.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map removeRecord(Object id) {
        Session ses = null;
        Transaction tx = null;
        try {
            ses = ORMDataSource.getSession();
            tx = ses.beginTransaction();
            Object record = ses.get(Country.class, (Serializable)id);
            ses.delete(record);
            tx.commit();
            Map map = this.getProperties(record);
            return map;
        }
        finally {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            if (ses != null) {
                ses.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map updateRecord(Map values) {
        Object id = values.get(this.getPrimaryKey());
        Session ses = null;
        Transaction tx = null;
        try {
            ses = ORMDataSource.getSession();
            tx = ses.beginTransaction();
            Object record = ses.get(Country.class, (Serializable)id);
            this.setProperties(values, record);
            ses.saveOrUpdate(record);
            tx.commit();
            Map map = this.getProperties(record);
            return map;
        }
        finally {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            if (ses != null) {
                ses.close();
            }
        }
    }

    private static synchronized Session getSession() {
        if (sessionFactory == null) {
            hibernateConfig = new Configuration();
            sessionFactory = hibernateConfig.configure().buildSessionFactory();
        }
        return sessionFactory.openSession();
    }
}

