<% 
%>
<%@ taglib uri="http://www.smartclient.com/taglib" prefix="isomorphic" %>
<%@ page import="com.isomorphic.base.*" %>
<%@ page import="com.isomorphic.rpc.*" %>
<%@ page import="com.isomorphic.auth.*" %>
<%@ page import="com.isomorphic.site.*" %>
<%@ page import="com.isomorphic.servlet.*" %>
<%@ page import="java.util.*" %>
<%
boolean hasDevRecord = false;
String email = null, username = null, organization = null, orgUrlFrag = null;
RequestContext requestContext = RequestContext.instance(this, request, response, out);
Map user = DevCenter.getUserRecordForOutputToBrowser(requestContext);
if (user != null) {
   email        = (String)user.get("email");
   username     = (String)user.get("username");
   organization = (String)user.get("organization");
   orgUrlFrag   = (String)user.get("orgUrlFragment");
   hasDevRecord = user.get("firstname")!=null;
}
Integer sessionTimeout = DevCenter.getSessionTimeout();
%>
<%!
    private Config baseConfig;
    private boolean allowAnyRPC = false;
    private final Set enabledBuiltinMethods = new HashSet();
    private boolean useIDACall = false;

    private final boolean isBuiltinMethodEnabled(String methodName) {
        return (allowAnyRPC || enabledBuiltinMethods.contains(methodName));
    }

    private final boolean isPrefixEnabled(String methodName, String prefix) {
        try {
            BuiltinRPC.validateFileDir(prefix, methodName);
        } catch (Exception nope) {
            return false;
        }
        return true; 
    }
%>

<%
    // Lets get the path of the current page and replace index.jsp with hostedOperations.jsp
    final String hostedOperationsPath = request.getRequestURI().replace("/index.jsp", "/hostedOperations.jsp");
    // Now we can fetch the hostedOperations.jsp resource, if null it's not there.
    final boolean hostedOperationsDoesNotExist = application.getResource(hostedOperationsPath) == null;

    ISCInit.go(getClass().getName());
    baseConfig = Config.getGlobal();

    String isomorphicURI = (String)request.getAttribute("isomorphicURI");
    if (isomorphicURI == null) isomorphicURI = "../../isomorphic/";
    String vbRootURL = isomorphicURI+"../tools/visualBuilder/";

    enabledBuiltinMethods.addAll(baseConfig.getList("RPCManager.enabledBuiltinMethods"));
    allowAnyRPC = enabledBuiltinMethods.contains("*");

    useIDACall = baseConfig.getBoolean("VisualBuilder.useIDACall", false) || hostedOperationsDoesNotExist;

    // if currentScreen param has been provided, it will override normal screen selection logic
    final String initialScreen = request.getParameter("currentScreen");

    // If the mockups param is present, and is anything but "0" or (case-insensitive) "no", then
    // consider it be a request to run VB in Mockup Mode
    String mockups = request.getParameter("mockups");
    final boolean mockupMode = mockups != null && !"0".equals(mockups) && 
                                       !"no".equalsIgnoreCase(mockups);

    final String title = (mockupMode ? "SmartMockups" : "Reify | Make Ideas Real");
%>
<!DOCTYPE html>
<HTML>
<HEAD>
<TITLE><%=title%></TITLE>
<link href="/favicon.ico?isc_version=v12.1p_2025-10-14.ico" rel="shortcut icon" type="image/x-icon" />
<LINK REL=StyleSheet HREF="<%=vbRootURL%>visualBuilder.css?isc_version=v12.1p_2025-10-14.css" TYPE="text/css">

<!--CSS for loading message at application start-->
<STYLE type="text/css">
    html, body { overflow:hidden }
    #loadingWrapper {
        position: absolute;
        top: 40%;
        width: 100%;
        text-align: center;
        z-index: 900001;
    }
    #loading {
        margin: 0 auto;
        border: 1px solid #ccc;
        width: 180px;
        padding: 2px;
        text-align: left;
    }
    #loading a {
        color: #225588;
    }
    #loading .loadingIndicator {
        background: white;
        font: bold 13px tahoma, arial, helvetica;
        padding: 10px 5px 10px 10px;
        margin: 0;
        height: auto;
        color: #444;
    }
     #loadingMsg {
        font: normal 10px arial, tahoma, sans-serif;
    }
</STYLE>

</HEAD>
<BODY STYLE="overflow:hidden">

<!--add loading indicator while the app is being loaded-->
<div id="loadingWrapper">
<div id="loading">
    <div class="loadingIndicator">
        <img src="/tools/visualBuilder/graphics/reifyLoading.gif" width="32" height="32"
             style="margin-right:8px;float:left;vertical-align:top;"/>
        <div id="reifyProductName">Reify</div>
        <div id="loadingMsg">Loading Core API...</div>
    </div>
</div>
</div>


<!-- these lightbox divs need to be at top level or they fail to position above all page content -->

<div id="light_databindingV2" style="display:none;">
    <a class="boxclose_databindingV2" id="boxclose_databindingV2" onclick="lightbox_close('databindingV2');"></a>
    <video id="databindingV2" preload="none" controls>
        <source src="https://www.smartclient.com/media/databindingV2.mp4" type="video/mp4">
    </video>
</div>
<div id="fade_databindingV2" style="display:none;" onClick="lightbox_close('databindingV2');"></div>
<div id="light_reifyIntroLayoutsV2" style="display:none;">
    <a class="boxclose_reifyIntroLayoutsV2" id="boxclose_reifyIntroLayoutsV2" 
        onclick="lightbox_close('reifyIntroLayoutsV2');"></a>
    <video id="reifyIntroLayoutsV2" preload="none"  controls>
        <source src="https://www.smartclient.com/media/reifyIntroLayoutsV2.mp4" type="video/mp4">
    </video>
</div>
<div id="fade_reifyIntroLayoutsV2" style="display:none;" onClick="lightbox_close('reifyIntroLayoutsV2');"></div>
<div id="light_video" style="display:none;">
    <video id="video" controls preload="none" muted="muted">
        <source src="https://www.smartclient.com/media/ReifyBriefIntroV3.mp4" type="video/mp4">
    </video>
</div>
<div id="fade_video" style="display:none;" onClick="lightbox_close_reify_brief_intro('video');"></div> 


<script>
vbRootURL = "<%=vbRootURL%>";
</script>
<%
String skin = request.getParameter("skin");
if (skin == null || "".equals(skin)) skin = "Tahoe";

String nSkin = request.getParameter("useNativeSkin");
boolean useNativeSkin = nSkin == null || "1".equals(nSkin);

String modules = "AdminConsole,Tools,DocViewer,FileBrowser,Drawing,Workflow";
//>Charts
modules += ",Charts";
//<Charts
//>Analytics
modules += ",Analytics";
//<Analytics
//>RealtimeMessaging
modules += ",RealtimeMessaging";
//<RealtimeMessaging
//>PowerFeatures
if (modules.indexOf("Analytics") < 0) modules += ",?Analytics";
//<PowerFeatures
%>

<SCRIPT>
// Report Framework API, documentation, and skin loading phases by hooking moduleLoaded event.
// Note that this approach means table is order dependent, as each module reports what's next.
(function showLoadingPhases() {
    var msgs = {
        Core: "UI Components",
        Forms: "Data API",
        DataBinding: "Calendar UI",
//>RealtimeMessaging
        DataBinding: "messaging",
        RealtimeMessaging: "Calendar UI",
//<RealtimeMessaging
        Calendar: "plugin support",
        PluginBridges: "drawing",
        Drawing: "tools",
//>Analytics
        Drawing: "analytics",
        Analytics: "tools",
//<Analytics
        Tools: "doc data",
        DocViewer: "Admin Tools",
        AdminConsole: "skins & styles"
    };
//>Charts
    msgs.Charts = msgs.Drawing, delete msgs.Drawing;
//<Charts
    
    window._isc_moduleLoadedHook = function (target,info) {
        var loadingMsg = msgs[info.moduleName];
        if (loadingMsg) {
            document.getElementById('loadingMsg').innerHTML = 'Loading ' + loadingMsg + '...';
        }
    }
})();
</SCRIPT>

<!-- load Isomorphic SmartClient -->
<isomorphic:loadISC isomorphicURI="<%=isomorphicURI%>" modulesDir="system/modules/" skin="<%=skin%>" includeModules="<%=modules%>"/>
<SCRIPT>

isc.nativeSkin = <%=useNativeSkin%>;

isc.isVisualBuilderSDK = true;
isc.Page.setAppImgDir(vbRootURL+"graphics/");
isc.Page.leaveScrollbarGap = false;
isc.Dialog.addClassProperties({
    loadingImageSrc: "reifyLoading.gif"
});
</SCRIPT>

<!-- Additional ToolSkin to apply to Tools controls -->
<SCRIPT>document.getElementById('loadingMsg').innerHTML = 'Loading tool skins...';</SCRIPT>
<%if (useNativeSkin) {%>
<SCRIPT src="<%=isomorphicURI%>skins/ToolSkinNative/load_skin.js?isc_version=v12.1p_2025-10-14.js"></SCRIPT>
<%} else {%>
<SCRIPT src="<%=isomorphicURI%>skins/ToolSkin/load_skin.js?isc_version=v12.1p_2025-10-14.js"></SCRIPT>
<%}%>

<!-- load application logic -->
<SCRIPT>document.getElementById('loadingMsg').innerHTML = 'Loading app...';</SCRIPT>
<isomorphic:loadModules isomorphicURI="<%=isomorphicURI%>" modulesDir="system/modules/" modules="VisualBuilder,SalesForce"/>

<SCRIPT>document.getElementById('loadingMsg').innerHTML = 'Loading datasources...';</SCRIPT>
<isomorphic:loadModules isomorphicURI="<%=isomorphicURI%>" modulesDir="system/modules/" modules="SystemSchema"/>

<script src="/assembled/hostedDataSources.js?isc_version=v12.1p_2025-10-14.js"></script>

<script>
    <isomorphic:loadDS ID = "userSkin,registeredDevelopers,managedUsers"></isomorphic:loadDS>
</script>

<%
%>
<SCRIPT>
isc.defineClass("JSDoc");
isc.jsdoc = isc.JSDoc;
isc.JSDoc.addClassProperties({
    hasData : function () { return false; }
});
</SCRIPT>
<isomorphic:loadModules isomorphicURI="<%=isomorphicURI%>" modulesDir="system/modules/" modules="ReferenceDocs" defer="true"/>
        
<script>
isc.Authentication.logOutURL = "/devlogin/logout.jsp";
// rely on code in reloginFlow.js to build the LoginWindow - it's now configurable in skins
</script>

<SCRIPT>var screenConfiguration = null;</SCRIPT>
<%if (initialScreen == null) {%>
<SCRIPT>var screenConfiguration;</SCRIPT>
<%} else {%>
<SCRIPT>var screenConfiguration = {initialScreen: "<%=initialScreen%>"};</SCRIPT>
<%}%>
<SCRIPT>

var fontIncrease = isc.getParams().fontIncrease;
if (fontIncrease == null) fontIncrease = 0;// 3;
fontIncrease = parseInt(fontIncrease);
isc.Canvas.resizeFonts(fontIncrease);
isc.Canvas.resizePadding(fontIncrease);

var sizeIncrease = isc.getParams().sizeIncrease;
if (sizeIncrease == null) sizeIncrease = 0;// 10;
sizeIncrease = parseInt(sizeIncrease); 
isc.Canvas.resizeControls(sizeIncrease);    

var allowScreenCodeEditing = isc.getParamBooleanValue("allowEditing");
var enableRelationEditor   = isc.getParamBooleanValue("enableRelationEditor", true);
var ignoreProgramErrors    = isc.getParamBooleanValue("ignoreProgramErrors");
var ignoreServerCommLoss   = isc.getParamBooleanValue("ignoreServerCommLoss");

var useIDACall = <%= useIDACall %>;
window.builder = isc.VisualBuilder.create({
    hostedMode: true,
    width: "100%",
    height: "100%",
    autoDraw: true,
    email:        <% requestContext.jsTrans.toJS(email, out); %>,
    userId:       <% requestContext.jsTrans.toJS(username, out); %>,
    organization: <% requestContext.jsTrans.toJS(organization, out); %>,
    orgUrlFrag:   <% requestContext.jsTrans.toJS(orgUrlFrag, out); %>,
    hasDevRecord: <% requestContext.jsTrans.toJS(hasDevRecord, out); %>,

    saveFileBuiltinIsEnabled: !useIDACall || <%= isBuiltinMethodEnabled("saveFile") && isPrefixEnabled("[TOOLS]", "saveFile") %>,
    loadFileBuiltinIsEnabled: !useIDACall || <%= isBuiltinMethodEnabled("loadFile") %>,
    filesystemDataSourceEnabled: !useIDACall || <%= baseConfig.getBoolean("FilesystemDataSource.enabled", false) %>,

    signOutURL: isc.Auth.logOutURL,

	skin: "<%=skin%>",
    defaultApplicationMode: "edit",
    showModeSwitcher: true,
    mockupMode: <%=mockupMode%>,
    projectRunnerURL: vbRootURL+"hostedProjectRunner.jsp",
    projectRunnerRunBaseURL: (location.origin+"").replace("create", "run")+"/",
    projectRunnerShareBaseURL: (location.origin+"").replace("create", "share")+"/",
    dsWizardsFile: vbRootURL+"hostedDataSourceWizards.xml?isc_version=v12.1p_2025-10-14.xml",
    deploymentConsoleURL: vbRootURL+"deploymentConsole.jsp",
    useMenuForDSWizardPicker: true,

    
    offerImmediateBinding: true,
    immediateBindingNewDSWizardName: "basicFields",

    keepUndoLog: true,
    addScreenSaveReasonFromUndoLog: true,

    sessionTimeout: <%=sessionTimeout%>,

    allowScreenCodeEditing: allowScreenCodeEditing,
    enableRelationEditor: enableRelationEditor,
    cleanupRelationsOnDataSourceRemove: true,

    ignoreProgramErrors: ignoreProgramErrors,
    ignoreServerCommLoss: ignoreServerCommLoss,

    defaultComponentsURL: vbRootURL+"defaultComponents.xml?isc_version=v12.1p_2025-10-14.xml",
    defaultMockupComponentsURL: vbRootURL+"defaultMockupComponents.xml?isc_version=v12.1p_2025-10-14.xml",
    customComponentsURL: vbRootURL+"customComponents.xml?isc_version=v12.1p_2025-10-14.xml",
    globalDependenciesURL: vbRootURL+"globalDependencies.xml?isc_version=v12.1p_2025-10-14.xml",
    defaultSettingsURL: vbRootURL+"default.vb.settings.xml?isc_version=v12.1p_2025-10-14.xml",
    defaultProjectURL: vbRootURL+"default.proj.xml?isc_version=v12.1p_2025-10-14.xml",

    // provide an initial top-level VLayout that is appropriate for a fullscreen app:
    // take up whole browser, never overflow
    initialComponent: {
        type: "DataView",
        defaults: {
            overflow: "hidden",
            width: "100%",
            height: "100%",
            // this is enough to make it obvious that a badly scrunched component
            // such as a ListGrid is actually a scrunched ListGrid and not just a
            // 1px black line (which happens with the default minMemberSize of 1)
            minMemberLength: 18
        }
    }
}, screenConfiguration);

// simplify check for Reify from Developer Console
window.hostedMode = true;

<% if (request.getParameter("mockup") != null) { %>
var mockupParam = '<% out.write(request.getParameter("mockup")); %>';
<% } else { %>
var mockupParam = "";
<% } %>

if (mockupParam != "") {
    window.builder.loadBMMLMockup(mockupParam);
}

</SCRIPT>
<script>
    
function showVideoReifyBriefIntro(userName) {
    var name = userName+"=",
        value = false;
    var decodedCookie = decodeURIComponent(document.cookie);
    var ca = decodedCookie.split(';');
    for(var i = 0; i <ca.length; i++) {
        var c = ca[i].trim();
        if (c.indexOf(name) == 0) {
            value = true;
            break;
        }
    }
    return value;
} 
function lightbox_open_reify_brief_intro(video) {
    window.document.onkeydown = function(e) {
        if (!e) {
            e = event;
        }
        if (e.keyCode == 27) {
            lightbox_close_reify_brief_intro('video');
        }
    }
    var lightBoxVideo = document.getElementById(video);
    window.scrollTo(0, 0);
    document.getElementById('video').width = lightBoxVideo.width = document.documentElement.clientWidth*0.6666;
    document.getElementById('video').height = lightBoxVideo.height = document.documentElement.clientHeight*0.6666;
    document.getElementById('light_'+video).style.display = 'block';
    document.getElementById('fade_'+video).style.display = 'block';
    lightBoxVideo.play();
}
function lightbox_close_reify_brief_intro(video) {
    if (video == null) return;
    var lightBoxVideo = document.getElementById(video);
    document.getElementById('light_'+video).style.display = 'none';
    document.getElementById('fade_'+video).style.display = 'none';
    lightBoxVideo.pause();
    // set the corresponding cookie
    var exdate = new Date();
    exdate.setDate(exdate.getDate() + 365);
    document.cookie = "<%=username%>=true;path=/;expires="+exdate.toUTCString();
    window.document.onkeydown = null;
}
if (!showVideoReifyBriefIntro('<%=username%>')) {
   lightbox_open_reify_brief_intro('video');
}

</script>
</BODY>
</HTML>
