/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.base.Config;
import com.isomorphic.base.IScriptSource;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.ReflectionArgument;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.interfaces.ICDIBeanManager;
import com.isomorphic.interfaces.ISpringBeanFactory;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.BuiltinRPC;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCRequest;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.rpc.ServerObject;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class RPCDMI
implements IScriptSource {
    private static Logger log = new Logger(RPCDMI.class.getName());
    private static Config config = Config.getGlobal();
    RPCRequest rpcRequest;
    RPCManager rpc;
    RequestContext context;

    public static RPCResponse execute(RPCRequest rpcRequest, RPCManager rpc, RequestContext context) throws Exception {
        return RPCDMI.execute(rpcRequest, rpc, context, false);
    }

    public static RPCResponse execute(RPCRequest rpcRequest, RPCManager rpc, RequestContext context, boolean allowAnyRPC) throws Exception {
        return new RPCDMI(rpcRequest, rpc, context).execute(allowAnyRPC);
    }

    public static boolean isDMIRequest(RPCRequest rpcRequest) {
        Map data = (Map)rpcRequest.getData();
        return data != null && data.get("is_ISC_RPC_DMI") != null;
    }

    public RPCDMI(RPCRequest rpcRequest, RPCManager rpc, RequestContext context) {
        this.rpcRequest = rpcRequest;
        this.rpc = rpc;
        this.context = context;
    }

    private RPCResponse execute() throws Exception {
        return this.execute(false);
    }

    private RPCResponse execute(boolean allowAnyRPC) throws Exception {
        Map data = (Map)this.rpcRequest.getData();
        if (data == null) {
            throw new Exception("Attempt to execute RPCDMI with null data");
        }
        String appID = this.rpcRequest.getAppID();
        String className = this.rpcRequest.getServerObjectID();
        String methodName = this.rpcRequest.getMethodName();
        List arguments = this.rpcRequest.getMethodArguments();
        Map appConfig = RPCDMI.loadAppConfig(appID);
        List rpcBindings = (List)appConfig.get("rpcBindings");
        if (rpcBindings == null) {
            throw new Exception(DataTools.escapeHTML(appID) + ".app.xml does not define any rpcBindings - please add an rpcBindings section to the file");
        }
        Map serverObjectConfig = null;
        for (Map rpcBinding : rpcBindings) {
            String soID = (String)rpcBinding.get("ID");
            String soClassName = (String)rpcBinding.get("className");
            if ((soID == null || !soID.equals(className)) && (soClassName == null || !soClassName.equals(className))) continue;
            serverObjectConfig = rpcBinding;
            break;
        }
        if (serverObjectConfig == null) {
            throw new Exception(DataTools.escapeHTML(appID) + ".app.xml: the rpcBindings section does not contain a serverObjectConfig with ID|className=\"" + DataTools.escapeHTML(className) + "\".");
        }
        List visibleMethods = (List)serverObjectConfig.get("visibleMethods");
        if (visibleMethods == null) {
            throw new Exception(DataTools.escapeHTML(appID) + ".app.xml: serverObjectConfig definition with ID|className=\"" + DataTools.escapeHTML(className) + " does not have a visibleMethods block defined - if you intend for this method (" + DataTools.escapeHTML(methodName) + ") to be visible, please add it to a visibleMethods block");
        }
        if ("isc_builtin".equals(appID) && !allowAnyRPC) {
            RPCDMI.verifyMethodEnabled(methodName);
        }
        if (methodName == null) {
            throw new Exception("Method name was not specified in RPC DMI call to \"" + DataTools.escapeHTML(className) + "\" in " + DataTools.escapeHTML(appID) + ".app.xml");
        }
        boolean methodIsVisible = false;
        String scriptArgs = null;
        String scriptLanguage = null;
        String script = null;
        for (Map method : visibleMethods) {
            String name = (String)method.get("name");
            if (!methodName.equals(name) && !name.equals("*")) continue;
            methodIsVisible = true;
            scriptArgs = (String)method.get("args");
            scriptLanguage = (String)method.get("language");
            script = (String)method.get("script");
            break;
        }
        if (!methodIsVisible) {
            throw new Exception("Method: " + DataTools.escapeHTML(methodName) + " called on serverObjectConfig ID|className=\"" + DataTools.escapeHTML(className) + "\" cannot be executed because it is not listed in the visibleMethods block.");
        }
        Object returnValue = null;
        Class<?> returnValueClass = null;
        if (script != null) {
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            boolean supportsFullJavaReflection = config.getBoolean((Object)("scripting." + scriptLanguage.toLowerCase() + ".supportsFullJavaReflection"), true);
            if (supportsFullJavaReflection) {
                bindings.put("rpcRequest", this.rpcRequest);
                if (this.context != null) {
                    bindings.put("requestContext", this.context);
                    bindings.put("request", (Object)this.context.request);
                    bindings.put("response", this.context.response);
                    bindings.put("servletContext", this.context.servletContext);
                    if (InterfaceProvider.exists("ISpringBeanFactory", false)) {
                        try {
                            ISpringBeanFactory beanFactory = (ISpringBeanFactory)InterfaceProvider.load("ISpringBeanFactory");
                            if (beanFactory != null) {
                                bindings.put("beanFactory", beanFactory.getBeanFactory(this.context.servletContext));
                                bindings.put("applicationContext", beanFactory.getBeanFactory(this.context.servletContext));
                            }
                        }
                        catch (Exception beanFactory) {
                            // empty catch block
                        }
                    }
                    if (InterfaceProvider.exists("ICDIBeanManager", false)) {
                        try {
                            ICDIBeanManager beanManager = (ICDIBeanManager)InterfaceProvider.load("ICDIBeanManager");
                            if (beanManager != null) {
                                bindings.put("cdiBeanManager", beanManager.getBeanManager());
                            }
                        }
                        catch (Exception beanManager) {
                            // empty catch block
                        }
                    }
                }
                if (this.rpc != null) {
                    bindings.put("rpc", this.rpc);
                    bindings.put("rpcManager", this.rpc);
                }
                bindings.put("log", log);
            }
            if (arguments != null && scriptArgs != null) {
                List<String> argNames = DataTools.simpleSplit(scriptArgs, ",");
                Iterator i = arguments.iterator();
                Iterator<String> j = argNames.iterator();
                while (i.hasNext() && j.hasNext()) {
                    Object arg = i.next();
                    String argName = j.next().trim();
                    bindings.put(argName, arg);
                }
            }
            DataTypeMap<String, Object> params = new DataTypeMap<String, Object>();
            params.put("engineName", scriptLanguage);
            params.put("script", script);
            params.put("bindings", bindings);
            params.put("scriptSource", this);
            RPCResponse rpcResponse = BuiltinRPC.evalServerScript(params);
            Map result = (Map)rpcResponse.getData();
            returnValue = result.get("evalResult");
            returnValueClass = returnValue == null ? null : returnValue.getClass();
        } else {
            ReflectionArgument[] factoryOptionalArgs = new ReflectionArgument[]{new ReflectionArgument(RPCManager.class, (Object)this.rpc, false, false), new ReflectionArgument(RPCRequest.class, (Object)this.rpcRequest, false, false)};
            ServerObject serverObject = new ServerObject(serverObjectConfig, this.context, factoryOptionalArgs, "");
            Class serverObjectClass = serverObject._getClass();
            Method method = serverObject.getMethod(methodName);
            Object serverObjectInstance = serverObject.getInstance(method);
            HttpSession session = null;
            if (Reflection.methodTakesArgType(method, HttpSession.class)) {
                session = this.context.request.getSession(true);
            }
            ArrayList<ReflectionArgument> optionalArgsList = new ArrayList<ReflectionArgument>();
            optionalArgsList.add(new ReflectionArgument(RequestContext.class, (Object)this.context, false, false));
            optionalArgsList.add(new ReflectionArgument(HttpServletRequest.class, (Object)(this.context != null ? this.context.request : null), false, false));
            optionalArgsList.add(new ReflectionArgument(HttpServletResponse.class, (Object)(this.context != null ? this.context.response : null), false, false));
            optionalArgsList.add(new ReflectionArgument(ServletContext.class, (Object)(this.context != null ? this.context.servletContext : null), false, false));
            if (InterfaceProvider.exists("ISpringBeanFactory", false)) {
                try {
                    ISpringBeanFactory beanFactoryIndirect = (ISpringBeanFactory)InterfaceProvider.load("ISpringBeanFactory");
                    if (beanFactoryIndirect != null && this.context != null) {
                        optionalArgsList.add(new ReflectionArgument("org.springframework.beans.factory.BeanFactory", beanFactoryIndirect.getBeanFactory(this.context.servletContext), false, false));
                        optionalArgsList.add(new ReflectionArgument("org.springframework.context.ApplicationContext", beanFactoryIndirect.getBeanFactory(this.context.servletContext), false, false));
                    }
                }
                catch (Throwable beanFactoryIndirect) {
                    // empty catch block
                }
            }
            optionalArgsList.add(new ReflectionArgument(HttpSession.class, (Object)session, false, false));
            optionalArgsList.add(new ReflectionArgument(RPCManager.class, (Object)this.rpc, false, false));
            optionalArgsList.add(new ReflectionArgument(RPCRequest.class, (Object)this.rpcRequest, false, false));
            optionalArgsList.add(new ReflectionArgument(Logger.class, (Object)log, false, false));
            ReflectionArgument[] optionalArgs = new ReflectionArgument[optionalArgsList.size()];
            for (int i = 0; i < optionalArgs.length; ++i) {
                optionalArgs[i] = (ReflectionArgument)optionalArgsList.get(i);
            }
            ReflectionArgument[] requiredArgs = new ReflectionArgument[arguments.size()];
            for (int i = 0; i < requiredArgs.length; ++i) {
                Object arg = arguments.get(i);
                requiredArgs[i] = new ReflectionArgument(arg == null ? null : arg.getClass(), arg);
            }
            try {
                returnValue = Reflection.adaptArgsAndInvoke(serverObjectInstance, method, requiredArgs, optionalArgs);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                log.debug((Object)"Invocation threw exception", t);
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                log.error((Object)"Invocation threw exception", t);
                Exception x = new Exception("RPCDMI infocation threw a: " + t.getClass().getName() + " with error: " + t.getMessage());
                throw x;
            }
            returnValueClass = method.getReturnType();
        }
        RPCResponse rpcResponse = null;
        if (returnValueClass != null && RPCResponse.class.isAssignableFrom(returnValueClass)) {
            log.debug("rpc returned RPCResponse");
            rpcResponse = (RPCResponse)returnValue;
        } else {
            log.debug("rpc returned data");
            rpcResponse = new RPCResponse();
            rpcResponse.setData(returnValue);
            rpcResponse.setStatus(0);
        }
        Object _data = rpcResponse.getData();
        if (_data != null && "jdk.nashorn.api.scripting.ScriptObjectMirror".equals(_data.getClass().getName()) && ((Boolean)Reflection.invokeMethod(_data, "isArray")).booleanValue()) {
            rpcResponse.setData(Reflection.invokeMethod(_data, "values"));
        }
        return rpcResponse;
    }

    public static Map loadAppConfig(String appID) throws Exception {
        if (appID == null) {
            throw new Exception("No appID passed, unable to lookup appConfig");
        }
        Map appConfig = null;
        if (appID.equals("isc_builtin")) {
            ISCFile builtinAppConfigFile = RPCDMI.getAppFile(appID);
            if (!builtinAppConfigFile.exists()) {
                throw new Exception("Unable to locate " + DataTools.escapeHTML(appID) + ".app.xml - check to make sure it's available in the CLASSPATH");
            }
            appConfig = (Map)XML.loadCacheableDSRecords(builtinAppConfigFile);
        } else {
            appConfig = (Map)DataStructCache.getInstance(appID, "apps", "App");
            if (appConfig == null) {
                log.warn("Unable to locate " + DataTools.escapeHTML(appID) + ".app.xml - check to make sure it's available in " + config.getString("project.apps"));
                throw new Exception("Unable to locate " + DataTools.escapeHTML(appID) + ".app.xml - check to make sure it's available in your project apps directory (see server logs for details)");
            }
        }
        return appConfig;
    }

    public static ISCFile getAppFile(String appID) throws Exception {
        if (appID.equals("isc_builtin")) {
            return ISCFile.newInstance(DataTools.resourceFromClassLoader("isc_builtin.app.xml"));
        }
        return ISCFile.newInstance(DataStructCache.getInstanceFile(appID, "apps", "App"));
    }

    @Override
    public int getScriptSourceOffset(Map scriptSourceContext) throws Exception {
        String appID = this.rpcRequest.getAppID();
        String className = this.rpcRequest.getServerObjectID();
        String methodName = this.rpcRequest.getMethodName();
        String source = null;
        try {
            ISCFile appFile = RPCDMI.getAppFile(appID);
            if (appFile != null) {
                source = appFile.getAsString();
            }
        }
        catch (Exception appFile) {
            // empty catch block
        }
        if (source == null) {
            throw new Exception(DataTools.escapeHTML(appID) + ".app.xml does not have source - unable to obtain line offset for script code");
        }
        String script = (String)scriptSourceContext.get("script");
        int idIndex = source.indexOf(className);
        if (idIndex == -1) {
            return -1;
        }
        int methodNameIndex = source.indexOf(methodName, idIndex);
        if (methodNameIndex == -1) {
            return -1;
        }
        int scriptIndex = source.indexOf(script, methodNameIndex);
        if (scriptIndex == -1) {
            return -1;
        }
        return DataTools.countCompleteLines(source.substring(0, scriptIndex));
    }

    @Override
    public String getScriptSourceName(Map scriptSourceContext) throws Exception {
        String appID = this.rpcRequest.getAppID();
        String className = this.rpcRequest.getServerObjectID();
        String methodName = this.rpcRequest.getMethodName();
        return appID + ".app.xml: " + className + "." + methodName + "()";
    }

    @Override
    public String getScriptSourceFilename(Map scriptSourceContext) throws Exception {
        String appID = this.rpcRequest.getAppID();
        Object source = null;
        try {
            ISCFile appFile = RPCDMI.getAppFile(appID);
            if (appFile != null) {
                return appFile.getPath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void verifyMethodEnabled(String methodName) throws Exception {
        RPCDMI.verifyMethodEnabled(methodName, null);
    }

    public static void verifyMethodEnabled(String methodName, DSRequest dsRequest) throws Exception {
        boolean allowAnyRPC = false;
        List enabledBuiltinMethods = config.getList("RPCManager.enabledBuiltinMethods");
        if (dsRequest != null && dsRequest.getAllowAnyRPC()) {
            allowAnyRPC = true;
        }
        if (!(allowAnyRPC || enabledBuiltinMethods.contains(methodName) || enabledBuiltinMethods.contains("*"))) {
            throw new Exception("Attempt to execute RPC DMI Builtin '" + DataTools.escapeHTML(methodName) + "' DENIED by server.properties configuration.  To enable this method, add it to the list of methods under RPCManager.enabledBuiltinMethods in server.properties");
        }
    }
}

