/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.io.file;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ISCRelativeFile
extends ISCFile {
    private static Logger log = new Logger(ISCRelativeFile.class.getName());
    protected ISCFile parent;

    public ISCRelativeFile(ISCFile parent, ISCFile child) {
        super(null, null);
        if (parent == null) {
            throw new IllegalStateException("parent cannot be null");
        }
        if (child == null) {
            throw new IllegalStateException("child cannot be null");
        }
        this.parent = parent;
        this.delegate = child;
    }

    public ISCRelativeFile getRelativeChild(Map<String, Object> values, DSRequest context) throws IOException {
        ISCFile child = this.parent.getChild(values, context);
        return new ISCRelativeFile(this.parent, child);
    }

    public Map<String, Object> readRelativeAttributes() throws Exception {
        Map<String, Object> childAttributes = this.delegate.readAttributes();
        if (childAttributes != null) {
            String parentPath = ISCFile.canonicalizePath(this.parent.getCanonicalPath());
            String childPath = ISCFile.canonicalizePath(this.delegate.getCanonicalPath());
            String difference = StringUtils.removeStart((String)childPath, (String)parentPath);
            String relativePath = StringUtils.removeStart((String)difference, (String)"/");
            String relativePathWithoutFormat = StringUtils.removeEnd((String)relativePath, (String)("." + (String)childAttributes.get("fileFormat")));
            String relativePathWithoutTypeAndFormat = StringUtils.removeEnd((String)relativePathWithoutFormat, (String)("." + (String)childAttributes.get("fileType")));
            childAttributes.put("fileName", relativePathWithoutTypeAndFormat);
        }
        return childAttributes;
    }
}

